/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** EXECUTE.C - This is the ODBC sample driver code for
** executing SQL Commands.
*/

#include "myodbc.h"

static char *insert_param(char *to,char *to_end,PARAM_BIND *param);

/*
** Intern function to execute query and return result
** Frees query if query != stmt->query
*/


static RETCODE do_query(STMT FAR *stmt,char *query)
{
  int error=SQL_ERROR;
  DBUG_ENTER("do_query");

  if (!query)
    DBUG_RETURN(error);		    /* Probably error from insert_param */
  if (stmt->max_rows && stmt->max_rows != (ulong) ~0L)
  {						/* Add limit to select
						   statement */
    char *pos,*tmp_buffer;
    for (pos=query; isspace(*pos) ; pos++) ;
    if (!my_casecmp(pos,"select",6))
    {
      uint length=strlen(pos);
      if ((tmp_buffer=my_malloc(length+20,MYF(0))))
      {
	memcpy(tmp_buffer,query,length);
	sprintf(tmp_buffer+length," limit %lu",stmt->max_rows);
	if (query != stmt->query)
	  my_free((gptr) query,MYF(0));
	query=tmp_buffer;
      }
    }
  }
  if (mysql_query(&stmt->dbc->mysql,query))
  {
    DBUG_PRINT("error",("Message: %s",mysql_error(&stmt->dbc->mysql)));
    strmov(stmt->dbc->sqlstate,"S1000");
    goto exit;
  }
  if (!(stmt->result=mysql_store_result(&stmt->dbc->mysql)))
  {
    if (!mysql_num_fields(&stmt->dbc->mysql))
    {
      error=SQL_SUCCESS;		       /* no result set */
      goto exit;
    }
    DBUG_PRINT("error",("Message: %s",mysql_error(&stmt->dbc->mysql)));
    strmov(stmt->dbc->sqlstate,"S1000");
    goto exit;
  }
  fix_result_types(stmt);
  error=SQL_SUCCESS;

exit:
  if (query != stmt->query)
    my_free((gptr) query,MYF(0));
  DBUG_RETURN(error);
}

/*
** Insert sql params at parameter positions
*/

static char *insert_params(STMT FAR *stmt)
{
  char *query=stmt->query,*to,*buffer,*buffer_end;
  uint i,length;
  DBUG_ENTER("insert_params");

  to=buffer=stmt->dbc->mysql.net.buff;
  buffer_end=buffer+stmt->dbc->mysql.net.max_packet-6;

  for (i=0; i < stmt->param_count; i++)
  {
    PARAM_BIND *param=dynamic_element(&stmt->params,i,PARAM_BIND*);
    char *pos;
    if (!param->used)
    {
      set_error(stmt->dbc,"S1090","SQLBindParameter not used for all parameters");
      DBUG_RETURN(0);
    }
    pos=param->pos_in_query;
    length=(uint) (pos-query);
    if (to+length+3 >= buffer_end)
      goto error;
    memcpy(to,query,length);
    to+=length;
    query=pos+1;				/* Skipp '?' */
    if (!(to=insert_param(to,buffer_end,param)))
      goto error;
  }
  length=(uint) (stmt->query_end - query);
  if (to+length >= buffer_end)
    goto error;
  memcpy(to,query,length+1);
  to+=length+1;
  if (!(to=my_memdup(buffer,(uint) (to-buffer),MYF(0))))
  {
    set_error(stmt->dbc,"S1001","Not enough memory");
    DBUG_RETURN(0);
  }
  DBUG_RETURN(to);

error:						/* Too much data */
  set_error(stmt->dbc,"S1001","Communication buffer is too small for query");
  DBUG_RETURN(0);
}


static char *insert_param(char *to,char *to_end,PARAM_BIND *param)
{
  uint length;
  char buff[128],*data;
  if (!param->actual_len || *(param->actual_len) == SQL_NTS)
  {
    length=strlen(data=param->buffer);
  }
  else if (*(param->actual_len) == SQL_NULL_DATA)
  {
    if (to+4 >= to_end)
      return 0;
    return strmov(to,"NULL");
  }
  else if (*param->actual_len == SQL_DATA_AT_EXEC ||
           *param->actual_len <= SQL_LEN_DATA_AT_EXEC_OFFSET)
  {
    length= param->value_length;
    if (!(data=param->value))
    {
      if (to+4 >= to_end)
        return 0;
      return strmov(to,"NULL");
    }
  }
  else
  {
    data=param->buffer;
    length= *param->actual_len;
  }
  DBUG_PRINT("Info",("param: %lx  ctype: %d  SqlType: %d  data: %lx  length: %d  actual_len: %d",
                     param,param->CType,param->SqlType,data,length,
		     param->actual_len ? *param->actual_len : 0));

  switch (param->CType) {
  case SQL_C_CHAR:
    break;
  case SQL_C_SHORT:
    length=int2str((long) *((short int*) data),buff,-10) -buff;
    data=buff;
    break;
  case SQL_C_LONG:
    length=int2str(*((long int*) data),buff,-10) -buff;
    data=buff;
    break;
  case SQL_C_FLOAT:
    sprintf(buff,"%f",*((float*) data));
    length=strlen(data=buff);
    break;
  case SQL_C_DOUBLE:
    sprintf(buff,"%f",*((double*) data));
    length=strlen(data=buff);
    break;
  case SQL_C_BIT:
    length=int2str((long) *((uchar*) data),buff,-10) -buff;
    data=buff;
    break;
  case SQL_C_TINYINT:
    length=int2str((long) *((char*) data),buff,-10) -buff;
    data=buff;
    break;
  case SQL_C_DATE:
  {
    struct tagDATE_STRUCT *date=(struct tagDATE_STRUCT*) data;
    sprintf(buff,"%04d%02d%02d",date->year,date->month,date->day);
    data=buff;
    length=8;
    break;
  }
  case SQL_C_TIME:
  {
    struct tagTIME_STRUCT *time=(struct tagTIME_STRUCT*) data;
    sprintf(buff,"%02d%02d%02d",time->hour,time->minute,time->second);
    data=buff;
    length=6;
    break;
  }
  case SQL_C_TIMESTAMP:
  {
    struct tagTIMESTAMP_STRUCT *time=(struct tagTIMESTAMP_STRUCT*) data;
    sprintf(buff,"%04d%02d%02d%02d%02d%02d",time->year,time->month,time->day,
	    time->hour,time->minute,time->second);
    data=buff;
    length=14;
    break;
  }
  }
  switch (param->SqlType) {
  case SQL_CHAR:
  case SQL_VARCHAR:
  case SQL_LONGVARCHAR:
  {
    char *data_end=data+length;

    *to++='\'';
    to_end--;					/* One extra is neaded */

    while (data != data_end && to < to_end)
    {
      if (*data == '\'' || *data == '\\')
	*to++= '\\';
      if (*data == 0)
      {
	*to++= '\\';
	*to++= '\0';
      }
      else
        *to++ = *data++;
    }
    if (to+1 >= to_end)
      return 0;
    *to++='\'';
    return to;
  }
  case SQL_TIME:
  {
    ulong time=str_to_time(data,length);
    if (to+10 >= to_end)
      return 0;
    sprintf(to,"'%02d:%02d:%02d'",time/10000,time/100%100,time%100);
    return to+10;
  }
  case SQL_DATE:
  {
    if (to+8 >= to_end)
      return 0;
    return strmake(to,data,8);
  }
  default:
    if (to+length >= to_end)
      return 0;
    memcpy(to,data,length);
    to+=length;
    *to=0;
    return to;
  }
}


//  Execute a prepared SQL statement

RETCODE SQL_API SQLExecute(HSTMT hstmt)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  char *query;
  uint i;
  DBUG_ENTER("SQLExecute");
  DBUG_PRINT("enter",("stmt: %lx",stmt));

  if (!stmt)
    DBUG_RETURN(SQL_ERROR);
  if (!stmt->query)
  {
    DBUG_RETURN(set_error(stmt->dbc,"S1010","No previous SQLPrepare done"));
  }
  SQLFreeStmt(hstmt,MYSQL_RESET_BUFFERS);
  query=stmt->query;
  if (stmt->param_count)
  {
    /*
     * If any parameters are required at execution time, cannot perform the
     * statement. It will be done throught SQLPutData() and SQLParamData().
     */
    for (i=0; i < stmt->param_count; i++)
    {
      PARAM_BIND *param=dynamic_element(&stmt->params,i,PARAM_BIND*);
      if (param->actual_len &&
	  (*param->actual_len == (long) SQL_DATA_AT_EXEC ||
	   *param->actual_len <= SQL_LEN_DATA_AT_EXEC_OFFSET))
      {
	stmt->current_param=i;	/* Fix by Giovanni */
        param->value=0;
        param->alloced=0;
  	DBUG_RETURN(SQL_NEED_DATA);
      }
    }
    query=insert_params(stmt);	/* Checked in do_query */
  }
  DBUG_RETURN(do_query(stmt,query));
}


//  Performs the equivalent of SQLPrepare, followed by SQLExecute.

RETCODE SQL_API SQLExecDirect(HSTMT hstmt,UCHAR FAR *szSqlStr,
			      SDWORD cbSqlStr)
{
  int error;
  DBUG_ENTER("SQLExecDirect");

  if ((error=SQLPrepare(hstmt,szSqlStr,cbSqlStr)))
    DBUG_RETURN(error);
  DBUG_RETURN(SQLExecute(hstmt));
}


//  Returns the SQL string as modified by the driver.

RETCODE SQL_API SQLNativeSql(HDBC hdbc,
			     UCHAR FAR *szSqlStrIn, SDWORD cbSqlStrIn,
			     UCHAR FAR *szSqlStr, SDWORD cbSqlStrMax,
			     SDWORD FAR *pcbSqlStr)
{
  return set_error((DBC FAR*) hdbc,"08002","mysql dosn't support this yet");
}



/*
** Supplies parameter data at execution time.  Used in conjuction with
** SQLPutData.
*/

RETCODE SQL_API SQLParamData(HSTMT hstmt, PTR FAR *prbgValue)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  uint i;
  DBUG_ENTER("SQLParamData");
  for (i=stmt->current_param; i < stmt->param_count; i++)
  {
    PARAM_BIND *param=dynamic_element(&stmt->params,i,PARAM_BIND*);
    if (param->actual_len &&
	(*param->actual_len == (long) SQL_DATA_AT_EXEC ||
         *param->actual_len <= SQL_LEN_DATA_AT_EXEC_OFFSET))
    {
      stmt->current_param=i+1;
      if (prbgValue)
	*prbgValue= param->buffer;
      param->value=0;
      param->alloced=0;
      DBUG_RETURN(SQL_NEED_DATA);
    }
  }
  DBUG_RETURN(do_query(stmt,insert_params(stmt)));
}


//  Supplies parameter data at execution time.  Used in conjunction with
//  SQLParamData.


RETCODE SQL_API SQLPutData(HSTMT hstmt, PTR rgbValue, SDWORD cbValue)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  PARAM_BIND *param;
  DBUG_ENTER("SQLPutData");

  if (!stmt)
    DBUG_RETURN(SQL_ERROR);

  if (cbValue == SQL_NTS)
    cbValue=strlen(rgbValue);
  if (cbValue == SQL_NULL_DATA)
  {
    param->value=0;
    DBUG_RETURN(SQL_SUCCESS);
  }
  param=dynamic_element(&stmt->params,stmt->current_param-1,PARAM_BIND*);
  if (param->value)
  {						/* append to old value */
    if (param->alloced)
    {
      if (!(param->value=my_realloc(param->value,param->value_length+cbValue+1,
				    MYF(0))))
	DBUG_RETURN(set_error(stmt->dbc,"S1001","Not enough memory"));
    }
    else
    {						/* This should never happen */
      gptr old_pos=param->value;
      if (!(param->value=my_malloc(param->value_length+cbValue+1,MYF(0))))
	DBUG_RETURN(set_error(stmt->dbc,"S1001","Not enough memory"));
      memcpy(param->value,old_pos,param->value_length);
    }
    memcpy(param->value+param->value_length,rgbValue,cbValue);
    param->value_length+=cbValue;
    param->value[param->value_length]=0;
    param->alloced=1;
  }
  else
  {						/* New value */
    if (!(param->value=my_malloc(cbValue+1,MYF(0))))
      DBUG_RETURN(set_error(stmt->dbc,"S1001","Not enough memory"));
    memcpy(param->value,rgbValue,cbValue);
    param->value_length=cbValue;
    param->value[param->value_length]=0;
    param->alloced=1;
  }
  DBUG_RETURN(SQL_SUCCESS);
}


RETCODE SQL_API SQLCancel(HSTMT hstmt)         // Statement to cancel.
{
  return SQLFreeStmt(hstmt,SQL_CLOSE);
}
