/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** CONNECT.C - This is the ODBC sample driver code for
** allocation and connection.
*/

#include "myodbc.h"

#ifndef _UNIX_
#include <odbcinst.h>
#include "dialogs.h"
#endif /* IS NOT UNIX */

//      CONNECT.C
//
//      SQLC connection functions.
//      -       -       -       -       -       -       -       -       -
//      Allocate an environment (ENV) block.


RETCODE SQL_API SQLAllocEnv(HENV FAR * phenv)
{
#ifndef _UNIX_
  HGLOBAL henv;
  henv = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT, sizeof (ENV));
  if (henv == NULL || (*phenv = (HENV)GlobalLock (henv)) == NULL)
  {
    GlobalFree (henv);	//	Free it if lock fails
    *phenv = SQL_NULL_HENV;
    return SQL_ERROR;
  }
  return SQL_SUCCESS;
#endif /* IS NOT UNIX */

#ifdef _UNIX_
#ifdef LOG_ALL
  DBUG_PUSH("d:F:L:t:S:O,/tmp/myodbc.log");
#else
  if(getenv("MYODBC_LOG") != NULL)
  DBUG_PUSH(getenv("MYODBC_LOG"));
#endif

  if (!(*phenv = (HENV) my_malloc(sizeof(ENV),MYF(MY_ZEROFILL))))
  {
    *phenv = SQL_NULL_HENV;
    return SQL_ERROR;
  }
  return SQL_SUCCESS;
#endif /* IS UNIX */
}

RETCODE SQL_API SQLFreeEnv(HENV henv)
{
#ifndef _UNIX_
  GlobalUnlock(GlobalHandle(henv));
  GlobalFree(GlobalHandle(henv));
  return SQL_SUCCESS;
#endif /* IS NOT UNIX */

#ifdef _UNIX_
  my_free(henv,MYF(0));
  return SQL_SUCCESS;
#endif /* IS UNIX */
}


//      -       -       -       -       -       -       -       -       -
//      Allocate a DBC block.

RETCODE SQL_API SQLAllocConnect(HENV henv, HDBC FAR *phdbc)
{
#ifndef _UNIX_
  HGLOBAL hdbc;
#endif /* IS NOT UNIX */
  DBC FAR *dbc;

#ifndef _UNIX_
  hdbc = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT, sizeof (DBC));
  if (!hdbc || (*phdbc = (HDBC)GlobalLock (hdbc)) == SQL_NULL_HDBC)
  {
    GlobalFree (hdbc);	//	Free it if lock fails
    *phdbc = SQL_NULL_HENV;
    return SQL_ERROR;
  }
#endif /* IS NOT UNIX */

#ifdef _UNIX_
  if (!(*phdbc = (HDBC) my_malloc(sizeof(DBC),MYF(MY_ZEROFILL))))
  {
    *phdbc = SQL_NULL_HDBC;
    return SQL_ERROR;
  }
#endif /* IS UNIX */

  dbc=(DBC FAR*) *phdbc;
  dbc->env=henv;
  dbc->mysql.net.fd = -1;			/* Marker if open */
  return SQL_SUCCESS;
}


RETCODE SQL_API SQLFreeConnect(HDBC hdbc)
{
  DBC FAR *dbc=(DBC FAR*) hdbc;
  my_free(dbc->database,MYF(MY_ALLOW_ZERO_PTR));
  my_free(dbc->server,MYF(MY_ALLOW_ZERO_PTR));
  my_free(dbc->user,MYF(MY_ALLOW_ZERO_PTR));
  my_free(dbc->password,MYF(MY_ALLOW_ZERO_PTR));

#ifndef _UNIX_
  GlobalUnlock (GlobalHandle((HGLOBAL) hdbc));
  GlobalFree (GlobalHandle((HGLOBAL) hdbc));
#endif /* IS NOT UNIX */

#ifdef _UNIX_
  my_free(hdbc,MYF(0));
#endif /* IS UNIX */
  return SQL_SUCCESS;
}



/******************************************************************************
*	Connect to mysql server
******************************************************************************/

RETCODE SQL_API SQLConnect(HDBC hdbc, UCHAR FAR *szDSN, SWORD   cbDSN,
			   UCHAR FAR *szUID, SWORD cbUID, UCHAR FAR *szAuthStr,
			   SWORD cbAuthStr)
{
  char host[64],user[64],passwd[64],database[NAME_LEN+1];
  DBC FAR *dbc=(DBC FAR*) hdbc;

  if (dbc->mysql.net.fd >= 0)
  {
    return set_error(hdbc,"08002","Connection in use");
  }
  dbc->sqlstate[0]=0;
#ifndef _UNIX_
  SQLGetPrivateProfileString(fix_str(database,szDSN,cbDSN),"server",
			     "localhost", host,sizeof(host),"ODBC.INI");
#endif /* IS NOT UNIX */

#ifdef _UNIX_
  strcpy(database,szDSN);
  strcpy(host,"localhost");
#endif /* IS UNIX */

  if (!mysql_connect(&dbc->mysql,host,fix_str(user,szUID,cbUID),
		     fix_str(passwd,szAuthStr,cbAuthStr)))
  {
    strmov(dbc->sqlstate,"S1000");
    return SQL_ERROR;
  }
  if (mysql_select_db(&dbc->mysql,database) < 0)
  {
    mysql_close(&dbc->mysql);
    strmov(dbc->sqlstate,"08004");
    return SQL_ERROR;
  }
  dbc->database=my_strdup(database,MYF(MY_WME));
  dbc->server=my_strdup(host,MYF(MY_WME));
  dbc->user=my_strdup(user,MYF(MY_WME));
  dbc->password=my_strdup(passwd,MYF(MY_WME));
  return SQL_SUCCESS;
}


//	This function as its "normal" behavior is supposed to bring up a
//	dialog box if it isn't given enough information via "szConnStrIn".  If
//	it is given enough information, it's supposed to use "szConnStrIn" to
//	establish a database connection.  In either case, it returns a
//	string to the user that is the string that was eventually used to
//	establish the connection.

RETCODE SQL_API SQLDriverConnect(HDBC hdbc,HWND hwnd,UCHAR FAR *szConnStrIn,
				 SWORD cbConnStrIn,UCHAR FAR *szConnStrOut,
				 SWORD cbConnStrOutMax,
				 SWORD FAR *pcbConnStrOut,
				 UWORD fDriverCompletion)
{
#ifndef _UNIX_

  short   iRet;
  BOOL    fPrompt = FALSE,maybe_prompt;
  DBC FAR *dbc=(DBC FAR*) hdbc;
  GLOBALHANDLE hglbAttr;
  LPSETUPDLG lpsetupdlg;
  DBUG_ENTER("SQLDriverConnect");
  DBUG_PRINT("enter",("fDriverCompletion: %d",fDriverCompletion));

  hglbAttr = GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, sizeof(SETUPDLG));
  if (!hglbAttr)
    DBUG_RETURN(FALSE);
  lpsetupdlg = (LPSETUPDLG)GlobalLock(hglbAttr);

  maybe_prompt=(fDriverCompletion == SQL_DRIVER_COMPLETE ||
		fDriverCompletion == SQL_DRIVER_COMPLETE_REQUIRED);
  if ((szConnStrIn == NULL) || (!cbConnStrIn) ||
      ((cbConnStrIn == SQL_NTS) && (!szConnStrIn[0])))
    fPrompt = TRUE;
  else
  {
    /* Check connection string for completeness. Prompt if not all params */
    ParseAttributes(szConnStrIn, lpsetupdlg);
    set_attributes(lpsetupdlg);
    if (fDriverCompletion == SQL_DRIVER_PROMPT ||
	(maybe_prompt &&
	 (!lpsetupdlg->aAttr[KEY_DSN].szAttr[0] ||
	  !lpsetupdlg->aAttr[KEY_SERVER].szAttr[0] ||
	  !lpsetupdlg->aAttr[KEY_USER].szAttr[0])))
      fPrompt = TRUE;
  }
retry:
  if (fPrompt)
  {
    iRet = DialogBoxParam(s_hModule, MAKEINTRESOURCE(DRIVERCONNECT), hwnd,
		          DriverConnectProc,
		          (LONG)(LPSTR) lpsetupdlg);
    if ((!iRet) || (iRet == -1))
    {
      GlobalUnlock(hglbAttr);
      GlobalFree(hglbAttr);
      DBUG_RETURN(SQL_NO_DATA_FOUND);
    }
  }
  if (szConnStrOut)
  {
    char *pos,buff[1024];
    long length;
    pos=strxmov(buff,"DSN=",lpsetupdlg->aAttr[KEY_DSN].szAttr,
		";SERVER=",lpsetupdlg->aAttr[KEY_SERVER].szAttr,
		";UID=",lpsetupdlg->aAttr[KEY_USER].szAttr,
		";PWD=",lpsetupdlg->aAttr[KEY_PASSWORD].szAttr,
		";PORT=",lpsetupdlg->aAttr[KEY_PORT].szAttr,";",NullS);
    VOID(copy_lresult((DBC FAR*) 0,szConnStrOut,cbConnStrOutMax,
                      &length,buff,(uint) (pos-buff),0L));
    if (pcbConnStrOut)
      *pcbConnStrOut=(SWORD) length;
    DBUG_PRINT("info",("Connect string out: %s",szConnStrOut));
  }
  if (dbc->port=atoi(lpsetupdlg->aAttr[KEY_PORT].szAttr))
    mysql_port=dbc->port;
  else
    dbc->port=mysql_port;
  if (!mysql_connect(&dbc->mysql,lpsetupdlg->aAttr[KEY_SERVER].szAttr,
		     lpsetupdlg->aAttr[KEY_USER].szAttr,
		     lpsetupdlg->aAttr[KEY_PASSWORD].szAttr))
  {
    if (maybe_prompt && !fPrompt)
    {
      fPrompt=TRUE;
      goto retry;
    }
    strmov(dbc->sqlstate,"S1000");
    GlobalUnlock(hglbAttr);
    GlobalFree(hglbAttr);
    DBUG_RETURN(SQL_ERROR);
  }
  if (mysql_select_db(&dbc->mysql,lpsetupdlg->aAttr[KEY_DSN].szAttr) < 0)
  {
    mysql_close(&dbc->mysql);
    strmov(dbc->sqlstate,"08004");
    GlobalUnlock(hglbAttr);
    GlobalFree(hglbAttr);
    DBUG_RETURN(SQL_ERROR);
  }
  dbc->database=my_strdup(lpsetupdlg->aAttr[KEY_DSN].szAttr,MYF(MY_WME));
  dbc->server=my_strdup(lpsetupdlg->aAttr[KEY_SERVER].szAttr,MYF(MY_WME));
  dbc->user=my_strdup(lpsetupdlg->aAttr[KEY_USER].szAttr,MYF(MY_WME));
  dbc->password=my_strdup(lpsetupdlg->aAttr[KEY_PASSWORD].szAttr,MYF(MY_WME));

  GlobalUnlock(hglbAttr);
  GlobalFree(hglbAttr);
  DBUG_RETURN(SQL_SUCCESS);
#endif /* IS NOT UNIX */

#ifdef _UNIX_
  UCHAR FAR *connstrin;
  char *KEY_DSN=NULL;
  char *KEY_SERVER=NULL;
  char *KEY_USER=NULL;
  char *KEY_PASSWORD=NULL;
  char *KEY_PORT=NULL;

  char *tok[5];
  char *tok2=NULL;
  char *tok3=NULL;
  int i;

  BOOL    fPrompt = FALSE;
  DBC FAR *dbc=(DBC FAR*) hdbc;
  DBUG_ENTER("SQLDriverConnect");
  DBUG_PRINT("enter",("fDriverCompletion: %d",fDriverCompletion));

  if ((szConnStrIn == NULL) || (!cbConnStrIn) ||
      ((cbConnStrIn == SQL_NTS) && (!szConnStrIn[0])))
    fPrompt = TRUE;
  else
  {
    /* Check connection string for completeness. Prompt if not all params */

    connstrin=(UCHAR FAR *) my_strdup(szConnStrIn,MYF(MY_WME));

    tok[0]=strtok(connstrin,";");
    tok[1]=strtok(NULL,";");
    tok[2]=strtok(NULL,";");
    tok[3]=strtok(NULL,";");
    tok[4]=strtok(NULL,";");
    tok[5]=NULL;

    i=0;
    while(tok[i] != NULL)
        {
        tok2=strtok(tok[i],"=");

        if(strcmp("DSN", tok2) == 0)
                {
                tok3=strtok(NULL,"\0");
                KEY_DSN=(char *) my_strdup(tok3,MYF(MY_WME));
                }

        if(strcmp("UID", tok2) == 0)
                {
                tok3=strtok(NULL,"\0");
                KEY_USER=(char *) my_strdup(tok3,MYF(MY_WME));
                }

        if(strcmp("PWD", tok2) == 0)
                {
                tok3=strtok(NULL,"\0");
                KEY_PASSWORD=(char *) my_strdup(tok3,MYF(MY_WME));
                }

        if(strcmp("SERVER", tok2) == 0)
                {
                tok3=strtok(NULL,"\0");
                KEY_SERVER=(char *) my_strdup(tok3,MYF(MY_WME));
                }

        if(strcmp("PORT", tok2) == 0)
                {
                tok3=strtok(NULL,"\0");
                KEY_PORT=(char *) my_strdup(tok3,MYF(MY_WME));
                }

        i++;
        }
    if(KEY_SERVER == NULL || KEY_SERVER[0] == '\0')
        {
        KEY_SERVER=(char *) my_strdup("localhost",MYF(MY_WME));
        }

    if(KEY_PORT == NULL || KEY_PORT[0] == '\0')
        {
        KEY_PORT=(char *) my_strdup("1113",MYF(MY_WME));
        }

    if(KEY_USER == NULL || KEY_USER[0] == '\0')
        {
        KEY_USER=(char *) my_strdup("dummy",MYF(MY_WME));
        }

    if(KEY_PASSWORD == NULL || KEY_PASSWORD[0] == '\0')
        {
        KEY_PASSWORD=(char *) my_strdup("dummy",MYF(MY_WME));
        }

    if (fDriverCompletion == SQL_DRIVER_PROMPT ||
        ((fDriverCompletion == SQL_DRIVER_COMPLETE ||
          fDriverCompletion == SQL_DRIVER_COMPLETE_REQUIRED) &&
         (!KEY_DSN)))
      fPrompt = TRUE;
  }
  if (fPrompt)
  {
  DBUG_RETURN(set_error((DBC FAR*) hdbc,"S1000","No DSN entered"));
  }

  if (szConnStrOut)
  {
    UCHAR FAR  *pos;
    pos=strxmov(szConnStrOut,"DSN=",KEY_DSN,
                ";SERVER=",KEY_SERVER,
                ";UID=",KEY_USER,
                ";PWD=",KEY_PASSWORD,
                ";PORT=",KEY_PORT,";",NullS);
    *pcbConnStrOut=(int) (pos-szConnStrOut);
  }
  if (!mysql_connect(&dbc->mysql,KEY_SERVER,
                     KEY_USER,
                     KEY_PASSWORD))
  {
    strmov(dbc->sqlstate,"S1000");
    DBUG_RETURN(SQL_ERROR);
  }
  if (mysql_select_db(&dbc->mysql,KEY_DSN) < 0)
  {
    mysql_close(&dbc->mysql);
    strmov(dbc->sqlstate,"08004");
    DBUG_RETURN(SQL_ERROR);
  }
  dbc->database=my_strdup(KEY_DSN,MYF(MY_WME));
  dbc->server=my_strdup(KEY_SERVER,MYF(MY_WME));
  dbc->user=my_strdup(KEY_USER,MYF(MY_WME));
  dbc->password=my_strdup(KEY_PASSWORD,MYF(MY_WME));
  dbc->port=atoi(KEY_PORT);

  x_free(KEY_DSN);
  x_free(KEY_SERVER);
  x_free(KEY_USER);
  x_free(KEY_PASSWORD);
  x_free(KEY_PORT);

  DBUG_RETURN(SQL_SUCCESS);
#endif /* IS UNIX */

}


RETCODE SQL_API SQLBrowseConnect(HDBC hdbc,UCHAR FAR *szConnStrIn,
				 SWORD cbConnStrIn,
				 UCHAR FAR *szConnStrOut,SWORD cbConnStrOutMax,
				 SWORD FAR *pcbConnStrOut)
{
  DBUG_ENTER("SQLBrowseConnect");
  DBUG_RETURN(set_error((DBC FAR*) hdbc,"IM001","This dosn't work yet"));
}


RETCODE SQL_API SQLDisconnect(HDBC hdbc)
{
  LIST *list_element,*next_element;
  DBC FAR *dbc=(DBC FAR*) hdbc;

  for (list_element=dbc->statements ; list_element ;
       list_element=next_element)
  {
    next_element=list_element->next;
    SQLFreeStmt((STMT FAR*) list_element->data,SQL_DROP);
  }
  mysql_close(&dbc->mysql);
  return SQL_SUCCESS;
}
