/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** CATALOG.C - This is the ODBC sample driver code for
** executing Data Dictionary functions.
*/

#include "myodbc.h"

static MYSQL_ROW fix_fields_copy(STMT FAR *hstmt,MYSQL_ROW row);
static int check_parameters(HSTMT hstmt,UCHAR FAR *szTableQualifier,
			    SWORD cbTableQualifier,UCHAR FAR *szTableOwner,
			    SWORD cbTableOwner,UCHAR FAR *szTableName,SWORD *cbTableName,
			    char *table_name,bool no_wildcards);

//  Have DBMS set up result set of Tables.

uint SQLTABLES_order[]={2};
char *SQLTABLES_values[]={"","",NULL,"TABLE","mysql table"};
MYSQL_FIELD SQLTABLES_fields[] = {
  {"Table_qualifer","Catalog",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"Table_owner","Catalog",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"Table_name","Catalog",NULL,FIELD_TYPE_STRING,NAME_LEN,NAME_LEN,NOT_NULL_FLAG},
  {"Table_type","Catalog",NULL,FIELD_TYPE_STRING,NAME_LEN,5,NOT_NULL_FLAG},
  {"Remarks","Catalog",NULL,FIELD_TYPE_STRING,NAME_LEN,11}};

const uint SQLTABLES_FIELDS=array_elements(SQLTABLES_values);


RETCODE SQL_API SQLTables(HSTMT hstmt,
			  UCHAR FAR *szTableQualifier,SWORD cbTableQualifier,
			  UCHAR FAR *szTableOwner,SWORD cbTableOwner,
			  UCHAR FAR *szTableName,SWORD cbTableName,
			  UCHAR FAR *szTableType,SWORD cbTableType)
{
  char Qualifier_buff[NAME_LEN+1],Owner_buff[NAME_LEN+1],Name_buff[NAME_LEN+1],
       buff[80],*TableQualifier,*TableOwner,*TableName;
  FAR STMT *stmt=(FAR STMT*) hstmt;
  DBUG_ENTER("SQLTables");
  DBUG_PRINT("enter",("Qualifier: '%s'  Owner: '%s'  Table: '%s'  Type: '%s'",
		      szTableQualifier,szTableOwner,szTableName,szTableType));

  if (!empty_str(szTableType,cbTableType) &&
      !(strinstr(fix_str(buff,szTableType,cbTableType),"'TABLE'")))
  {
    set_error(stmt->dbc,"S1102","mysql has only 'TABLE' types");
    DBUG_RETURN(SQL_ERROR);
  }
  SQLFreeStmt(hstmt,MYSQL_RESET);

  /* If table qualifier or tableowner requested, return empty set */
  TableQualifier=fix_str(Qualifier_buff,szTableQualifier,cbTableQualifier);
  TableOwner=    fix_str(Owner_buff,szTableOwner,cbTableOwner);
  TableName=     fix_str(Name_buff,szTableName,cbTableName);
  if (!strcmp(TableQualifier,"%") && !TableOwner[0] && !TableName[0] ||
      !TableQualifier && !strcmp(TableOwner,"%") && !TableName[0] ||
      TableQualifier[0] && !strcmp(TableQualifier,"%") ||
      TableOwner[0] && !strcmp(TableOwner,"%"))
  {
    stmt->result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES),MYF(MY_ZEROFILL));
    stmt->result->eof=1;
    mysql_link_fields(stmt->result,SQLTABLES_fields, SQLTABLES_FIELDS);
    fix_result_types(stmt);
    DBUG_RETURN(SQL_SUCCESS);
  }

  if (!(stmt->result=mysql_list_tables(&stmt->dbc->mysql,TableName)))
  {
    DBUG_RETURN(set_error(stmt->dbc,"S1000","Could not read table names"));
    DBUG_RETURN(SQL_ERROR);
  }
  stmt->order=       SQLTABLES_order;
  stmt->order_count= array_elements(SQLTABLES_order);
  stmt->fix_fields=  fix_fields_copy;
  stmt->array=(MYSQL_ROW) my_memdup((gptr) SQLTABLES_values,
				    sizeof(SQLTABLES_values),MYF(0));
  mysql_link_fields(stmt->result,SQLTABLES_fields,5);
  fix_result_types(stmt);
  DBUG_RETURN(SQL_SUCCESS);
}


static MYSQL_ROW fix_fields_copy(STMT FAR *stmt,MYSQL_ROW row)
{
  uint i;
  for (i=0 ; i < stmt->order_count; i++)
    stmt->array[stmt->order[i]]=row[i];
  return stmt->array;
}


//  Have DBMS set up result set of Columns.

char SC_type[10],SC_typename[20],SC_precision[10],SC_length[10],SC_scale[10],
  SC_nullable[10];

char *SQLCOLUMNS_values[]={"","",NULL,NULL,SC_type,SC_typename,
			   SC_precision,
			   SC_length,SC_scale,"10",SC_nullable,"mysql column"};

MYSQL_FIELD SQLCOLUMNS_fields[] = {
  {"Table_qualifer","mySQL Catalog",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"Table_owner","mySQL Catalog",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"Table_name","mySQL Catalog",NULL,FIELD_TYPE_STRING,NAME_LEN,NAME_LEN,NOT_NULL_FLAG},
  {"Column_name","mySQL Catalog",NULL,FIELD_TYPE_STRING,NAME_LEN,NAME_LEN,NOT_NULL_FLAG},
  {"Data_type","mySQL Catalog",NULL,FIELD_TYPE_SHORT,5,5,NOT_NULL_FLAG},
  {"Type_name","mySQL Catalog",NULL,FIELD_TYPE_STRING,20,20,NOT_NULL_FLAG},
  {"Precision","mySQL Catalog",NULL,FIELD_TYPE_LONG,7,7},
  {"Length","mySQL Catalog",NULL,FIELD_TYPE_LONG,7,7},
  {"Scale","mySQL Catalog",NULL,FIELD_TYPE_SHORT,2,2},
  {"Radix","mySQL Catalog",NULL,FIELD_TYPE_SHORT,2,2},
  {"Nullable","mySQL Catalog",NULL,FIELD_TYPE_SHORT,5,5,NOT_NULL_FLAG},
  {"Remarks","mySQL Catalog",NULL,FIELD_TYPE_STRING,NAME_LEN,16}};

const uint SQLCOLUMNS_FIELDS=array_elements(SQLCOLUMNS_values);


RETCODE SQL_API SQLColumns(HSTMT hstmt,
			   UCHAR FAR *szTableQualifier, SWORD cbTableQualifier,
			   UCHAR FAR *szTableOwner, SWORD cbTableOwner,
			   UCHAR FAR *szTableName, SWORD cbTableName,
			   UCHAR FAR *szColumnName, SWORD cbColumnName)
{
  char buff[80],table_name[NAME_LEN+1],column_name[NAME_LEN+1];
  uint c_data_length;
  MYSQL_FIELD *curField;
  char **row;
  MEM_ROOT *alloc;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLColumns");

  if (check_parameters(hstmt,szTableQualifier,cbTableQualifier,szTableOwner,
		       cbTableOwner,szTableName,&cbTableName,table_name,1))
    return SQL_ERROR;
  if (!(stmt->result=mysql_list_fields(&stmt->dbc->mysql,table_name,
				       fix_str(column_name,szColumnName,
					       cbColumnName))))
  {
    strmov(stmt->dbc->sqlstate,"S1000");
    DBUG_RETURN(SQL_ERROR);
  }
  stmt->result_array= (char**) my_malloc(sizeof(char*)*SQLCOLUMNS_FIELDS*
					 stmt->result->field_count,
					 MYF(MY_FAE | MY_ZEROFILL));

  /* convert mysql fields to data that odbc wants */
  alloc=&stmt->result->field_alloc;

  for (row= stmt->result_array ;
       (curField = mysql_fetch_field(stmt->result)) ; )
  {
    int type;
    row[0]="";                /* No qualifers */
    row[1]="";                /* No owner */
    row[2]= curField->table;
    row[3]= curField->name;
    type=unireg_to_sql_datatype(curField,buff,&c_data_length);
    row[5]=sql_strdup_root(alloc,buff);
    sprintf(buff,"%d",type);
    row[4]=sql_strdup_root(alloc,buff);
    sprintf(buff,"%d",curField->length);
    row[6]=sql_strdup_root(alloc,buff);
    sprintf(buff,"%d",c_data_length ? c_data_length : curField->length);
    row[7]=sql_strdup_root(alloc,buff);		/* Length of ctype */
    sprintf(buff,"%d",curField->decimals);
    row[8]=sql_strdup_root(alloc,buff);		/* scale */
    row[9]="10";
    sprintf(buff,"%d",curField->flags & NOT_NULL_FLAG ? SQL_NO_NULLS :
	    SQL_NULLABLE);
    row[10]=sql_strdup_root(alloc,buff);
    row[11]="";
    row+=SQLCOLUMNS_FIELDS;
  }
  stmt->result->row_count=stmt->result->field_count;
  mysql_link_fields(stmt->result,SQLCOLUMNS_fields,SQLCOLUMNS_FIELDS);
  fix_result_types(stmt);
  DBUG_RETURN(SQL_SUCCESS);
}


/* Have DBMS set up result set of Statistics. */

char SS_type[10];
uint SQLSTAT_order[]={2,3,5,7,8,9,10};
char *SQLSTAT_values[]={NULL,NULL,"","",NULL,"",SS_type,"","","","",NULL,NULL};

MYSQL_FIELD SQLSTAT_fields[] = {
  {"Table_qualifer","mySQL Stat",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"Table_owner","mySQL Stat",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"Table_name","mySQL Stat",NULL,FIELD_TYPE_STRING,NAME_LEN,NAME_LEN,NOT_NULL_FLAG},
  {"Non_unique","mySQL Stat",NULL,FIELD_TYPE_SHORT,1,1,NOT_NULL_FLAG},
  {"Index_qualifer","mySQL Stat",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"Index_name","mySQL Stat",NULL,FIELD_TYPE_STRING,NAME_LEN,NAME_LEN},
  {"Type","mySQL Stat",NULL,FIELD_TYPE_SHORT,1,1,NOT_NULL_FLAG},
  {"Seq_in_index","mySQL Stat",NULL,FIELD_TYPE_SHORT,1,2,NOT_NULL_FLAG},
  {"Column_name","mySQL Stat",NULL,FIELD_TYPE_STRING,NAME_LEN,NAME_LEN,NOT_NULL_FLAG},
  {"Coallation","mySQL Stat",NULL,FIELD_TYPE_STRING,1,1},
  {"Cardinality","mySQL Stat",NULL,FIELD_TYPE_LONG,11,11},
  {"Pages","mySQL Stat",NULL,FIELD_TYPE_LONG,9,9},
  {"Filter","mySQL Stat",NULL,FIELD_TYPE_STRING,10,10},
};

const uint SQLSTAT_FIELDS=array_elements(SQLSTAT_fields);

RETCODE SQL_API SQLStatistics(HSTMT hstmt,
			      UCHAR FAR *szTableQualifier,
			      SWORD cbTableQualifier,
			      UCHAR FAR *szTableOwner,SWORD cbTableOwner,
			      UCHAR FAR *szTableName,SWORD cbTableName,
			      UWORD fUnique,UWORD fAccuracy)
{
  char buff[100],table_name[NAME_LEN+1];
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLStatistics");

  if (check_parameters(hstmt,szTableQualifier,cbTableQualifier,szTableOwner,
		       cbTableOwner,szTableName,&cbTableName,table_name,1))
    DBUG_RETURN(SQL_ERROR);
  remove_escape(table_name);
  strxmov(buff,"show keys from ",table_name,NullS);
  if (mysql_query(&stmt->dbc->mysql,buff) ||
      !(stmt->result=mysql_store_result(&stmt->dbc->mysql)))
  {
    strmov(stmt->dbc->sqlstate,"S1000");
    DBUG_RETURN(SQL_ERROR);
  }
  int2str(SQL_INDEX_OTHER,SS_type,10);
  stmt->order=       SQLSTAT_order;
  stmt->order_count= array_elements(SQLSTAT_order);
  stmt->fix_fields=  fix_fields_copy;
  stmt->array=(MYSQL_ROW) my_memdup((gptr) SQLSTAT_values,
				    sizeof(SQLSTAT_values),MYF(0));
  if (fUnique == SQL_INDEX_UNIQUE)
  {					/* This is too low level... */
    MYSQL_ROWS **prev,*pos;
    prev= &stmt->result->data->data;
    for (pos= *prev ; pos ; pos=pos->next)
    {
      if (pos->data[1][0] == '0')	/* Unlink nonunique index */
      {
	(*prev)=pos;
	prev= &pos->next;
      }
      else
	stmt->result->row_count--;
    }
    (*prev)=0;
     mysql_data_seek(stmt->result,0);   /* Restore pointer */
  }
  mysql_link_fields(stmt->result,SQLSTAT_fields,SQLSTAT_FIELDS);
  fix_result_types(stmt);
  DBUG_RETURN(SQL_SUCCESS);
}


//  Have DBMS set up result set of TablePrivileges.

RETCODE SQL_API SQLTablePrivileges(HSTMT hstmt,
				   UCHAR FAR *szTableQualifier,
				   SWORD cbTableQualifier,
				   UCHAR FAR *szTableOwner,SWORD cbTableOwner,
				   UCHAR FAR *szTableName,SWORD cbTableName)
{
  DBUG_ENTER("SQLTablePrivileges");
  DBUG_RETURN(set_error(((STMT FAR*) hstmt)->dbc,"08002",
			"mysql dosn't support this yet"));
}


//  Have DBMS set up result set of ColumnPrivileges.

RETCODE SQL_API SQLColumnPrivileges(HSTMT hstmt,
				    UCHAR FAR *szTableQualifier,
				    SWORD cbTableQualifier,
				    UCHAR FAR *szTableOwner,SWORD cbTableOwner,
				    UCHAR FAR *szTableName,SWORD cbTableName,
				    UCHAR FAR *szColumnName,SWORD cbColumnName)
{
  DBUG_ENTER("SQLColumnPrivileges");
  DBUG_RETURN(set_error(((STMT FAR*) hstmt)->dbc,"08002",
			"mysql dosn't support this yet"));
}


//  Have DBMS set up result set of SpecialColumns.


MYSQL_FIELD SQLSPECIALCOLUMNS_fields[] = {
  {"Scope","mySQL SpecialColumns",NULL,FIELD_TYPE_SHORT,5,5,
   NOT_NULL_FLAG},
  {"Column_name","mySQL SpecialColumns",NULL,FIELD_TYPE_STRING,NAME_LEN,
   NAME_LEN,NOT_NULL_FLAG},
  {"Data_type","mySQL SpecialColumns",NULL,FIELD_TYPE_SHORT,5,5,
   NOT_NULL_FLAG},
  {"Type_name","mySQL SpecialColumns",NULL,FIELD_TYPE_STRING,20,20,
   NOT_NULL_FLAG},
  {"Precision","mySQL SpecialColumns",NULL,FIELD_TYPE_LONG,7,7},
  {"Length","mySQL SpecialColumns",NULL,FIELD_TYPE_LONG,7,7},
  {"Scale","mySQL SpecialColumns",NULL,FIELD_TYPE_SHORT,3,3},
  {"Pseudo_column","mySQL SpecialColumns",NULL,FIELD_TYPE_SHORT,3,3}
};

const uint SQLSPECIALCOLUMNS_FIELDS=array_elements(SQLSPECIALCOLUMNS_fields);


RETCODE SQL_API SQLSpecialColumns(HSTMT hstmt,UWORD fColType,
				  UCHAR FAR *szTableQualifier,
				  SWORD cbTableQualifier,
				  UCHAR FAR *szTableOwner,SWORD cbTableOwner,
				  UCHAR FAR *szTableName,SWORD cbTableName,
				  UWORD     fScope,UWORD fNullable)
{
  char buff[80],table_name[NAME_LEN+1];
  uint field_count,c_length;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  char **row;
  MEM_ROOT *alloc;
  bool primary_key;
  MYSQL_FIELD *field;
  DBUG_ENTER("SQLSpecialColumns");

  if (check_parameters(hstmt,szTableQualifier,cbTableQualifier,szTableOwner,
		       cbTableOwner,szTableName,&cbTableName,table_name,1))
    DBUG_RETURN(SQL_ERROR);

  if (!(stmt->result=mysql_list_fields(&stmt->dbc->mysql,table_name,0)))
  {
    strmov(stmt->dbc->sqlstate,"S1000");
    return(SQL_ERROR);
  }

  if (fColType == SQL_ROWVER)
  {						/* Find possible timestamp */
    stmt->result_array=
      (char**) my_malloc(sizeof(char*)*SQLSPECIALCOLUMNS_FIELDS*
			 stmt->result->field_count, MYF(MY_FAE | MY_ZEROFILL));
    /* convert mysql fields to data that odbc wants */
    alloc=&stmt->result->field_alloc;
    field_count=0;
    mysql_field_seek(stmt->result,0);
    for (row= stmt->result_array ;
         (field = mysql_fetch_field(stmt->result)) ;
         )
    {
      int type;
      if ((field->type != FIELD_TYPE_TIMESTAMP))
        continue;
      field_count++;
      sprintf(buff,"%d",SQL_SCOPE_SESSION);
      row[0]=sql_strdup_root(alloc,buff);
      row[1]= field->name;
      type=unireg_to_sql_datatype(field,buff,&c_length);
      row[3]=sql_strdup_root(alloc,buff);
      sprintf(buff,"%d",type);
      row[2]=sql_strdup_root(alloc,buff);
      sprintf(buff,"%d",field->length);
      row[4]=sql_strdup_root(alloc,buff);
      sprintf(buff,"%d",c_length);
      row[5]=sql_strdup_root(alloc,buff);
      sprintf(buff,"%d",field->decimals);
      row[6]=sql_strdup_root(alloc,buff);
      sprintf(buff,"%d",SQL_PC_NOT_PSEUDO);
      row[7]=sql_strdup_root(alloc,buff);
      row+=SQLSPECIALCOLUMNS_FIELDS;
    }
    stmt->result->row_count=field_count;
    mysql_link_fields(stmt->result,SQLSPECIALCOLUMNS_fields,
		      SQLSPECIALCOLUMNS_FIELDS);
    fix_result_types(stmt);
    DBUG_RETURN(SQL_SUCCESS);
  }

  /*
   * The optimal set of columns for identifing a row is either
   * the primary key, or if there is no primary key, then
   * all the fields.
   */

  /* Check if there is a primary (unique) key */
  primary_key=0;
  while ((field = mysql_fetch_field(stmt->result)))
  {
    if (field->flags & PRI_KEY_FLAG)
    {
      primary_key=1;
      break;
    }
  }
  stmt->result_array=
    (char**) my_malloc(sizeof(char*)*SQLSPECIALCOLUMNS_FIELDS*
		       stmt->result->field_count, MYF(MY_FAE | MY_ZEROFILL));

  /* convert mysql fields to data that odbc wants */
  alloc=&stmt->result->field_alloc;
  field_count=0;
  mysql_field_seek(stmt->result,0);
  for (row= stmt->result_array ;
       (field = mysql_fetch_field(stmt->result)) ;
       )
  {
    int type;
    if (primary_key && !(field->flags & PRI_KEY_FLAG))
      continue;
    field_count++;
    sprintf(buff,"%d",SQL_SCOPE_SESSION);
    row[0]=sql_strdup_root(alloc,buff);
    row[1]= field->name;
    type=unireg_to_sql_datatype(field,buff,&c_length);
    row[3]=sql_strdup_root(alloc,buff);
    sprintf(buff,"%d",type);
    row[2]=sql_strdup_root(alloc,buff);
    sprintf(buff,"%d",field->length);
    row[4]=sql_strdup_root(alloc,buff);
    sprintf(buff,"%d",c_length);
    row[5]=sql_strdup_root(alloc,buff);
    sprintf(buff,"%d",field->decimals);
    row[6]=sql_strdup_root(alloc,buff);
    sprintf(buff,"%d",SQL_PC_NOT_PSEUDO);
    row[7]=sql_strdup_root(alloc,buff);
    row+=SQLSPECIALCOLUMNS_FIELDS;
  }
  stmt->result->row_count=field_count;
  mysql_link_fields(stmt->result,SQLSPECIALCOLUMNS_fields,
		    SQLSPECIALCOLUMNS_FIELDS);
  fix_result_types(stmt);
  DBUG_RETURN(SQL_SUCCESS);
}


//  Have DBMS set up result set of PrimaryKeys.

MYSQL_FIELD SQLPRIM_KEYS_fields[] = {
  {"Table_qualifer","mySQL Primary keys",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"Table_owner","mySQL Primary keys",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"Table_name","mySQL Primary keys",NULL,FIELD_TYPE_STRING,NAME_LEN,NAME_LEN,
   NOT_NULL_FLAG},
  {"Column_name","mySQL Primary keys",NULL,FIELD_TYPE_STRING,NAME_LEN,NAME_LEN,
   NOT_NULL_FLAG},
  {"Key_seq","mySQL Primary keys",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"Pk_name","mySQL Primary keys",NULL,FIELD_TYPE_STRING,128,0},
};

const uint SQLPRIM_KEYS_FIELDS=array_elements(SQLPRIM_KEYS_fields);

RETCODE SQL_API SQLPrimaryKeys(HSTMT hstmt,
			       UCHAR FAR *szTableQualifier,
			       SWORD cbTableQualifier,
			       UCHAR FAR *szTableOwner,SWORD cbTableOwner,
			       UCHAR FAR *szTableName,SWORD cbTableName)
{
  char buff[100],table_name[NAME_LEN+1],**data;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  uint row_count;
  MYSQL_ROW row;
  DBUG_ENTER("SQLPrimaryKeys");

  if (check_parameters(hstmt,szTableQualifier,cbTableQualifier,szTableOwner,
		       cbTableOwner,szTableName,&cbTableName,table_name,1))
    DBUG_RETURN(SQL_ERROR);
  remove_escape(table_name);
  strxmov(buff,"show keys from ",table_name,NullS);
  if (mysql_query(&stmt->dbc->mysql,buff) ||
      !(stmt->result=mysql_store_result(&stmt->dbc->mysql)))
  {
    strmov(stmt->dbc->sqlstate,"S1000");
    DBUG_RETURN(SQL_ERROR);
  }
  stmt->result_array= (char**) my_malloc(sizeof(char*)*SQLPRIM_KEYS_FIELDS*
					 stmt->result->row_count,
					 MYF(MY_FAE | MY_ZEROFILL));
  row_count=0;
  data=stmt->result_array;
  while ((row = mysql_fetch_row(stmt->result)))
  {
    if (row[1][0] == '0')			/* If unique index */
    {
      if (row_count && !strcmp(row[3],"1"))
	break;					/* Allready found unique key */
      row_count++;
      data[0]=data[1]=data[5]=0;
      data[2]=row[0];
      data[3]=row[4];
      data[4]=row[3];
      data+=SQLPRIM_KEYS_FIELDS;
    }
  }
  stmt->result->row_count=row_count;
  mysql_link_fields(stmt->result,SQLPRIM_KEYS_fields,SQLPRIM_KEYS_FIELDS);
  fix_result_types(stmt);
  DBUG_RETURN(SQL_SUCCESS);
}

/*
** Have DBMS set up result set of ForeignKeys.
** mysql dosen't have foreing key, return empty set
*/

MYSQL_FIELD SQLFORE_KEYS_fields[] = {
  {"Pktable_qualifer","mySQL Foreign keys",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"PkTable_owner","mySQL Foreign keys",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"PkTable_name","mySQL Foreign keys",NULL,FIELD_TYPE_STRING,NAME_LEN,
   NAME_LEN,NOT_NULL_FLAG},
  {"PkColumn_name","mySQL Foreign keys",NULL,FIELD_TYPE_STRING,NAME_LEN,
   NAME_LEN,NOT_NULL_FLAG},
  {"fktable_qualifier","mySQL Foreign keys",NULL,FIELD_TYPE_STRING,NAME_LEN,0,
   NOT_NULL_FLAG},
  {"fkTable_owner","mySQL Foreign keys",NULL,FIELD_TYPE_STRING,NAME_LEN,0},
  {"fkTable_name","mySQL Foreign keys",NULL,FIELD_TYPE_STRING,NAME_LEN,
   NAME_LEN,NOT_NULL_FLAG},
  {"fkColumn_name","mySQL Foreign keys",NULL,FIELD_TYPE_STRING,NAME_LEN,
   NAME_LEN,NOT_NULL_FLAG},
  {"Key_seq","mySQL Foreign keys",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"Update_rule","mySQL Foreign keys",NULL,FIELD_TYPE_SHORT,2,2},
  {"Delete_rule","mySQL Foreign keys",NULL,FIELD_TYPE_SHORT,2,2},
  {"Fk_name","mySQL Foreign keys",NULL,FIELD_TYPE_STRING,128,0},
  {"Pk_name","mySQL Foreign keys",NULL,FIELD_TYPE_STRING,128,0},
};

const uint SQLFORE_KEYS_FIELDS=array_elements(SQLFORE_KEYS_fields);

RETCODE SQL_API SQLForeignKeys(HSTMT hstmt,
			       UCHAR FAR *szPkTableQualifier,
			       SWORD cbPkTableQualifier,
			       UCHAR FAR *szPkTableOwner,SWORD cbPkTableOwner,
			       UCHAR FAR *szPkTableName,SWORD cbPkTableName,
			       UCHAR FAR *szFkTableQualifier,
			       SWORD cbFkTableQualifier,
			       UCHAR FAR *szFkTableOwner,SWORD cbFkTableOwner,
			       UCHAR FAR *szFkTableName,SWORD cbFkTableName)
{
  FAR STMT *stmt=(FAR STMT*) hstmt;
  DBUG_ENTER("SQLForeignKeys");

  SQLFreeStmt(hstmt,MYSQL_RESET);
  stmt->result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES),MYF(MY_ZEROFILL));
  stmt->result->eof=1;
  mysql_link_fields(stmt->result,SQLFORE_KEYS_fields,SQLFORE_KEYS_FIELDS);
  fix_result_types(stmt);
  DBUG_RETURN(SQL_SUCCESS);
}


//  Have DBMS set up result set of Procedures.

RETCODE SQL_API SQLProcedures(HSTMT hstmt,
			      UCHAR FAR *szProcQualifier,SWORD cbProcQualifier,
			      UCHAR FAR *szProcOwner,SWORD cbProcOwner,
			      UCHAR FAR *szProcName,SWORD cbProcName)
{
  return set_error(((STMT FAR*)hstmt)->dbc,"08002",
		   "mysql dosn't support this yet");
}


//  Have DBMS set up result set of ProcedureColumns.

RETCODE SQL_API SQLProcedureColumns(HSTMT hstmt,
				    UCHAR FAR *szProcQualifier,
				    SWORD cbProcQualifier,
				    UCHAR FAR *szProcOwner,SWORD cbProcOwner,
				    UCHAR FAR *szProcName,SWORD cbProcName,
				    UCHAR FAR *szColumnName,SWORD cbColumnName)
{
  return set_error(((STMT FAR*)hstmt)->dbc,"08002",
		   "mysql dosn't support this yet");
}


static int check_parameters(HSTMT hstmt,UCHAR FAR *szTableQualifier,
			    SWORD cbTableQualifier,UCHAR FAR *szTableOwner,
			    SWORD cbTableOwner, UCHAR FAR *szTableName,
			    SWORD *cbTableName,
			    char *table_name,bool no_wildcards)
{
#ifdef NOT_NEEDED
  {
    char buff[128],*res;
    if ((szTableQualifier &&
         strcmp(res=fix_str(buff,szTableQualifier,cbTableQualifier),"%") &&
         res[0]) ||
        (szTableOwner && strcmp(res=fix_str(buff,szTableOwner,cbTableOwner),"%") &&
         res[0]))
    {
      DBUG_PRINT("error",("szTableQualifier: '%s'  szTableOwner: '%s'  res: '%s'",
			   szTableQualifier,szTableOwner,res));
      return set_error(((STMT FAR*) hstmt)->dbc,
  		       "S1C00","Can't use tablequalifer or owners");
    }
  }
#endif
  /* Check table name and copy it to table_name */
  if (!szTableName)
  {
    szTableName="";
    *cbTableName=0;
  }
  if (*cbTableName == SQL_NTS)
    *cbTableName=strlen(szTableName);
  if ((uint) *cbTableName > NAME_LEN)
    return set_error(((STMT FAR*) hstmt)->dbc,"SC1090","Invalid table name");
  strmake(table_name,szTableName,*cbTableName);
  if (no_wildcards && (!table_name[0] || strchr(table_name,'%')))
    return(set_error(((STMT FAR*) hstmt)->dbc,"S1C00",
		     "Can't use wildcards in table name"));
  SQLFreeStmt(hstmt,MYSQL_RESET);
  return 0;
}
