/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/* password checking routines */
/*****************************************************************************
  The main idea is that no password are sent between client & server on
  connection and that no password are saved in mysql in a decodable form.

  On connection a random string is generated and sent to the client.
  The client generates a new string with a random generator inited with
  the hash values from the password and the sent string.
  This 'check' string is sent to the server where it is compared with
  a string generated from the stored hash_value of the password and the
  random string.

  The password is saved (in user.password) by using the PASSWORD() function in
  mysql.

  Example:
    update user set password=PASSWORD("hello") where user="test"
  This saves a hashed number as a string in the password field.
*****************************************************************************/

#include <global.h>
#include <m_string.h>
#include "mysql.h"


void randominit(struct rand_struct *rand,ulong nr)
{
  rand->max_value= 0x01FFFFFFL;
  nr%=rand->max_value;
  rand->seed=nr ; rand->seed2=nr/2 ;
}


double rnd(struct rand_struct *rand)
{
  rand->seed=(rand->seed*3+rand->seed2) % rand->max_value;
  rand->seed2=(rand->seed+rand->seed2+33) % rand->max_value;
  return (((double) rand->seed)/rand->max_value);
}


static ulong hash_password(const char *password)
{
  register ulong nr=1345345333L, nr2=7;
  ulong tmp;
  for (; *password ; password++)
  {
    if (*password == ' ' || *password == '\t')
      continue;			/* skipp space in password */
    tmp=(ulong) (uchar) *password;
    nr^= (((nr & 63)+nr2)*tmp)+ (nr << 8);
    nr2+=tmp;
  }
  return nr & (((ulong) 1L << 31) -1L); /* Don't use sign bit (str2int) */
}

void make_scrambled_password(char *to,const char *password)
{
  sprintf(to,"%08lx",hash_password(password));
}

ulong get_salt_from_password(const char *password)
{
  long val=0;
  if (password)
    VOID(str2int(password,16,0,LONG_MAX,&val));
  return (uint) val;
}

/*
 * Genererate a new message based on message and password
 * The same thing is done in client and server and the results are checked.
 */

char *scramble(char *to,const char *message,const char *password)
{
  struct rand_struct rand;
  if (password && password[0])
  {
    randominit(&rand,hash_password(password) ^ hash_password(message));
    while (*message++)
      *to++= (char) (floor(rnd(&rand)*31)+64);
  }
  *to=0;
  return to;
}


bool check_scramble(const char *scramble,const char *message,ulong salt)
{
  struct rand_struct rand;
  randominit(&rand,salt ^ hash_password(message));
  while (*scramble)
  {
    if (*scramble++ != (char) (floor(rnd(&rand)*31)+64))
      return 1;					/* Wrong password */
  }
  return 0;
}
