/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

#ifdef _WIN32
#include <winsock.h>
#include <odbcinst.h>
#endif
#include <global.h>
#include <my_sys.h>
#include <m_string.h>
#include "mysql.h"
#include "version.h"
#include "errmsg.h"
#include <sys/stat.h>
#include <signal.h>
#ifdef	 HAVE_PWD_H
#include <pwd.h>
#endif
#ifndef MSDOS
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#endif
#ifdef HAVE_SYS_UN_H
#  include <sys/un.h>
#endif
#ifdef THREAD
#include <my_pthread.h>				/* because of signal()	*/
#endif

#ifndef INADDR_NONE
#define INADDR_NONE	-1
#endif

static int	Init=0;
static MYSQL	*current_mysql;
uint		mysql_port=0;
string		mysql_unix_port=0;

#define CLIENT_CAPABILITIES	0		/* We can nothing yet */

#ifdef MSDOS
#define ERRNO WSAGetLastError()
#define perror(A)
#else
#define ERRNO errno
#define SOCKET_ERROR -1
#define closesocket(A) close(A)
#endif

static MYSQL_DATA *read_rows (MYSQL *mysql,MYSQL_FIELD *fields,
			      uint field_count);
static void end_server(MYSQL *mysql);
static void remember_connection(MYSQL *mysql);
static void read_user_name(char *name);
static void append_wild(char *to,const char *wild);


/*****************************************************************************
** read a packet from server. Give error message if socket was down
** or package is an error message
*****************************************************************************/

static uint
net_safe_read(MYSQL *mysql)
{
  NET *net= &mysql->net;
  uint len=0;

  if (net->fd >= 0 && (len=net_read(net)) == packet_error || len == 0)
  {
    DBUG_PRINT("error",("Wrong packet. len: %d",len));
    end_server(mysql);
    strmov(net->last_error,SERVER_GONE_ERROR);
    return(packet_error);
  }
  if (net->buff[0] == 255)
  {
    if (net->buff[1])
      VOID(strmake(net->last_error,(char*) net->buff+1,
		   sizeof(net->last_error)-1));
    else
      VOID(strmov(net->last_error,UNKNOWN_ERROR));
    DBUG_PRINT("error",("Got error: %s",net->last_error));
    return(packet_error);
  }
  return len;
}


/* Get the length of next field. Change parameter to point at fieldstart */
static ulong
net_field_length(uchar **packet)
{
  reg1 uchar *pos= *packet;
  if (*pos < 251)
  {
    (*packet)++;
    return (ulong) *pos;
  }
  if (*pos == 251)
  {
    (*packet)++;
    return NULL_LENGTH;
  }
  if (*pos == 252)
  {
    (*packet)+=3;
    return uint2korr(pos+1);
  }
  if (*pos == 253)
  {
    (*packet)+=4;
    return uint3korr(pos+1);
  }
  (*packet)+=6;					/* Must be 254 when here */
  return uint4korr(pos+1);
}

static void free_rows(MYSQL_DATA *cur)
{
  if (cur)
  {
    sql_free(&cur->alloc);
    my_free((gptr) cur,MYF(0));
  }
}


static void
simple_command(MYSQL *mysql,enum enum_server_command command, const char *arg,
	       uint length)
{
  NET *net= &mysql->net;

  if (mysql->net.fd >= 0)
  {
    mysql->net.last_error[0]=0;
    mysql->info=0;
    mysql->affected_rows= (ulong) ~0L;
    remember_connection(mysql);
    net_clear(net);			/* Clear receive buffer */
    if (!arg)
      arg="";
    VOID(net_write_command(net,(uchar) command,arg,
			   length ? length :strlen(arg)));
  }
}


static void free_old_query(MYSQL *mysql)
{
  DBUG_ENTER("free_old_query");
  if (mysql->fields)
    sql_free(&mysql->field_alloc);
  else
    init_sql_alloc(&mysql->field_alloc);
  mysql->fields=0;
  mysql->field_count=0;				/* For API */
  DBUG_VOID_RETURN;
}


#if !defined(MSDOS) && ! defined(VMS)
static void read_user_name(char *name)
{
#ifdef HAVE_CUSERID
  if (geteuid() == 0)
    VOID(strmov(name,"root"));		/* allow use of su & surun */
  else
    VOID(cuserid(name));
#else
  struct passwd *skr,*getpwuid();
  char *str,*getlogin();
  DBUG_ENTER("read_user_name");
  if (geteuid() == 0)
    VOID(strmov(name,"root"));		/* allow use of surun */
  else
  {
#define USERNAMELENGTH 16
    if ((str=getlogin()) == NULL)
      if ((skr=getpwuid(geteuid())) != NULL)
	str=skr->pw_name;
      else
	if ((str=getenv("USER")) == NULL)
	  if ((str=getenv("LOGNAME")) == NULL)
	    if ((str=getenv("LOGIN")) == NULL)
	      str="NO USER";
    VOID(strmake(name,str,USERNAMELENGTH-1));
  }
  DBUG_VOID_RETURN;
#endif
}

#else /* If MSDOS || VMS */

static void read_user_name(char *name)
{
  strmov(name,"ODCB");	 /* ODBC will send user variable */
}

#endif

/*
** Expand wildcard to a sql string
*/

static void
append_wild(char *to,const char *wild)
{
  if (wild && wild[0])
  {
    to=strmov(to," like '");
    while (*wild)
    {
      if (*wild == '\\' || *wild == '\'')
	*to++='\\';
      *to++= *wild++;
    }
    to[0]='\'';
    to[1]=0;
  }
}



/**************************************************************************
** Init debugging if MYSQL_DEBUG environment variable is found
**************************************************************************/

static void
mysql_debug(void)
{
#ifndef DBUG_OFF
  char	*env;
  if ((env = getenv("MYSQL_DEBUG")))
  {
    DEBUGGER_ON;
    DBUG_PUSH(env);
#if !defined(_WINVER) && !defined(WINVER)
    puts("\n-------------------------------------------------------");
    puts("MYSQL_DEBUG found. libmysql started with the following:");
    puts(env);
    puts("-------------------------------------------------------\n");
#else
    {
      char buff[80];
      strmov(strmov(buff,"libmysql: "),env);
      MessageBox((HWND) 0,"Debugging variable MYSQL_DEBUG used",buff,MB_OK);
    }
#endif
  }
#endif
}


/**************************************************************************
** Store the server socket currently in use
** Used by pipe_handler if error on socket interrupt
**************************************************************************/

static void
remember_connection(MYSQL *mysql)
{
  current_mysql = mysql;
}

/**************************************************************************
** Close the server connection if we get a SIGPIPE
   ARGSUSED
**************************************************************************/

static sig_handler
pipe_sig_handle(int sig __attribute__((unused)))
{
  DBUG_PRINT("info",("Hit by signal %d",sig));
#ifdef NOT_USED
  end_server(current_mysql);
#endif
#ifdef DONT_REMEMBER_SIGNAL
  VOID(signal(SIGPIPE,pipe_sig_handle));
#endif
}


/**************************************************************************
** Shut down connection
**************************************************************************/

static void
end_server(MYSQL *mysql)
{
  DBUG_ENTER("end_server");
  if (mysql->net.fd >= 0)
  {
    DBUG_PRINT("enter",("Socket: %d", mysql->net.fd));
    VOID(shutdown(mysql->net.fd,2));
    VOID(closesocket(mysql->net.fd));
    mysql->net.fd= -1;
    net_end(&mysql->net);
    free_old_query(mysql);
  }
  DBUG_VOID_RETURN;
}


void mysql_free_result(MYSQL_RES *result)
{
  DBUG_ENTER("mysql_free_result");
  DBUG_PRINT("enter",("mysql_res: %lx",result));
  if (result)
  {
    free_rows(result->data);
    if (result->fields)
      sql_free(&result->field_alloc);
    if (result->row)
      my_free((gptr) result->row,MYF(0));
    my_free((gptr) result,MYF(0));
  }
  DBUG_VOID_RETURN;
}


/***************************************************************************
** Change field rows to field structs
***************************************************************************/

static MYSQL_FIELD *
unpack_fields(MYSQL_DATA *data,MEM_ROOT *alloc,uint fields,bool default_value)
{
  MYSQL_ROWS	*row;
  MYSQL_FIELD	*field,*result;

  field=result=(MYSQL_FIELD*) sql_alloc_root(alloc,sizeof(MYSQL_FIELD)*fields);
  if (!result)
    return 0;

  for (row=data->data; row ; row = row->next,field++)
  {
    field->table=  sql_strdup_root(alloc,(char*) row->data[0]);
    field->name=   sql_strdup_root(alloc,(char*) row->data[1]);
    field->length= (uint) uint3korr(row->data[2]);
    field->type=   (enum enum_field_types) (uchar) row->data[3][0];
    field->flags=   (uint) (uchar) row->data[4][0];
    field->decimals=(uint) (uchar) row->data[4][1];
    if (default_value && row->data[5])
      field->def=sql_strdup_root(alloc,(char*) row->data[5]);
    else
      field->def=0;
    field->max_length= 0;
  }
  free_rows(data);				/* Free old data */
  return(result);
}


/* Read all rows (fields or data) from server */

static MYSQL_DATA *read_rows(MYSQL *mysql,MYSQL_FIELD *mysql_fields,
			     uint fields)
{
  uint	field,pkt_len;
  ulong len;
  uchar *cp;
  char	*to;
  MYSQL_DATA *result;
  MYSQL_ROWS **prev_ptr,*cur;
  NET *net = &mysql->net;
  DBUG_ENTER("read_rows");

  if ((pkt_len=(uint) net_safe_read(mysql)) == packet_error)
    DBUG_RETURN(0);
  if (!(result=(MYSQL_DATA*) my_malloc(sizeof(MYSQL_DATA),
				       MYF(MY_WME | MY_ZEROFILL))))
  {
    strmov(mysql->net.last_error,OUT_OF_MEMORY);
    DBUG_RETURN(0);
  }
  result->alloc.min_malloc=fields*(sizeof(char*)+1);
  prev_ptr= &result->data;
  result->rows=0;
  result->fields=fields;

  while (*(cp=net->buff) != 254 || pkt_len != 1)
  {
    result->rows++;
    if (!(cur= (MYSQL_ROWS*) sql_alloc_root(&result->alloc,
					    sizeof(MYSQL_ROWS))) ||
	!(cur->data= ((MYSQL_ROW)
		      sql_alloc_root(&result->alloc,
				     (fields+1)*sizeof(char *)+pkt_len))))
    {
      free_rows(result);
      strmov(mysql->net.last_error,OUT_OF_MEMORY);
      DBUG_RETURN(0);
    }
    *prev_ptr=cur;
    prev_ptr= &cur->next;
    to= (char*) (cur->data+fields+1);
    for (field=0 ; field < fields ; field++)
    {
      if ((len=net_field_length(&cp)) == NULL_LENGTH)
      {						/* null field */
	cur->data[field] = 0;
      }
      else
      {
	cur->data[field] = to;
	memcpy(to,(char*) cp,len); to[len]=0;
	to+=len+1;
	cp+=len;
	if (mysql_fields)
	{
	  if (mysql_fields[field].max_length < len)
	    mysql_fields[field].max_length=len;
	}
      }
    }
    cur->data[field]=to;			/* End of last field */
    if ((pkt_len=net_safe_read(mysql)) == packet_error)
    {
      free_rows(result);
      DBUG_RETURN(0);
    }
  }
  *prev_ptr=0;					/* last pointer is null */
  DBUG_PRINT("exit",("Got %d rows",result->rows));
  DBUG_RETURN(result);
}


/*
** Read one row. Uses packet buffer as storage for fields.
** When next package is read, the previous field values are destroyed
*/


static int
read_one_row(MYSQL *mysql,uint fields,MYSQL_ROW row)
{
  uint field,pkt_len,len;
  uchar *pos,*prev_pos;

  if ((pkt_len=(uint) net_safe_read(mysql)) == packet_error)
    return -1;
  if (pkt_len == 1 && mysql->net.buff[0] == 254)
    return 1;				/* End of data */
  prev_pos= 0;				/* allowed to write at packet[-1] */
  pos=mysql->net.buff;
  for (field=0 ; field < fields ; field++)
  {
    if ((len=net_field_length(&pos)) == NULL_LENGTH)
    {						/* null field */
      row[field] = 0;
    }
    else
    {
      row[field] = (char*) pos;
      pos+=len;
    }
    if (prev_pos)
      *prev_pos=0;				/* Terminate prev field */
    prev_pos=pos;
  }
  row[field]=(char*) prev_pos+1;		/* End of last field */
  *prev_pos=0;					/* Terminate last field */
  return 0;
}


/**************************************************************************
** Connect to sql server
** If host == 0 then use localhost
**************************************************************************/

MYSQL *mysql_connect(MYSQL *mysql,const char *host,
		     const char *user, const char *passwd)
{
  char		buff[100],*end;
  int		sock;
  ulong		ip_addr;
  struct	sockaddr_in sock_addr;
  NET		*net;
#ifndef MSDOS
  char		*env;
  int		opt;
  struct servent *serv_ptr;
#endif

#ifdef HAVE_SYS_UN_H
  struct	sockaddr_un UNIXaddr;
#endif
  DBUG_ENTER("mysql_connect");

#ifdef DONT_USE_MYSQL_PWD
  if (!passwd)
    passwd=getenv("MYSQL_PWD");  /* read Password from environment (haneke) */
#endif
  if (!Init)
  {
    Init++;
    my_init();
    if (!mysql_port)
    {
      mysql_port = MYSQL_PORT;
#ifndef MSDOS
      if ((serv_ptr = getservbyname("mysql", "tcp")))
	mysql_port = (uint) ntohs((ushort) serv_ptr->s_port);
      if ((env = getenv("MYSQL_TCP_PORT")))
	mysql_port =(uint) atoi(env);
#endif
    }
#ifndef MSDOS
    if (!mysql_unix_port)
    {
      mysql_unix_port = MYSQL_UNIX_ADDR;
      if ((env = getenv("MYSQL_UNIX_PORT")))
	mysql_unix_port = env;
    }
#endif
    mysql_debug();
  }
  DBUG_PRINT("enter",("host: %s",host ? host : "(Null)"));
  if (!mysql)
  {
    if (!(mysql=(MYSQL*) my_malloc(sizeof(*mysql),MYF(MY_WME | MY_ZEROFILL))))
      DBUG_RETURN(0);
    mysql->free_me=1;
  }
  else
    bzero(mysql,sizeof(*mysql));
  remember_connection(mysql);

  net= &mysql->net;
  net->fd= -1;				/* If something goes wrong */
  if (!host)
    host=LOCAL_HOST;

  /*
  ** Grab a socket and connect it to the server
  */

#ifdef HAVE_SYS_UN_H
  if (!strcmp(host,LOCAL_HOST))
  {
    strmov(mysql->host_info,"Localhost via UNIX socket");
    DBUG_PRINT("info",("Using UNIX sock (%s)",mysql_unix_port));
    if ((sock = socket(AF_UNIX,SOCK_STREAM,0)) == SOCKET_ERROR)
    {
      sprintf(net->last_error,SOCKET_CREATE_ERROR);
      goto error;
    }
    net->fd=sock;
    opt = 1;
    VOID(setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, (char *)&opt,
		    sizeof(opt)));

    bzero(&UNIXaddr,sizeof(UNIXaddr));
    UNIXaddr.sun_family = AF_UNIX;
    strmov(UNIXaddr.sun_path, mysql_unix_port);
    if (connect(sock,(struct sockaddr *) &UNIXaddr, sizeof(UNIXaddr)) <0)
    {
      sprintf(net->last_error,CONNECTION_ERROR,errno);
      goto error;
    }
  }
  else
#endif
  {
    sprintf(mysql->host_info,"%s via TCP/IP",host);
    DBUG_PRINT("info",("Server name = %s.  Using TCP sock (%d)",
		       host,mysql_port));
    if ((sock = socket(AF_INET,SOCK_STREAM,0)) == SOCKET_ERROR)
    {
      strmov(net->last_error,IPSOCK_ERROR);
      goto error;
    }
    net->fd=sock;
#ifndef MSDOS
    opt = 1;
    VOID(setsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, (char *)&opt,
		    sizeof(opt)));
#endif
    bzero(&sock_addr,sizeof(sock_addr));
    sock_addr.sin_family = AF_INET;

    /*
    ** The server name may be a host name or IP address
    */

    if ((int) (ip_addr = inet_addr(host)) != (int) INADDR_NONE)
    {
      memcpy(&sock_addr.sin_addr,&ip_addr,sizeof(ip_addr));
    }
    else
#if defined(HAVE_GETHOSTBYNAME_R) && defined(_REENTRANT) && defined(THREAD)
    {
      int tmp_errno;
      struct hostent tmp_hostent,*hp;
      char buff[2048];
      hp = gethostbyname_r(host,&tmp_hostent,buff,sizeof(buff),&tmp_errno);
      if (!hp)
      {
	sprintf(net->last_error, UNKNOWN_HOST, host,tmp_errno);
	goto error;
      }
      memcpy(&sock_addr.sin_addr,hp->h_addr, (size_t) hp->h_length);
    }
#else
    {
      struct hostent *hp;
      if (!(hp=gethostbyname(host)))
      {
	sprintf(net->last_error, UNKNOWN_HOST, host,errno);
	goto error;
      }
      memcpy(&sock_addr.sin_addr,hp->h_addr, (size_t) hp->h_length);
    }
#endif
    sock_addr.sin_port = (ushort) htons((u_short) mysql_port);
    if (connect(sock,(struct sockaddr *) &sock_addr, sizeof(sock_addr))<0)
    {
      DBUG_PRINT("error",("Got error %d on connect to '%s'",ERRNO,host));
      sprintf(net->last_error,CONN_HOST_ERROR,host,ERRNO);
      goto error;
    }
  }

#if defined(SIGPIPE)
  VOID(signal(SIGPIPE,SIG_IGN));
#endif
  DBUG_PRINT("info",("Connection socket %d",sock));
  if (net_init(net,sock))
    goto error;
  /* Get version info */
  if (net_safe_read(mysql) == packet_error)
    goto error;

  /* Check if version of protocoll matches current one */

  mysql->protocol_version= net->buff[0];
  DBUG_DUMP("packet",(char*) net->buff,10);
  DBUG_PRINT("info",("mysql protocol version %d, server=%d",
		     PROTOCOL_VERSION, mysql->protocol_version));
  if (mysql->protocol_version != PROTOCOL_VERSION)
  {
    sprintf(net->last_error,VERSION_ERROR, mysql->protocol_version,
	    PROTOCOL_VERSION);
    goto error;
  }
  end=strend((char*) net->buff+1);
  if ((uint) (end-(char*) (net->buff+1)) < sizeof(mysql->server_version))
  {
    strmov(mysql->server_version,(char*) net->buff+1);
    DBUG_PRINT("info",("Server version = '%s'",mysql->server_version));
    mysql->thread_id=uint4korr(end+1);
    strmov(mysql->scramble,end+5);
  }
  else
    strmov(mysql->server_version,"Error in server handshake");

  /* Send client information for access check */
  int2store(buff,CLIENT_CAPABILITIES);
  int3store(buff+2,max_allowed_packet);
  if (user)
    strmov(buff+5,user);
  else
    read_user_name((char*) buff+5);
  end=scramble(strend(buff+5)+1,mysql->scramble,passwd);

  if (net_write(net,buff,(uint) (end-buff)) || net_flush(net) ||
      net_safe_read(mysql) == packet_error)
    goto error;
  DBUG_PRINT("exit",("Mysql handler: %lx",mysql));
  DBUG_RETURN(mysql);

error:
  DBUG_PRINT("error",("message: %s",net->last_error));
  end_server(mysql);
  if (mysql->free_me)
    my_free((gptr) mysql,MYF(0));
  DBUG_RETURN(0);
}


/**************************************************************************
** Set current database
**************************************************************************/

int
mysql_select_db(MYSQL *mysql, const char *db)
{
  char buff[128],*end;
  DBUG_ENTER("mysql_select_db");
  DBUG_PRINT("enter",("db: '%s'",db));

  end=strmov((char*) buff, db);
  simple_command(mysql,INIT_DB,buff,(uint) (end-buff));
  DBUG_RETURN(net_safe_read(mysql) == packet_error ? -1 : 0);
}


/*************************************************************************
** Send a QUIT to the server and close the connection
** If handle is alloced by mysql connect free it.
*************************************************************************/

void
mysql_close(MYSQL *mysql)
{
  DBUG_ENTER("mysql_close");
  if (mysql)			/* Some simple safety */
  {
    if (mysql->net.fd >= 0)
    {
      free_old_query(mysql);
      simple_command(mysql,QUIT,NullS,0);
      end_server(mysql);
    }
    if (mysql->free_me)
      my_free((gptr) mysql,MYF(0));
  }
  DBUG_VOID_RETURN;
}


/**************************************************************************
** Do a query. If query returned rows, free old rows.
** Read data by mysql_store_result or by repeat call of mysql_fetch_row
**************************************************************************/

int
mysql_query(MYSQL *mysql, const char *query)
{
  return mysql_real_query(mysql,query,strlen(query));
}


int
mysql_real_query(MYSQL *mysql, const char *query,uint length)
{
  uchar *pos;
  uint field_count;
  MYSQL_DATA *fields;
  DBUG_ENTER("mysql_real_query");
  DBUG_PRINT("query",("Query = \"%s\"",query));

  simple_command(mysql,QUERY,query,length);
  if ((length=net_safe_read(mysql)) == packet_error)
    DBUG_RETURN(-1);
  free_old_query(mysql);			/* Free old result */
  pos=(uchar*) mysql->net.buff;
  if ((field_count=(uint) net_field_length(&pos)) == 0)
  {
    mysql->affected_rows= net_field_length(&pos);
    mysql->insert_id=	  net_field_length(&pos);
    if (pos < mysql->net.buff+length && net_field_length(&pos))
      mysql->info=(char*) pos;
    DBUG_RETURN(0);
  }
  mysql->extra_info= net_field_length(&pos); /* Maybe number of rec */
  if (!(fields=read_rows(mysql,(MYSQL_FIELD*) 0,5)))
    DBUG_RETURN(-1);
  if (!(mysql->fields=unpack_fields(fields,&mysql->field_alloc,field_count,0)))
    DBUG_RETURN(-1);
  mysql->field_count=field_count;
  DBUG_RETURN(0);
}


/**************************************************************************
** Alloc result struct for buffered results. All rows are read to buffer.
** mysql_data_seek may be used.
**************************************************************************/

MYSQL_RES *
mysql_store_result(MYSQL *mysql)
{
  MYSQL_RES *result;
  DBUG_ENTER("mysql_store_result");

  if (!mysql->fields)
    DBUG_RETURN(0);
  if (!(result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES)+
				      sizeof(uint)*mysql->field_count,
				      MYF(MY_WME | MY_ZEROFILL))))
  {
    strmov(mysql->net.last_error,OUT_OF_MEMORY);
    DBUG_RETURN(0);
  }
  result->eof=1;				/* Marker for buffered */
  result->lengths=(uint*) (result+1);
  if (!(result->data=read_rows(mysql,mysql->fields,mysql->field_count)))
  {
    my_free((gptr) result,MYF(0));
    DBUG_RETURN(0);
  }
  mysql->affected_rows= result->row_count=result->data->rows;
  result->data_cursor= result->data->data;
  result->fields=	mysql->fields;
  result->field_alloc=	mysql->field_alloc;
  result->field_count=	mysql->field_count;
  result->current_field=0;
  result->current_row=0;			/* Must do a fetch first */
  mysql->fields=0;				/* fields is now in result */
  DBUG_RETURN(result);				/* Data fetched */
}


/**************************************************************************
** Alloc struct for use with unbuffered reads. Data is fetched by domand
** when calling to mysql_fetch_row.
** mysql_data_seek is a noop.
**
** No other queries may be specified with the same MYSQL handle.
** There shouldn't be much processing per row because mysql server shouldn't
** have to wait for the client (and will not wait more than 30 sec/packet).
**************************************************************************/

MYSQL_RES *
mysql_use_result(MYSQL *mysql)
{
  MYSQL_RES *result;
  DBUG_ENTER("mysql_use_result");

  if (!mysql->fields)
    DBUG_RETURN(0);
  if (!(result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES)+
				      sizeof(uint)*mysql->field_count,
				      MYF(MY_WME | MY_ZEROFILL))))
    DBUG_RETURN(0);
  result->lengths=(uint*) (result+1);
  if (!(result->row=(MYSQL_ROW)
	my_malloc(sizeof(result->row[0])*(mysql->field_count+1), MYF(MY_WME))))
  {					/* Ptrs: to one row */
    my_free((gptr) result,MYF(0));
    DBUG_RETURN(0);
  }
  result->fields=	mysql->fields;
  result->field_alloc=	mysql->field_alloc;
  result->field_count=	mysql->field_count;
  result->current_field=0;
  result->handle=	mysql;
  result->current_row=	0;
  mysql->fields=0;			/* fields is now in result */
  DBUG_RETURN(result);			/* Data is read to be fetched */
}




/**************************************************************************
** Return next field of the query results
**************************************************************************/

MYSQL_FIELD *
mysql_fetch_field(MYSQL_RES *result)
{
  if (result->current_field >= result->field_count)
    return(NULL);
  return &result->fields[result->current_field++];
}


/**************************************************************************
**  Return next row of the query results
**************************************************************************/

MYSQL_ROW
mysql_fetch_row(MYSQL_RES *res)
{
  if (!res->data)
  {
    int error;
    if (!res->eof)
    {
      if (!(error=read_one_row(res->handle,res->field_count,res->row)))
      {
	res->row_count++;
	return (res->current_row=res->row);
      }
      if (error > 0)
	res->eof=1;
    }
    return (MYSQL_ROW) NULL;
  }
  else
  {
    MYSQL_ROW tmp;
    if (!res->data_cursor)
      return (res->current_row=(MYSQL_ROW) NULL);
    tmp = res->data_cursor->data;
    res->data_cursor = res->data_cursor->next;
    return (res->current_row=tmp);
  }
}

/**************************************************************************
** Get column lengths of the current row
** This is done by calculation the offset between pointers.
**************************************************************************/

uint *
mysql_fetch_lengths(MYSQL_RES *res)
{
  uint *lengths,*prev_length;
  byte *start;
  MYSQL_ROW column,end;

  if (!(column=res->current_row))
    return 0;					/* Something is wrong */
  start=0;
  prev_length=0;				/* Keep gcc happy */
  lengths=res->lengths;
  for (end=column+res->field_count+1 ; column != end ; column++,lengths++)
  {
    if (!*column)
    {
      *lengths=0;				/* Null */
      continue;
    }
    if (start)					/* Found end of prev string */
      *prev_length= (uint) (*column-start-1);
    start= *column;
    prev_length=lengths;
  }
  return res->lengths;
}

/**************************************************************************
** Move to a specific row
**************************************************************************/

void
mysql_data_seek(MYSQL_RES *result, uint row)
{
  MYSQL_ROWS	*tmp;
  DBUG_PRINT("info",("mysql_data_seek(%d)",row));
  for (tmp=result->data->data; row-- && tmp ; tmp = tmp->next) ;
  result->current_row=0;
  result->data_cursor = tmp;
}


/*****************************************************************************
** List all databases
*****************************************************************************/

MYSQL_RES *
mysql_list_dbs(MYSQL *mysql, const char *wild)
{
  char buff[100];
  DBUG_ENTER("mysql_list_dbs");

  append_wild(strmov(buff,"show databases"),wild);
  if (mysql_query(mysql,buff) < 0)
    DBUG_RETURN(0);
  DBUG_RETURN (mysql_store_result(mysql));
}


/*****************************************************************************
** List all tables in a database
** If wild is given then only the tables matching wild is returned
*****************************************************************************/

MYSQL_RES *
mysql_list_tables(MYSQL *mysql, const char *wild)
{
  char buff[100];
  DBUG_ENTER("mysql_list_tables");

  append_wild(strmov(buff,"show tables"),wild);
  if (mysql_query(mysql,buff) < 0)
    DBUG_RETURN(0);
  DBUG_RETURN (mysql_store_result(mysql));
}


/**************************************************************************
** List all fields in a table
** If wild is given then only the fields matching wild is returned
** Instead of this use query:
** show fields in 'table' like "wild"
**************************************************************************/

MYSQL_RES *
mysql_list_fields(MYSQL *mysql, const char *table, const char *wild)
{
  MYSQL_RES *result;
  MYSQL_DATA *query;
  NET	     *net= &mysql->net;
  char	     buff[128],*end;
  DBUG_ENTER("mysql_list_fields");

  LINT_INIT(query);
  remember_connection(mysql);
  free_old_query(mysql);
  net_clear(net);
  mysql->affected_rows= (ulong) ~0L;

  end=strmov(strmov(buff, table)+1,wild ? wild : "");
  if (net_write_command(net,(uchar) FIELD_LIST,buff,(uint) (end-buff)) ||
      !(query = read_rows(mysql,(MYSQL_FIELD*) 0,6)))
    DBUG_RETURN(NULL);

  if (!(result = (MYSQL_RES *) my_malloc(sizeof(MYSQL_RES),
					 MYF(MY_WME | MY_ZEROFILL))))
  {
    free_rows(query);
    DBUG_RETURN(NULL);
  }
  result->field_count = query->rows;
  result->fields=	unpack_fields(query,&result->field_alloc,
				      result->field_count,1);
  result->eof=1;
  DBUG_RETURN(result);
}

/* List all running processes (threads) in server */

MYSQL_RES *
mysql_list_processes(MYSQL *mysql)
{
  MYSQL_DATA *fields;
  uint field_count;
  uchar *pos;
  DBUG_ENTER("mysql_list_processes");

  LINT_INIT(fields);
  free_old_query(mysql);
  simple_command(mysql,PROCESS_INFO,0,0);
  if (net_safe_read(mysql) == packet_error)
    DBUG_RETURN(0);
  pos=(uchar*) mysql->net.buff;
  field_count=(uint) net_field_length(&pos);
  if (!(fields = read_rows(mysql,(MYSQL_FIELD*) 0,5)))
    DBUG_RETURN(NULL);
  if (!(mysql->fields=unpack_fields(fields,&mysql->field_alloc,field_count,0)))
    DBUG_RETURN(0);
  mysql->field_count=field_count;
  DBUG_RETURN(mysql_store_result(mysql));
}


int
mysql_create_db(MYSQL *mysql, const char *db)
{
  char buff[128],*end;
  DBUG_ENTER("mysql_createdb");
  DBUG_PRINT("enter",("db: %s",db));

  end=strmov((char*) buff, db);
  simple_command(mysql,CREATE_DB,buff,(uint) (end-buff));
  DBUG_RETURN(net_safe_read(mysql) == packet_error ? -1 : 0);
}


int
mysql_drop_db(MYSQL *mysql, const char *db)
{
  char buff[128],*end;
  DBUG_ENTER("mysql_drop_db");
  DBUG_PRINT("enter",("db: %s",db));

  end=strmov((char*) buff, db);
  simple_command(mysql,DROP_DB,buff,(uint) (end-buff));
  DBUG_RETURN(net_safe_read(mysql) == packet_error ? -1 : 0);
}


int
mysql_shutdown(MYSQL *mysql)
{
  DBUG_ENTER("mysql_shutdown");
  simple_command(mysql,SHUTDOWN,0,0);
  DBUG_RETURN(net_safe_read(mysql) == packet_error ? -1 : 0);
}


int
mysql_reload(MYSQL *mysql)
{
  DBUG_ENTER("mysql_reload");
  simple_command(mysql,RELOAD,0,0);
  DBUG_RETURN(net_safe_read(mysql) == packet_error ? -1 : 0);
}


int
mysql_kill(MYSQL *mysql,ulong pid)
{
  char buff[4];
  DBUG_ENTER("mysql_kill");
  int4store(buff,pid);
  simple_command(mysql,PROCESS_KILL,buff,4);
  DBUG_RETURN(net_safe_read(mysql) == packet_error ? -1 : 0);
}


char *
mysql_stat(MYSQL *mysql)
{
  DBUG_ENTER("mysql_stat");
  simple_command(mysql,STATISTICS,0,0);
  if (net_safe_read(mysql) == packet_error)
    return mysql->net.last_error;
  if (!mysql->net.buff[0])
    return "Wrong packet info";
  DBUG_RETURN((char*) mysql->net.buff);
}


char *
mysql_get_server_info(MYSQL *mysql)
{
  return((char*) mysql->server_version);
}


char *
mysql_get_host_info(MYSQL *mysql)
{
  return(mysql->host_info);
}


uint
mysql_get_proto_info(MYSQL *mysql)
{
  return (mysql->protocol_version);
}

char *
mysql_get_client_info(void)
{
  return SERVER_VERSION;
}
