/* Copyright (C) 1996  TCX DataKonsult AB & Monty Program KB & Detron HB
   For a more info consult the file COPYRIGHT distributed with this file */

	/* For better memory-copy use memcpy */

#ifndef VMS
#if !defined(__ZTC__) && !defined(__WATCOMC__) && !defined(USG)
#include <memory.h>
#else
#include <string.h>
#endif
#endif

#ifdef	__cplusplus
extern "C" {
#endif

extern char NEAR _dig_vec[];		/* Declared in int2str() */

#if !defined(DS90) && ( ! defined(_MSC_VER) || defined(WIN32) )
#define bfill(A,B,C) VOID(memset((A),(C),(size_t) (B)))
#define bzero(A,B)   VOID(memset((A),0,(size_t) (B)))
#ifdef USG
#define bmove(A,B,C) memmove(A,B,C)
#endif
#ifdef HAVE_purify
#define bmove512(A,B,C) memcpy((A),(B),(C))
#endif
#ifndef HAVE_PURIFY
#ifndef bcmp
#define bcmp(A,B,C)  memcmp((A),(B),(size_t) (C))
#endif
#endif
#endif /* DS90 || _MSC_VER*/

#ifdef BAD_STRING_COMPILER
#define strmov(A,B)  (memccpy(A,B,0,INT_MAX)-1)
#else
#define strmov_overlapp(A,B) strmov(A,B)
#define strmake_overlapp(A,B,C) strmake(A,B,C)
#endif
#ifdef MSDOS
#define bmove512(A,B,C) bmove_allign(A,B,C)
#define my_itoa(A,B,C) itoa(A,B,C)
#define my_ltoa(A,B,C) ltoa(A,B,C)
extern	void bmove_allign _A((gptr dst,const gptr src,uint len));
#else
#define bmove_allign(A,B,C) memcpy(A,B,C)
#endif
#ifdef INTEL_386
#define bmove512(A,B,C) memcpy(A,B,C)
#endif

	/* Prototypes for string functions */

#ifndef bfill
extern	void bfill _A((gptr dst,uint len,pchar fill));
#endif
#ifndef bmove512
extern	void bmove512 _A((gptr dst,const gptr src,uint len));
#endif
#ifndef bzero
extern	void bzero _A((gptr dst,uint len));
#endif
#ifndef bcmp
extern	int my_bcmp _A((const char *s1,const char *s2,uint len));
extern	int bcmp _A((const char *s1,const char *s2,uint len));
#ifdef HAVE_purify
#define bcmp(A,B,C) my_bcmp((A),(B),(C))
#endif
#endif

#ifndef bmove
extern	void bmove _A((gptr dst,const char *src,uint len));
#endif
extern	void bmove_upp _A((char *dst,const char *src,uint len));
extern	void bchange _A((char *dst,uint old_len,const char *src,
			 uint new_len,uint tot_len));
extern	void strappend _A((char *s,uint len,pchar fill));
extern	char *strend _A((const char *s));
extern char *strcend _A((const char *, pchar));
extern	char *strfield _A((char *src,int fields,int chars,int blanks,
			   int tabch));
extern	char *strfill _A((char *s,uint len,pchar fill));
extern	uint strinstr _A((const char *str,const char *search));
extern	char *strkey _A((char *dst,char *head,char *tail,char *flags));
extern	char *strmake _A((char *dst,const char *src,uint length));
#ifndef strmake_overlapp
extern	char *strmake_overlapp _A((char *dst,const char *src, uint length));
#endif
#ifndef strmov
extern	char *strmov _A((char *dst,const char *src));
#endif
#ifndef strmov_overlapp
extern	char *strmov_overlapp _A((char *dst,const char *src));
#endif
extern	uint strnlen _A((const char *s,uint n));
extern	char *strnmov _A((char *dst,const char *src,uint n));
extern	char *strsuff _A((const char *src,const char *suffix));
extern	char *strcont _A((const char *src,const char *set));
extern	char *strxcat _VARARGS((char *dst,const char *src, ...));
extern	char *strxmov _VARARGS((char *dst,const char *src, ...));
extern	char *strxcpy _VARARGS((char *dst,const char *src, ...));
extern	char *strxncat _VARARGS((char *dst,uint len, const char *src, ...));
extern	char *strxnmov _VARARGS((char *dst,uint len, const char *src, ...));
extern	char *strxncpy _VARARGS((char *dst,uint len, const char *src, ...));

	/* Prototypes of normal stringfunctions (with may ours) */

#ifdef NOT_NEADED
extern char *strcat _A((char *, const char *));
extern char *strchr _A((const char *, pchar));
extern char *strrchr _A((const char *, pchar));
#ifndef __GNUC__
extern size_t strlen _A((const char *));
#endif
#endif /* _WINDOWS */

#if !defined(__cplusplus) && !defined(_WINDOWS)
extern char *strpbrk _A((const char *, const char *));
extern size_t strspn _A((const char *, const char *));
extern char *strstr _A((const char *, const char *));
#endif
extern qsort_cmp get_ptr_compare _A((uint));
extern int is_prefix _A((const char *, const char *));
/* extern char *strtok _A((char *, const char *)); */

#if !defined(DGUX) || !defined(__OPTIMIZE__)
extern char *strcpy _A((char *, const char *));
extern int strcmp _A((const char *, const char *));
#endif

	/* Conversion rutins */

#ifdef USE_MY_ITOA
extern char *my_itoa _A((int val,char *dst,int radix));
extern char *my_ltoa _A((long val,char *dst,int radix));
extern long strtol _A((const char *str, char **ptr, int base));
extern ulong strtoul _A((const char *str, char **ptr, int base));
#endif

extern char *int2str _A((long val,char *dst,int radix));
extern char *str2int _A((const char *src,int radix,long lower,long upper,
			 long *val));
#ifdef HAVE_LONGLONG
extern char *longlong2str _A((longlong val,char *dst,int radix));
#ifndef HAVE_LONGLONGLIB
extern longlong strtoll _A((const char *str, char **ptr, int base));
extern ulonglong strtoull _A((const char *str, char **ptr, int base));
#endif
#endif

#ifdef	__cplusplus
}
#endif
