/* Copyright (C) 1996  TCX DataKonsult AB & Monty Program KB & Detron HB
   For a more info consult the file COPYRIGHT distributed with this file */

/* Definitioner f|r parameterar till och fr}n input */

#define MAX_INPUT_LENGTH max(511,FN_REFLEN)	/* Max row to m_input */
#define SCROLL_JUMP 8				/* Jumps when scrolling */

#define T_RETURN	1
#define T_NEXT		10
#define T_PREV		11
#define T_NEXTROW	12
#define T_PREVROW	13
#define T_CE		14

#define T_HOME		20
#define T_NEXTPAGE	21
#define T_PREVPAGE	22
#define T_READY		23
#define T_UPDATE	24
#define T_END		25
#define T_READY_PRINT	26
#define T_GOTOLINE	27

#define T_READ		30
#define T_READNEXT	31
#define T_READPREV	32
#define T_READINC	33
#define T_SEARCH_REC	34
#define T_SEARCH_REC2	35
#define T_SHOW_REC	36
#define T_DELETE	37
#define T_HELP		38
#define T_SHELL		39
#define T_EXTEND_COMMAND 40

#define T_INSROW	41
#define T_DELROW	42
#define T_INSPAGE	43
#define T_DELPAGE	44
#define T_PR_MARK	45
#define T_PR_UNMARK	46
#define T_PR_PRINT	47
#define T_TO_NEXT_DAT	48
#define T_TO_PREV_DAT	49
#define T_MAKE_MACRO	50

#define T_BACK		51
#define T_STOP		52
#define T_MENY		53

	/* Rad-editeringstangenter */
	/* OBS! Dessa {r beroende av positionen i setup_km */

#define MAXTANGENT 255
#define T_NEXTCHAR 256+1
#define T_PREVCHAR 256+2
#define T_DELCHAR  256+3

	/* F|ljande anv{nds som gr{ns-avskiljare */

#define T_MOVEF 20
#define T_MOVEL 30
#define T_RESET 51

	/* Parameter fr}n input */

#define CHANGE 256
#define PRGTANG 256		/* Offset f|r tangent med funktion */
#define FUNKTANG 512		/* Offset f|r funktionstangent fr}n get_tang */

	/* Parameter till input */

#define MI_SCREEN_FIELD		1	/* Inmatning av rutedit-rad */
#define MI_FILE_FIELD		2	/* Inmatning av filnamn */
#define MI_SEARCH		3	/* Nummer med '?' och '*' */
#define MI_REGFIELD		4	/* Man kan mata in ett f{ltnamn */
#define MI_NOT_RANGE		5	/* Kan vara intervall men inte tv{ng */
#define MI_GET_RANGE		6	/* Use get_range, no force */
#define MI_BIT_RANGE		7	/* Field can have several int-values */
#define MI_RANGE_OR_EMPTY	8	/* Range, but allow empty */

	/* Struktur f|r specialparametrar till input */

typedef struct st_input_type {
  int		field_type;		/* Type of field */
  int		types;			/* How many different intervalls */
  string	dev;			/* Pointer to where files is */
  TYPELIB	*intervall;		/* standar input-values */
  TYPELIB	*table_alias;		/* Name of tables */
  TYPELIB	*names[17];		/* Pointer to formnames */
  TYPELIB	*s_names;		/* Pointers to screen-field-names */
  TYPELIB	*(*get_range) _A((gptr,string,uint,string *));
					/* external ranges */
  gptr		get_range_param;	/* first param to get_range() */
} INPUT_TYPE;

/* external variables... */

extern int NEAR return_key_value;
extern int NEAR my_input_inited;
extern int NEAR in_querry;
extern int NEAR put_cursor_on_screen;	/* neaded by my_mess */
extern my_bool NEAR input_insert_mode;

	/* Prototypes for extern functions */

extern int m_input _A((uint inputflag,uint length,uint slength,char *pos,
		       int *infield,int *kol,struct st_input_type *type));
extern void *init_m_input _A((char *progdir,char *languagedir));
extern void end_m_input _A((void ));
extern void set_input_func _A((void (*func1)(string,int),void (*func2)(int)));
extern int format_number _A((uint inputflag,uint maxlength,char *pos,
			     uint length,char * *errpos));
extern int get_tang _A((void ));
extern int get_cur_tang _A((uint wait_for_real_key));
extern int test_if_key _A((void ));
extern void empty_keybuffer _A((int flag));
extern int sleeptang _A((int wait_time));
extern void push_back_last_key _A((void));
extern void show_key_bindings _A((void ));
extern int skipp_begin_sp _A((string pos));
extern int skipp_last_sign _A((string pos,uint length));
extern int load_and_exec_macro _A((string name,int macro_repeat,
				   pbool load_only));
extern int make_macro_reader _A((int (*read_function) _A((char *,int, void *)),
				 void *arg));
