/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/* Include right curses to be used */
/* Set up ATTR_? to rutins to be used, independent of curses */

#define _m_curses_h			/* Signal global about curses */

#ifdef P_CURSES
#include "pcurses.h"			/* ncurses includes global.h */

#define HAS_CURSES_ADDMEM		/* waddmem function exists */
/*
 Attribute is as following:
   0 = Normal
   1 = Bold	(Or incresed intensity)
   2 = Underline
   3 = Flash
   4 = Revers
   5 = Bold+flash
Colors is as following:
   0 = Normal (White)
   1 = Red
   2 = Green
   3 = Yellow
   4 = Blue
   5 = Magentha
   6 = Cyan
   7 = White on blue:		Used as input-field
   8 = Red   on Yellow:		Fatal error
*/

#define ATTR_CUR_ON()		curson()
#define ATTR_CUR_OFF()		cursoff()
#define FIX_CURSOR_POS()	fix_cursor_position()
#define ATTR_ALL_OFF(W)		{ wattribute(W,0); wcolor(W,0); }
#define ATTR_REV(W)		wattribute(W,4)
#define ATTR_REV_OFF(W)		wattribute(W,0)
#define ATTR_UL(W)		wattribute(W,2)
#define ATTR_UL_OFF(W)		wattribute(W,0)
#define ATTR_BOLD(W)		wattribute(W,1)
#define ATTR_BOLD_OFF(W)	wattribute(W,0)
#define ATTR_INPUT(W)		wcolor(W,7)
#define ATTR_INPUT_OFF(W)	wcolor(W,0)
#define ATTR_INFO(W)		wcolor(W,4)
#define ATTR_INFO_OFF(W)	wcolor(W,0)
#define ATTR_WORKING(W)		wattribute(W,5)
#define ATTR_WORKING_OFF(W)	wattribute(W,0)
#define ATTR_ERROR(W)		wcolor(W,1)
#define ATTR_ERROR_OFF(W)	wcolor(W,0)
#define ATTR_FATAL_ERROR(W)	wcolor(W,8)
#define ATTR_FATAL_ERROR_OFF(W) wcolor(W,0)
#define ATTR_HELP_BOX(W)	wcolor(W,0) /* 6 */
#define ATTR_KEY_BOX(W)		wcolor(W,0) /* 3 */
#define ATTR_VALUES_BOX(W)	wcolor(W,0) /* 2 */
#define ATTR_BOX(W)		wbox(W,0,0,(int)W->_maxy,(int)W->_maxx,OVERLAY)
#define ATTR_EXTEND_BOX(W,A,B,C,D,E)	wbox(W,A,B,C,D,E)
#define WINDOW_BEGY(W)		(W)->_begy
#define WNOUTREFRESH(W)		wnoutrefresh(W)

#else
#ifdef M_TERMCAP
#include <curses.h>
#include "global.h"

#define ATTR_CUR_ON()		{}
#define ATTR_CUR_OFF()		{}
#define FIX_CURSOR_POS()
#define ATTR_ALL_OFF(W)		wstandend(W)
#define ATTR_REV(W)		wstandout(W)
#define ATTR_REV_OFF(W)		wstandend(W)
#define ATTR_UL(W)		wstandout(W)
#define ATTR_UL_OFF(W)		wstandend(W)
#define ATTR_BOLD(W)		wstandout(W)
#define ATTR_BOLD_OFF(W)	wstandend(W)
#define ATTR_INPUT(W)		wstandout(W)
#define ATTR_INPUT_OFF(W)	wstandend(W)
#define ATTR_INFO(W)		{}
#define ATTR_INFO_OFF(W)	{}
#define ATTR_WORKING(W)		{}
#define ATTR_WORKING_OFF(W)	{}
#define ATTR_ERROR(W)		wstandout(W)
#define ATTR_ERROR_OFF(W)	wstandend(W)
#define ATTR_FATAL_ERROR(W)	wstandout(W)
#define ATTR_FATAL_ERROR_OFF(W) wstandend(W)
#define ATTR_HELP_BOX(W)	{}
#define ATTR_KEY_BOX(W)		{}
#define ATTR_VALUES_BOX(W)	{}
#define ATTR_BOX(W)		box(W,'*','*')
#define ATTR_EXTEND_BOX(W,A,B,C,D,E)	ATTR_BOX(W)
#define WINDOW_BEGY(W)		(W)->_begy
#define WNOUTREFRESH(W)		wrefresh(W)
#define endwin_free_only()	{}
#ifndef __linux__
void beep _A((void));			/* Declared in my_mess.c */
#endif
#else
#if defined(TERMINFO) || defined(SYS5_TERMINFO)		/* TERMINFO */
#include <curses.h>
#include "global.h"

#define ATTR_CUR_ON()
#define ATTR_CUR_OFF()
#define FIX_CURSOR_POS()
#define ATTR_ALL_OFF(W)		wattroff(W,A_REVERSE+A_BOLD+A_UNDERLINE+\
					 A_STANDOUT+A_DIM)
#define ATTR_REV(W)		wattron(W,A_REVERSE)
#define ATTR_REV_OFF(W)		wattroff(W,A_REVERSE)
#define ATTR_UL(W)		wattron(W,A_UNDERLINE)
#define ATTR_UL_OFF(W)		wattroff(W,A_UNDERLINE)
#define ATTR_BOLD(W)		wattron(W,A_BOLD)
#define ATTR_BOLD_OFF(W)	wattroff(W,A_BOLD)
#define ATTR_INPUT(W)		wattron(W,A_REVERSE)
#define ATTR_INPUT_OFF(W)	wattroff(W,A_REVERSE)
#define ATTR_INFO(W)		wattron(W,A_UNDERLINE)
#define ATTR_INFO_OFF(W)	wattroff(W,A_UNDERLINE)
#define ATTR_WORKING(W)		wattron(W,A_BOLD+A_STANDOUT)
#define ATTR_WORKING_OFF(W)	wattroff(W,A_BOLD+A_STANDOUT)
#define ATTR_ERROR(W)		wattron(W,A_DIM)
#define ATTR_ERROR_OFF(W)	wattroff(W,A_DIM)
#define ATTR_FATAL_ERROR(W)	wattron(W,A_STANDOUT)
#define ATTR_FATAL_ERROR_OFF(W) wattroff(W,A_STANDOUT)
#define ATTR_HELP_BOX(W)	wattron(W,A_BOLD)
#define ATTR_KEY_BOX(W)		wattron(W,A_BOLD)
#define ATTR_VALUES_BOX(W)	wattron(W,A_BOLD)
#define ATTR_BOX(W)		box(W,'*','*')
#define ATTR_EXTEND_BOX(W,A,B,C,D,E)	ATTR_BOX(W)
#define WINDOW_BEGY(W)		(W)->_begy
#define WNOUTREFRESH(W)		wrefresh(W)
#define endwin_free_only()	{}

#else
#ifdef VAXCURSES
#include <curses.h>
#include "global.h"

#define ATTR_CUR_ON()
#define ATTR_CUR_OFF()
#define FIX_CURSOR_POS()
#define ATTR_ALL_OFF(W)		wclrattr(W,_BLINK|_BOLD|_REVERSE|_UNDERLINE)
#define ATTR_REV(W)		wsetattr(W,_REVERSE)
#define ATTR_REV_OFF(W)		wclrattr(W,_REVERSE)
#define ATTR_UL(W)		wsetattr(W,_UNDERLINE)
#define ATTR_UL_OFF(W)		wclrattr(W,_UNDERLINE)
#define ATTR_BOLD(W)		wsetattr(W,_BOLD)
#define ATTR_BOLD_OFF(W)	wclrattr(W,_BOLD)
#define ATTR_INPUT(W)		ATTR_REV(W)
#define ATTR_INPUT_OFF(W)	ATTR_REV_OFF(W)
#define ATTR_INFO(W)		ATTR_UL(W)
#define ATTR_INFO_OFF(W)	ATTR_UL_OFF(W)
#define ATTR_WORKING(W)		wsetattr(W,_BOLD|_BLINK)
#define ATTR_WORKING_OFF(W)	wclrattr(W,_BOLD|_BLINK)
#define ATTR_ERROR(W)		ATTR_BOLD(W)
#define ATTR_ERROR_OFF(W)	ATTR_BOLD_OFF(W)
#define ATTR_FATAL_ERROR(W)	ATTR_REV(W)
#define ATTR_FATAL_ERROR_OFF(W) ATTR_REV_OFF(W)
#define ATTR_HELP_BOX(W)	wsetattr(W,_BOLD)
#define ATTR_KEY_BOX(W)		wsetattr(W,_BOLD)
#define ATTR_VALUES_BOX(W)	wsetattr(W,_BOLD)
#define ATTR_BOX(W)		box(W,'*','*')
#define ATTR_EXTEND_BOX(W,A,B,C,D,E)	ATTR_BOX(W)
#define WNOUTREFRESH(W)		wrefresh(W)
#define WINDOW_BEGY(W)		(W)->_beg_y
#define cbreak()				/* cbreak not neaded */
#define winsertln(w)		my_winsertln(w) /* winsertln() doesn't work */
#define endwin_free_only()	{}
#define COLS			(curscr->_max_x)
#define LINES			(curscr->_max_y)

#else					/* PC_CURSES */
#include <global.h>
#include <curses.h>

#define HAS_CURSES_ADDMEM		/* waddmem function exists */
/*
 Attribute is as following:
   7   = Normal		(This should always be on, except for underline)
   8   = Bold
   1   = Underline	(Must be reset to normal)
   128 = Flash
Colors is as following:
   0 = Black
   1 = Blue
   2 = Green
   3 = Cyan
   4 = Red
   5 = Magentha
   6 = Yellow
   7 = White	(Normal)
*/

#define ATTR_CUR_ON()		curson()
#define ATTR_CUR_OFF()		cursoff()
#define FIX_CURSOR_POS()
#define ATTR_ALL_OFF(W)		wapplic_color(W,0)
#define ATTR_REV(W)		wfbreverse(W)
#define ATTR_REV_OFF(W)		wfbreverse(W)
#define ATTR_UL(W)		wapplic_color(W,9)
#define ATTR_UL_OFF(W)		ATTR_ALL_OFF(W)
#define ATTR_BOLD(W)		wapplic_color(W,10)
#define ATTR_BOLD_OFF(W)	ATTR_ALL_OFF(W)
#define ATTR_INPUT(W)		wapplic_color(W,1)
#define ATTR_INPUT_OFF(W)	ATTR_ALL_OFF(W)
#define ATTR_INFO(W)		wapplic_color(W,2)
#define ATTR_INFO_OFF(W)	ATTR_ALL_OFF(W)
#define ATTR_WORKING(W)		wapplic_color(W,3)
#define ATTR_WORKING_OFF(W)	ATTR_ALL_OFF(W)
#define ATTR_ERROR(W)		wapplic_color(W,4)
#define ATTR_ERROR_OFF(W)	ATTR_ALL_OFF(W)
#define ATTR_FATAL_ERROR(W)	wapplic_color(W,5)
#define ATTR_FATAL_ERROR_OFF(W) ATTR_ALL_OFF(W)
#define ATTR_HELP_BOX(W)	wapplic_color(W,6)
#define ATTR_KEY_BOX(W)		wapplic_color(W,7)
#define ATTR_VALUES_BOX(W)	wapplic_color(W,8)
#define ATTR_BOX(W)		box(W);
#define ATTR_EXTEND_BOX(W,A,B,C,D,E) wbox(W,A,B,C,D,(E | DOUBLE_HEIGHT))
#define WINDOW_BEGY(W)		(W)->_begy
#define WNOUTREFRESH(W)		wnoutrefresh(W)
#define endwin_free_only()	{}

#endif			/* PC_CURSES */
#endif			/* VAXCURSES */
#endif			/* TERMINFO */
#endif			/* P_CURSES */

#ifndef HAS_CURSES_ADDMEM
#define waddmem(W,S,L) {  string macro_pos,macro_endpos;\
			 for (macro_pos=(S), macro_endpos=macro_pos+(L);\
			      macro_pos < macro_endpos ;\
			      macro_pos++)\
			   waddch(W,*macro_pos); }
#endif


	/* Some standar curses-functions that we use */

extern WINDOW *my_newwin _A((int num_lines,int num_columns,int begy,int begx));
extern void my_delwin _A((WINDOW *win));
extern void my_touchwindows _A((void));
extern void my_refresh _A((void));
