/* Copyright (C) 1996  TCX DataKonsult AB & Monty Program KB & Detron HB
   For a more info consult the file COPYRIGHT distributed with this file */
/*
  A better inplementation of the UNIX ctype(3) library.
  Notes:   global.h should be included before ctype.h
*/

#ifndef _m_ctype_h
#define _m_ctype_h
#ifdef WIN32
#include <ctype.h>
#endif
#define _CTYPE_H	/* Don't include std ctype.h when this is included */

#ifndef CTYPE_LIBRARY
#define EXT extern
#define D(x)
#else
#define EXT
#define D(x)	= x
#endif

#define	_U	01	/* Upper case */
#define	_L	02	/* Lower case */
#define	_N	04	/* Numeral (digit) */
#define	_S	010	/* Spacing character */
#define	_P	020	/* Punctuation */
#define	_C	040	/* Control character */
#define	_B	0100	/* Blank */
#define	_X	0200	/* heXadecimal digit */

extern uchar NEAR ctype_usa7[];
extern uchar NEAR to_upper_usa7[],NEAR to_lower_usa7[],NEAR sort_order_usa7[];

extern uchar NEAR ctype_swe7[];
extern uchar NEAR to_upper_swe7[],NEAR to_lower_swe7[],NEAR sort_order_swe7[];

extern uchar NEAR ctype_hp8[];
extern uchar NEAR to_upper_hp8[],NEAR to_lower_hp8[],NEAR sort_order_hp8[];

extern uchar NEAR ctype_dec8[];
extern uchar NEAR to_upper_dec8[],NEAR to_lower_dec8[],NEAR sort_order_dec8[];

extern uchar NEAR ctype_ISO_8859_1[];
extern uchar NEAR to_upper_ISO_8859_1[],NEAR to_lower_ISO_8859_1[],
	     NEAR sort_order_ISO_8859_1[];

#if defined(USE_USA7BITCHARS) + \
    defined(USE_SWE7BITCHARS) + \
    defined(USE_DEC8BITCHARS) + \
    defined(USE_HP8BITCHARS) + \
    defined(USE_ISO_8859_1) + \
    defined(MSDOS) != 1
error "More than one USE_xxxnBITCHARS defined"
#endif

#ifdef USE_USA7BITCHARS
/* to_*_usa7 is also used directly by other programs (dlisp) */

EXT uchar *my_ctype	D(ctype_usa7);
EXT uchar *my_to_lower	D(to_lower_usa7);
EXT uchar *my_to_upper	D(to_upper_usa7);
EXT uchar *my_sort_order D(sort_order_usa7);

#else
#ifdef USE_SWE7BITCHARS

EXT uchar *my_ctype	D(ctype_swe7);
EXT uchar *my_to_upper	D(to_upper_swe7);
EXT uchar *my_to_lower	D(to_lower_swe7);
EXT uchar *my_sort_order D(sort_order_swe7);

#else
#ifdef USE_HP8BITCHARS

/* use HPUX internal tables */

EXT uchar *my_ctype		D(ctype_hp8);
EXT uchar *my_to_upper		D(to_upper_hp8);
EXT uchar *my_to_lower		D(to_lower_hp8);
EXT uchar *my_sort_order	D(sort_order_hp8);

#else
#ifdef USE_DEC8BITCHARS

/* use DEC multinational chars */

EXT uchar *my_ctype		D(ctype_dec8);
EXT uchar *my_to_upper		D(to_upper_dec8);
EXT uchar *my_to_lower		D(to_lower_dec8);
EXT uchar *my_sort_order	D(sort_order_dec8);


#else
#ifdef USE_ISO_8859_1

EXT uchar *my_ctype		D(ctype_ISO_8859_1);
EXT uchar *my_to_upper		D(to_upper_ISO_8859_1);
EXT uchar *my_to_lower		D(to_lower_ISO_8859_1);
EXT uchar *my_sort_order	D(sort_order_ISO_8859_1);

#else
#ifdef MSDOS

#define my_ctype	ctype
#define my_to_upper	to_upper
#define my_to_lower	to_lower
#define my_sort_order	sort_order

extern uchar NEAR ctype[],NEAR to_lower[],NEAR to_upper[],NEAR sort_order[];

#endif /* MSDOS */
#endif
#endif
#endif
#endif
#endif

#ifndef WIN32
#define	_toupper(c)	(char) my_to_upper[(uchar) (c)]
#define	_tolower(c)	(char) my_to_lower[(uchar) (c)]
#define toupper(c)	(char) my_to_upper[(uchar) (c)]
#define tolower(c)	(char) my_to_lower[(uchar) (c)]

#define	isalpha(c)	((my_ctype+1)[(uchar) (c)] & (_U | _L))
#define	isupper(c)	((my_ctype+1)[(uchar) (c)] & _U)
#define	islower(c)	((my_ctype+1)[(uchar) (c)] & _L)
#define	isdigit(c)	((my_ctype+1)[(uchar) (c)] & _N)
#define	isxdigit(c)	((my_ctype+1)[(uchar) (c)] & _X)
#define	isalnum(c)	((my_ctype+1)[(uchar) (c)] & (_U | _L | _N))
#define	isspace(c)	((my_ctype+1)[(uchar) (c)] & _S)
#define	ispunct(c)	((my_ctype+1)[(uchar) (c)] & _P)
#define	isprint(c)	((my_ctype+1)[(uchar) (c)] & (_P | _U | _L | _N | _B))
#define	isgraph(c)	((my_ctype+1)[(uchar) (c)] & (_P | _U | _L | _N))
#define	iscntrl(c)	((my_ctype+1)[(uchar) (c)] & _C)
#define	isascii(c)	(!((c) & ~0177))
#define	toascii(c)	((c) & 0177)
#endif

#ifdef ctype
#undef ctype
#endif /* ctype */

	/* These is allways used */

/* Some macros that should be cleaned up a little */
#define isvar(c)	(isalnum(c) || (c) == '_')
#define isvar_start(c)	(isalpha(c) || (c) == '_')
#define tocntrl(c)	((c) & 31)
#define toprint(c)	((c) | 64)

#endif /* _m_ctype_h */
