/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */


/* general definitions */

#define	 ERR		0		/* general error flag */
#define	 OK		1		/* general OK flag */

/* functions defined as macros */

#define getch()	   wgetch(stdscr)	/* using macroes allows you to use */
#define	ungetch(c) wungetch(c)		/* #undef getch/ungetch in your */
					/* programs to use MSC/TRC getch() */
					/* and ungetch() routines */
#define getyx(win,y,x)   	(y = (win)->_cury, x = (win)->_curx)
#define mvcur(oldy,oldx,newy,newx) _mvcur(newy,newx)

/* video attribute definitions. Colour definitions for */
/* CGA/EGA should also go here... */

#define wattribute(win,A)	((win)->_attrs= (win)->_attrs & 0x7000 | (A<<8))
#define wbcolor(win,A)		((win)->_attrs= (win)->_attrs & 0x8f00 | (A<<12))
#define wfcolor(win,A)		wattribute(win,A)
#define wattrcolor(win,A,C)	((win)->_attrs= ((A) | ((C) << 4)) << 8)
#define wfbcolor(win,A,C)	((win)->_attrs= ((A) | ((C) << 4)) << 8)
#define wattron(win,A) \
	( win->_attrs= (A & 0x70 ? win->attrs & 0x8f00 | (A<<8) : win->attrs | (A<<8)))
#define wattroff(win,A) \
	( win->_attrs= (A & 0x70 ? win->_attrs & 0x8f00 : \
	               (A & 0x07 ? win->_attrs | 0x0700 : win->_attrs & (~A<<8)))
#define wattrset(win,A)		((win)->_attrs= (A<<8))
#define wstandout(win)		(win)->_attrs= 0x7000)
#define wstandend(win)		(win)->_attrs= 0x0700)
#define wgetfcolor(win)		(((win)->_attrs >> 8) & 7)
#define wgetbcolor(win)		(((win)->_attrs >> 12) & 7)

#define	A_ALTCHARSET   0x07
#define	A_BLINK        0x80
#define	A_BLANK        0
#define	A_BOLD         0x0f
#define	A_DIM          0x07
#define	A_PROTECT      0x07
#define	A_REVERSE      0x70
#define	A_STANDOUT     0x70
#define	A_UNDERLINE    0x01

	/* Defines for wbox() */

#define OVERLAY		1
#define DOUBLE_WIDTH	2
#define DOUBLE_HEIGHT	4

	/* type declarations */

#ifdef __WATCOMC__
#pragma pack(4)				/* Used by memadd.asm */
#endif

typedef struct st_window
  {
  short	   _cury;			/* Current pseudo-cursor */
  short	   _curx;
  short	   _maxy;			/* Max coordinates */
  short	   _maxx;
  short	   _begy;			/* Origin on screen */
  short	   _begx;
  short	   _flags;			/* Window properties */
  short	   _attrs;			/* Attributes of written characters */
  short	   _tabsize;			/* Tab character size */
  bool	   _clear;			/* Causes clear at next refresh */
  bool	   _leave_cursor;		/* Leaves cursor as it happens */
  bool	   _scroll;			/* Allows window scrolling */
  bool	   _nodelay;			/* Input character wait flag */
  bool	   _keypad;			/* Flags keypad key mode active */
  short   **_line;			/* Pointer to line pointer array */
  short	  *_minchng;			/* First changed character in line */
  short	  *_maxchng;			/* Last changed character in line */
  short	   _regtop;			/* Top of scrolling region */
  short	   _regbottom;			/* Bottom of scrolling region */
  }	WINDOW;

#ifdef __WATCOMC__
#pragma pack()
#endif
	/* External variables */

extern	int NEAR	LINES;		/* terminal height */
extern	int NEAR	COLS;		/* terminal width */
extern	WINDOW * NEAR	curscr;		/* the current screen image */
extern	WINDOW * NEAR	stdscr;		/* the default screen window */

	/* PCcurses function declarations */

#define _FA	__fastcall

extern int _FA	addch(pchar c);		/* put char in stdscr */
extern int	addstr(char *str);	/* put string in stdscr */
extern void _FA	beep(void);		/* sound bell */
extern void _FA	border(int l,int r,int t,int b,int tl,int tr,int bl,int br);
extern void _FA	box(WINDOW *win);
extern void _FA	cbreak(void);		/* set terminal cbreak mode */
extern void _FA	clear(void);		/* clear stdscr */
extern void _FA	clearok(WINDOW *win,pchar flag);
extern int _FA	clrtobot(void);		/* clear end of stdscr */
extern int _FA	clrtoeol(void);		/* clear end of line in stdscr */
extern void _FA	crmode(void);		/* set terminal cbreak mode */
extern void _FA	cursoff(void);		/* turns off hardware cursor */
extern void _FA	curson(void);		/* turns on hardware cursor */
extern void _FA	def_prog_mode(void);	/* save TTY modes */
extern void _FA	def_shell_mode(void);	/* compatibility dummy */
extern int _FA	delch(void);		/* delete a char in stdscr */
extern int _FA	deleteln(void);		/* delete a line in stdscr */
extern void _FA	delwin(WINDOW *win);	/* delete a window or a subwindow */
extern void	doupdate(void);		/* update physical screen */
extern void _FA	echo(void);		/* set terminal echo mode */
extern int _FA	endwin(void);		/* cleanup and finitialization */
extern void _FA	erase(void);		/* erase stdscr */
extern int _FA	fixterm(void);		/* compatibility dummy */
extern void _FA	flushinp(void);		/* kill pending keyboard input */
extern int _FA	getstr(char *str);	/* get string to stdscr and buffer */
extern int _FA	initscr(void);		/* curses initialization */
extern int _FA	inch(void);		/* get char at stdscr cursor */
extern int _FA	insch(pchar c);		/* insert character in stdscr */
extern int _FA	insrawch(pchar c);	/* insert character in stdscr, raw */
extern int _FA	insertln(void);		/* insert new line in stdscr */
extern char 	* _FA longname(void);	/* terminal description */
extern void _FA	leaveok(WINDOW *win,pchar flag);
extern int _FA	move(int y,int x);	/* move cursor in stdscr */
extern int	mvaddstr(int y,int x,char *str);
extern int _FA	_mvcur(int newy,int newx);
extern int _FA	mvdelch(int y,int x);	/* move & delete a char in stdscr */
extern int _FA	mvgetstr(int y,int x,char *str);
extern int _FA	mvinch(int y,int x);	/* move & get char at stdscr cursor */
extern int _FA	mvinsch(int y,int x,pchar c);
extern int _FA	mvinsrawch(int y,int x,pchar c);
extern int	mvprintw _VARARGS((int y,int x,const char *fmt,...));
extern int	mvscanw();		/* move & get values via stdscr */
extern int	mvwaddch(WINDOW *win,int y,int x,pchar c);
extern int	mvwaddstr(WINDOW *win,int y,int x,char *str);
extern int _FA	mvwdelch(WINDOW *win,int y,int x);
extern int _FA	mvwgetstr(WINDOW *win,int y,int x,char *str);
extern int _FA	mvwinch(WINDOW *win,int y,int x);
extern int _FA	mvwinsch(WINDOW *win,int y,int x,pchar c);
extern int _FA	mvwinsrawch(WINDOW *win,int y,int x,pchar c);
extern int _FA	mvwin(WINDOW *win,int begy,int begx);
extern int	mvwprintw();		/* move & print string in a window */
extern int	mvwscanw();		/* move & get values via a window */
extern WINDOW *	_FA newwin(int num_lines,int num_columns,int begy,int begx);
extern void _FA	nocbreak(void);		/* unset terminal cbreak mode */
extern void _FA	nocrmode(void);		/* unset terminal cbreak mode */
extern void _FA	noecho(void);		/* unset terminal echo mode */
extern void _FA	noraw(void);		/* unset raw terminal mode */
extern void _FA	overlay(WINDOW *win1,WINDOW *win2);
extern void _FA	overwrite(WINDOW *win1,WINDOW *win2);
extern int	printw _VARARGS((const char *fmt,...));
extern void _FA	raw(void);		/* set raw terminal mode */
extern void _FA	refresh(void);		/* refresh stdscr */
extern int _FA	resetterm(void);	/* compatibility dummy */
extern int _FA	resetty(void);		/* restore terminal I/O modes */
extern void _FA	reset_prog_mode(void);	/* restore terminal I/O modes */
extern void _FA	reset_shell_mode(void);	/* set terminal to default modes */
extern int _FA	savetty(void);		/* save terminal I/O modes */
extern int	scanw();		/* get values via stdscr */
extern void	scroll(WINDOW *win);	/* scroll region in a window */
extern WINDOW 	* _FA subwin(WINDOW *orig,int num_lines,int num_columns,int begy,int begx);
extern int _FA	tabsize(int ts);	/* set/get tabsize of stdscr */
extern void _FA	touchwin(WINDOW *win);	/* mark a window as modified */
extern int _FA	waddch(WINDOW *win,pchar c);
extern int	waddstr(WINDOW *win,char *str);
extern void _FA	wborder(WINDOW *win,int l,int r,int t,int b,int tl,int tr,int bl,int br);
extern int _FA	wbox(WINDOW *win,int ymin,int xmin,int ymax,int xmax,int flag);
extern void _FA	wclear(WINDOW *win);	/* clear a window */
extern int _FA	wclrtobot(WINDOW *win);	/* clear end of a window */
extern int _FA	wclrtoeol(WINDOW *win);	/* clear end of line in a window */
extern int _FA	wdelch(WINDOW *win);	/* delete a char in a window */
extern int _FA	wdeleteln(WINDOW *win);	/* delete a line in a window */
extern void _FA	werase(WINDOW *win);	/* erase a window */
extern int _FA	wgetch(WINDOW *win);	/* get char to a window */
extern int _FA	wgetstr(WINDOW *win,char *str);
extern int _FA	winch(WINDOW *win);	/* get char at window cursor */
extern int _FA	winsch(WINDOW *win,pchar c);
extern int _FA	winsertln(WINDOW *win);	/* insert new line in a window */
extern int 	wmove(WINDOW *win,int y,int x);
extern void _FA	wnoutrefresh(WINDOW *win);
extern int 	wprintw();		/* print string in a window */
extern void _FA	wrefresh(WINDOW *win);	/* refresh screen */
extern int	wscanw();		/* get values via a window */
extern int _FA	wsetscrreg(WINDOW *win,int top,int bottom);
extern int _FA	wtabsize(WINDOW *win,int ts);
extern int  _FA	chadd(WINDOW *win,pchar c,pchar xlat);
extern bool	_cursespendch(void);
extern int _FA	setscrreg(int top,int bottom);
extern int	waddmem(WINDOW *win,char *str,int length);
extern void _FA	not_raw_output(void);	/* Don't have raw output on screen */
extern void _FA wapplic_color(WINDOW *w,uint offset);
extern void _FA wfbreverse(WINDOW *w);
