/*
** log.h
**
** main header of the logging library
**
** (c) 1997 by Dirk Ohme - all rights reserved
*/

#ifndef __H_LOG
#define __H_LOG

/*---| definitions |---------------------------------------------------------*/
#if defined(OS2) || defined(__STDC__)
#  define USE_STDARG_H
#endif

/*---| internal constants |--------------------------------------------------*/
#define LOG_LEVEL_DISABLED             0
#define LOG_LEVEL_STANDARD             1
#define LOG_LEVEL_EXTENDED             2

#ifdef DEBUG
#  define LOG_LEVEL_DEFAULT            LOG_LEVEL_EXTENDED
#else
#  define LOG_LEVEL_DEFAULT            LOG_LEVEL_DISABLED
#endif

#define LOG_STATUS                     ' '
#define LOG_ERROR                      '!'
#define LOG_WARNING                    '>'
#define LOG_INPUT                      'i'
#define LOG_OUTPUT                     'o'
#define LOG_SUMMARY                    '+'
#define LOG_RETURNCODE                 '<'

/*---| function prototypes |-------------------------------------------------*/
RETCODE SQL_LOCAL_API LogInit(         char     *pszPrgName          );
RETCODE SQL_LOCAL_API LogSetLevel(     int       iLogLevel           );
#ifdef USE_STDARG_H
  RETCODE SQL_LOCAL_API LogEntry(      char      cLogType, ...       );
#else
  RETCODE SQL_LOCAL_API LogEntry();
#endif

/*---------------------------------------------------------------------------*/
#endif

/*===| end of file |=========================================================*/
