/*
** CLI.C - This is the module containing the code for the
** Call Level Interface
**
** (c) 1997 by Dirk Ohme - all rights reserved
*/

#include "cli.h"

/*---------------------------------------------------------------------------*/
/*      Allocate something specified                                         */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLAllocHandle(   SQLSMALLINT    HandleType,
                             SQLINTEGER     InputHandle,
                             SQLINTEGER    *OutputHandle
                        )
{
        /*
        ** check, which type of handle to allocate
        */
        switch( HandleType )
        {
                case SQL_HANDLE_ENV:
                        return SQLAllocEnv( (HENV FAR *) OutputHandle );

                case SQL_HANDLE_DBC:
                        return SQLAllocConnect( (LPENV)      InputHandle,
                                                (HDBC FAR *) OutputHandle
                                              );

                case SQL_HANDLE_STMT:
                        return SQLAllocStmt( (LPDBC)       InputHandle,
                                             (HSTMT FAR *) OutputHandle
                                           );

                case SQL_HANDLE_DESC:

                default:
                        break;

        } /* switch */

        /*
        ** return error
        */
        return SQL_ERROR;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLBindParam(     SQLHSTMT            StatementHandle,
                             SQLSMALLINT         ParamNumber,
                             SQLSMALLINT         BufferType,
                             SQLSMALLINT         ParamType,
                             SQLINTEGER          ParamLength,
                             SQLSMALLINT         Scale,
                             SQLPOINTER          Data,
                             SQLINTEGER         *DataLength
                       )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLCloseCursor(   SQLHSTMT            StatementHandle )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLCopyDesc(
                             SQLHDESC            SourceDescHandle,
                             SQLHDESC            TargetDescHandle
                      )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLEndTran(       SQLSMALLINT         HandleType,
                             SQLHENV             Handle,
                             SQLSMALLINT         CompletionType
                     )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLFreeHandle(    SQLSMALLINT         HandleType,
                             SQLINTEGER          Handle
                        )
{
        /*
        ** check, which type of handle to allocate
        */
        switch( HandleType )
        {
                case SQL_HANDLE_ENV:
                        return SQLFreeEnv( (LPENV) Handle );

                case SQL_HANDLE_DBC:
                        return SQLFreeConnect( (LPDBC) Handle );

                case SQL_HANDLE_STMT:
                        return SQLFreeStmt( (LPSTMT) Handle, SQL_DROP );

                case SQL_HANDLE_DESC:

                default:
                        break;

        } /* switch */

        /*
        ** return error
        */
        return SQL_ERROR;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLGetCol(        SQLHSTMT            StatementHandle,
                             SQLSMALLINT         ColumnNumber,
                             SQLPOINTER          TargetValue,
                             SQLINTEGER          BufferLength,
                             SQLINTEGER         *StringLength,
                             SQLINTEGER         *IndicatorValue
                    )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLGetConnectAttr(
                             SQLHDBC             ConnectionHandle,
                             SQLINTEGER          Attribute,
                             SQLPOINTER          Value,
                             SQLINTEGER          BufferLength,
                             SQLINTEGER         *StringLength
                            )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLGetDescField(  SQLHDESC            DescriptorHandle,
                             SQLSMALLINT         RecordNumber,
                             SQLSMALLINT         FieldIdentifier,
                             SQLPOINTER          Value,
                             SQLINTEGER          BufferLength,
                             SQLINTEGER         *StringLength
                          )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLGetDescRec(    SQLHDESC            DescriptorHandle,
                             SQLSMALLINT         RecordNumber,
                             SQLCHAR            *Name,
                             SQLSMALLINT         BufferLength,
                             SQLSMALLINT        *StringLength,
                             SQLSMALLINT        *Type,
                             SQLSMALLINT        *SubType,
                             SQLINTEGER         *Length,
                             SQLSMALLINT        *Precision,
                             SQLSMALLINT        *Scale,
                             SQLSMALLINT        *Nullable
                        )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLGetDiagField(  SQLSMALLINT         HandleType,
                             SQLINTEGER          Handle,
                             SQLSMALLINT         RecordNumber,
                             SQLSMALLINT         DiagIdentifier,
                             SQLPOINTER          DiagInfo,
                             SQLSMALLINT         BufferLength,
                             SQLSMALLINT        *StringLength
                          )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLGetDiagRec(    SQLSMALLINT         HandleType,
                             SQLINTEGER          Handle,
                             SQLSMALLINT         RecordNumber,
                             SQLCHAR            *Sqlstate,
                             SQLINTEGER         *NativeError,
                             SQLCHAR            *MessageText,
                             SQLSMALLINT         BufferLength,
                             SQLSMALLINT        *StringLength
                        )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLGetEnvAttr(    SQLHENV             EnvironmentHandle,
                             SQLINTEGER          Attribute,
                             SQLPOINTER          Value,
                             SQLINTEGER          BufferLength,
                             SQLINTEGER         *StringLength
                        )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLGetStmtAttr(   SQLHSTMT            StatementHandle,
                             SQLINTEGER          Attribute,
                             SQLPOINTER          Value,
                             SQLINTEGER          BufferLength,
                             SQLINTEGER         *StringLength
                         )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLLanguages(     SQLHSTMT            StatementHandle )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLReleaseEnv(    SQLHENV             EnvironmentHandle )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLServerInfo(    SQLHSTMT            StatementHandle,
                             SQLCHAR            *ServerAttribute,
                             SQLSMALLINT         AttributeLength
                        )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLSetDescField(  SQLHDESC            DescriptorHandle,
                             SQLSMALLINT         RecordNumber,
                             SQLSMALLINT         FieldIdentifier,
                             SQLPOINTER          Value,
                             SQLINTEGER          BufferLength
                          )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLSetDescRec(    SQLHDESC            DescriptorHandle,
                             SQLSMALLINT         RecordNumber,
                             SQLSMALLINT         Type,
                             SQLSMALLINT         SubType,
                             SQLINTEGER          Length,
                             SQLSMALLINT         Precision,
                             SQLSMALLINT         Scale,
                             SQLPOINTER          Data,
                             SQLINTEGER         *StringLength,
                             SQLSMALLINT *Indicator
                        )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLSetEnvAttr(    SQLHENV             EnvironmentHandle,
                             SQLINTEGER          Attribute,
                             SQLPOINTER          Value,
                             SQLINTEGER          StringLength
                        )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*---------------------------------------------------------------------------*/
/*      ???                                                                  */
/*---------------------------------------------------------------------------*/
SQLRETURN  SQLSetStmtAttr(   SQLHSTMT            StatementHandle,
                             SQLINTEGER          Attribute,
                             SQLPOINTER          Value,
                             SQLINTEGER          StringLength
                         )
{

/*
** under construction
*/

    return SQL_SUCCESS;
}

/*===| end of file |=========================================================*/
