/*
** main.c
**
** main program part of the iODBC driver manager for OS/2
**
** (c) 1997 by Dirk Ohme, all rights reserved
*/

/*---| includes |------------------------------------------------------------*/
#define INCL_PM
#define INCL_WIN
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>

#include <sqlcli_.h>
#include "iODBCmgr.h"

/*===| main() |==============================================================*/
int main( void )
{
        APIRET           iRC           = 0;
        HAB              hab;
        HMQ              hmq;
        HWND             hwndDlg;
        SQLPDriverList  *pDrvList;

        /*
        ** initialize window sub-system
        */
        hab = WinInitialize( 0 );
        hmq = WinCreateMsgQueue( hab, 0 );

        /*
        ** read in driver list
        */
        if( NULL == (pDrvList=getDriverList()) )
        {
                register ULONG  ulResponse;

                /*---| display error box |---*/
                ulResponse = WinMessageBox( HWND_DESKTOP,
                                            HWND_DESKTOP,
                                            "can't find the iODBC.INI file or file is empty"\
                                            " - shall I create an new (empty) file?",
                                            "iODBCmgr V " VERSION, 0,
                                            MB_ICONQUESTION | MB_YESNO |
                                            MB_DEFBUTTON2   | MB_MOVEABLE );

                /*---| set error code |---*/
                if( MBID_YES == ulResponse )
                        iRC = 0;       /* yes -> continue */
                else
                        iRC = 1;       /* no -> abort */
        }

        /*
        ** load and execute main dialog
        */
        if( 0 == iRC )
        {
                /*---| check for storage of results |---*/
                if( !WinDlgBox( HWND_DESKTOP, HWND_DESKTOP,
                                DlgMain,      NULLHANDLE,
                                WND_MAIN,     (PVOID) &pDrvList ) )
                {
                        /*---| abort -> do not store results |---*/
                        iRC = 3;
                }
        }

        /*
        ** write driver list
        */
        if( 0 == iRC && 0 != putDriverList(pDrvList) )
        {
                /*---| display error box |---*/
                WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
                               "can't write the iODBC.INI file",
                               "iODBCmgr", 0,
                               MB_OK | MB_ERROR | MB_MOVEABLE );

                /*---| set error code |---*/
                iRC = 2;
        }

        /*
        ** di-initialize window sub-system
        */
        WinDestroyMsgQueue( hmq );
        WinTerminate( hab );

        /*
        ** return success
        */
        return iRC;

} /* main() */

/*===| end of file |=========================================================*/
