.*------------------------------------------------------------------------------
.* iODBC (OS/2) - limits
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Limitations and Differences to Standard CLI/ODBC'
.*------------------------------------------------------------------------------
:h1 id=limits clear.Limitations and Differences to Standard CLI/ODBC
:p.Depending on the version of this CLI/ODBC implementation, there are
limitations and differences to the CLI or ODBC standard. Some of them, which
are common to all versions, are described below, others, unique to one
version, in the following sub-sections.

:p.There are the following limits dependingless to the version&colon.
:lm margin=5.:ul.
:li.The length of the string associated to a cursor is limited to the value
:hp4.SQL_MAX_CURSOR_NAME:ehp4. (32 byte = :hp4.31:ehp4. characters plus
terminating NUL).
:li.Under :hp2.OS/2:ehp2. the order functions are stored in the dynamic link
libraries was changed in :hp1.1.00.4:ehp1.. The new order can be watched in
the file :hp4.LIB\ODBC.def:ehp4.. The old order, which was valid up to version
:hp1.1.00.3:ehp1. can be checked in the file :hp4.LIB\ODBC_103.def:ehp4..
:hp8.It may be necessary to re-compile programs linked against an older
version of this ODBC manager!:ehp8.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.* 'Limits for mSQL'
.*------------------------------------------------------------------------------
:h2 id=limits_msql clear.Limits for mSQL
:p.Currently these SQL and C data types are supported for mSQL&colon.
:lm margin=5.:ul.
:li.:link reftype=hd refid=sql_data_types.SQL_CHAR:elink. (SQL_C_CHAR) equals
the :hp1.CHAR:ehp1. data type of mSQL.
:li.:link reftype=hd refid=sql_data_types.SQL_INTEGER:elink. (SQL_C_INTEGER)
equals the :hp1.INT:ehp1. data type of mSQL.
:li.:link reftype=hd refid=sql_data_types.SQL_REAL:elink. (SQL_C_REAL) equals
the :hp1.REAL:ehp1. data type of mSQL.
:eul.:lm margin=1.

:p.The implementation level of routines equals :hp1.ODBC core level:ehp1..

:p.There are the following limits for mSQL for Unix and mSQL for OS/2&colon.
:lm margin=5.:ul.
:li.The number of resulting colums which can be bound to variables is limited
to :hp4.SQL_MAX_COLUMN:ehp4. (:hp4.64:ehp4.).
:li.The number of input parameters on a query, insert, update, delete, etc.,
which can be bound to variables, is limited to :hp4.SQL_MAX_PARAM:ehp4.
(:hp4.16:ehp4.).
:li.There is a maximum size a SQL statement can reach at execution time of
:hp4.SQL_MAX_BUFFER_SIZE:ehp4. (:hp4.65535:ehp4.) bytes - this includes the
SQL statement plus all string space provided by input parameters (bounded
variables).
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.* 'Limits for Oracle'
.*------------------------------------------------------------------------------
:h2 id=limits_oracle clear.Limits for Oracle
:p.Currently these SQL and C data types are supported for Oracle 7.x&colon.
:lm margin=5.:ul.
:li.:link reftype=hd refid=sql_data_types.SQL_CHAR:elink. (SQL_C_CHAR) equals
the :hp1.VARCHAR2:ehp1. data type of Oracle 7.x.
:li.:link reftype=hd refid=sql_data_types.SQL_INTEGER:elink. (SQL_C_INTEGER)
equals the :hp1.NUMBER:ehp1. data type of Oracle 7.x.
:li.:link reftype=hd refid=sql_data_types.SQL_REAL:elink. (SQL_C_REAL) equals
the :hp1.NUMBER:ehp1. data type of Oracle 7.x.
:eul.:lm margin=1.

:p.The implementation level of routines equals :hp1.ODBC core level:ehp1.,
except :hp2.SQLColAttributes():ehp2. (see below).

:p.There are the following limits for Oracle 7.xcolon.
:lm margin=5.:ul.
:li.Requires Oracle's OCI (:hp1.Oracle Call Interface:ehp1.) at a version
7020200.1 (Feb. 15, 1995) or newer.
:li.:hp2.SQL_CHAR:ehp2. does :hp8.not:ehp8. refer to the :hp2.CHAR:ehp2. data
type of Oracle's database, but refers to :hp2.VARCHAR2:ehp2.. This is due to
the compatibility considerations - mSQL lacks such a data type, but its
:hp1.CHAR:ehp1. data type exquals VARCHAR2. So to keep both implementations
compatible, the :hp1.SQL_CHAR:ehp1. has been defined as stated. Another point
is, that Oracle changed definitions on CHAR and VARCHAR2 data types between
Oracle 6.x and 7.x.
:li.:link reftype=hd refid=cli_SQLColAttributes.SQLColAttributes():elink.
does not work properly (produces core dumps),
:link reftype=hd refid=cli_SQLDescribeCol.SQLDescribeCol():elink. has to be
used instead. There you have to note, that every column can be stated only
one time each! This is a limitation of Oracle's OCI ...
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
