.*------------------------------------------------------------------------------
.* iODBC (OS/2) - iODBC
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'iODBC'
.*------------------------------------------------------------------------------
:h1 id=iodbc clear.iODBC
:p.This and the following sections describe the
:hp1.intrinsic Open Data Base Connection (iODBC):ehp1. package coming along
with this.

:p.The iODBC library ables multiple database environments without having the
need to re-compile the sources. This is done by a so-called :hp1.driver
manager:ehp1.. The driver manager is a layer between application and iODBC
driver, which may be a CLI library. The driver manager's task is to check a
database connection string in order to call the proper iODBC driver.

:artwork name='IMAGES\iodbc_3.bmp' align=center.

:p.If an application wants to connect to a database :hp1.db_1:ehp1., it does
it through the driver manager, which resolves the request by a configuration
file (:link reftype=hd refid=iodbc_ini.iodbc.ini:elink.) telling that
connections to the database :hp1.db_1:ehp1. requires the driver
:hp1.Driver_A:ehp1.. All further access goes via driver manager to the
driver A.

.*------------------------------------------------------------------------------
.* 'Description of iODBC.INI'
.*------------------------------------------------------------------------------
:h2 id=iodbc_ini clear.Description of iODBC.INI
:p.The file :hp2.iODBC.INI:ehp2. is located
:lm margin=5.:ul.
:li.:hp1.OS/2:ehp1. in the same directory as the iODBC driver manager DLL
:hp1.iODBC.DLL:ehp1.,
:li.:hp1.Unix:ehp1. as file :hp2.~/.iodbc.ini:ehp2. in the user's home
directory.
:eul.:lm margin=1.

:p.If is an ASCII file containing these elements&colon.
:lm margin=5.:ul.
:li.lines starting with :hp4.#:ehp4. (hash sign) are ignored (remarks)
:li.lines starting with :hp4.;:ehp4. (semicolon) are ignored (remarks)
:li.a :hp4.[:ehp4.:hp1.DSN:ehp1.:hp4.]:ehp4. starts a new data source name
section - a data source name is the database name or database alias-name
:lm margin=10.:ul.
:li.:hp4.Driver = :ehp4.:hp1.path/file:ehp1. - path and file name of iODBC
driver
:li.:hp4.DSN = :ehp4.:hp1.new data source name:ehp1. - if given, replaces the
DSN during a :link reftype=hd refid=cli_SQLConnect.SQLConnect():elink. or
:link reftype=hd refid=cli_SQLDriverConnect.SQLDriverConnect():elink. call
:li.:hp4.Trace = :ehp4.:hp1.x:ehp1. - enable (x = 1, on, On, ON) or disable
(x = 0, off, Off, OFF) tracing
:li.:hp4.Tracefile = :ehp4.:hp1.stdout | stderr:ehp1. - on tracing specifies
the path for output; only standard output or error channel are allowed!
:eul.:lm margin=5.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.* 'Sample iODBC.INI for OS/2'
.*------------------------------------------------------------------------------
:h2 id=iodbc_os2 clear.Sample iODBC.INI for OS/2
:xmp.
:hp1.#=============================================================================#:ehp1.
:hp1.# iodbc.ini (OS/2)                                                            #:ehp1.
:hp1.#=============================================================================#:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.# sample configuration file for iODBC                                         #:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.#-----------------------------------------------------------------------------#:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.# a driver section is set up like this:                                       #:ehp1.
:hp1.#       [<identifier>]                                                        #:ehp1.
:hp1.#               Driver = <path>/<name_of_dynamic_link_library>                #:ehp1.
:hp1.#               DSN    = <database_name>                                      #:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.# <identifier>  &colon.&colon.= [A-za-z][A-Za-z0-9_]*                                     #:ehp1.
:hp1.#  [default]    &colon.&colon.= entry used, if no other data matches                      #:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.# Trace = ON | On | on | 1 | OFF | Off | off | 0                              #:ehp1.
:hp1.#       enable tracing of ODBC routines                                       #:ehp1.
:hp1.# Tracefile = stdout | stderr                                                 #:ehp1.
:hp1.#       output for trace information, either stdout or stderr                 #:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.#=============================================================================#:ehp1.

:hp2.[DB2]:ehp2.
Comment  = sample entry for IBM DB2/2
Trace    = Off
TraceFile= stderr
Driver   = c&colon.\sqllib\dll\db2cli.dll
DSN      = test

:hp2.[mSQL]:ehp2.
Comment  = sample entry for Mini SQL 1.0.x
Trace    = Off
TraceFile= stderr
Driver   = ..\lib\libmsql.dll
DSN      = test@localhost

:hp2.[mSQL2]:ehp2.
Comment  = sample entry for Mini SQL 2.0
Trace    = Off
TraceFile= stderr
Driver   = ..\lib\libmsql2.dll
DSN      = test@localhost

:hp2.[default]:ehp2.
Comment  = default entry - used when no entry else matches
Trace    = On
TraceFile= stderr
Driver   = ..\lib\libmsql2.dll
DSN      = Minerva@localhost

:hp1.#=============================================================================#:ehp1.
:hp1.# end of file                                                                 #:ehp1.
:hp1.#=============================================================================#:ehp1.
:exmp.

.*------------------------------------------------------------------------------
.* 'Sample iODBC.INI for Unix'
.*------------------------------------------------------------------------------
:h2 id=iodbc_unix clear.Sample iODBC.INI for Unix
:xmp.
:hp1.#=============================================================================#:ehp1.
:hp1.# iodbc.ini (Unix)                                                            #:ehp1.
:hp1.#=============================================================================#:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.# sample configuration file for iODBC                                         #:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.#-----------------------------------------------------------------------------#:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.# a driver section is set up like this:                                       #:ehp1.
:hp1.#       [<identifier>]                                                        #:ehp1.
:hp1.#               Driver = <path>/<name_of_dynamic_link_library>                #:ehp1.
:hp1.#               DSN    = <database_name>                                      #:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.# <identifier>  &colon.&colon.= [A-za-z][A-Za-z0-9_]*                                     #:ehp1.
:hp1.#  [default]    &colon.&colon.= entry used, if no other data matches                      #:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.# Trace = ON | On | on | 1 | OFF | Off | off | 0                              #:ehp1.
:hp1.#       enable tracing of ODBC routines                                       #:ehp1.
:hp1.# Tracefile = stdout | stderr                                                 #:ehp1.
:hp1.#       output for trace information, either stdout or stderr                 #:ehp1.
:hp1.#                                                                             #:ehp1.
:hp1.#=============================================================================#:ehp1.

:hp2.[mSQL]:ehp2.
Comment  = sample entry for Mini SQL 1.0.x
Trace    = Off
TraceFile= stderr
Driver   = ../lib/libclimSQL.so
DSN      = test@localhost

:hp2.[mSQL2]:ehp2.
Comment  = sample entry for Mini SQL 2.0
Trace    = Off
TraceFile= stderr
Driver   = ../lib/libclimSQL2.so
DSN      = test@localhost

:hp2.[Oracle]:ehp2.
Comment  = sample entry for Oracle 7.x database
Trace    = Off
TraceFile= stderr
Driver   = ../lib/libclioracle.so
DSN      = test/test@testdb

:hp2.[default]:ehp2.
Comment  = default entry - used when no entry else matches
Trace    = On
TraceFile= stderr
Driver   = ../lib/libclimSQL2.so
DSN      = Minerva@localhost

:hp1.#=============================================================================#:ehp1.
:hp1.# end of file                                                                 #:ehp1.
:hp1.#=============================================================================#:ehp1.
:exmp.

.*------------------------------------------------------------------------------
.* 'Compatibility List'
.*------------------------------------------------------------------------------
:h2 id=iodbc_compatibility clear.Compatibility List
:p.Under OS/2 the iODBC interface has been successfully tested against
:lm margin=5.:ul.
:li.IBM DB2/2 2.1 Call-Level Interface (CLI) DLL :hp1.db2cli.dll:ehp1.
:li.mSQL for OS/2 1.x Call-Level Interface (CLI) DLL :hp1.libmsql.dll:ehp1.
:li.mSQL for OS/2 2.0 Call-Level Interface (CLI) DLL :hp1.libmsql2.dll:ehp1.
:eul.:lm margin=1.

:p.Under Unix the iODBC interface has been successfully tested against
:lm margin=5.:ul.
:li.mSQL 1.0.x Call-Level Interface (CLI) dynamic library :hp1.libclimSQL.so:ehp1.
:li.mSQL 2.0 Call-Level Interface (CLI) dynamic library :hp1.libclimSQL2.so:ehp1.
:li.Oracle CLI-OCI-Bridge (CLI) dynamic library :hp1.libclioracle.so:ehp1.
:eul.:lm margin=1.

.*==============================================================================
