.*------------------------------------------------------------------------------
.* iODBC (OS/2) - intro
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Introduction and Files'
.*------------------------------------------------------------------------------
:h1 id=introduction clear.Introduction and Files
:p.The :hp4.C:ehp4.all :hp4.L:ehp4.evel :hp4.I:ehp4.nterface is an C-API for
writing portable database applications. It is meant to be database independent.
The sources are drawn a bit from ODBC (Open DataBase Connection - a firm
specific standard by the Microsoft Corporation based on X/Open's CLI) and CLI
specified by the ISO/ANSI comitee and X/Open.

:p.Drivers (:hp1.CLI:ehp1.) are located under the :hp4.DRIVER:ehp4. directory.
Currently there are the following drivers&colon.
:lm margin=5.:ul.
:li.:hp2.mSQL:ehp2. - driver for mSQL 1.x and 2.x
:eul.:lm margin=1.

:p.The following Call-Level Interfaces (CLI) may be used as iODBC-compliant
ODBC drivers&colon.
:lm margin=5.:ul.
:li.:hp2.IBM DB2/2 V 2.0:ehp2. and above
:li.:hp2.SOLID V 2.1:ehp2. SQL database
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.* 'How to use the CLI'
.*------------------------------------------------------------------------------
:h1 id=how_to_use clear.How to use the CLI
:p.Within your programs, you have to include a file named :hp4.sqlcli_.h:ehp4..
This is normally done by insertion of a statement like this&colon.
:xmp.
         /*
         ** use the next include for use of CLI or iODBC
         ** (contains function prototypes)
         */
         :hp2.#include <sqlcli_.h>:ehp2.

         /*
         ** on iODBC as an alternative to the above include file
         ** you may use one or both of these include files
         ** (lacks most function prototypes)
         */
         :hp2.#include <isql.h>:ehp2.
         :hp2.#include <isqlext.h>:ehp2.

:exmp.
:p.Make sure that this file is located to a directory normally being searched
for include files by the compiler or specify the directory containing this
file directly at compiler call (this is done by
:hp2./I:ehp2.:hp1.directory:ehp1. for the IBM C compilers or by
:hp2.-I:ehp2.:hp1.directory:ehp1. for Unix style C compilers, e.g.
:hp1.gcc:ehp1., there :hp1.directory:ehp1. is the desired directory).

:note.
All environement dependend header files (i.e. :hp1.msql.h:ehp1. for
:hp2.mSQL:ehp2.) have to be put to a directory, for which the same conditions
exists (included during compilation per default or per parameter switch).

:p.In order to link the compiled sources, use following files located in the
library directory (:hp2.LIB:ehp2.) for
:lm margin=5.:ul.
:li.:hp2.CLI (Driver):ehp2.
:lm margin=10.:ul.
:li.under :hp1.OS/2:ehp1.&colon. :hp4.libmsql.lib:ehp4. (dynamic linkage against
MSQL.DLL, mSQL 1.x)
:li.under :hp1.OS/2:ehp1.&colon. :hp4.libmsql2.lib:ehp4. (dynamic linkage against
MSQL.DLL, mSQL 2.x)
:li.under :hp1.Unix:ehp1.&colon. :hp4.libclimSQL.so:ehp4. (dynmaic linkage, mSQL 1.0.x)
:li.under :hp1.Unix:ehp1.&colon. :hp4.libclimSQL2.so:ehp4. (dynamic linkage, mSQL 2.0)
:li.under :hp1.Unix:ehp1.&colon. :hp4.libclioracle.so:ehp4. (dynmaic linkage, Oracle)
:eul.:lm margin=5.
:li.:hp2.iODBC:ehp2.
:lm margin=10.:ul.
:li.under :hp1.OS/2:ehp1.&colon. :hp4.iodbc.lib:ehp4. (dynamic linkage against
IODBC.DLL)
:li.under :hp1.Unix:ehp1.&colon. :hp4.iodbc.so:ehp4. (dynamic linkage)
:eul.:lm margin=5.
:eul.:lm margin=1.

:p.To use the CLI properly there is a predefined path showing when to call
which routine. The next picture describes a CLI session.

:artwork name='IMAGES\iodbc_1.bmp' align=center.

:lm margin=5.:ul.
:li.First, there has to be an allocation of environment space
(see :link reftype=hd refid=cli_SQLAllocEnv.SQLAllocEnv():elink.).
:li.Then, a database context has to be set up
(see :link reftype=hd refid=cli_SQLAllocConnect.SQLAllocConnect():elink.).
:li.In order to do transactions there must be a database connection established
(done either by :link reftype=hd refid=cli_SQLConnect.SQLConnect():elink.
or :link reftype=hd refid=cli_SQLDriverConnect.SQLDriverConnect():elink.).
:li.Transactions take place (see below).
:li.After the last transaction, the connection to the database has to be closed
(see :link reftype=hd refid=cli_SQLDisconnect.SQLDisconnect():elink.).
:li.Then the database context has to be freed
(see :link reftype=hd refid=cli_SQLFreeConnect.SQLFreeConnect():elink.).
:li.The last (CLI) operation is to free the environment space
(see :link reftype=hd refid=cli_SQLFreeEnv.SQLFreeEnv():elink.).
:eul.:lm margin=1.

:p.Transactions could be done in various ways. A transaction can store or
manipulate data (:hp1.INSERT:ehp1., :hp1.UPDATE:ehp1., :hp1.DELETE:ehp1., ...),
retrieve data (:hp1.SELECT:ehp1., ...) or do anything else (manipulation on
table structure, access control to data, creation of views, ...). The next
picture contains an overview on transaction operation&colon.

:artwork name='IMAGES\iodbc_2.bmp' align=center.

:lm margin=5.:ul.
:li.Before any transaction a statement buffer has to be allocated
(see :link reftype=hd refid=cli_SQLAllocStmt.SQLAllocStmt():elink.).
:li.A transaction statement then can be prepared and then being executed
(see :link reftype=hd refid=cli_SQLPrepare.SQLPrepare():elink.,
:link reftype=hd refid=cli_SQLExecute.SQLExecute():elink.) or run directly
(see :link reftype=hd refid=cli_SQLExecDirect.SQLExecDirect():elink.). On
both paths certain parameters of the statment could be bound to variables
(see :link reftype=hd refid=cli_SQLBindParam.SQLBindParam():elink.).
:li.Depending on the transaction type, there are those possibilities&colon.
:eul.:lm margin=1.
:lm margin=10.:ul.
:li.On :hp2.Data Retrival:ehp2. the number of resulting columns has to be
gathered (see :link reftype=hd
refid=cli_SQLNumResultCols.SQLResultCols():elink.), the columns bound to
variables
(see :link reftype=hd refid=cli_SQLBindCol.SQLBindCol():elink.) and all
result rows processed (see :link reftype=hd
refid=cli_SQLFetch.SQLFetch():elink.). Optionally additional columns
informations can be retrieved
(see :link reftype=hd refid=cli_SQLDescribeCol.SQLDescribeCol():elink.
or :link reftype=hd refid=cli_SQLColAttributes.SQLColAttributes():elink.)
and column values asked (see :link reftype=hd
refid=cli_SQLGetData.SQLGetData():elink.).
:li.On :hp2.Data Manipulation:ehp2. only the number of rows being affected
can be retrieved (see :link reftype=hd
refid=cli_SQLRowCount.SQLRowCount():elink.).
:li.On :hp2.any other transaction type:ehp2. there are no special returns.
:eul.:lm margin=1.
:lm margin=5.:ul.
:li.When the last transaction is done, the statement buffer has to be freed
first (see :link reftype=hd refid=cli_SQLFreeStmt.SQLFreeStmt():elink.).
:li.All transactions then have to be commited or withdrawn by a
:link reftype=hd refid=cli_SQLTransact.SQLTransact():elink. call.
:eul.:lm margin=1.


.*------------------------------------------------------------------------------
