.*------------------------------------------------------------------------------
.* iODBC (OS/2) - defs
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'Definitions and Common Data Types'
.*------------------------------------------------------------------------------
:h1 id=definitions clear.Definitions and Common Data Types
:p.This section contains the definitions used within the Call-Level
Interface as there set in :hp1.sqlcli_.h:ehp1.. For better understanding,
notice, that (under OS/2!)&colon.
:lm margin=5.:ul.
:li. a :hp1.character:ehp1. has a size of 8 bits,
:li. a :hp1.word:ehp1. has a size of 16 bits,
:li. a :hp1.short integer:ehp1. has a size of 16 bits,
:li. a :hp1.double word:ehp1. has a size of 32 bits,
:li. a :hp1.long integer:ehp1. has a size of 32 bits.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'Data Qualifier FAR, NEAR'
.*------------------------------------------------------------------------------
:h2 id=data_qualifier_far clear.Data Qualifier FAR, NEAR
:xmp.
  FAR
  NEAR
:exmp.
:p.The purpose of this qualifiers is to specify if a pointer is used
within this data segment (:hp1.NEAR:ehp1.) or not (:hp1.FAR:ehp1.). Under
OS/2 2.x or above it is not necessary to use this.
:note.
This is implemented for migration of software from platforms, where the
determination of :hp1.FAR:ehp1. and :hp1.NEAR:ehp1. pointers is necessary.

.*------------------------------------------------------------------------------
.*   'Data Type BOOL'
.*------------------------------------------------------------------------------
:h2 id=data_type_bool clear.Data Type BOOL
:xmp.
  BOOL                   { FALSE, TRUE }
:exmp.
:p.This defines a boolean data type with it's two possible values
:lm margin=5.:ul.
:li.:hp4.FALSE:ehp4.
:li.:hp4.TRUE:ehp4.
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'Data Type CHAR, UCHAR'
.*------------------------------------------------------------------------------
:h2 id=data_type_char clear.Data Type CHAR, UCHAR
:xmp.
  CHAR                   - signed char
  UCHAR                  - unsigned char
:exmp.
:p.This defines a data type for storing signed / unsigned integer values,
i.e. characters.

.*------------------------------------------------------------------------------
.*   'Data Type DWORD, SDWORD, UDWORD'
.*------------------------------------------------------------------------------
:h2 id=data_type_dword clear.Data Type DWORD, SDWORD, UDWORD
:xmp.
  DWORD                  - double word
  SDWORD                 - signed double word
  UDWORD                 - unsigned double word
:exmp.
:p.This defines a data type for storing signed / unsigned double words.

.*------------------------------------------------------------------------------
.*   'Data Type HANDLE'
.*------------------------------------------------------------------------------
:h2 id=data_type_handle clear.Data Type HANDLE
:xmp.
  HANDLE                 - (unqualified) handle
:exmp.
:p.The purpose of this data type is to store a unqualified handle to
"anything".

.*------------------------------------------------------------------------------
.*   'Data Type HWND'
.*------------------------------------------------------------------------------
:h2 id=data_type_hwnd clear.Data Type HWND
:xmp.
  HWND                   - handle (for) window
:exmp.
:p.The purpose of this data type is to store a handle for window manipulation.

.*------------------------------------------------------------------------------
.*   'Data Type LONG, ULONG'
.*------------------------------------------------------------------------------
:h2 id=data_type_long clear.Data Type LONG, ULONG
:xmp.
  LONG                   - signed long integer
  ULONG                  - unsigned long integer
:exmp.
:p.This defines a data type for storing signed / unsigned long integer
values.

.*------------------------------------------------------------------------------
.*   'Data Type PTR'
.*------------------------------------------------------------------------------
:h2 id=data_type_ptr clear.Data Type PTR
:xmp.
  PTR                    - (unqualified) pointer
:exmp.
:p.This data type is intended to be used for unqualified pointer
specification. It is comparable with the ANSI-C data type :hp1.void *:ehp1..

.*------------------------------------------------------------------------------
.*   'Data Type RETCODE'
.*------------------------------------------------------------------------------
:h2 id=data_type_retcode clear.Data Type RETCODE
:xmp.
  RETCODE                - (unqualified) program return code
:exmp.
:p.This data type is intended to be used to specify an unqualified
program return code, i.e. a return code of "something".

.*------------------------------------------------------------------------------
.*   'Data Type SHORT, USHORT'
.*------------------------------------------------------------------------------
:h2 id=data_type_short clear.Data Type SHORT, USHORT
:xmp.
  SHORT                  - signed short integer
  USHORT                 - unsigned short integer
:exmp.
:p.This defines a data type for storing signed / unsigned short integer
values.

.*------------------------------------------------------------------------------
.*   'Data Type WORD, SWORD, UWORD'
.*------------------------------------------------------------------------------
:h2 id=data_type_word clear.Data Type WORD, SWORD, UWORD
:xmp.
  WORD                   - word
  SWORD                  - signed word
  UWORD                  - unsigned word
:exmp.
:p.This defines a data type for storing signed / unsigned words.

.*------------------------------------------------------------------------------
.*   'Data Type UINT'
.*------------------------------------------------------------------------------
:h2 id=data_type_uint clear.Data Type INT
:xmp.
  UINT                   - unsigned integer
:exmp.
:p.This defines a data type for storing unsigned integer values.

.*------------------------------------------------------------------------------
.*   'Function Qualifier PASCAL'
.*------------------------------------------------------------------------------
:h2 id=function_qualifier_pascal clear.Function Qualifier PASCAL
:xmp.
  PASCAL
:exmp.
:p.The intention of this function qualifier is to distinguish between
function with "C" and "PASCAL" parameter/calling convention. For
example&colon.
:xmp.
  void funcProto(int a, int b );       /* C calling convention      */
  void PASCAL funcProto(int a, int b); /* PASCAL calling convention */
:exmp.
:lm margin=5.:ul.
:li. "C" calling stores first :hp1.b:ehp1., then :hp1.a:ehp1. to the head
:li. "PASCAL" calling stores first :hp1.a:ehp1., then :hp1.b:ehp1. to the head
:eul.:lm margin=1.

.*------------------------------------------------------------------------------
.*   'Function Qualifier SQL_API'
.*------------------------------------------------------------------------------
:h2 id=function_qualifier_sql_api clear.Function Qualifier SQL_API
:xmp.
  SQL_API
:exmp.
:p.This qualifier is used for specification of a public call-level
interface routine (procedure).

.*------------------------------------------------------------------------------
.*   'Function Qualifier SQL_LOCAL_API'
.*------------------------------------------------------------------------------
:h2 id=function_qualifier_sql_local_api clear.Function Qualifier SQL_LOCAL_API
:xmp.
  SQL_LOCAL_API
:exmp.
:p.This qualifier is used for specification of a non-public (private)
call-level interface routine (procedure).

.*------------------------------------------------------------------------------
.*   'Function Macro MAX, MIN'
.*------------------------------------------------------------------------------
:h2 id=function_macro_max_min clear.Function Macro MAX, MIN
:xmp.
  MAX(x,y)               ((x > y) ? x : y)
  MIN(x,y)               ((x < y) ? x : y)
:exmp.
:p.These macros can be used for checking two numbers (numerical values)
against. :hp1.MAX:ehp1. returns the greater number, :hp1.MIN:ehp1. the
minor number of the two given ones.

.*------------------------------------------------------------------------------
