.*------------------------------------------------------------------------------
.* iODBC (OS/2) - data
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.* 'SQL Data Types'
.*------------------------------------------------------------------------------
:h1 id=sql_data_types clear.SQL Data Types
:p.Accessing the database through the Call-Level Interface requires an
abstraction of the data types. The 'C' programming language and the structured
query language (SQL) have different names and types for certain data objects.
So there are data types defined in the header file :hp1.sqlcli_.h:ehp1. for
interactions between 'C' code and SQL database.

:p.First there are the following definitions (constants)&colon.
:table cols='25 54'.
:row.:c.SQL_DATE_LEN              :c.maximum length of date strings
:row.:c.SQL_MAX_DRV_ID_LENGTH     :c.maximum length of iODBC driver setup IDs
:row.:c.SQL_MAX_ID_LENGTH         :c.maximum length of identifiers
:row.:c.SQL_MAX_MESSAGE_LENGTH    :c.maximum length of messages
:row.:c.SQL_SQLSTATE_SIZE         :c.maximum length of status codes
:row.:c.SQL_TIME_LEN              :c.maximum length of time strings
:row.:c.SQL_TIMESTAMP_LEN         :c.maxmimum length of a timestamp
:row.:c.SQLPOINTER                :c.:link reftype=hd refid=data_type_ptr.PTR:elink.
:row.:c.SQLRETURN                 :c.:link reftype=hd refid=data_type_retcode.RETCODE:elink. :link reftype=hd refid=function_qualifier_sql_api.SQL_API:elink.
:row.:c.SQLUINTEGER               :c.:link reftype=hd refid=data_type_uint.UINT:elink.
:row.:c.SQLUSMALLINT              :c.:link reftype=hd refid=data_type_short.USHORT:elink.
:etable.

:p.And now the SQL data types&colon.
:table cols='19 21 17 21'.
:row.:c.***SQL native***:c.identifier:c.'C'           :c.***comment***
:row.:c.SQLBINARY  :c.SQL_C_BINARY:c.unsigned char    :c.bit field of 8 bits
:row.:c.SQLBIT     :c.SQL_C_BIT   :c.:link reftype=hd refid=data_type_bool.BOOL:elink.:c.
:row.:c.SQLBLOBLOCATOR:c.SQL_C_BLOB_LOCATOR:c.long    :c.reference
:row.:c.SQLCHAR    :c.SQL_C_CHAR  :c.unsigned char    :c.
:row.:c.SQLCLOBLOCATOR:c.SQL_C_CLOB_LOCATOR:c.long    :c.reference
:row.:c.SQLDATE    :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLDBCHAR  :c.SQL_C_DBCHAR:c.unsigned char    :c.character
:row.:c.SQLDBCLOBLOCATOR:c.SQL_C_DBCLOB_LOCATOR:c.long:c.reference
:row.:c.SQLDECIMAL :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLDOUBLE  :c.SQL_C_DOUBLE:c.double           :c.
:row.:c.SQLINTEGER :c.SQL_C_LONG  :c.long             :c.
:row.:c.SQLFLOAT   :c.SQL_C_FLOAT :c.float            :c.
:row.:c.SQLNUMERIC :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLREAL    :c.SQL_C_REAL  :c.float            :c.
:row.:c.SQLSCHAR   :c.SQL_C_TINYINT:c.signed char     :c.
:row.:c.SQLSHORT   :c.SQL_C_SHORT :c.short            :c.
:row.:c.SQLSMALLINT:c.SQL_C_SHORT :c.short            :c.
:row.:c.SQLTIME    :c.-           :c.unsigned char    :c.pointer to string
:row.:c.SQLTIMESTAMP:c.-          :c.unsigned char    :c.pointer to string
:row.:c.SQLTINYINT :c.SQL_C_TINYINT:c.signed char     :c.
:row.
:row.:c.***SQL native***:c.identifier:c.sub-entries   :c.***comment***
:row.:c.SQLDATE    :c.SQL_C_DATE  :c.DATE_STRUCT      :c.date structure
:row.:c.           :c.            :c.:hp1.year:ehp1.  :c.:hp1.year:ehp1.
:row.:c.           :c.            :c.:hp1.month:ehp1. :c.:hp1.month:ehp1.
:row.:c.           :c.            :c.:hp1.day:ehp1.   :c.:hp1.day:ehp1.
:row.:c.SQLTIME    :c.SQL_C_TIME  :c.TIME_STRUCT      :c.time structure
:row.:c.           :c.            :c.:hp1.hour:ehp1.  :c.:hp1.hour:ehp1.
:row.:c.           :c.            :c.:hp1.minute:ehp1.:c.:hp1.minute:ehp1.
:row.:c.           :c.            :c.:hp1.second:ehp1.:c.:hp1.second:ehp1.
:row.:c.SQLTIMESTAMP:c.SQL_C_TIMESTAMP:c.TIMESTAMP_STRUCT:c.time stamp
:row.:c.           :c.            :c.:hp1.year:ehp1.  :c.:hp1.year:ehp1.
:row.:c.           :c.            :c.:hp1.month:ehp1. :c.:hp1.month:ehp1.
:row.:c.           :c.            :c.:hp1.day:ehp1.   :c.:hp1.day:ehp1.
:row.:c.           :c.            :c.:hp1.hour:ehp1.  :c.:hp1.hour:ehp1.
:row.:c.           :c.            :c.:hp1.minute:ehp1.:c.:hp1.minute:ehp1.
:row.:c.           :c.            :c.:hp1.second:ehp1.:c.:hp1.second:ehp1.
:row.:c.           :c.            :c.:hp1.fraction:ehp1.:c.:hp1.???:ehp1.
:row.
:row.:c.***SQL***  :c.Handle/Pointer:c.'C'            :c.***comment***
:row.:c.SQLHDBC    :c.HDBC, LPDBC :c.DBC              :c.CLI database context
:row.:c.SQLHDESC   :c.HDESC, LPDESC:c.DESC            :c.CLI descriptor
:row.:c.SQLHENV    :c.HENV, LPENV :c.ENV              :c.CLI environment
:row.:c.SQLHSTMT   :c.HSTMT, LPSTMT:c.STMT            :c.CLI statement
:etable.

:note.
.br
:hp1.BLOB:ehp1. stands for :hp1.binary large object block:ehp1..
.br
:hp1.CLOB:ehp1. stands for :hp1.character large object block:ehp1..

:p.Special structures used by the iODBC&colon.

:xmp.
typedef struct _SQLDrvOptList {        /* driver options list                */
        char        szOptName[SQL_MAX_DRV_ID_LENGTH]; /* - option name       */
        char        szOptValue[SQL_MAX_DRV_ID_LENGTH]; /* - option value     */
        void       *pNext;             /*   - pointer to next element        */
} SQLDrvOptList, *SQLPDrvOptList;      /*                                    */

typedef struct _SQLDriverList {        /* driver list                        */
        char        szName[SQL_MAX_DRV_ID_LENGTH]; /* - name of driver       */
        SQLPDrvOptList pOptions;       /*   - start of options list          */
        void       *pNext;             /*   - pointer to next element        */
} SQLDriverList, *SQLPDriverList;      /*                                    */
:exmp.

.*------------------------------------------------------------------------------
