.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLTransact
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLTransact'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLTransact clear.SQLTransact
:xmp.
RETCODE SQL_API SQLTransact(
        LPENV   lpenv,
        LPDBC   lpdbc,
        UWORD   fType);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpenv:ehp1. - handle for environment (or :hp4.SQL_NULL_HENV:ehp4.)
:li.:hp1.lpdbc:ehp1. - handle for database context (or :hp4.SQL_NULL_HDBC:ehp4.)
:li.:hp1.fType:ehp1. - type of action to be done: :hp4.SQL_COMMIT:ehp4. to
commit all previous database activities, or :hp4.SQL_ROLLBACK:ehp4. to withdraw
all former activities
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.08003  :c.no connection open for specified action
:row.:c.                     :c.58004  :c.:hp4.SQL_ROLLBACK:ehp4. failed
:row.:c.                     :c.S1012  :c.invalid action code :hp1.fType:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.handle :hp1.lpenv:ehp1. or :hp1.lpdbc:ehp1. must be set
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.The purpose of the function is to commit or rollback (withdraw) database
actions, like INSERT, UPDATE or DELETE. This function is called normally after
(at the end of) a(n) (un)successful transaction.

:note.
mSQL 1.x does not allow rollbacks on previous database actions. This is because
it does not have any recovery mechanism. For that reason all rollback
operations result in an error :hp4.SQL_ERROR:ehp4. with message code
:hp4.58004:ehp4., to signalize an unsuccessful rollback.

.*------------------------------------------------------------------------------
