.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLSetParam
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLSetParam'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetParam clear.SQLSetParam
:xmp.
RETCODE SQL_API SQLSetParam(
        LPSTMT      lpstmt,
        UWORD       ipar,
        SWORD       fCType,
        SWORD       fSqlType,
        UDWORD      cbColDef,
        SWORD       ibScale,
        PTR         rgbValue,
        SDWORD FAR *pcbValue );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.ipar:ehp1. - number of parameter to be defined, starting left to right
with :hp4.1:ehp4..
:li.:hp1.fCType:ehp1. - C data type (:hp1.SQL_C_...:ehp1.) or :hp4.SQL_C_DEFAULT:ehp4..
:li.:hp1.fSqlType:ehp1. - SQL data type (e.g. :hp4.SQL_INTEGER:ehp4.).
:li.:hp1.cbColDef:ehp1. - length of data to be transfered (character fields)
or precision on :hp4.SQL_DECIMAL:ehp4. / :hp4.SQL_NUMERIC:ehp4., else ignored.
:li.:hp1.ibScale:ehp1. - scaling factor (used only at :hp4.SQL_DECIMAL:ehp4.
or :hp4.SQL_NUMERIC:ehp4.).
:li.:hp1.rgbValue:ehp1. - pointer to variable to be bound to parameter.
:li.:hp1.pcbValue:ehp1. - pointer to variable used for signalising, how many
bytes were transfered at execution of the statement.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.07006  :c.can't convert C data type into SQL data type
:row.:c.                     :c.S1003  :c.invalid C data type in :hp1.fCType:ehp1.
:row.:c.                     :c.S1004  :c.invalid SQL data type in :hp1.fSqlType:ehp1.
:row.:c.                     :c.S1009  :c.:hp1.rgbValue:ehp1. must not be NULL
:row.:c.                     :c.S1010  :c.must be called after :link reftype=hd refid=cli_SQLPrepare.SQLPrepare():elink.
:row.:c.                     :c.S1013  :c.can't allocate internal memory
:row.:c.                     :c.S1093  :c.invalid parameter number :hp1.ipar:ehp1.
:row.:c.                     :c.S1094  :c.invalid value in :hp1.ibScale:ehp1.
:row.:c.                     :c.S1104  :c.invalid value in :hp1.cbColDef:ehp1.
:row.:c.                     :c.S1C00  :c.unable to resolve the given C or SQL data type
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.A parameter is a place holder in a SQL statement which is resolved at
execution time (via :link reftype=hd refid=cli_SQLExecute.SQLExecute():elink.).
A parameter is marked by a simple question mark (":hp4.?:ehp4."). Question
marks inside of strings delimited by single quotes (":hp4.':ehp4."). are not
treated as parameter place holders but as characters. An example would be
this&colon.
:lines align=left.
    select name, age from test where name='???' or name=?
:elines.
At execution time this would be resolved to&colon.
:lines align=left.
    select name, age from test where name='???' or name='[contents of variable]'
:elines.

:note.
Character fields will be enclosed in single quotes automatically.

.*------------------------------------------------------------------------------
