.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLSetCursorName
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLSetCursorName'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLSetCursorName clear.SQLSetCursorName
:xmp.
RETCODE SQL_API SQLSetCursorName(
        LPSTMT  lpstmt,
        UCHAR FAR *szCursor,
        SWORD   cbCursor);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.szCursor:ehp1. - pointer to string containing new cursor name
:li.:hp1.cbCursor:ehp1. - length od :hp1.szCursor:ehp1. or :hp4.SQL_NTS:ehp4.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.34000  :c.invalid cursor name in :hp1.szCursor:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.This is the reverse function to :link reftype=hd
refid=cli_SQLGetCursorName.SQLGetCursorName():elink.. It is used to set a new
cursor name for the statement. A cursor name must start with a character
(:hp4.a..z:ehp4. or :hp4.A..Z:ehp4.) and may then contain a mixture of
characters, digits and underscores (:hp4.a..z:ehp4., :hp4.A..Z:ehp4.,
:hp4.0..9:ehp4. or :hp4._:ehp4.).

:note.
Other implementations need unique cursor names and do not allow the re-use of
a cursor name, that has been already in use. This implementation does not
check cursor names for unique use, since cursor names are not being used
internally, but are implemented for compatibility.

:note.
Since there will be a unique cursor name created during allocation of the
statement handle (:link reftype=hd refid=cli_SQLAllocStmt.SQLAllocStmt():elink.),
you may not use this function within your programs.

.*------------------------------------------------------------------------------
