.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLRowCount
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLRowCount'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLRowCount clear.SQLRowCount
:xmp.
RETCODE SQL_API SQLRowCount(
        LPSTMT  lpstmt,
        SWORD FAR *pcrow);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.pcrow:ehp1. - pointer to variable used for storage of row count
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1009  :c.:hp1.pcrow:ehp1. must point to a variable
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no error
:etable.

:p.The number of rows affected by an UPDATE, INSERT or DELETE can be obtained
with this function. For the number of rows returned by a SELECT have a look
at :link reftype=hd refid=cli_SQLNumResultCols.SQLNumResultCols():elink..

:note.
For the mSQL 1.x driver, this function is not behave absolutely identical to
the ANSI, ODBC or X/Open version. On UPDATE, INSERT or DELETE a value of
:hp4.0:ehp4. is always returned regardless the true number of rows affected.
On SELECT it returns the number of rows selected. The other drivers do behave
conforming to ANSI, ODBC and X/Open.

.*------------------------------------------------------------------------------
