.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLGetCursorName
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLGetCursorName'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLGetCursorName clear.SQLGetCursorName
:xmp.
RETCODE SQL_API SQLGetCursorName(
        LPSTMT  lpstmt,
        UCHAR FAR *szCursor,
        SWORD   cbCursorMax,
        SWORD FAR *pcbCursor);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.szCursor:ehp1. - variable to be filled with cursor name
:li.:hp1.cbCursorMax:ehp1. - maximum length of :hp1.szCursor:ehp1.
:li.:hp1.pcbCursor:ehp1. - pointer to variable storing result length of :hp1.szCursor:ehp1.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1090  :c.parameter :hp1.szCursor:ehp1. must not be NULL
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS_WITH_INFO:c.01004  :c.cursor name was truncated
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.This function returns the name of the cursor associated with the statement.
A new cursor name can be set by calling :link reftype=hd
refid=cli_SQLSetCursorName.SQLSetCursorName():elink..

.*------------------------------------------------------------------------------
