.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLFreeEnv
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLFreeEnv'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLFreeEnv clear.SQLFreeEnv
:xmp.
  RETCODE SQL_API SQLFreeEnv(  LPENV               lpenv
                            );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpenv:ehp1. - handle for environment block
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1010  :c.connections have to be closed first
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid pointer :hp1.lpenv:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.environment successfully freed
:etable.

:p.This function has to be called at the end of the program to free the CLI
environment block. After successful removement of the environment block, the
variable used for handle storage (input parameter :hp1.lpenv:ehp1.) has to be
invalidated.

:note.
After successfully freeing the CLI environment block, no error message can be
obtained through :hp2.SQLError:ehp2..

.*------------------------------------------------------------------------------
