.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLError
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLError'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLError clear.SQLError
:xmp.
  RETCODE SQL_API SQLError(
          LPENV   lpenv,
          LPDBC   lpdbc,
          LPSTMT  lpstmt,
          UCHAR FAR *szSqlState,
          SDWORD FAR *pfNativeError,
          UCHAR FAR *szErrorMsg,
          SWORD   cbErrorMsgMax,
          SWORD FAR *pcbErrorMsg);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpenv:ehp1. - handle for environment block
:li.:hp1.lpdbc:ehp1. - handle for database context block
:li.:hp1.lpstmt:ehp1. - handle for current statement structure
:li.:hp1.szSqlState:ehp1. - pointer to buffer for SQL error state code
:li.:hp1.pfNativeError:ehp1. - pointer to buffer for internal error code
:li.:hp1.szErrorMsg:ehp1. - pointer to string for storing error message text
:li.:hp1.cgErrorMsgMax:ehp1. - maximum length for :hp1.szErrorMsg:ehp1.
:li.:hp1.pcbErrorMsg:ehp1. - result length for :hp1.szErrorMsg:ehp1.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid :hp1.lpenv:ehp1., :hp1.lpdbc:ehp1. and :hp1.lpstmt:ehp1.
:row.:c.SQL_NO_DATA_FOUND    :c.-      :c.no more data or no previous error
:row.:c.SQL_SUCCESS          :c.-      :c.data available
:etable.

:p.Returns a message text for a previously occurred error. If there was no
previous error, :hp2.SQL_NO_DATA_FOUND:ehp2. is returned. After successful
return of this function, all internal states are resetted.

.*------------------------------------------------------------------------------
