.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLDriverConnect
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLDriverConnect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLDriverConnect clear.SQLDriverConnect
:xmp.
RETCODE SQL_API SQLDriverConnect(
                             LPDBC               lpdbc,
                             HWND                hwnd,
                             UCHAR FAR          *szConnStrIn,
                             SWORD               cbConnStrIn,
                             UCHAR FAR          *szConnStrOut,
                             SWORD               cbConnStrOutMax,
                             SWORD FAR          *pcbConnStrOutMax,
                             UWORD               fDriverCompletion
                                );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.level 1
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. - handle to database context
:li.:hp1.hwnd:ehp1. - handle for Presentation Manager desktop (OS/2), Windows
desktop, Motif desktop (Unix), or :hp4.NULL:ehp4.
(:hp1.currently not used:ehp1.)
:li.:hp1.szConnStrIn:ehp1. - connection input string, consists of
:hp2.keyword =:ehp2. :hp1.value:ehp1. pairs, which are separated by semicolons
:lm margin=10.:ul.
:li.:hp2.DSN:ehp2. - describes the data source name (name or alias-name of
database)
:li.:hp2.UID:ehp2. - describes the user name
:li.:hp2.PWD:ehp2. - describes the user password
:eul.:lm margin=5.
:li.:hp1.cbConnStrIn:ehp1. - length of :hp1.szConnStrIn:ehp1. or
:hp4.SQL_NTS:ehp4. if the string is NUL terminated
:li.:hp1.szConnStrOut:ehp1. - pointer to area where the completed connection
string is written
:li.:hp1.cbConnStrOutMax:ehp1. - maximum length of area :hp1.szConnStrOut:ehp1.
:li.:hp1.pcbConnStrOut:ehp1. - pointer to variable, to be filled with the
length of the completed connection string
:li.:hp1.fDriverCompletion:ehp1. - flag describing, how to proceed on
insufficient data
(:hp1.not implemented yet - always assumes SQL_DRIVER_NOPROMPT:ehp1.)
:lm margin=10.:ul.
:li.:hp2.SQL_DRIVER_PROMPT:ehp2. - always prompt a dialog (window) where the
user may modify the data or abort the operation
:li.:hp2.SQL_DRIVER_COMPLETE:ehp2. - prompt a dialog (window) only if there
is insufficient data for database login
:li.:hp2.SQL_DRIVER_COMPLETE_REQUIRED:ehp2. - prompt a dialog (window) only
if there is insufficient data for database login, ask only for mandatory
information
:li.:hp2.SQL_DRIVER_NOPROMPT:ehp2. - never present a dialog (window), if the
given information is insufficient the database login fails
:eul.:lm margin=5.
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.08001  :c.can't connect to database server (host)
:row.:c.                     :c.08002  :c.already connected
:row.:c.                     :c.08004  :c.can't connect to database (on host)
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpdbc:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.successful database login
:etable.

:p.Comparable to :link reftype=hd refid=cli_SQLConnect.SQLConnect():elink.,
but with more possibilities. If the given information is insufficient for
database login, this routine may open a dialog window to give the user the
possibility to complete the information. Further, the connection information
is given by one string (no separate database, user name, password strings) -
the structure is described above. The example above shows a connection
information for login into a database :hp1.testdb:ehp1. with user name
:hp1.master:ehp1. and password :hp1.chief:ehp1..
:xmp.
        DSN=testdb;UID=master;PWD=chief
:exmp.

.*------------------------------------------------------------------------------
