.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLDescribeCol
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLDescribeCol'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLDescribeCol clear.SQLDescribeCol
:xmp.
RETCODE SQL_API SQLDescribeCol(
        LPSTMT  lpstmt,
        UWORD   icol,
        UCHAR FAR *szColName,
        SWORD   cbColNameMax,
        SWORD FAR *pcbColName,
        SWORD FAR *pfSqlType,
        UDWORD FAR *pcbColDef,
        SWORD FAR *pibScale,
        SWORD FAR *pfNullable);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.icol:ehp1. - number of column in result list to be examined (starting with :hp4.1:ehp4.)
:li.:hp1.szColName:ehp1. - pointer to string used for storing column name
:li.:hp1.cbColNameMax:ehp1. - maximum length for :hp1.szColName:ehp1.
:li.:hp1.pcbColName:ehp1. - pointer to variable storing real length of :hp1.szColName:ehp1.
:li.:hp1.pfSqlType:ehp1. - pointer to variable storing type of column
:li.:hp1.pcbColDef:ehp1. - pointer to variable storing precision of column
:li.:hp1.pibScale:ehp1. - pointer to variable storing scale of (numeric) column
:li.:hp1.pfNullable:ehp1. - pointer to boolean variable storing info if column is nullable
(:hp4.SQL_NULLABLE:ehp4.) or not (:hp4.SQL_NO_NULLS:ehp4.)
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.07005  :c.column not available
:row.:c.                     :c.40003  :c.can't get column info from server
:row.:c.                     :c.S1002  :c.invalid column number :hp1.icol:ehp1.
:row.:c.                     :c.S1010  :c.no query has been executed
:row.:c.                     :c.S1097  :c.invalid column type detected
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.This routine can be used first to find out how many columns a query returns.
Second, it can be used to detect the type of columns.

.*------------------------------------------------------------------------------
