.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLConnect
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLConnect'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLConnect clear.SQLConnect
:xmp.
  RETCODE SQL_API SQLConnect(  LPDBC               lpdbc,
                               UCHAR FAR          *szDSN,
                               SWORD               cbDSN,
                               UCHAR FAR          *szUID,
                               SWORD               cbUID,
                               UCHAR FAR          *szAuthStr,
                               SWORD               cbAuthStr
                            );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. - handle to already allocated database context
:li.:hp1.szDSN:ehp1. - pointer to string containing database source (table)
:li.:hp1.cbDSN:ehp1. - size of string :hp1.szDSN:ehp1. or :hp2.SQL_NTS:ehp2.
if string is \0 (NUL) terminated
:li.:hp1.szUID:ehp1. - pointer to string containing user identifier (user name)
for database access
:li.:hp1.cbUID:ehp1. - size of string :hp1.szUID:ehp1. or :hp2.SQL_NTS:ehp2.
if string is \0 (NUL) terminated
:li.:hp1.szAuthStr:ehp1. - pointer to string containing password for database
access
:li.:hp1.cbAuthStr:ehp1. - size of string :hp1.szAuthStr:ehp1. or
:hp2.SQL_NTS:ehp2. if string is \0 (NUL) terminated
:eul.:lm margin=1.

:note.
.br
This special implementation for :hp4.mSQL:ehp4. may have a different use of
:hp1.szDSN:ehp1. as known by other CLIs or ODBC. You may specify :hp1.user
name:ehp1., :hp1.database name:ehp1. and :hp1.host (system name or IP):ehp1.
within this entry. Examples&colon.
:xmp.
  szDSN = <database name>                        "sample"
          <user name>.<database name>            "kim.sample"
          <database name>@<host>                 "sample@minerva.edu.au"
          <user name>.<database name>@<host>     "kim.sample@127.0.0.1"
:exmp.
:note.
.br
If a :hp1.host:ehp1. isn't specified, a connection to the server on the local
machine (:hp1.localhost:ehp1.) is tried to be established.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.08001  :c.can't connect to server
:row.:c.                     :c.08002  :c.connection already established
:row.:c.                     :c.08004  :c.can't connect to database
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid database context handle
:row.:c.SQL_SUCCESS          :c.-      :c.connection established
:etable.

:p.This function has to be called after
:link reftype=hd refid=cli_SQLAllocConnect.SQLAllocConnect():elink.. It tries
to connect to a database source (:hp1.mSQL:ehp1.&colon. host/database). After
successful connection database activities may start.

.*------------------------------------------------------------------------------
