.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLColAttributes.ipf
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLColAttributes'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLColAttributes clear.SQLColAttributes
:xmp.
RETCODE SQL_API SQLColAttributes(
        LPSTMT      lpstmt,
        UWORD       icol,
        UWORD       fDescType,
        UCHAR FAR  *rgbDesc,
        SWORD       cbDescMax,
        SWORD FAR  *pcbDesc,
        SDWORD FAR *pfDesc );
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.icol:ehp1. - number of column to be queried (starting with :hp4.1:ehp4.)
:li.:hp1.fDescType:ehp1. - type of information to be queried, numerical or
boolean results are stored in :hp1.pfDesc:ehp1., result string in :hp1.rgbDesc:ehp1..
:lm margin=10.:ul.
:li.:hp4.SQL_COLUMN_AUTO_INCREMENT:ehp4. - check whether a column refers to an
auto increment data type or not. Returns :hp4.FALSE:ehp4. in :hp1.pfDesc:ehp1.
for all data types.
:li.:hp4.SQL_COLUMN_CASE_SENSITIVE:ehp4. - column can case sensitive on
character fields, :hp4.FALSE:ehp4. is returned on numerical fields.
:li.:hp4.SQL_COLUMN_CATALOG_NAME:ehp4. - return catalog name in :hp1.rgbDesc:ehp1.
for the column. Under mSQL returns always an empty string, since there are no
catalogs.
:li.:hp4.SQL_COLUMN_QUALIFIER_NAME:ehp4. - same as :hp4.SQL_COLUMN_CATALOG_NAME:ehp4..
:li.:hp4.SQL_COLUMN_COUNT:ehp4. - :hp1.pfDesc:ehp1. contains the number of
resulting columns.
:li.:hp4.SQL_DISPLAY_SIZE:ehp4. - returns display size for column in :hp1.pfDesc:ehp1.
:li.:hp4.SQL_COLUMN_DISTINCT_TYPE:ehp4. - implemented for compatibility with
IBM's DB2/2. In this implementation returns always an empty string.
:li.:hp4.SQL_COLUMN_LABEL:ehp4. - returns the label of the column in
:hp1.rgbDesc:ehp1..
:li.:hp4.SQL_COLUMN_LENGTH:ehp4. - returns the length of a column in :hp1.pfDesc:ehp1..
:li.:hp4.SQL_COLUMN_MONEY:ehp4. - :hp4.TRUE:ehp4. on columns dealing with cash.
In this implementation, this sub-routine returns always :hp4.FALSE:ehp4..
:li.:hp4.SQL_COLUMN_NAME:ehp4. - in this implementation, same as
:hp4.SQL_COLUMN_LABEL:ehp4..
:li.:hp4.SQL_COLUMN_NULLABLE:ehp4. - returns boolean expression whether a
column can store a NULL value or not (defined as :hp1.NOT NULL:ehp1.).
:li.:hp4.SQL_COLUMN_PRECISION:ehp4. - on numerical columns (fields) the
precision in digits, on character columns the maximum number of bytes.
:li.:hp4.SQL_COLUMN_SCALE:ehp4. - scaling of a column. In the implementation,
returns always :hp4.0:ehp4..
:li.:hp4.SQL_COLUMN_SCHEMA_NAME:ehp4. - returns the table name, in this
implementation returns always an empty string.
:li.:hp4.SQL_COLUMN_OWNER_NAME:ehp4. - same as :hp4.SQL_COLUMN_SCHEMA_NAME:ehp4..
:li.:hp4.SQL_COLUMN_SEARCHABLE:ehp4. - returns on of these
:lm margin=15.:ul.
:li.:hp9.SQL_UNSEARCHABLE:ehp9. - column can't be used with a WHERE clause
:li.:hp9.SQL_LIKE_ONLY:ehp9. - column can be used within WHERE on LIKE operations
:li.:hp9.SQL_ALL_EXCEPT_LIKE:ehp9. - column can be used within WHERE except on LIKE operations
:li.:hp9.SQL_SEARCHABLE:ehp9. - no restrictions in use
:lm margin=10.:eul.
.br
In this implementation for numerical data types :hp9.SQL_ALL_EXCEPT_LIKE:ehp9.
and for character data types :hp9.SQL_SEARCHABLE:ehp9. will be returned.
:li.:hp4.SQL_COLUMN_TABLE_NAME:ehp4. - returns table name, in this implementation
returns always an empty string
:li.:hp4.SQL_COLUMN_TYPE:ehp4. - returns the data type of the column as
numerical value (e.g. :hp1.SQL_CHAR:ehp1.).
:li.:hp4.SQL_COLUMN_TYPE_NAME:ehp4. - returns the data type of the column as string.
The string equals the data type name at column definition in a CREATE TABLE
statement (e.g. "char" for character fields).
:li.:hp4.SQL_COLUMN_UNSIGNED:ehp4. - returns whether a column contains unsigned
data or not. In this implementation :hp4.TRUE:ehp4. on all character columns
and :hp4.FALSE:ehp4. on numerical fields.
:li.:hp4.SQL_COLUMN_UPDATABLE:ehp4. - returns one of these
:lm margin=15.:ul.
:li.:hp9.SQL_ATTR_READWRITE_UNKNOWN:ehp9. - column is updateable
:li.:hp9.SQL_ATTR_READONLY:ehp9. - column can't be updated
:lm margin=10.:eul.
.br
In this implementation all columns are updateable.
:lm margin=5.:eul.
:li.:hp1.rgbDesc:ehp1. - pointer to string buffer for storing the result
:li.:hp1.cbDescMax:ehp1. - maximum length of string buffer :hp1.rgbDesc:ehp1.
:li.:hp1.pcbDesc:ehp1. - pointer to variable storing the length of the result string
:li.:hp1.pfDesc:ehp1. - on non-string results (integer number results) the
result is stored in the variable referenced by this pointer
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.07005  :c.no result available for sub-function
:row.:c.                     :c.40003  :c.communication to database server failed
:row.:c.                     :c.S1002  :c.invalid column number :hp1.icol:ehp1.
:row.:c.                     :c.S1010  :c.there are no results of a query to be examined
:row.:c.                     :c.S1090  :c.invalid pointer :hp1.rgbDesc:ehp1. or :hp1.pfDesc:ehp1. or length :hp1.cbDescMax:ehp1.
:row.:c.                     :c.S1091  :c.invalid sub-function :hp1.fDescType:ehp1.
:row.:c.                     :c.S1C00  :c.CLI can't resolve database server's answer
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS_WITH_INFO:c.01004  :c.result string :hp1.rgbDesc:ehp1. has been truncated
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.This function returns various informations about the result columns of a
database query. Keep in mind, that each call of this function can return only
one answer. An alternative may be :link reftype=hd
refid=cli_SQLDescribeCol.SQLDescribeCol():elink..

.*------------------------------------------------------------------------------
