.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLBindCol
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLBindCol'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLBindCol clear.SQLBindCol
:xmp.
RETCODE SQL_API SQLBindCol(
        LPSTMT  lpstmt,
        UWORD   icol,
        SWORD   fCType,
        PTR     rgbValue,
        SDWORD  cbValueMax,
        SDWORD FAR *pcbValue);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpstmt:ehp1. - handle for statement
:li.:hp1.icol:ehp1. - column to be bound (starting with :hp4.1:ehp4.)
:li.:hp1.fCType:ehp1. - type of data (:hp4.SQL_C_...:ehp4.)
:li.:hp1.rgbValue:ehp1. - pointer to variable to be used for storage
:li.:hp1.cbValueMax:ehp1. - maximum length of data to be transfered
:li.:hp1.pcbValue:ehp1. - pointer to variable with length of data to be copied
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.07005  :c.column :hp1.icol:ehp1. not available
:row.:c.                     :c.S1003  :c.unsupported C data type in :hp1.fCType:ehp1.
:row.:c.                     :c.S1002  :c.invalid column number :hp1.icol:ehp1.
:row.:c.                     :c.S1010  :c.no query has been done or no results
:row.:c.                     :c.S1090  :c.result greater than allowed in :hp1.cbValueMax:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpstmt:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.no errors
:etable.

:p.After execution of a query via :link reftype=hd
refid=cli_SQLExecute.SQLExecute():elink. or :link reftype=hd
refid=cli_SQLExecDirect.SQLExecDirect():elink. the results must be bound to
variables before a :link reftype=hd refid=cli_SQLFetch.SQLFetch():elink. call
for getting values can take place. This function bind a variable to a field or
column of the resulting table.

.*------------------------------------------------------------------------------
