.*------------------------------------------------------------------------------
.* iODBC (OS/2) - SQLAllocStmt
.* (c) 1997 by Dirk Ohme - all rights reserved
.*------------------------------------------------------------------------------

.*------------------------------------------------------------------------------
.*   'SQLAllocStmt'
.*------------------------------------------------------------------------------
:h2 id=cli_SQLAllocStmt clear.SQLAllocStmt
:xmp.
  RETCODE SQL_API SQLAllocStmt(
          LPDBC   lpdbc,
          HSTMT FAR *phstmt);
:exmp.
:table cols='20 59'.
:row.:c.ODBC            :c.core level
:row.:c.X/Open          :c.yes
:etable.

:p.:hp2.calling parameters:ehp2.
:lm margin=5.:ul.
:li.:hp1.lpdbc:ehp1. - handle for database context
:li.:hp1.phstmt:ehp1. - pointer to variable storing statement handle
:eul.:lm margin=1.

:p.:hp2.return codes:ehp2.
:table cols='20 10 49'.
:row.:c.return code          :c.:link reftype=hd refid=cli_SQLError.SQLError:elink.:c.comment
:row.:c.SQL_ERROR            :c.S1001  :c.memory allocation failure
:row.:c.                     :c.S1009  :c.invalid pointer :hp1.phstmt:ehp1.
:row.:c.SQL_INVALID_HANDLE   :c.-      :c.invalid handle :hp1.lpdbc:ehp1.
:row.:c.SQL_SUCCESS          :c.-      :c.statment handle created successfully
:etable.

:p.Allocation of a statement handle, which is used for database interactions
(queries, insertions, deletes, etc.). This function requires an open database
context handle. After the last interaction and before freeing the database
context, all allocated statement handles have to be closed via
:link reftype=hd refid=cli_SQLFreeStmt.SQLFreeStmt():elink..

.*------------------------------------------------------------------------------
