/*
@echo off
cls
echo.
echo.
echo ERROR:
echo REXX support not installed
echo You must have REXX support installed to run this
echo program.
echo.
echo To run this program, run Selective Install from
echo your System Setup folder, and install REXX or
echo run install2.cmd .
exit
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
/*-- get the command line --*/
parse arg sourcedir destdir

  /* Go search for the OS2.INI file, this will be our bootdrive */
  testos2path = SysSearchPath('PATH', 'OS2.INI');
  bootdrive = FILESPEC("drive", testos2path);
  os2path = FILESPEC("path",testos2path);

/*-- get dest dir --*/
if destdir = '' then do
  say ''
  say 'Please enter a directory name for ELSA Video Driver'
  say '(Default: 'bootdrive'\WINOS232):'
  /*-- if error --*/
  parse pull destdir
  if destdir = ' ' then do
    destdir = bootdrive'\WINOS232'
  end
end


  DestDrive = FILESPEC("drive", destdir)
if sourcedir = '' then do
  thisdir = directory()
  say ''
  say 'Please enter the directory where the program is being installed'
  say 'from(Default: 'thisdir'):'
  parse pull sourcedir
  /*-- if another error --*/
  if sourcedir = ' ' then do
    sourcedir = thisdir
    say 'using the current directory as the source directory.'
end

/*-- make sure path is good --*/
If substr( sourcedir, length(sourcedir), 1 ) \= '\' then
    sourcedir = sourcedir||'\'

/*-- do main screen --*/
call SysCls
say
say '                   ELSA Video Driver Installation'
say
say 'The ELSA Video Driver will be Installed with the following settings:'
say
say 'Source directory: "'sourcedir'"'
say 'Destination directory: "'destdir'"'
say
say 'Okay to continue(Y/n)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then do
  say
  say 'Installation cancelled.'
  exit
end


     ScreenSys = SysSearchPath('PATH', 'screen01.sys');
     "@attrib -r -h -s "||ScreenSys
     if ScreenSys > ' ' then
        "@copy "||ScreenSys||" "||bootdrive||os2path||"*.ibm"
     call CopyDriverFiles sourcedir , destdir
     DestDrive
     "@CD "||destdir
     DosSys = SysSearchPath('PATH', 'command.com');
     DosPath = FILESPEC("PATH", DosSys);
     "@attrib -r -h -s "||bootdrive||DosPath||"vsvga.sys"
     "@attrib -r -h -s "||bootdrive||os2path||"dll\*.dll"
     if DosSys > " " then
        "@copy "||destdir||"\vsvga.sys "||bootdrive||DosPath||"*.*"
     DSPINSTL.EXE                       /* go execute DSPINSTL */
     say ""
/*-- create a program object --*/
call SysCls
say
say
say
say
say 'ELSA Video Configuration Editor can be installed as an object on your desktop.'
say 'Do you want to create it now(Y/n)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then call GoodBye

say
say 'Creating the program folder,'
x = SysCreateObject("WPFolder",,
                    "ELSA Video Configuration",,
                    "<WP_DESKTOP>",,
                    "OBJECTID=<ELSAFLDR>;ICONFILE="||destdir||"\wininst.ICO", "replace")
if x = 0 then do
  say 'Unable to create folder; cancelling.'
  exit
end


say 'ReadMe file,'
x = SysCreateObject("WPProgram",,
                    "Read Me",,
                    "<ELSAFLDR>",,
                    "EXENAME=E.EXE;PARAMETERS="||destdir||"\README")

say 'Liesmich file,'
x = SysCreateObject("WPProgram",,
                    "Lies mich",,
                    "<ELSAFLDR>",,
                    "EXENAME=E.EXE;PARAMETERS="||destdir||"\LIESMICH")

say 'and the Program file.'
x = SysCreateObject("WPProgram",,
                    "ELSA Video Configuration Editor",,
                    "<ELSAFLDR>",,
                    "EXENAME="||destdir||"\WININST.EXE;STARTUPDIR="||destdir)


GoodBye:
/*-- exit with a goodbye --*/
call SysCls
say
say
say
say
say 'ELSA Video Adapter File  was installed successfully.'
say 'Please reboot your system.'
say
say 'ELSA Video Configuration Editor has been installed on your system.'
say
say 'Be sure to read the file README for up-to-date information.'
say
say 'Press any key to exit installation...'
k = SysGetKey('NOECHO')
call SysCls
"@start e.exe "||destdir||"\readme"
exit


INST_EXIT:
  EXIT



CopyDriverFiles: Arg SrcDrive , DestDir

  DestDrive = FILESPEC("drive",DestDir)
  /*-- create the dest. dir --*/
  DestDrive
  rc = SysMkDir(DestDir)
  if rc = 0 then do
    say 'The directory ' DestDir ' was created successfully.'
  end
  else do
    if SysFileTree(DestDir,file,D)>0 then
    do
       say 'The directory ' DestDir ' could not be created successfully; cancelling.'
       exit
    end
  end
  say 'Please wait ....'
  "@xcopy "||SrcDrive||"*.* "||DestDir
  return
