/************************************************************************\
*                                                                        *
*         Microsoft C  Language Sample TalkThru HLLAPI Module             *
*                                                                        *
*       (C) Copyright Software Corporation of America, Inc. 1991.        *
*       All Rights Reserved.                                             *
*                                                                        *
*			Start Host Async Notification - 23                                    *
*                                                                        *
\************************************************************************/
 
#include "stdio.h"

#define INCL_DOSSEMAPHORES
#include "os2.h"
 
#include "clim.h"                     /* Include the CLIM header        */
#include "hapi.h"                     /* Include sample subs. header    */
 
void pascal hllapi();
 
 
/************************************************************************\
*                                                                        *
*        Global Variables                                                *
*                                                                        *
\************************************************************************/
 
extern int CLIMFunction;              /* API function                   */
extern int CLIMLength;                /* API string length              */
extern int CLIMReturnCode;            /* API return code                */
 
 
/************************************************************************\
*                                                                        *
*  HapiStartHostAsyncNote - Function to issue HLLAPI call #23	          *
*                                                                        *
\************************************************************************/
 
int HapiStartHostAsyncNote(ShortName,Request,phsemAsyncWait)
char ShortName;
char Request;
PHSEM *phsemAsyncWait;
{
char	szData[7];
 
    CLIMFunction   = PCB_START_HOST_NOTE;        /* Set Function Code   */
    CLIMLength     = 7;                          /* Set Length          */
    CLIMReturnCode = -1;                         /* Initialize Ret. Code*/

	 memset(szData,0x00,7);
	 szData[0] = ShortName;
	 szData[1] = 'A';
	 szData[6] = Request;
 
    hllapi(&CLIMFunction, &szData[0], &CLIMLength, &CLIMReturnCode);

	 memmove(phsemAsyncWait,&szData[2],4);
 
    return(CLIMReturnCode);                      /* Return to Caller    */
}
 
