/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.swing.text.ArabicLigaturizer;
import javax.swing.text.ExtendedTextLabel;
import javax.swing.text.NewArabicShaping;
import sun.awt.font.StandardGlyphVector;

class StandardExtendedTextLabel
extends ExtendedTextLabel {
    GlyphVector gv;
    float[] charinfo;
    LineMetrics metrics;
    boolean dataIsLTR;
    boolean lineIsLTR;
    float italicAngle;
    int numchars;
    Rectangle2D lb;
    Rectangle2D ab;
    Rectangle2D vb;
    private static final int posx = 0;
    private static final int posy = 1;
    private static final int advx = 2;
    private static final int advy = 3;
    private static final int visx = 4;
    private static final int visy = 5;
    private static final int visw = 6;
    private static final int vish = 7;
    private static final int numvals = 8;
    private static final char[] mirrorPairs = new char[]{'(', ')', '<', '>', '[', ']', '{', '}', '\u2045', '\u2046', '\u207d', '\u207e', '\u208d', '\u208e', '\u2264', '\u2265', '\u3008', '\u3009', '\u300a', '\u300b', '\u300c', '\u300d', '\u300e', '\u300f', '\u3010', '\u3011', '\u3014', '\u3015', '\u3016', '\u3017', '\u3018', '\u3019', '\u301a', '\u301b'};

    protected StandardExtendedTextLabel(GlyphVector glyphVector, float[] fArray, LineMetrics lineMetrics, boolean bl, boolean bl2, float f) {
        this.gv = glyphVector;
        this.charinfo = fArray;
        this.metrics = lineMetrics;
        this.dataIsLTR = bl;
        this.lineIsLTR = bl2;
        this.italicAngle = f;
        this.numchars = fArray.length / 8;
    }

    /*
     * WARNING - void declaration
     */
    static ExtendedTextLabel create(char[] cArray, int n, int n2, int n3, int n4, boolean bl, Font font, FontRenderContext fontRenderContext) {
        int n5;
        int n6;
        int n7;
        char[] cArray2 = cArray;
        int n8 = n3;
        if (bl) {
            n7 = n3;
            n6 = n3 + n4;
            while (n7 < n6) {
                if (StandardExtendedTextLabel.isFormatMark(cArray[n7])) {
                    cArray2 = new char[n4];
                    n8 = 0;
                    System.arraycopy(cArray, n3, cArray2, 0, n4);
                    cArray2[n7 - n3] = 65535;
                    n5 = n7 - n3 + 1;
                    while (n5 < n4) {
                        if (StandardExtendedTextLabel.isFormatMark(cArray2[n5])) {
                            cArray2[n5] = 65535;
                        }
                        ++n5;
                    }
                    break;
                }
                ++n7;
            }
        } else {
            void var13_17;
            n7 = 8;
            n6 = n3 - 1;
            while (n6 >= n) {
                n7 = NewArabicShaping.getShapeType(cArray[n6]);
                if (n7 != 4) break;
                --n6;
            }
            n5 = 8;
            int bl3 = n3 + n4;
            int n9 = n + n2;
            while (var13_17 < n9) {
                n5 = NewArabicShaping.getShapeType(cArray[var13_17]);
                if (n5 != 4) break;
                ++var13_17;
            }
            n8 = 0;
            cArray2 = new char[n4];
            int n10 = n4;
            int n11 = n3 - 1;
            while (n10 > 0) {
                cArray2[--n10] = cArray[++n11];
            }
            NewArabicShaping.shape(cArray2, n5, n7);
            ArabicLigaturizer.getLamAlefInstance().ligaturize(cArray2, 0, cArray2.length);
            int n12 = 0;
            while (n12 < n4) {
                char c = cArray2[n12];
                cArray2[n12] = StandardExtendedTextLabel.isFormatMark(c) ? 65535 : StandardExtendedTextLabel.getMirroredChar(c);
                ++n12;
            }
        }
        StandardGlyphVector standardGlyphVector = new StandardGlyphVector(font, cArray2, n8, n4, fontRenderContext);
        float[] fArray = standardGlyphVector.getGlyphInfo();
        LineMetrics lineMetrics = font.getLineMetrics(cArray2, n8, n4, fontRenderContext);
        boolean bl2 = bl;
        boolean bl3 = bl;
        float f = font.getItalicAngle();
        return new StandardExtendedTextLabel((GlyphVector)standardGlyphVector, fArray, lineMetrics, bl3, bl2, f);
    }

    protected Rectangle2D createAlignBounds() {
        float f = 0.0f;
        float f2 = -this.metrics.getAscent();
        float f3 = 0.0f;
        float f4 = this.metrics.getAscent() + this.metrics.getDescent();
        int n = this.charinfo.length - 8;
        while (n > 0 && (this.charinfo[n + 2] == 0.0f || this.lineIsLTR && this.charinfo[n + 6] == 0.0f)) {
            n -= 8;
        }
        if (n >= 0) {
            int n2 = 0;
            while (n2 < n && (this.charinfo[n2 + 2] == 0.0f || !this.lineIsLTR && this.charinfo[n2 + 6] == 0.0f)) {
                n2 += 8;
            }
            f = Math.max(0.0f, this.charinfo[n2]);
            f3 = this.charinfo[n] + this.charinfo[n + 2] - f;
        }
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    protected Rectangle2D createLogicalBounds() {
        float f = 0.0f;
        float f2 = -this.metrics.getAscent();
        float f3 = 0.0f;
        float f4 = this.metrics.getAscent() + this.metrics.getDescent() + this.metrics.getLeading();
        int n = this.charinfo.length - 8;
        while (n > 0) {
            if (this.charinfo[n + 2] != 0.0f) break;
            n -= 8;
        }
        if (n >= 0) {
            int n2 = 0;
            while (n2 < n) {
                if (this.charinfo[n2 + 2] != 0.0f) break;
                n2 += 8;
            }
            f = Math.min(0.0f, this.charinfo[n2]);
            f3 = this.charinfo[n] + this.charinfo[n + 2] - f;
        }
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    protected Rectangle2D createVisualBounds() {
        return this.gv.getVisualBounds();
    }

    void draw(Graphics2D graphics2D, float f, float f2) {
        graphics2D.drawGlyphVector(this.gv, f, f2);
    }

    Rectangle2D getAlignBounds(float f, float f2) {
        if (this.ab == null) {
            this.ab = this.createAlignBounds();
        }
        return new Rectangle2D.Float((float)(this.ab.getX() + (double)f), (float)(this.ab.getY() + (double)f2), (float)this.ab.getWidth(), (float)this.ab.getHeight());
    }

    float getCharAdvance(int n) {
        this.validate(n);
        return this.charinfo[this.l2v(n) * 8 + 2];
    }

    float getCharAdvanceBetween(int n, int n2) {
        float f = 0.0f;
        --n;
        while (++n < n2) {
            f += this.charinfo[this.l2v(n) * 8 + 2];
        }
        return f;
    }

    int getCharIndexAtWidth(float f) {
        int n = 0;
        if (this.dataIsLTR) {
            int n2 = n * 8 + 2;
            int n3 = this.getNumCharacters();
            --n;
            while (f >= 0.0f && ++n < n3) {
                f -= this.charinfo[n2];
                n2 += 8;
            }
        } else {
            n = this.getNumCharacters() - 1;
            int n4 = n * 8 + 2;
            ++n;
            while (f >= 0.0f && --n >= 0) {
                f -= this.charinfo[n4];
                n4 -= 8;
            }
        }
        return n;
    }

    Rectangle2D getCharVisualBounds(int n, float f, float f2) {
        this.validate(n);
        n = this.l2v(n) * 8;
        return new Rectangle2D.Float(this.charinfo[n + 4] + f, this.charinfo[n + 5] + f2, this.charinfo[n + 6], this.charinfo[n + 7]);
    }

    float getCharX(int n) {
        this.validate(n);
        return this.charinfo[this.l2v(n) * 8];
    }

    float getCharY(int n) {
        this.validate(n);
        return this.charinfo[this.l2v(n) * 8 + 1];
    }

    float getItalicAngle() {
        return this.italicAngle;
    }

    int getLineBreakIndex(int n, float f) {
        this.validate(n);
        --n;
        while (f >= 0.0f && ++n < this.numchars) {
            f -= this.charinfo[this.l2v(n) * 8 + 2];
        }
        return n;
    }

    LineMetrics getLineMetrics() {
        return this.metrics;
    }

    Rectangle2D getLogicalBounds(float f, float f2) {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return new Rectangle2D.Float((float)(this.lb.getX() + (double)f), (float)(this.lb.getY() + (double)f2), (float)this.lb.getWidth(), (float)this.lb.getHeight());
    }

    private static char getMirroredChar(char c) {
        if (c <= '}' || c >= '\u2045' && c <= '\u301b') {
            int n = 0;
            while (n < mirrorPairs.length) {
                char c2 = mirrorPairs[n];
                if (c2 == c) {
                    return mirrorPairs[n + ((n & 1) == 0 ? 1 : -1)];
                }
                if (c2 > c) break;
                ++n;
            }
        }
        return c;
    }

    int getNumCharacters() {
        return this.numchars;
    }

    Shape getOutline(float f, float f2) {
        return this.gv.getOutline(f, f2);
    }

    Rectangle2D getVisualBounds(float f, float f2) {
        if (this.vb == null) {
            this.vb = this.createVisualBounds();
        }
        return new Rectangle2D.Float((float)(this.vb.getX() + (double)f), (float)(this.vb.getY() + (double)f2), (float)this.vb.getWidth(), (float)this.vb.getHeight());
    }

    private static boolean isFormatMark(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case '\u200c': 
            case '\u200d': 
            case '\u200e': 
            case '\u200f': 
            case '\u2028': 
            case '\u2029': 
            case '\u202a': 
            case '\u202b': 
            case '\u202c': 
            case '\u202d': 
            case '\u202e': 
            case '\u206a': 
            case '\u206b': 
            case '\u206c': 
            case '\u206d': 
            case '\u206e': 
            case '\u206f': 
            case '\ufeff': {
                return true;
            }
        }
        return false;
    }

    protected int l2v(int n) {
        return this.dataIsLTR ? n : this.numchars - 1 - n;
    }

    int logicalToVisual(int n) {
        this.validate(n);
        return this.l2v(n);
    }

    public String toString() {
        String string = null;
        int n = 0;
        while (n < this.charinfo.length) {
            string = String.valueOf(string) + "\tadvx = " + this.charinfo[n + 2];
            string = String.valueOf(string) + " advy = " + this.charinfo[n + 3];
            string = String.valueOf(string) + " posx = " + this.charinfo[n];
            string = String.valueOf(string) + " posy = " + this.charinfo[n + 1];
            string = String.valueOf(string) + "\n";
            n += 8;
        }
        return string;
    }

    protected int v2l(int n) {
        return this.dataIsLTR ? n : this.numchars - 1 - n;
    }

    private void validate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index " + n + " < 0");
        }
        if (n >= this.numchars) {
            throw new IllegalArgumentException("index " + n + " >= " + this.numchars);
        }
    }

    int visualToLogical(int n) {
        this.validate(n);
        return this.v2l(n);
    }
}

