/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;

public class JPopupMenu
extends JComponent
implements Accessible,
MenuElement {
    private static final String uiClassID = "PopupMenuUI";
    transient Component invoker;
    transient Popup popup;
    transient Frame frame;
    private String label = null;
    private boolean paintBorder = true;
    private Insets margin = null;
    private int desiredLocationX;
    private int desiredLocationY;
    private int lastPopupType = 0;
    private static final Object heavyPopupCacheKey = new StringBuffer("JPopupMenu.heavyPopupCache");
    private static final Object lightPopupCacheKey = new StringBuffer("JPopupMenu.lightPopupCache");
    private static final Object mediumPopupCacheKey = new StringBuffer("JPopupMenu.mediumPopupCache");
    private static final Object defaultLWPopupEnabledKey = new StringBuffer("JPopupMenu.defaultLWPopupEnabledKey");
    private static final int MAX_CACHE_SIZE = 5;
    private boolean lightWeightPopupEnabled = true;
    private static final int LIGHT_WEIGHT_POPUP = 0;
    private static final int MEDIUM_WEIGHT_POPUP = 1;
    private static final int HEAVY_WEIGHT_POPUP = 2;
    private SingleSelectionModel selectionModel;
    private static Hashtable listenerRegistry = null;
    private static final Object classLock = new Object();
    static /* synthetic */ Class class$javax$swing$event$PopupMenuListener;

    public JPopupMenu() {
        this(null);
    }

    public JPopupMenu(String string) {
        this.label = string;
        this.lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.addMouseListener(new MouseAdapter(){});
        this.updateUI();
    }

    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        jMenuItem.addActionListener(action);
        this.add(jMenuItem);
        this.registerMenuItemForAction(jMenuItem, action);
        return jMenuItem;
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        super.add(jMenuItem);
        return jMenuItem;
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(class$javax$swing$event$PopupMenuListener != null ? class$javax$swing$event$PopupMenuListener : (class$javax$swing$event$PopupMenuListener = JPopupMenu.class$("javax.swing.event.PopupMenuListener")), popupMenuListener);
    }

    public void addSeparator() {
        this.add(new Separator());
    }

    boolean alwaysOnTop() {
        return true;
    }

    private boolean ancestorIsModalDialog(Component component) {
        Container container = null;
        if (component != null) {
            container = component.getParent();
            while (container != null) {
                if (container instanceof Dialog && ((Dialog)container).isModal()) {
                    return true;
                }
                container = container.getParent();
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    private Popup createHeavyWeightPopup() {
        Frame frame = JPopupMenu.getFrame(this.invoker);
        if (frame != null) {
            this.popup = JPopupMenu.getRecycledHeavyPopup(frame);
        } else {
            frame = new Frame();
        }
        if (this.popup == null) {
            this.popup = new WindowPopup(frame);
        }
        return this.popup;
    }

    private Popup createLightWeightPopup() {
        Popup popup = JPopupMenu.getRecycledLightPopup();
        if (popup == null) {
            popup = new JPanelPopup();
        }
        return popup;
    }

    private Popup createMediumWeightPopup() {
        Popup popup = JPopupMenu.getRecycledMediumPopup();
        if (popup == null) {
            popup = new PanelPopup();
        }
        return popup;
    }

    protected void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$PopupMenuListener != null ? class$javax$swing$event$PopupMenuListener : JPopupMenu.class$("javax.swing.event.PopupMenuListener"))) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n + 1]).popupMenuCanceled(popupMenuEvent);
            }
            n -= 2;
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$PopupMenuListener != null ? class$javax$swing$event$PopupMenuListener : JPopupMenu.class$("javax.swing.event.PopupMenuListener"))) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
            }
            n -= 2;
        }
    }

    protected void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$PopupMenuListener != null ? class$javax$swing$event$PopupMenuListener : JPopupMenu.class$("javax.swing.event.PopupMenuListener"))) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
            }
            n -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPopupMenu();
        }
        return this.accessibleContext;
    }

    public Component getComponent() {
        return this;
    }

    public Component getComponentAtIndex(int n) {
        return this.getComponent(n);
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static boolean getDefaultLightWeightPopupEnabled() {
        Boolean bl = (Boolean)SwingUtilities.appContextGet(defaultLWPopupEnabledKey);
        if (bl == null) {
            SwingUtilities.appContextPut(defaultLWPopupEnabledKey, Boolean.TRUE);
            return true;
        }
        return bl;
    }

    private static Frame getFrame(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Frame) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Frame)component2;
    }

    private static Hashtable getHeavyPopupCache() {
        Hashtable hashtable = (Hashtable)SwingUtilities.appContextGet(heavyPopupCacheKey);
        if (hashtable == null) {
            hashtable = new Hashtable(2);
            SwingUtilities.appContextPut(heavyPopupCacheKey, hashtable);
        }
        return hashtable;
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public String getLabel() {
        return this.label;
    }

    private static Vector getLightPopupCache() {
        Vector vector = (Vector)SwingUtilities.appContextGet(lightPopupCacheKey);
        if (vector == null) {
            vector = new Vector();
            SwingUtilities.appContextPut(lightPopupCacheKey, vector);
        }
        return vector;
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    private static Vector getMediumPopupCache() {
        Vector vector = (Vector)SwingUtilities.appContextGet(mediumPopupCacheKey);
        if (vector == null) {
            vector = new Vector();
            SwingUtilities.appContextPut(mediumPopupCacheKey, vector);
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Popup getRecycledHeavyPopup(Frame frame) {
        Object object = classLock;
        synchronized (object) {
            Hashtable hashtable = JPopupMenu.getHeavyPopupCache();
            if (!hashtable.containsKey(frame)) return null;
            Vector vector = (Vector)hashtable.get(frame);
            int n = vector.size();
            if (n <= 0) return null;
            Popup popup = (Popup)vector.elementAt(0);
            vector.removeElementAt(0);
            return popup;
        }
    }

    static Popup getRecycledLightPopup() {
        Object object = classLock;
        synchronized (object) {
            Vector vector = JPopupMenu.getLightPopupCache();
            int n = vector.size();
            if (n > 0) {
                Popup popup = (Popup)vector.elementAt(0);
                vector.removeElementAt(0);
                Popup popup2 = popup;
                Object var2_6 = null;
                return popup2;
            }
            Popup popup = null;
            Object var2_7 = null;
            return popup;
        }
    }

    static Popup getRecycledMediumPopup() {
        Object object = classLock;
        synchronized (object) {
            Vector vector = JPopupMenu.getMediumPopupCache();
            int n = vector.size();
            if (n > 0) {
                Popup popup = (Popup)vector.elementAt(0);
                vector.removeElementAt(0);
                Popup popup2 = popup;
                Object var2_6 = null;
                return popup2;
            }
            Popup popup = null;
            Object var2_7 = null;
            return popup;
        }
    }

    JPopupMenu getRootPopupMenu() {
        JPopupMenu jPopupMenu = this;
        while (jPopupMenu != null && !jPopupMenu.isPopupMenu() && jPopupMenu.getInvoker() != null && jPopupMenu.getInvoker().getParent() != null && jPopupMenu.getInvoker().getParent() instanceof JPopupMenu) {
            jPopupMenu = (JPopupMenu)jPopupMenu.getInvoker().getParent();
        }
        return jPopupMenu;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public MenuElement[] getSubElements() {
        Vector<Component> vector = new Vector<Component>();
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            if (component instanceof MenuElement) {
                vector.addElement(component);
            }
            ++n2;
        }
        MenuElement[] menuElementArray = new MenuElement[vector.size()];
        n2 = 0;
        n = vector.size();
        while (n2 < n) {
            menuElementArray[n2] = (MenuElement)vector.elementAt(n2);
            ++n2;
        }
        return menuElementArray;
    }

    public PopupMenuUI getUI() {
        return (PopupMenuUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void insert(Component component, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        int n2 = this.getComponentCount();
        Vector<Component> vector = new Vector<Component>();
        int n3 = n;
        while (n3 < n2) {
            vector.addElement(this.getComponent(n));
            this.remove(n);
            ++n3;
        }
        this.add(component);
        int n4 = 0;
        while (n4 < vector.size()) {
            this.add((Component)vector.elementAt(n4));
            ++n4;
        }
    }

    public void insert(Action action, int n) {
        throw new Error("void insert(Action, int) {} not yet implemented");
    }

    private boolean invokerInHeavyWeightPopup(Component component) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof WindowPopup) {
                    return true;
                }
                if (container instanceof PanelPopup || container instanceof JPanelPopup) break;
                container = container.getParent();
            }
        }
        return false;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    private boolean isPopupMenu() {
        return this.invoker != null && !(this.invoker instanceof JMenu);
    }

    boolean isSubPopupMenu(JPopupMenu jPopupMenu) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                JPopupMenu jPopupMenu2 = jMenu.getPopupMenu();
                if (jPopupMenu2 == jPopupMenu) {
                    return true;
                }
                if (jPopupMenu2.isSubPopupMenu(jPopupMenu)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public boolean isVisible() {
        if (this.popup != null) {
            return this.popup.isShowing();
        }
        return false;
    }

    public void menuSelectionChanged(boolean bl) {
        if (this.invoker instanceof JMenu) {
            JMenu jMenu = (JMenu)this.invoker;
            if (bl) {
                jMenu.setPopupMenuVisible(true);
            } else {
                jMenu.setPopupMenuVisible(false);
            }
        }
        if (this.isPopupMenu() && !bl) {
            this.setVisible(false);
        }
    }

    public void pack() {
        if (this.popup != null) {
            this.popup.pack();
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    protected String paramString() {
        String string;
        String string2 = this.label != null ? this.label : "";
        String string3 = this.paintBorder ? "true" : "false";
        String string4 = string = this.margin != null ? this.margin.toString() : "";
        String string5 = this.lastPopupType == 0 ? "LIGHT_WEIGHT_POPUP" : (this.lastPopupType == 1 ? "MEDIUM_WEIGHT_POPUP" : (this.lastPopupType == 2 ? "HEAVY_WEIGHT_POPUP" : ""));
        String string6 = this.lightWeightPopupEnabled ? "true" : "false";
        return String.valueOf(super.paramString()) + ",desiredLocationX=" + this.desiredLocationX + ",desiredLocationY=" + this.desiredLocationY + ",label=" + string2 + ",lastPopupType=" + string5 + ",lightWeightPopupEnabled=" + string6 + ",margin=" + string + ",paintBorder=" + string3;
    }

    private boolean popupFit(Rectangle rectangle) {
        if (this.invoker != null) {
            Container container = this.invoker.getParent();
            while (container != null) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return SwingUtilities.isRectangleContainingRectangle(container.getBounds(), rectangle);
                }
                if (container instanceof JApplet) {
                    Rectangle rectangle2 = container.getBounds();
                    Point point = container.getLocationOnScreen();
                    rectangle2.x = point.x;
                    rectangle2.y = point.y;
                    return SwingUtilities.isRectangleContainingRectangle(rectangle2, rectangle);
                }
                if (container instanceof Frame) {
                    return SwingUtilities.isRectangleContainingRectangle(container.getBounds(), rectangle);
                }
                container = container.getParent();
            }
        }
        return false;
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("invoker")) {
            this.invoker = (Component)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("popup")) {
            this.popup = (Popup)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("frame")) {
            this.frame = (Frame)vector.elementAt(++n);
            ++n;
        }
    }

    static void recycleHeavyPopup(Popup popup) {
        Object object = classLock;
        synchronized (object) {
            Vector vector;
            final Frame frame = JPopupMenu.getFrame((Component)((Object)popup));
            Hashtable hashtable = JPopupMenu.getHeavyPopupCache();
            if (hashtable.containsKey(frame)) {
                vector = (Vector)hashtable.get(frame);
            } else {
                vector = new Vector();
                hashtable.put(frame, vector);
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent windowEvent) {
                        Hashtable hashtable = JPopupMenu.getHeavyPopupCache();
                        hashtable.remove(frame);
                    }
                });
            }
            if (vector.size() < 5) {
                vector.addElement(popup);
            }
        }
    }

    static void recycleLightPopup(Popup popup) {
        Object object = classLock;
        synchronized (object) {
            Vector vector = JPopupMenu.getLightPopupCache();
            if (vector.size() < 5) {
                vector.addElement(popup);
            }
        }
    }

    static void recycleMediumPopup(Popup popup) {
        Object object = classLock;
        synchronized (object) {
            Vector vector = JPopupMenu.getMediumPopupCache();
            if (vector.size() < 5) {
                vector.addElement(popup);
            }
        }
    }

    static void recyclePopup(Popup popup) {
        if (popup instanceof JPanelPopup) {
            JPopupMenu.recycleLightPopup(popup);
        } else if (popup instanceof WindowPopup) {
            JPopupMenu.recycleHeavyPopup(popup);
        } else if (popup instanceof PanelPopup) {
            JPopupMenu.recycleMediumPopup(popup);
        }
    }

    private void registerMenuItemForAction(JMenuItem jMenuItem, Action action) {
        PropertyChangeListener propertyChangeListener = this.createActionChangeListener(jMenuItem);
        if (listenerRegistry == null) {
            listenerRegistry = new Hashtable();
        }
        listenerRegistry.put(jMenuItem, propertyChangeListener);
        listenerRegistry.put(propertyChangeListener, action);
        action.addPropertyChangeListener(propertyChangeListener);
    }

    public void remove(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n > this.getComponentCount() - 1) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        Component component = this.getComponent(n);
        if (component instanceof JMenuItem) {
            this.unregisterMenuItemForAction((JMenuItem)component);
        }
        super.remove(n);
    }

    public void remove(Component component) {
        super.remove(component);
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            this.unregisterMenuItemForAction(jMenuItem);
        }
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(class$javax$swing$event$PopupMenuListener != null ? class$javax$swing$event$PopupMenuListener : (class$javax$swing$event$PopupMenuListener = JPopupMenu.class$("javax.swing.event.PopupMenuListener")), popupMenuListener);
    }

    private void replacePopup(int n) {
        this.popup.removeComponent(this);
        JPopupMenu.recyclePopup(this.popup);
        this.popup = null;
        switch (n) {
            case 0: {
                this.popup = this.createLightWeightPopup();
                break;
            }
            case 1: {
                this.popup = this.createMediumWeightPopup();
                break;
            }
            case 2: {
                this.popup = this.createHeavyWeightPopup();
                break;
            }
        }
        this.popup.setLocationOnScreen(this.desiredLocationX, this.desiredLocationY);
        this.popup.addComponent(this, "Center");
        this.invalidate();
        this.popup.setBackground(this.getBackground());
        this.popup.pack();
    }

    public void setBorderPainted(boolean bl) {
        this.paintBorder = bl;
        this.repaint();
    }

    public static void setDefaultLightWeightPopupEnabled(boolean bl) {
        SwingUtilities.appContextPut(defaultLWPopupEnabledKey, new Boolean(bl));
    }

    public void setInvoker(Component component) {
        Component component2 = this.invoker;
        this.invoker = component;
        if (component2 != this.invoker && this.ui != null) {
            this.ui.uninstallUI(this);
            this.ui.installUI(this);
        }
        this.invalidate();
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.firePropertyChange("label", string2, string);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        this.invalidate();
        this.repaint();
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public void setLocation(int n, int n2) {
        if (this.popup != null) {
            this.popup.setLocationOnScreen(n, n2);
        } else {
            this.desiredLocationX = n;
            this.desiredLocationY = n2;
        }
    }

    public void setPopupSize(int n, int n2) {
        if (this.popup != null) {
            this.popup.setSize(n, n2);
        }
    }

    public void setPopupSize(Dimension dimension) {
        if (this.popup != null) {
            this.popup.setSize(dimension.width, dimension.height);
        }
    }

    public void setSelected(Component component) {
        SingleSelectionModel singleSelectionModel = this.getSelectionModel();
        int n = this.getComponentIndex(component);
        singleSelectionModel.setSelectedIndex(n);
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        this.selectionModel = singleSelectionModel;
    }

    public void setUI(PopupMenuUI popupMenuUI) {
        super.setUI(popupMenuUI);
    }

    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        if (!bl) {
            this.getSelectionModel().clearSelection();
        } else if (this.isPopupMenu()) {
            MenuElement[] menuElementArray;
            if (this.getSubElements().length > 0) {
                menuElementArray = new MenuElement[]{this, this.getSubElements()[0]};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            } else {
                menuElementArray = new MenuElement[]{this};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            }
        }
        if (bl) {
            boolean bl2 = this.ancestorIsModalDialog(this.invoker);
            this.firePopupMenuWillBecomeVisible();
            switch (this.lastPopupType) {
                case 0: {
                    this.popup = this.createLightWeightPopup();
                    break;
                }
                case 1: {
                    this.popup = this.createMediumWeightPopup();
                    break;
                }
                case 2: {
                    this.popup = this.createHeavyWeightPopup();
                    break;
                }
            }
            int n = this.lastPopupType;
            this.popup.setLocationOnScreen(this.desiredLocationX, this.desiredLocationY);
            this.popup.addComponent(this, "Center");
            this.popup.setBackground(this.getBackground());
            this.popup.pack();
            Rectangle rectangle = new Rectangle(this.desiredLocationX, this.desiredLocationY, this.popup.getWidth(), this.popup.getHeight());
            int n2 = this.popupFit(rectangle) ? (this.lightWeightPopupEnabled ? 0 : 1) : (bl2 ? 1 : 2);
            if (this.invokerInHeavyWeightPopup(this.invoker)) {
                n2 = 2;
            }
            if (this.invoker == null) {
                n2 = 2;
            }
            if (n2 != n) {
                this.replacePopup(n2);
                n = n2;
            }
            this.lastPopupType = n;
            this.popup.show(this.invoker);
        } else if (this.popup != null) {
            this.firePopupMenuWillBecomeInvisible();
            this.popup.hide();
            this.popup.removeComponent(this);
            JPopupMenu.recyclePopup(this.popup);
            this.popup = null;
        }
        if (this.accessibleContext != null) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }
        }
    }

    public void show(Component component, int n, int n2) {
        this.setInvoker(component);
        Frame frame = JPopupMenu.getFrame(component);
        if (frame != this.frame && frame != null) {
            this.frame = frame;
            if (this.popup != null) {
                this.setVisible(false);
            }
        }
        if (component != null) {
            Point point = component.getLocationOnScreen();
            this.setLocation(point.x + n, point.y + n2);
        } else {
            this.setLocation(n, n2);
        }
        this.setVisible(true);
    }

    private void unregisterMenuItemForAction(JMenuItem jMenuItem) {
        ActionChangedListener actionChangedListener;
        if (listenerRegistry != null && (actionChangedListener = (ActionChangedListener)listenerRegistry.remove(jMenuItem)) != null) {
            Action action = (Action)listenerRegistry.remove(actionChangedListener);
            if (action != null) {
                jMenuItem.removeActionListener(action);
                action.removePropertyChangeListener(actionChangedListener);
            }
            actionChangedListener.setTarget(null);
        }
    }

    public void updateUI() {
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.invoker != null && this.invoker instanceof Serializable) {
            vector.addElement("invoker");
            vector.addElement(this.invoker);
        }
        if (this.popup != null && this.popup instanceof Serializable) {
            vector.addElement("popup");
            vector.addElement(this.popup);
        }
        if (this.frame != null && this.frame instanceof Serializable) {
            vector.addElement("frame");
            vector.addElement(this.frame);
        }
        objectOutputStream.writeObject(vector);
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.setTarget(jMenuItem);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            }
        }

        public void setTarget(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }
    }

    private static interface Popup {
        public void addComponent(Component var1, Object var2);

        public Rectangle getBoundsOnScreen();

        public Component getComponent();

        public int getHeight();

        public int getWidth();

        public void hide();

        public boolean isShowing();

        public void pack();

        public void removeComponent(Component var1);

        public void setBackground(Color var1);

        public void setLocationOnScreen(int var1, int var2);

        public void setSize(int var1, int var2);

        public void show(Component var1);
    }

    class WindowPopup
    extends JWindow
    implements Popup,
    Serializable,
    Accessible {
        int saveX;
        int saveY;
        boolean firstShow = true;
        protected AccessibleContext accessibleContext = null;

        public WindowPopup(Frame frame) {
            super(frame);
        }

        public void addComponent(Component component, Object object) {
            this.getContentPane().add(component, object);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleWindowPopup();
            }
            return this.accessibleContext;
        }

        public Rectangle getBoundsOnScreen() {
            return this.getBounds();
        }

        public Component getComponent() {
            return this;
        }

        public int getHeight() {
            return this.getBounds().height;
        }

        public int getWidth() {
            return this.getBounds().width;
        }

        public void hide() {
            super.hide();
            ((Container)this).removeNotify();
        }

        public void removeComponent(Component component) {
            this.getContentPane().remove(component);
        }

        public void setLocationOnScreen(int n, int n2) {
            ((Component)this).setLocation(n, n2);
            this.saveX = n;
            this.saveY = n2;
        }

        public void show(Component component) {
            ((Component)this).setLocation(this.saveX, this.saveY);
            ((Component)this).setVisible(true);
            if (this.firstShow) {
                this.hide();
                ((Component)this).setVisible(true);
                this.firstShow = false;
            }
        }

        public void update(Graphics graphics) {
            ((Container)this).paint(graphics);
        }

        protected class AccessibleWindowPopup
        extends AccessibleContext
        implements Serializable,
        AccessibleComponent {
            protected AccessibleWindowPopup() {
            }

            public void addFocusListener(FocusListener focusListener) {
                WindowPopup.this.addFocusListener(focusListener);
            }

            public boolean contains(Point point) {
                return WindowPopup.this.contains(point);
            }

            public Accessible getAccessibleAt(Point point) {
                return SwingUtilities.getAccessibleAt(WindowPopup.this, point);
            }

            public Accessible getAccessibleChild(int n) {
                return SwingUtilities.getAccessibleChild(WindowPopup.this, n);
            }

            public int getAccessibleChildrenCount() {
                return SwingUtilities.getAccessibleChildrenCount(WindowPopup.this);
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public int getAccessibleIndexInParent() {
                return SwingUtilities.getAccessibleIndexInParent(WindowPopup.this);
            }

            public Accessible getAccessibleParent() {
                if (this.accessibleParent != null) {
                    return this.accessibleParent;
                }
                Container container = WindowPopup.this.getParent();
                if (container instanceof Accessible) {
                    return (Accessible)((Object)container);
                }
                return null;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.WINDOW;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(WindowPopup.this);
                if (WindowPopup.this.getFocusOwner() != null) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                return accessibleStateSet;
            }

            public Color getBackground() {
                return ((Component)WindowPopup.this).getBackground();
            }

            public Rectangle getBounds() {
                return WindowPopup.this.getBounds();
            }

            public Cursor getCursor() {
                return WindowPopup.this.getCursor();
            }

            public Font getFont() {
                return WindowPopup.this.getFont();
            }

            public FontMetrics getFontMetrics(Font font) {
                return WindowPopup.this.getFontMetrics(font);
            }

            public Color getForeground() {
                return WindowPopup.this.getForeground();
            }

            public Locale getLocale() {
                return WindowPopup.this.getLocale();
            }

            public Point getLocation() {
                return WindowPopup.this.getLocation();
            }

            public Point getLocationOnScreen() {
                return WindowPopup.this.getLocationOnScreen();
            }

            public Dimension getSize() {
                return WindowPopup.this.getSize();
            }

            public boolean isEnabled() {
                return WindowPopup.this.isEnabled();
            }

            public boolean isFocusTraversable() {
                return WindowPopup.this.isFocusTraversable();
            }

            public boolean isShowing() {
                return WindowPopup.this.isShowing();
            }

            public boolean isVisible() {
                return WindowPopup.this.isVisible();
            }

            public void removeFocusListener(FocusListener focusListener) {
                WindowPopup.this.removeFocusListener(focusListener);
            }

            public void requestFocus() {
                WindowPopup.this.requestFocus();
            }

            public void setBackground(Color color) {
                ((Component)WindowPopup.this).setBackground(color);
            }

            public void setBounds(Rectangle rectangle) {
                ((Component)WindowPopup.this).setBounds(rectangle);
            }

            public void setCursor(Cursor cursor) {
                WindowPopup.this.setCursor(cursor);
            }

            public void setEnabled(boolean bl) {
                WindowPopup.this.setEnabled(bl);
            }

            public void setFont(Font font) {
                WindowPopup.this.setFont(font);
            }

            public void setForeground(Color color) {
                WindowPopup.this.setForeground(color);
            }

            public void setLocation(Point point) {
                ((Component)WindowPopup.this).setLocation(point);
            }

            public void setSize(Dimension dimension) {
                ((Component)WindowPopup.this).setSize(dimension);
            }

            public void setVisible(boolean bl) {
                ((Component)WindowPopup.this).setVisible(bl);
            }
        }
    }

    class JPanelPopup
    extends JPanel
    implements Popup,
    Serializable {
        int desiredLocationX;
        int desiredLocationY;

        public JPanelPopup() {
            this.setLayout(new BorderLayout());
            this.setDoubleBuffered(true);
            this.setOpaque(true);
        }

        public void addComponent(Component component, Object object) {
            this.add(component, object);
        }

        Point convertParentLocationToScreen(Container container, int n, int n2) {
            Component component = null;
            Container container2 = this;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    component = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (component != null) {
                Rectangle rectangle = component.getBounds();
                Point point = new Point(n, n2);
                point = SwingUtilities.convertPoint(container, point, null);
                point.x += rectangle.x;
                point.y += rectangle.y;
                return point;
            }
            throw new Error("convertParentLocationToScreen: no window ancestor found");
        }

        Point convertScreenLocationToParent(Container container, int n, int n2) {
            Window window = null;
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    window = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (window != null) {
                Point point = new Point(n, n2);
                SwingUtilities.convertPointFromScreen(point, container);
                return point;
            }
            throw new Error("convertScreenLocationToParent: no window ancestor found");
        }

        public Rectangle getBoundsOnScreen() {
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                Point point = this.convertParentLocationToScreen(container, rectangle.x, rectangle.y);
                rectangle.x = point.x;
                rectangle.y = point.y;
                return rectangle;
            }
            throw new Error("getBoundsOnScreen called on an invisible popup");
        }

        public Component getComponent() {
            return this;
        }

        public void hide() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
            }
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void pack() {
            this.setSize(this.getPreferredSize());
        }

        public void removeComponent(Component component) {
            this.remove(component);
        }

        public void setLocationOnScreen(int n, int n2) {
            Container container = this.getParent();
            if (container != null) {
                Point point = this.convertScreenLocationToParent(container, n, n2);
                this.setLocation(point.x, point.y);
            } else {
                this.desiredLocationX = n;
                this.desiredLocationY = n2;
            }
        }

        public void show(Component component) {
            Container container = null;
            if (component != null) {
                container = component.getParent();
            }
            Window window = null;
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof JRootPane) {
                    if (!(container2.getParent() instanceof JInternalFrame)) {
                        container = ((JRootPane)container2).getLayeredPane();
                        container2 = container.getParent();
                        while (container2 != null && !(container2 instanceof Window)) {
                            container2 = container2.getParent();
                        }
                        window = (Window)container2;
                        break;
                    }
                } else if (container2 instanceof Window) {
                    container = container2;
                    window = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            Point point = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
            this.setLocation(point.x, point.y);
            if (container instanceof JLayeredPane) {
                ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
            } else {
                container.add(this);
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    class PanelPopup
    extends Panel
    implements Popup,
    Serializable {
        int desiredLocationX;
        int desiredLocationY;
        JRootPane rootPane;

        public PanelPopup() {
            this.setLayout(new BorderLayout());
            this.rootPane = new JRootPane();
            this.add((Component)this.rootPane, "Center");
        }

        public void addComponent(Component component, Object object) {
            this.rootPane.getContentPane().add(component, object);
        }

        Point convertParentLocationToScreen(Container container, int n, int n2) {
            Component component = null;
            Container container2 = this;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    component = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (component != null) {
                Rectangle rectangle = component.getBounds();
                Point point = new Point(n, n2);
                point = SwingUtilities.convertPoint(container, point, null);
                point.x += rectangle.x;
                point.y += rectangle.y;
                return point;
            }
            throw new Error("convertParentLocationToScreen: no window ancestor found");
        }

        Point convertScreenLocationToParent(Container container, int n, int n2) {
            Window window = null;
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    window = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (window != null) {
                Point point = new Point(n, n2);
                SwingUtilities.convertPointFromScreen(point, container);
                return point;
            }
            throw new Error("convertScreenLocationToParent: no window ancestor found");
        }

        public Rectangle getBoundsOnScreen() {
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                Point point = this.convertParentLocationToScreen(container, rectangle.x, rectangle.y);
                rectangle.x = point.x;
                rectangle.y = point.y;
                return rectangle;
            }
            throw new Error("getBoundsOnScreen called on an invisible popup");
        }

        public Component getComponent() {
            return this;
        }

        public int getHeight() {
            return this.getBounds().height;
        }

        public int getWidth() {
            return this.getBounds().width;
        }

        public void hide() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
            }
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void pack() {
            this.setSize(this.getPreferredSize());
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public void removeComponent(Component component) {
            this.rootPane.getContentPane().remove(component);
        }

        public void setLocationOnScreen(int n, int n2) {
            Container container = this.getParent();
            if (container != null) {
                Point point = this.convertScreenLocationToParent(container, n, n2);
                this.setLocation(point.x, point.y);
            } else {
                this.desiredLocationX = n;
                this.desiredLocationY = n2;
            }
        }

        public void show(Component component) {
            Container container = null;
            if (component != null) {
                container = component.getParent();
            }
            while (!(container instanceof Window) && !(container instanceof Applet) && container != null) {
                container = container.getParent();
            }
            if (container instanceof RootPaneContainer) {
                container = ((RootPaneContainer)((Object)container)).getLayeredPane();
                Point point = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
                this.setLocation(point.x, point.y);
                ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
            } else {
                Point point = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
                this.setLocation(point.x, point.y);
                container.add(this);
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    protected class AccessibleJPopupMenu
    extends JComponent.AccessibleJComponent {
        protected AccessibleJPopupMenu() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }

    public static class Separator
    extends JSeparator {
        public Separator() {
            super(0);
        }

        public String getUIClassID() {
            return "PopupMenuSeparatorUI";
        }
    }
}

