/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.SingleVectorSelection;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import com.borland.jbcl.model.VectorModelMulticaster;
import com.borland.jbcl.model.VectorSelectionEvent;
import com.borland.jbcl.model.VectorSelectionListener;
import com.borland.jbcl.model.VectorSelectionMulticaster;
import com.borland.jbcl.model.VectorSubfocusEvent;
import com.borland.jbcl.model.VectorSubfocusListener;
import com.borland.jbcl.model.VectorViewManager;
import com.borland.jbcl.model.WritableVectorModel;
import com.borland.jbcl.model.WritableVectorSelection;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.TabInfo;
import com.borland.jbcl.view.TextItemPainter;
import com.borland.jbcl.view.VectorView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class TabsetView
extends BeanPanel
implements ItemPaintSite,
VectorModelListener,
VectorSelectionListener,
VectorView,
Serializable {
    private static final long serialVersionUID = 200L;
    static final int SEL_HEIGHT_INCREASE = 2;
    static final int SLOPE = 1;
    static final int EDGE = 2;
    static final int LINE = 2;
    static final int SCROLLER_WIDTH = 28;
    static final int SCROLLER_HEIGHT = 14;
    protected transient VectorModel model;
    protected transient WritableVectorModel writeModel;
    protected transient VectorViewManager viewManager;
    protected transient WritableVectorSelection selection = new SingleVectorSelection();
    protected transient ItemPainter defaultPainter;
    private int alignment = 34;
    private boolean clientBordered = false;
    private Insets itemMargins = new Insets(1, 4, 1, 4);
    private boolean readOnly = false;
    private boolean tabsOnTop = true;
    private boolean showRollover = false;
    private int rollover = -1;
    boolean thickBorder = true;
    int border = 2;
    private int tabBarTop;
    protected int tabBarWidth;
    protected int tabBarHeight;
    private int oldIndex = -1;
    int firstVisible = 0;
    int lastVisible = -1;
    int xOffset = 0;
    Rectangle leftArrowRect = new Rectangle();
    Rectangle rightArrowRect = new Rectangle();
    boolean needScroller = false;
    boolean lastClipped = false;
    transient EventMulticaster subfocusListeners = new EventMulticaster();
    private transient VectorModelMulticaster modelMulticaster = new VectorModelMulticaster();
    private transient VectorSelectionMulticaster selectionMulticaster = new VectorSelectionMulticaster();
    Vector tabInfo = new Vector();

    public TabsetView() {
        super(null);
        this.setBackground(SystemColor.control);
        this.selection.addSelectionListener(this);
        this.selection.addSelectionListener(this.selectionMulticaster);
        TextItemPainter textItemPainter = new TextItemPainter(33, new Insets(1, 1, 1, 1));
        this.defaultPainter = new FocusableItemPainter(textItemPainter);
    }

    public void setLabels(String[] stringArray) {
        if (this.isReadOnly()) {
            return;
        }
        if (stringArray != null) {
            this.writeModel.enableModelEvents(false);
            this.writeModel.removeAll();
            for (int i = 0; i < stringArray.length; ++i) {
                this.writeModel.addItem(stringArray[i]);
            }
            this.writeModel.enableModelEvents(true);
        } else {
            this.writeModel.removeAll();
        }
    }

    public String[] getLabels() {
        String[] stringArray = new String[this.model.getCount()];
        for (int i = 0; i < this.model.getCount(); ++i) {
            stringArray[i] = this.model.get(i).toString();
        }
        return stringArray;
    }

    public void setLabel(int n, Object object) {
        if (this.isReadOnly()) {
            return;
        }
        this.writeModel.set(n, object);
    }

    public String getLabel(int n) {
        return this.model.get(n).toString();
    }

    public void addTab(Object object) {
        if (this.isReadOnly()) {
            return;
        }
        this.writeModel.addItem(object);
    }

    public void removeTab(Object object) {
        if (this.isReadOnly()) {
            return;
        }
        int n = this.writeModel.find(object);
        if (n != -1) {
            this.writeModel.remove(n);
        }
    }

    public void addTab(int n, Object object) {
        if (this.isReadOnly()) {
            return;
        }
        if (n == -1) {
            this.writeModel.addItem(object);
        } else {
            this.writeModel.addItem(n, object);
        }
    }

    public void renameTab(String string, String string2) {
        if (this.isReadOnly()) {
            return;
        }
        int n = this.writeModel.find(string);
        if (n != -1) {
            this.writeModel.set(n, string2);
        }
    }

    public VectorModel getModel() {
        return this.model;
    }

    public WritableVectorModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(VectorModel vectorModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = vectorModel;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableVectorModel ? (WritableVectorModel)this.model : null;
        this.updateTabInfo();
    }

    public VectorViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(VectorViewManager vectorViewManager) {
        this.viewManager = vectorViewManager;
        this.invalidate();
        this.repaint(100L);
    }

    public int getSubfocus() {
        return this.getSelectedIndex();
    }

    public void setSubfocus(int n) {
        this.selectTab(n);
    }

    public WritableVectorSelection getSelection() {
        return this.selection;
    }

    public void setSelection(WritableVectorSelection writableVectorSelection) {
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
            this.selection.removeSelectionListener(this.selectionMulticaster);
        }
        this.selection = writableVectorSelection;
        if (this.selection != null) {
            this.selection.addSelectionListener(this);
            this.selection.addSelectionListener(this.selectionMulticaster);
        }
        int n = this.getSelectedIndex();
        this.repaintTab(n);
        this.repaintTab(this.oldIndex);
        this.oldIndex = n;
    }

    public void setShowRollover(boolean bl) {
        this.showRollover = bl;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public int getSelectedIndex() {
        int[] nArray = this.selection.getAll();
        return nArray.length > 0 ? nArray[0] : -1;
    }

    public void setSelectedIndex(int n) {
        this.selectTab(n);
    }

    public String getSelectedTab() {
        int n = this.getSelectedIndex();
        if (n >= 0) {
            return this.model.get(n).toString();
        }
        return null;
    }

    public void setSelectedTab(Object object) {
        this.selectTab(this.model.find(object));
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaint(100L);
    }

    public boolean isClientBordered() {
        return this.clientBordered;
    }

    public void setClientBordered(boolean bl) {
        this.clientBordered = bl;
        this.repaint(100L);
    }

    public boolean isFocusAware() {
        return super.isFocusAware();
    }

    public void setFocusAware(boolean bl) {
        super.setFocusAware(bl);
        this.repaintTab(this.getSelectedIndex());
    }

    public Insets getItemMargins() {
        return this.itemMargins;
    }

    public void setItemMargins(Insets insets) {
        this.itemMargins = insets;
        this.invalidate();
        this.repaint(100L);
    }

    public Component getSiteComponent() {
        return this;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isTabsOnTop() {
        return this.tabsOnTop;
    }

    public void setTabsOnTop(boolean bl) {
        this.tabsOnTop = bl;
        this.invalidate();
        this.repaint(100L);
    }

    public void setThickBorder(boolean bl) {
        this.thickBorder = bl;
        this.repaint(100L);
    }

    public boolean isThickBorder() {
        return this.thickBorder;
    }

    public int hitTest(int n, int n2) {
        if (this.needScroller && n > this.leftArrowRect.x) {
            return -1;
        }
        if (this.tabsOnTop ? n2 < this.border || n2 >= this.border + this.tabBarHeight : n2 < this.getSize().height - this.border - this.tabBarHeight || n2 >= this.getSize().height - this.border) {
            return -1;
        }
        return this.hitTestX(n);
    }

    int hitTestX(int n) {
        try {
            int n2;
            for (n2 = this.firstVisible; n2 <= this.lastVisible; ++n2) {
                TabInfo tabInfo = (TabInfo)this.tabInfo.elementAt(n2);
                if (!tabInfo.hitTestX(n + this.xOffset)) continue;
                int n3 = n2;
                return n3;
            }
            n2 = -1;
            return n2;
        }
        catch (Exception exception) {
            int n4 = -1;
            return n4;
        }
    }

    public void addModelListener(VectorModelListener vectorModelListener) {
        this.modelMulticaster.add(vectorModelListener);
    }

    public void removeModelListener(VectorModelListener vectorModelListener) {
        this.modelMulticaster.remove(vectorModelListener);
    }

    public void addSelectionListener(VectorSelectionListener vectorSelectionListener) {
        this.selectionMulticaster.add(vectorSelectionListener);
    }

    public void removeSelectionListener(VectorSelectionListener vectorSelectionListener) {
        this.selectionMulticaster.remove(vectorSelectionListener);
    }

    public void addSubfocusListener(VectorSubfocusListener vectorSubfocusListener) {
        this.subfocusListeners.add(vectorSubfocusListener);
    }

    public void removeSubfocusListener(VectorSubfocusListener vectorSubfocusListener) {
        this.subfocusListeners.remove(vectorSubfocusListener);
    }

    public void modelContentChanged(VectorModelEvent vectorModelEvent) {
        switch (vectorModelEvent.getChange()) {
            case 1: {
                this.updateTabInfo();
                break;
            }
            case 17: 
            case 33: {
                TabInfo tabInfo = (TabInfo)this.tabInfo.elementAt(vectorModelEvent.getLocation());
                tabInfo.item = this.model.get(vectorModelEvent.getLocation());
                this.updateTabRects();
                this.adjustScrollbar();
                this.repaint(100L);
            }
        }
    }

    public void modelStructureChanged(VectorModelEvent vectorModelEvent) {
        this.updateTabInfo();
    }

    public void selectionItemChanged(VectorSelectionEvent vectorSelectionEvent) {
    }

    public void selectionRangeChanged(VectorSelectionEvent vectorSelectionEvent) {
    }

    public void selectionChanged(VectorSelectionEvent vectorSelectionEvent) {
        int n = this.getSelectedIndex();
        this.repaintTab(n);
        this.repaintTab(this.oldIndex);
        this.oldIndex = n;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this.repaintTab(this.getSelectedIndex());
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 36: {
                this.selectTab(0);
                break;
            }
            case 37: {
                int n = this.getSelectedIndex();
                if (n <= 0) break;
                this.selectTab(n - 1);
                break;
            }
            case 39: {
                int n = this.getSelectedIndex();
                if (n >= this.tabInfo.size() - 1) break;
                this.selectTab(n + 1);
                break;
            }
            case 35: {
                if (this.tabInfo.size() <= 0) break;
                this.selectTab(this.tabInfo.size() - 1);
            }
        }
    }

    protected boolean preProcessSubfocusEvent(VectorSubfocusEvent vectorSubfocusEvent) {
        if (this.subfocusListeners.hasListeners()) {
            return this.subfocusListeners.vetoableDispatch(vectorSubfocusEvent);
        }
        return true;
    }

    protected void processSubfocusEvent(VectorSubfocusEvent vectorSubfocusEvent) {
        if (this.subfocusListeners.hasListeners()) {
            this.subfocusListeners.dispatch(vectorSubfocusEvent);
        }
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.rollover = -1;
        if (mouseEvent.isMetaDown()) {
            return;
        }
        if (this.scrollCheck(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        int n = this.hitTest(mouseEvent.getX(), mouseEvent.getY());
        if (n >= 0) {
            this.selectTab(n);
        }
    }

    protected void processMouseMoved(MouseEvent mouseEvent) {
        int n;
        if (this.showRollover && (n = this.hitTest(mouseEvent.getX(), mouseEvent.getY())) >= 0 && n != this.rollover) {
            int n2 = this.rollover;
            this.rollover = n;
            this.repaintTab(n2);
            this.repaintTab(this.rollover);
        }
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
        if (this.showRollover) {
            int n = this.rollover;
            this.rollover = -1;
            this.repaintTab(n);
        }
    }

    protected void setBorderHeight(int n) {
        this.border = n;
    }

    protected void updateTabInfo() {
        this.tabInfo.removeAllElements();
        for (int i = 0; i < this.model.getCount(); ++i) {
            this.tabInfo.addElement(new TabInfo(this.model.get(i)));
        }
        int[] nArray = this.selection.getAll();
        if (nArray.length > 0 && nArray[0] >= this.tabInfo.size()) {
            int[] nArray2 = new int[]{};
            this.selection.removeAll();
            this.selection.add(nArray2);
        }
        this.updateTabRects();
        this.adjustScrollbar();
        this.invalidate();
        this.repaint(100L);
    }

    protected void selectTab(int n) {
        if (n != this.getSelectedIndex() && n < this.tabInfo.size()) {
            if (!this.preProcessSubfocusEvent(new VectorSubfocusEvent(this, 1, n))) {
                return;
            }
            int n2 = this.getSelectedIndex();
            this.selection.enableSelectionEvents(false);
            this.selection.removeAll();
            if (n >= 0) {
                this.selection.add(n);
            }
            this.selection.enableSelectionEvents(true);
            this.processSubfocusEvent(new VectorSubfocusEvent(this, 2, n));
        }
    }

    protected void scrollLeft() {
        if (this.firstVisible > 0) {
            --this.firstVisible;
            this.adjustScrollbar();
            this.repaint(100L);
        }
    }

    protected void scrollRight() {
        if ((this.lastClipped || this.lastVisible < this.tabInfo.size() - 1) && this.firstVisible < this.tabInfo.size() - 1) {
            ++this.firstVisible;
            this.adjustScrollbar();
            this.repaint(100L);
        }
    }

    protected boolean scrollCheck(int n, int n2) {
        if (this.needScroller) {
            if (this.leftArrowRect.contains(n, n2)) {
                this.scrollLeft();
                return true;
            }
            if (this.rightArrowRect.contains(n, n2)) {
                this.scrollRight();
                return true;
            }
        }
        return false;
    }

    void updateTabRects() {
        Graphics graphics = this.getGraphics();
        this.tabBarWidth = 0;
        if (graphics != null) {
            int n = 2;
            int n2 = 0;
            graphics.setFont(this.getFont());
            for (int i = 0; i < this.tabInfo.size(); ++i) {
                Dimension dimension;
                TabInfo tabInfo = (TabInfo)this.tabInfo.elementAt(i);
                int n3 = 0;
                if (i == this.getSelectedIndex()) {
                    n3 |= 4;
                    n3 |= this.focusState;
                }
                if (tabInfo.item != null) {
                    ItemPainter itemPainter = this.getPainter(i, n3);
                    dimension = itemPainter.getPreferredSize(tabInfo.item, graphics, n3, this);
                } else {
                    dimension = new Dimension(10, 10);
                }
                tabInfo.x = n;
                tabInfo.itemWidth = dimension.width;
                tabInfo.width = 2 + tabInfo.itemWidth + 2;
                tabInfo.itemHeight = dimension.height;
                int n4 = 4 + tabInfo.itemHeight + 2 - 3;
                n += tabInfo.width;
                if (n4 <= n2) continue;
                n2 = n4;
            }
            this.tabBarWidth = n + 2;
            this.tabBarHeight = n2;
        }
    }

    protected void adjustScrollbar() {
        this.tabBarTop = this.tabsOnTop ? this.border : this.getSize().height - this.border - this.tabBarHeight;
        this.xOffset = 0;
        this.needScroller = false;
        this.lastClipped = false;
        if (this.tabBarWidth <= this.getSize().width) {
            this.firstVisible = 0;
            this.lastVisible = this.tabInfo.size() - 1;
            return;
        }
        int n = this.getSize().width - 28 - 2 - this.itemMargins.right;
        int n2 = (this.tabBarHeight - 14) / 2;
        n2 = this.tabsOnTop ? (n2 += this.border) : (n2 += this.getSize().height - this.border - this.tabBarHeight);
        if (this.tabInfo.size() > 0) {
            if (this.firstVisible >= this.tabInfo.size()) {
                --this.firstVisible;
            }
            this.xOffset = ((TabInfo)this.tabInfo.elementAt((int)this.firstVisible)).x - 2;
            this.lastVisible = this.firstVisible;
            int n3 = this.firstVisible;
            while (n3 < this.tabInfo.size()) {
                TabInfo tabInfo = (TabInfo)this.tabInfo.elementAt(n3);
                this.lastVisible = n3;
                if (tabInfo.x - this.xOffset + tabInfo.width > n - 2 - this.itemMargins.right) {
                    this.lastClipped = true;
                    this.needScroller = true;
                    break;
                }
                this.lastVisible = n3++;
            }
        }
        if (this.firstVisible != 0) {
            this.needScroller = true;
        }
        if (this.needScroller) {
            this.leftArrowRect = new Rectangle(n, n2, 14, 14);
            this.rightArrowRect = new Rectangle(n + 14 + 1, n2, 14, 14);
        }
    }

    ItemPainter getPainter(int n, int n2) {
        return this.viewManager != null ? this.viewManager.getPainter(n, ((TabInfo)this.tabInfo.elementAt((int)n)).item, n2) : this.defaultPainter;
    }

    public Insets insets() {
        this.updateTabRects();
        if (this.tabsOnTop) {
            return new Insets(this.tabBarHeight + this.border, 2, this.clientBordered ? 2 : 0, 2);
        }
        return new Insets(this.clientBordered ? 2 : 0, 2, this.tabBarHeight + this.border, 2);
    }

    public Dimension getPreferredSize() {
        Insets insets = this.insets();
        return new Dimension(this.tabBarWidth, insets.top + insets.bottom);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.doLayout();
        this.repaint(100L);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint(100L);
    }

    public void doLayout() {
        super.doLayout();
        this.updateTabRects();
        this.adjustScrollbar();
    }

    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            return;
        }
        if (rectangle.width <= 0 || rectangle.height <= 0 || this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.texture != null) {
            if (this.tabsOnTop) {
                ImageTexture.texture(this.texture, graphics, 2, this.tabBarHeight, this.getSize().width - 2, this.getSize().height - 2);
            } else {
                ImageTexture.texture(this.texture, graphics, 2, 2, this.getSize().width - 2, this.getSize().height - this.tabBarHeight - 2);
            }
        } else if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.paintBorderLines(graphics);
        if (this.tabInfo.size() > 0) {
            if (rectangle.y < this.tabBarTop + this.tabBarHeight && rectangle.y + rectangle.height > this.tabBarTop) {
                TabInfo tabInfo;
                int n = this.hitTestX(rectangle.x);
                int n2 = this.hitTestX(rectangle.x + rectangle.width - 1);
                if (n == -1) {
                    tabInfo = (TabInfo)this.tabInfo.elementAt(this.firstVisible);
                    if (rectangle.x + this.xOffset < tabInfo.x) {
                        n = this.firstVisible;
                    }
                }
                if (n2 == -1) {
                    try {
                        tabInfo = (TabInfo)this.tabInfo.elementAt(this.lastVisible);
                        if (rectangle.x + rectangle.width + this.xOffset > tabInfo.x + tabInfo.width) {
                            n2 = this.lastVisible;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n != -1 && n2 != -1) {
                    for (int i = n; i <= n2; ++i) {
                        this.paintTab(graphics, i);
                    }
                }
            }
            if (this.needScroller) {
                this.paintScrollArrows(graphics);
            }
        }
    }

    void paintBorderLines(Graphics graphics) {
        int n = 0;
        int n2 = this.getSize().width - 1;
        int n3 = 0;
        int n4 = this.getSize().height - 1;
        int n5 = n;
        if (this.tabInfo.size() > 0) {
            try {
                TabInfo tabInfo = (TabInfo)this.tabInfo.elementAt(this.lastVisible);
                n5 = tabInfo.x + tabInfo.width - 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.tabsOnTop) {
            n3 = this.border + this.tabBarHeight - 2;
            if (this.clientBordered) {
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(n, n3, n, n4 - 1);
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(n, n4, n2, n4);
                graphics.drawLine(n2, n3, n2, n4);
                if (this.thickBorder) {
                    graphics.setColor(SystemColor.controlHighlight);
                    graphics.drawLine(n + 1, n3 + 1, n + 1, n4 - 2);
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(n + 1, n4 - 1, n2 - 2, n4 - 1);
                    graphics.drawLine(n2 - 1, n3 + 1, n2 - 1, n4 - 1);
                }
            }
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n, n3, n + 2, n3);
            graphics.drawLine(n5, n3, n2 - 1, n3);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(n + 1, n3 + 1, n + 2 - 1, n3 + 1);
            graphics.drawLine(n5 + 1, n3 + 1, n2 - 2, n3 + 1);
        } else {
            n4 = this.getSize().height - this.border - this.tabBarHeight + 1;
            if (this.clientBordered) {
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(n, n3, n2 - 1, n3);
                graphics.drawLine(n, n3, n, n4 - 1);
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(n2, n3, n2, n4);
                if (this.thickBorder) {
                    graphics.setColor(SystemColor.controlHighlight);
                    graphics.drawLine(n + 1, n3 + 1, n2 - 2, n3 + 1);
                    graphics.drawLine(n + 1, n3 + 1, n + 1, n4 - 2);
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(n2 - 1, n3 + 1, n2 - 1, n4 - 1);
                }
            }
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(n, n4, n + 2, n4);
            graphics.drawLine(n5, n4, n2, n4);
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n + 1, n4 - 1, n + 2 - 1, n4 - 1);
            graphics.drawLine(n5 + 1, n4 - 1, n2 - 2, n4 - 1);
        }
    }

    public void repaintTab(int n) {
        if (n == -1 || n > this.tabInfo.size() - 1) {
            return;
        }
        TabInfo tabInfo = (TabInfo)this.tabInfo.elementAt(n);
        this.repaint(100L, tabInfo.x - this.xOffset, this.tabBarTop, tabInfo.width, this.tabBarHeight);
    }

    private void paintTab(Graphics graphics, int n) {
        if (this.tabsOnTop) {
            this.paintTopTab(graphics, n);
        } else {
            this.paintBottomTab(graphics, n);
        }
    }

    private void paintTopTab(Graphics graphics, int n) {
        boolean bl;
        TabInfo tabInfo = (TabInfo)this.tabInfo.elementAt(n);
        int n2 = this.getSelectedIndex();
        if (n2 == -1) {
            n2 = -2;
        }
        boolean bl2 = bl = n == n2;
        if (this.model.getCount() == 1) {
            n2 = -2;
        }
        int n3 = 0;
        if (this.texture != null) {
            ImageTexture.texture(this.texture, graphics, tabInfo.x - this.xOffset + 2, this.tabBarTop + 2, tabInfo.width - 2 - 2, this.tabBarHeight);
        } else if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(tabInfo.x - this.xOffset, this.tabBarTop, tabInfo.width, this.tabBarHeight);
        }
        int n4 = tabInfo.x - this.xOffset;
        int n5 = n4 + tabInfo.width - 1;
        int n6 = this.border + 2;
        int n7 = this.border + this.tabBarHeight - 2;
        if (bl) {
            n6 -= 2;
        }
        ItemPainter itemPainter = null;
        if (tabInfo.item != null) {
            itemPainter = this.getPainter(n, n3);
        }
        Font font = this.getFont();
        Font font2 = this.getFont();
        if (bl) {
            n3 |= 4;
            n3 |= this.focusState;
            graphics.setFont(font2);
        } else {
            graphics.setFont(font);
        }
        Rectangle rectangle = new Rectangle(n4 + 2, n6 + 2 - 2, tabInfo.itemWidth, tabInfo.itemHeight);
        if (!this.isEnabled()) {
            n3 |= 1;
        }
        n3 |= n == this.rollover ? 64 : 0;
        graphics.setColor(this.getBackground());
        if (itemPainter != null) {
            itemPainter.paint(tabInfo.item, graphics, rectangle, n3, this);
        }
        if (n == n2 + 1) {
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(n4, n6 + 1 - 2, n4 + 1, n6 + 1 + 1 - 2);
            graphics.drawLine(n4 + 1, n6 + 1 + 2 - 2, n4 + 1, n7);
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n4, n6 + 2 - 2, n4 + 1 - 1, n6 + 1 + 2 - 2);
            graphics.drawLine(n4 + 1 - 1, n6 + 1 + 3 - 2, n4 + 1 - 1, n7);
        } else if (n != n2 || n == 0) {
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n4, n6 + 1 + 1, n4, n7);
            graphics.drawLine(n4 + 1, n6 + 1, n4 + 1, n6 + 1);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(n4 + 1, n6 + 1 + 2, n4 + 1, n7);
            graphics.drawLine(n4 + 1, n6 + 1 + 1, n4 + 1 + 1, n6 + 1);
        }
        int n8 = 0;
        int n9 = 0;
        if (n == n2) {
            if (n == 0) {
                n8 = 2;
            }
            if (n == this.model.getCount() - 1) {
                n9 = 2;
            }
        } else if (n >= 0) {
            n8 = 2;
            n9 = 2;
        }
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n4 + n8, n6, n5 - n9, n6);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(n4 + n8, n6 + 1, n5 - n9, n6 + 1);
        if (n == n2 - 1) {
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n5 - 1, n6 + 1 + 1 - 2, n5 - 1, n7);
            graphics.drawLine(n5 - 1 + 1, n6 + 1 - 2, n5, n6 + 1 - 2);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(n5 - 1 + 1, n6 + 1 + 2 - 2, n5 - 1 + 1, n7);
            graphics.drawLine(n5 - 1 + 1, n6 + 1 + 1, n5 + 1, n6 + 1 - 2);
        } else if (n != n2 || n == this.model.getCount() - 1) {
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(n5 - 1, n6 + 1, n5, n6 + 1 + 1);
            graphics.drawLine(n5, n6 + 1 + 2, n5, n7);
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n5 - 1, n6 + 2, n5 - 1, n6 + 1 + 2);
            graphics.drawLine(n5 - 1, n6 + 1 + 3, n5 - 1, n7);
        }
        if (!bl) {
            n8 = 0;
            n9 = 0;
            if (n == n2 - 1) {
                n9 = 2;
            } else if (n == n2 + 1) {
                n8 = 2;
            }
            int n10 = this.border + this.tabBarHeight - 2;
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n4 + n8, n10, n5 - n9, n10);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(n4 + n8, n10 + 1, n5 - n9, n10 + 1);
        }
    }

    private void paintBottomTab(Graphics graphics, int n) {
        int n2;
        TabInfo tabInfo = (TabInfo)this.tabInfo.elementAt(n);
        boolean bl = n == this.getSelectedIndex();
        int n3 = 0;
        if (this.texture != null) {
            ImageTexture.texture(this.texture, graphics, tabInfo.x - this.xOffset + 2, this.tabBarTop, tabInfo.width - 2 - 2, this.tabBarHeight - 2);
        } else if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(tabInfo.x - this.xOffset, this.tabBarTop, tabInfo.width, this.tabBarHeight);
        }
        int n4 = tabInfo.x - this.xOffset;
        int n5 = n4 + tabInfo.width - 1;
        int n6 = this.getSize().height - this.border - this.tabBarHeight + 2 - 1;
        int n7 = this.getSize().height - this.border - (bl ? 0 : 2) - 1;
        ItemPainter itemPainter = null;
        if (tabInfo.item != null) {
            itemPainter = this.getPainter(n, n3);
        }
        Font font = this.getFont();
        Font font2 = this.getFont();
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n5, n6, n5, n7 - 1 - 1);
        graphics.drawLine(n5, n7 - 1 - 1, n5 - 1, n7 - 1);
        graphics.drawLine(n5 - 1 - 1, n7, n4 + 1 + 1, n7);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n5 - 1, n6, n5 - 1, n7 - 1 - 1);
        graphics.drawLine(n5 - 1, n7 - 2 - 1, n5 - 1 - 1, n7 - 2);
        graphics.drawLine(n5 - 1 - 1, n7 - 1, n4 + 1, n7 - 1);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n4 + 1, n7 - 1, n4, n7 - 1 - 1);
        graphics.drawLine(n4, n7 - 1 - 1, n4, n6);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(n4 + 1, n7 - 2, n4 + 1, n7 - 2 - 1);
        graphics.drawLine(n4 + 1, n7 - 2 - 1, n4 + 1, n6);
        if (bl) {
            n3 |= 4;
            n3 |= this.focusState;
            graphics.setFont(font2);
            n2 = this.getSize().height - this.tabBarHeight - this.border;
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n4, n2, n4, n2);
            graphics.drawLine(n5 - 1, n2, n5, n2);
        } else {
            n2 = this.getSize().height - this.tabBarHeight - this.border;
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(n4, n2 + 1, n5, n2 + 1);
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n4, n2, n5, n2);
            graphics.setFont(font);
        }
        Rectangle rectangle = new Rectangle(n4 + 2, n7 - 2 - tabInfo.itemHeight + 1, tabInfo.itemWidth, tabInfo.itemHeight);
        if (!this.isEnabled()) {
            n3 |= 1;
        }
        n3 |= n == this.rollover ? 64 : 0;
        graphics.setColor(this.getBackground());
        if (tabInfo.item != null) {
            itemPainter.paint(tabInfo.item, graphics, rectangle, n3, this);
        }
    }

    private void paintScrollArrows(Graphics graphics) {
        if (this.lastClipped) {
            int n;
            int n2 = 0;
            int n3 = this.tabBarTop;
            int n4 = this.tabBarTop + this.tabBarHeight - 1;
            int n5 = this.leftArrowRect.x - 2 - this.itemMargins.left + 1;
            int n6 = this.getSize().width - 1;
            graphics.setColor(this.getBackground());
            graphics.fillRect(n5, n3, n6 - n5 + 1, this.tabBarHeight);
            if (this.tabsOnTop) {
                n2 = this.border + this.tabBarHeight - 2;
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(n5, n2, n6, n2);
                graphics.setColor(SystemColor.controlHighlight);
                graphics.drawLine(n5, n2 + 1, n6, n2 + 1);
                if (this.clientBordered) {
                    graphics.setColor(SystemColor.controlDkShadow);
                    graphics.drawLine(n6, n2, n6, n2 + 1);
                    if (this.thickBorder) {
                        graphics.setColor(SystemColor.controlShadow);
                        graphics.drawLine(n6 - 1, n2 + 1, n6 - 1, n2 + 1);
                    }
                }
            } else {
                n2 = this.getSize().height - this.tabBarHeight - this.border;
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(n5, n2 + 1, n6, n2 + 1);
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine(n5, n2, n6, n2);
                if (this.clientBordered) {
                    graphics.setColor(SystemColor.controlDkShadow);
                    graphics.drawLine(n6, n2, n6, n2);
                }
            }
            if ((n = this.getSelectedIndex()) == -1 || n != this.hitTestX(n5)) {
                if (this.tabsOnTop) {
                    n3 += 2;
                } else {
                    n4 -= 2;
                }
            }
            graphics.setColor(SystemColor.controlShadow);
            int n7 = 0;
            int n8 = 1;
            int n9 = 0;
            int n10 = n4 - n3;
            int[] nArray = new int[n10];
            int[] nArray2 = new int[n10];
            int n11 = 0;
            for (int i = n3; i < n4; ++i) {
                nArray[n11] = n5 + n7;
                nArray2[n11] = i;
                ++n11;
                if (n9 == 1) {
                    n9 = 0;
                    if ((n7 += n8) == 2) {
                        n8 = -1;
                        continue;
                    }
                    if (n7 != 0) continue;
                    n8 = 1;
                    continue;
                }
                ++n9;
            }
            graphics.drawPolyline(nArray, nArray2, n10);
        }
        this.paintScrollArrow(graphics, true);
        this.paintScrollArrow(graphics, false);
    }

    private void paintScrollArrow(Graphics graphics, boolean bl) {
        Rectangle rectangle = bl ? this.leftArrowRect : this.rightArrowRect;
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 2);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        if (bl) {
            if (this.firstVisible > 0) {
                graphics.setColor(SystemColor.controlDkShadow);
            } else {
                graphics.setColor(SystemColor.controlShadow);
            }
            graphics.drawLine(rectangle.x + rectangle.width / 2 - 1, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width / 2 - 1, rectangle.y + rectangle.height / 2);
            graphics.drawLine(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 - 1, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + 1);
            graphics.drawLine(rectangle.x + rectangle.width / 2 + 1, rectangle.y + rectangle.height / 2 - 2, rectangle.x + rectangle.width / 2 + 1, rectangle.y + rectangle.height / 2 + 2);
        } else {
            if (this.lastClipped) {
                graphics.setColor(SystemColor.controlDkShadow);
            } else {
                graphics.setColor(SystemColor.controlShadow);
            }
            graphics.drawLine(rectangle.x + rectangle.width / 2 + 1, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width / 2 + 1, rectangle.y + rectangle.height / 2);
            graphics.drawLine(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 - 1, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + 1);
            graphics.drawLine(rectangle.x + rectangle.width / 2 - 1, rectangle.y + rectangle.height / 2 - 2, rectangle.x + rectangle.width / 2 - 1, rectangle.y + rectangle.height / 2 + 2);
        }
    }

    public void setDoubleBuffer(boolean bl) {
        this.setDoubleBuffered(bl);
    }

    public boolean isDoubleBuffer() {
        return this.isDoubleBuffered();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(4);
        if (this.model instanceof Serializable) {
            hashtable.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hashtable.put("v", this.viewManager);
        }
        if (this.selection instanceof Serializable) {
            hashtable.put("s", this.selection);
        }
        if (this.defaultPainter instanceof Serializable) {
            hashtable.put("p", this.defaultPainter);
        }
        objectOutputStream.writeObject(hashtable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v = hashtable.get("m");
        if (v instanceof VectorModel) {
            this.model = (VectorModel)v;
        }
        if (this.model instanceof WritableVectorModel) {
            this.writeModel = (WritableVectorModel)this.model;
        }
        if ((v = hashtable.get("v")) instanceof VectorViewManager) {
            this.viewManager = (VectorViewManager)v;
        }
        if ((v = hashtable.get("s")) instanceof WritableVectorSelection) {
            this.selection = (WritableVectorSelection)v;
        }
        if ((v = hashtable.get("p")) instanceof ItemPainter) {
            this.defaultPainter = (ItemPainter)v;
        }
    }
}

