/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import com.borland.jbcl.model.WritableVectorModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class BasicVectorContainer
implements WritableVectorModel,
Serializable {
    private static final long serialVersionUID = 200L;
    private transient Vector array;
    private boolean variableSize = true;
    private transient EventMulticaster modelListeners = new EventMulticaster();
    private boolean events = true;

    public BasicVectorContainer() {
        this.array = new Vector();
    }

    public BasicVectorContainer(int n) {
        this.array = new Vector(n);
    }

    public BasicVectorContainer(int n, Object object) {
        this.array = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.array.addElement(object);
        }
    }

    public BasicVectorContainer(Object[] objectArray) {
        this.array = new Vector();
        Object[] objectArray2 = objectArray;
        synchronized (objectArray2) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                this.array.addElement(objectArray[i]);
            }
        }
    }

    public Object[] getItems() {
        Object[] objectArray = new Object[this.array.size()];
        this.array.copyInto(objectArray);
        return objectArray;
    }

    public void setItems(Object[] objectArray) {
        this.array = new Vector();
        Object[] objectArray2 = objectArray;
        synchronized (objectArray2) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                this.array.addElement(objectArray[i]);
            }
        }
        this.processModelEvent(new VectorModelEvent(this, 2));
    }

    public Object get(int n) {
        if (n >= 0 && this.array.size() > n) {
            return this.array.elementAt(n);
        }
        return null;
    }

    public int getCount() {
        return this.array.size();
    }

    public int find(Object object) {
        return this.array.indexOf(object);
    }

    public void setCount(int n) {
        int n2 = this.array.size();
        if (!this.variableSize || n == n2) {
            return;
        }
        if (n > n2) {
            for (int i = n2; i < n; ++i) {
                this.array.addElement(null);
            }
        } else {
            for (int i = n2; i > n; --i) {
                this.array.removeElementAt(i - 1);
            }
        }
    }

    public void addModelListener(VectorModelListener vectorModelListener) {
        this.modelListeners.add(vectorModelListener);
    }

    public void removeModelListener(VectorModelListener vectorModelListener) {
        this.modelListeners.remove(vectorModelListener);
    }

    public boolean canSet(int n, boolean bl) {
        return n < this.array.size();
    }

    public void set(int n, Object object) {
        this.array.setElementAt(object, n);
        this.processModelEvent(new VectorModelEvent(this, 17, n));
    }

    public void touched(int n) {
        if (n < this.array.size()) {
            this.processModelEvent(new VectorModelEvent(this, 33, n));
        }
    }

    public boolean isVariableSize() {
        return this.variableSize;
    }

    public void setVariableSize(boolean bl) {
        this.variableSize = bl;
    }

    public void addItem(Object object) {
        if (!this.variableSize) {
            return;
        }
        this.array.addElement(object);
        this.processModelEvent(new VectorModelEvent(this, 18, this.array.size()));
    }

    public void addItem(int n, Object object) {
        if (!this.variableSize) {
            return;
        }
        this.array.insertElementAt(object, n);
        this.processModelEvent(new VectorModelEvent(this, 18, n));
    }

    public void remove(int n) {
        if (!this.variableSize) {
            return;
        }
        this.array.removeElementAt(n);
        this.processModelEvent(new VectorModelEvent(this, 34, n));
    }

    public void removeAll() {
        if (!this.variableSize) {
            return;
        }
        if (this.array.size() > 0) {
            this.array.removeAllElements();
            this.processModelEvent(new VectorModelEvent(this, 2));
        }
    }

    public void enableModelEvents(boolean bl) {
        if (this.events != bl) {
            this.events = bl;
            if (bl) {
                this.processModelEvent(new VectorModelEvent(this, 2));
            }
        }
    }

    protected void processModelEvent(VectorModelEvent vectorModelEvent) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(vectorModelEvent);
        }
    }

    public Enumeration begin() {
        return this.array.elements();
    }

    public Vector getVector() {
        return this.array;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Vector vector = new Vector();
        for (int i = 0; i < this.array.size(); ++i) {
            if (!(this.array.elementAt(i) instanceof Serializable)) continue;
            vector.addElement(this.array.elementAt(i));
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.array = (Vector)objectInputStream.readObject();
    }
}

