/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.PlaceHolder;
import com.borland.jbcl.model.BasicVectorContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorSelectionEvent;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.TabsetView;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class TabsetPanel
extends TabsetView
implements Serializable {
    private Vector pageInfo = new Vector();
    CardLayout cardLayout = new CardLayout();
    Insets margins = new Insets(4, 4, 4, 4);
    String textureName;

    public TabsetPanel() {
        super.setModel(new BasicVectorContainer());
        TextItemPainter textItemPainter = new TextItemPainter(33, new Insets(1, 1, 1, 1));
        super.setViewManager(new BasicViewManager(new FocusableItemPainter(textItemPainter)));
        this.setClientBordered(true);
        super.setLayout(this.cardLayout);
        super.addImpl(new JPanel(), "BLANK", -1);
        super.setBackground(UIManager.getColor("TabbedPane.tabBackground"));
        super.setForeground(UIManager.getColor("TabbedPane.tabForeground"));
    }

    public void updateUI() {
        super.setBackground(UIManager.getColor("TabbedPane.tabBackground"));
        super.setForeground(UIManager.getColor("TabbedPane.tabForeground"));
    }

    public void setSelectedPage(Component component) {
        int n = this.pageInfo.indexOf(component);
        if (n != -1) {
            this.setSelectedIndex(n);
        }
    }

    public Component getSelectedPage() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        Component component = (Component)this.pageInfo.elementAt(n);
        if (component instanceof PlaceHolder) {
            return null;
        }
        return component;
    }

    public void removePage(Component component) {
        int n = this.pageInfo.indexOf(component);
        if (n != -1) {
            this.removeTab((String)this.model.get(n));
        }
    }

    public void setLabels(String[] stringArray) {
        super.setLabels(stringArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public void addTab(Object object) {
        super.addTab(object);
    }

    public void removeTab(String string) {
        if (this.isReadOnly()) {
            return;
        }
        int n = this.writeModel.find(string);
        if (n != -1) {
            Component component = (Component)this.pageInfo.elementAt(n);
            this.pageInfo.removeElementAt(n);
            if (!(component instanceof PlaceHolder)) {
                super.remove(component);
            }
            super.removeTab(string);
        }
    }

    public void addTab(int n, String string) {
        if (this.isReadOnly()) {
            return;
        }
        if (n == -1) {
            this.pageInfo.addElement(new PlaceHolder());
        } else {
            this.pageInfo.insertElementAt(new PlaceHolder(), n);
        }
        super.addTab(n, string);
    }

    public void addImpl(Component component, Object object, int n) {
        this.writeModel.enableModelEvents(false);
        if (object != null) {
            int n2 = this.model.find(object);
            if (n2 != -1) {
                Component component2 = (Component)this.pageInfo.elementAt(n2);
                if (!(component2 instanceof PlaceHolder)) {
                    super.remove(component2);
                }
                this.pageInfo.setElementAt(component, n2);
            } else {
                this.pageInfo.addElement(component);
                super.addTab(object);
            }
        } else {
            this.pageInfo.addElement(component);
            object = component.getName();
            super.addTab(object);
        }
        super.addImpl(component, object, n);
        this.writeModel.enableModelEvents(true);
        String string = this.getSelectedTab();
        if (string != null && string.equals((String)object)) {
            this.cardLayout.show(this, string);
        }
    }

    public void remove(Component component) {
        int n = this.pageInfo.indexOf(component);
        if (n != -1) {
            this.pageInfo.setElementAt(new PlaceHolder(), n);
        }
        super.remove(component);
    }

    public void removeAll() {
        if (this.isReadOnly()) {
            return;
        }
        for (int i = 0; i < this.pageInfo.size(); ++i) {
            if (this.pageInfo.elementAt(i) instanceof PlaceHolder) continue;
            super.remove((Component)this.pageInfo.elementAt(i));
        }
        this.pageInfo.removeAllElements();
        this.writeModel.removeAll();
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.left += this.margins.left;
        insets.top += this.margins.top;
        insets.right += this.margins.right;
        insets.bottom += this.margins.bottom;
        return insets;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(Insets insets) {
        this.margins = insets == null ? new Insets(0, 0, 0, 0) : insets;
        this.invalidate();
        this.repaint(100L);
    }

    public void selectionChanged(VectorSelectionEvent vectorSelectionEvent) {
        super.selectionChanged(vectorSelectionEvent);
        int n = this.getSelectedIndex();
        if (n != -1 && !(this.pageInfo.elementAt(n) instanceof PlaceHolder)) {
            String string = this.model.get(n).toString();
            this.cardLayout.show(this, string);
            return;
        }
        this.cardLayout.show(this, "BLANK");
    }

    public void modelContentChanged(VectorModelEvent vectorModelEvent) {
        switch (vectorModelEvent.getChange()) {
            case 1: 
            case 17: 
            case 33: {
                this.updateTabInfo();
            }
        }
    }

    protected void updateTabInfo() {
        int n;
        int n2;
        if (this.pageInfo == null) {
            return;
        }
        Component[] componentArray = new Component[this.pageInfo.size()];
        for (n2 = 0; n2 < this.pageInfo.size(); ++n2) {
            componentArray[n2] = (Component)this.pageInfo.elementAt(n2);
        }
        n2 = this.getSelectedIndex();
        for (n = 0; n < this.model.getCount(); ++n) {
            if (n < componentArray.length) {
                if (componentArray[n] instanceof PlaceHolder) continue;
                this.cardLayout.removeLayoutComponent(componentArray[n]);
                this.cardLayout.addLayoutComponent(componentArray[n], this.model.get(n));
                if (n2 != n) continue;
                this.cardLayout.show(this, (String)this.model.get(n));
                continue;
            }
            this.pageInfo.addElement(new PlaceHolder());
        }
        for (n = componentArray.length - 1; n >= this.model.getCount(); --n) {
            this.pageInfo.removeElementAt(n);
            if (componentArray[n] instanceof PlaceHolder) continue;
            super.remove(componentArray[n]);
        }
        super.updateTabInfo();
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(100, 100);
        if (!this.pageInfo.isEmpty()) {
            dimension = this.cardLayout.preferredLayoutSize(this);
            dimension.width = Math.max(dimension.width, super.getPreferredSize().width);
        }
        return dimension;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.getSelectedPage() != null) {
            this.getSelectedPage().setEnabled(bl);
        }
    }
}

