/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jb.util;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.ExceptionDispatch;
import com.borland.jb.util.VetoException;
import com.borland.jb.util.VetoableDispatch;
import java.util.EventListener;

public class EventMulticaster {
    protected transient EventListener[] listeners;

    public int getListenerCount() {
        return this.listeners != null ? this.listeners.length : 0;
    }

    public static final EventMulticaster remove(EventMulticaster eventMulticaster, EventListener eventListener) {
        if (eventMulticaster != null) {
            eventMulticaster.remove(eventListener);
            if (!eventMulticaster.hasListeners()) {
                eventMulticaster = null;
            }
        }
        return eventMulticaster;
    }

    public static final EventMulticaster add(EventMulticaster eventMulticaster, EventListener eventListener) {
        if (eventMulticaster == null) {
            eventMulticaster = new EventMulticaster();
        }
        eventMulticaster.add(eventListener);
        return eventMulticaster;
    }

    public final synchronized void remove(EventListener eventListener) {
        int n = this.find(eventListener);
        if (n > -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                EventListener[] eventListenerArray = new EventListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, eventListenerArray, 0, n);
                if (n < eventListenerArray.length) {
                    System.arraycopy(this.listeners, n + 1, eventListenerArray, n, eventListenerArray.length - n);
                }
                this.listeners = eventListenerArray;
            }
        }
    }

    public final synchronized void add(EventListener eventListener) {
        if (this.find(eventListener) < 0) {
            EventListener[] eventListenerArray;
            if (this.listeners == null) {
                eventListenerArray = new EventListener[1];
            } else {
                eventListenerArray = new EventListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, eventListenerArray, 0, this.listeners.length);
            }
            eventListenerArray[eventListenerArray.length - 1] = eventListener;
            this.listeners = eventListenerArray;
        }
    }

    public int find(EventListener eventListener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != eventListener) continue;
                return i;
            }
        }
        return -1;
    }

    public final void exceptionDispatch(ExceptionDispatch exceptionDispatch) throws Exception {
        EventListener[] eventListenerArray = this.listeners;
        if (eventListenerArray != null) {
            int n = eventListenerArray.length;
            for (int i = 0; i < n; ++i) {
                exceptionDispatch.exceptionDispatch(eventListenerArray[i]);
            }
        }
    }

    public final boolean vetoableDispatch(VetoableDispatch vetoableDispatch) {
        EventListener[] eventListenerArray = this.listeners;
        try {
            if (eventListenerArray != null) {
                int n = eventListenerArray.length;
                for (int i = 0; i < n; ++i) {
                    vetoableDispatch.vetoableDispatch(eventListenerArray[i]);
                }
            }
        }
        catch (VetoException vetoException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public final void dispatch(DispatchableEvent dispatchableEvent) {
        EventListener[] eventListenerArray = this.listeners;
        if (eventListenerArray != null) {
            int n = eventListenerArray.length;
            for (int i = 0; i < n; ++i) {
                dispatchableEvent.dispatch(eventListenerArray[i]);
            }
        }
    }

    public final boolean hasListeners() {
        return this.listeners != null;
    }
}

