/*
 * Decompiled with CFR 0.152.
 */
package com.bai.htmlview;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class BaiHTMLEditorKit
extends HTMLEditorKit {
    public static final int JUMP = 0;
    public static final int MOVE = 1;
    LinkController myController = new LinkController();

    public void install(JEditorPane c) {
        c.addMouseListener(this.myController);
        c.addMouseMotionListener(this.myController);
    }

    public static class LinkController
    extends MouseInputAdapter
    implements Serializable {
        URL currentUrl = null;

        public void mouseClicked(MouseEvent e) {
            Point pt;
            int pos;
            JEditorPane editor = (JEditorPane)e.getSource();
            if (!editor.isEditable() && (pos = editor.viewToModel(pt = new Point(e.getX(), e.getY()))) >= 0) {
                this.activateLink(pos, editor, 0);
            }
        }

        public void mouseMoved(MouseEvent e) {
            Point pt;
            int pos;
            JEditorPane editor = (JEditorPane)e.getSource();
            if (!editor.isEditable() && (pos = editor.viewToModel(pt = new Point(e.getX(), e.getY()))) >= 0) {
                this.activateLink(pos, editor, 1);
            }
        }

        protected void activateLink(int pos, JEditorPane html, int type) {
            Document doc = html.getDocument();
            if (doc instanceof HTMLDocument) {
                HTMLDocument hdoc = (HTMLDocument)doc;
                Element e = hdoc.getCharacterElement(pos);
                AttributeSet a = e.getAttributes();
                AttributeSet anchor = (AttributeSet)a.getAttribute(HTML.Tag.A);
                String href = anchor != null ? (String)anchor.getAttribute(HTML.Attribute.HREF) : null;
                boolean shouldExit = false;
                HyperlinkEvent linkEvent = null;
                if (href != null) {
                    URL u;
                    try {
                        u = new URL(hdoc.getBase(), href);
                    }
                    catch (MalformedURLException m) {
                        u = null;
                    }
                    if (type == 1 && !u.equals(this.currentUrl)) {
                        linkEvent = new HyperlinkEvent(html, HyperlinkEvent.EventType.ENTERED, u, href);
                        this.currentUrl = u;
                    } else if (type == 0) {
                        linkEvent = new HyperlinkEvent(html, HyperlinkEvent.EventType.ACTIVATED, u, href);
                        shouldExit = true;
                    } else {
                        return;
                    }
                    html.fireHyperlinkUpdate(linkEvent);
                } else if (this.currentUrl != null) {
                    shouldExit = true;
                }
                if (shouldExit) {
                    linkEvent = new HyperlinkEvent(html, HyperlinkEvent.EventType.EXITED, this.currentUrl, null);
                    html.fireHyperlinkUpdate(linkEvent);
                    this.currentUrl = null;
                }
            }
        }
    }
}

