/* Program to use settings from Irish Setter to configure a Motorola BitSUFR Pro T/A */
/* Just setting variables so it won't print to a file or copy the variable name instead of the information */
SaveSet = ">w"
ResetTA= ">z"
port = ''
portNum = ''
IrishName = ''
ATCommand = "AT"
main:                   /* Now the program starts! */
PARSE ARG IrishName
/*  After getting the filename from the commandline, we open the file & copy what is in it. */
rc = LineIn(IrishName,1,0)
port = LineIn(IrishName)
portNum = strip(port, 't', ':')
FSpid = LineIn(IrishName)
SSpid = LineIn(IrishName)
DATASpid = LineIn(IrishName)
FDirNum = LineIn(IrishName)
SDirNum = LineIn(IrishName)
DNDATANum = LineIn(IrishName)
/*                              The following three variables aren't normally used.                     */
/*                              They are included here in case you need them.                           */
/*    Most often the TEI are set automatically after the T/A has been set with the other variables.  */
TEIFNum = LineIn(IrishName)
TEISNum = LineIn(IrishName)
TEIDNum = LineIn(IrishName)
SwitchType = LineIn(IrishName)
SSwitchType = LineIn(IrishName)
/* Here we have the variables converted to the 'AT' command that will be used. */
NFSpid = "AT *1!C6=" || FSpid
NSSpid = "AT *2!C6=" || SSpid
NDATASpid = "AT !C6=" || DATASpid
NFDirNum = "AT *1!N1=" || FDirNum
NSDirNum = "AT *2!N1=" || SDirNum
NDNDATANum = "AT !n1=" || DNDATANum
/* * * * * * * * * * * * * * *  ONLY use these variables when necessary! * * * * * * * * */
/*
NTEIFNum = "AT *1!D3=" || TEIFNum
NTEISNum = "AT *2!D3=" || TEISNum
NTEIDNum = "AT !D3=" || TEIDNum
p1.0 = "\"
p1.1 = "-"
p1.2 = "/"
p1.3 = "-"
p2 = 0
*/
/*    Here is where the information is uploaded to the T/A(commonly known as a 'cable modem').  */
NSwitchtype = "AT !C0=" || Switchtype
NSSwitchType = "AT !C1=" || SSwitchType
rc = stream(portNum, 'C', 'OPEN')
CALL FirstPOTS
CALL SecondPOTS
CALL DATAPOTS
CALL FirstSPID
CALL SecondSPID
CALL DATASPID
CALL DOSwitch
CALL DOSoft
CALL SAVEset
CALL RESet
return
FirstPOTS:
CALL LineOut portNum, NFDirNum
Info=''
DO  While Chars(port)
   Info= Info || CharIn(port)
   CALL CharOut , "1B"x || '[s Reading ' || p1.p2 || "1B"x || "[u"
   p2 = (p2+1) // 4
   end  /* end DO */
IF POS("OK", Info) <> 0 then
        DO SAY "ERROR! on first Directory number"
        exit
        end  /* end DO */
else
SAY Info
return
SecondPOTS:
CALL LineOut portNum, NSDirNum
Info=''
DO  While Chars(port)
   Info= Info || CharIn(port)
   CALL CharOut , "1B"x || '[s Reading ' || p1.p2 || "1B"x || "[u"
   p2 = (p2+1) // 4
   end  /* end DO */
IF POS("OK", Info) <> 0 then
        DO SAY "ERROR! on second Directory number"
        exit
        end
else
SAY Info
return
DATAPOTS:
CALL LineOut portNum, NDATASpid
Info=''
DO  While Chars(port)
   Info= Info || CharIn(port)
   CALL CharOut , "1B"x || '[s Reading ' || p1.p2 || "1B"x || "[u"
   p2 = (p2+1) // 4
   end  /* end DO */
IF POS("OK", Info) <> 0 then
        DO SAY "ERROR! on  DATA Directory number"
        exit
        end
else
SAY Info
return
FirstSPID:
CALL LineOut portNum, NFSpid
Info=''
DO  While Chars(port)
   Info= Info || CharIn(port)
   CALL CharOut , "1B"x || '[s Reading ' || p1.p2 || "1B"x || "[u"
   p2 = (p2+1) // 4
   end  /* end DO */
IF POS("OK", Info) <> 0 then
        DO SAY "ERROR! on first SPID number"
        exit
        end
else
SAY Info
return
SecondSPID:
CALL LineOut portNum, NSSpid
Info=''
DO  While Chars(port)
   Info= Info || CharIn(port)
   CALL CharOut , "1B"x || '[s Reading ' || p1.p2 || "1B"x || "[u"
   p2 = (p2+1) // 4
   end  /* end DO */
IF POS("OK", Info) <> 0 then
        DO SAY "ERROR! on second SPID number"
        exit
        end
else
SAY Info
return
DATASPID:
CALL LineOut portNum, NDNDATANum
Info=''
DO  While Chars(port)
   Info= Info || CharIn(port)
   CALL CharOut , "1B"x || '[s Reading ' || p1.p2 || "1B"x || "[u"
   p2 = (p2+1) // 4
   end  /* end DO */
IF POS("OK", Info) <> 0 then
        DO SAY "ERROR! on DATA SPID number"
        exit
        end
else
SAY Info
return
DOSwitch:
CALL LineOut portNum, NSwitchType
Info=''
DO  While Chars(port)
   Info= Info || CharIn(port)
   CALL CharOut , "1B"x || '[s Reading ' || p1.p2 || "1B"x || "[u"
   p2 = (p2+1) // 4
   end  /* end DO */
IF POS("OK", Info) <> 0 then
        DO SAY "ERROR! on Central Office Switch type."
        exit
        end
else
SAY Info
return
DOSoft:
CALL LineOut portNum, NSSwitchType
Info=''
DO  While Chars(port)
   Info= Info || CharIn(port)
   CALL CharOut , "1B"x || '[s Reading ' || p1.p2 || "1B"x || "[u"
   p2 = (p2+1) // 4
   end  /* end DO */
IF POS("OK", Info) <> 0 then
        DO SAY "ERROR! on Central Office Software version."
        exit
        end
else
SAY Info
return
/*  
CALL LineOut portNum, NTEIDNum
CALL LineOut portNum, NTEIFNum
CALL LineOut portNum, NTEISNum
*/
SAVEset:
CALL LineOut portNum, "AT " || SaveSet
Info=''
DO  While Chars(port)
   Info= Info || CharIn(port)
   CALL CharOut , "1B"x || '[s Reading ' || p1.p2 || "1B"x || "[u"
   p2 = (p2+1) // 4
   end  /* end DO */
IF POS("OK", Info) <> 0 then
        DO SAY "ERROR! on saving settings to non-volatile memory!"
        exit
        end
else
SAY Info
return
RESet:
CALL LineOut portNum, "AT " || ResetTA
Info=''
DO  While Chars(port)
   Info= Info || CharIn(port)
   CALL CharOut , "1B"x || '[s Reading ' || p1.p2 || "1B"x || "[u"
   p2 = (p2+1) // 4
   end  /* end DO */
IF POS("OK", Info) <> 0 then
        DO SAY "ERROR! on resetting T/A."
        exit
        end
else
SAY Info
return
exit

