/* REXX file to automate the HA5 => ZOC dialing dir conversion */

    /* REXX command file to convert HA5 to Telmate format */

    script = "         "
    log = "         "
    counter = 0

    infile = 'HA5DIR.IN'
    outfile = 'HA5DIR.OUT'

    /* Let's do the disclaimer stuff */
    'CLS'
    Say ''
    Say ''
    Say 'HA52ZOC'
    Say 'Armadillo Software'
    Say 'copyright 1995, Wm. Eric Brunsen, All rights reserved'
    Say 'Convert HA/5 dialing directory to ZOC'
    Say ''
    Say 'This program is available free of charge as long as'
    Say 'you agree to the following:'
    Say ''
    Say '   By using this program, you are agreeing to accept'
    Say '   all risk for use of this program.'
    Say ''
    Say '   This means that YOU and YOU ALONE are responsible for'
    Say '   any and all problems that may arise from use of this software.'
    Say ''
    Say 'Do you agree to these terms? (Y/N):'
    pull agree

    if agree <> 'Y'
        Then Exit

    Do while LINES(infile)
        counter = counter + 1
        junkline = LINEIN(infile)
        parse var junkline record.counter.1'.'record.counter.2 record.counter.3 record.counter.4 record.counter.5 record.counter.6 record.counter.7 record.counter.8 junk
    End

    record.0 = counter - 1

    do counter = 1 to record.0
        name = OVERLAY(record.counter.1,'',,46,' ')
        phone = STRIP(TRANSLATE(record.counter.2,' ','.'))
        phone = OVERLAY(phone,'',,21,' ')
        baud = OVERLAY(record.counter.3,'',,6,' ')
        parity = record.counter.5
        data = record.counter.6
        stops = record.counter.7
        emuType = record.counter.8


        select
            when LEFT(emuType,4) = 'ANSI'
                then emu = "                  "||'1'
            when LEFT(emuType,2) = 'VT'
                then emu = "                  "||'2'
            when LEFT(emuType,3) = 'TTY'
                then emu = "                  "||'3'
            otherwise
                emu = "                  "||'0'
        end

        call LINEOUT outFile, name||script||log||phone||baud||data||parity||stops||emu

    end
    call LINEOUT outfile,

    'HA52ZOC HA5DIR.OUT'
