/* Das Script liefert Informationen zur bergebenen Tabelle */

call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
call SysLoadFuncs

call RxFuncAdd 'DbRxLoadFuncs', CaTable, 'DbRxLoadFuncs' 
call DbRxLoadFuncs

parse arg Name

if length( Name )=0 then
do 
   say 'Dieses Script liefert Informationen zu einer Tabelle'
   say 'welche von CaTable verwaltet wird.'
   say 'Syntax:'
   say 'QueryDB.cmd Dateiname'
   exit
end /* do */

say 'CaTable Version 'DbRxVersion()


rc = SysFileTree( Name, 'Dir', 'FO' )
do i=1 to Dir.0
   ulCount = TestFile( Dir.i )
   if ulCount==0 then
   call SysFileDelete Dir.i
end /* do */

exit


TestFile:
procedure
parse arg name

ulCount = 1
say ''
say Name
rc = DbRxOpen( Name, 'hTable' )
if rc>0 then 
do 
   say 'Die Datei 'Name' ist warscheinlich keine Datenbanktatei'
   say DbRxGetErrorText( rc ) 'bei open'
   return rc
end /* do */

rc = DbRxQueryColDef( hTable, 'Def' )
if rc>0 then say DbRxGetErrorText( rc ) 'bei DbRxQueryColDef'
else say 'Spaltendefinition:' Def

rc = DbRxQueryComment( hTable, 'Comment' )
if rc>0 then say DbRxGetErrorText( rc ) 'bei DbQueryComment'
else say 'Kommentar:' Comment

rc = DbRxQueryUserVersion( hTable, 'Version' )
if rc>0 then say DbRxGetErrorText( rc ) 'bei DbRxQueryUserVersion'
else say 'Version:' Version

rc = DbRxStartRead( hTable, 'hRead', 'ulCount' )
if rc>0 then say DbRxGetErrorText( rc ) 'bei DbRxStartRead'
else 
do 
   say 'Anzahl der enthaltenen Datenstze:' ulCount
   rc = DbRxEndRead( hRead )
   if rc>0 then say DbRxGetErrorText( rc ) 'bei DbRxEndRead'
end /* do */

rc = DbRxClose( hTable );
if rc>0 then 
do 
   say DbRxGetErrorText( rc ) 'bei Close'
end /* do */
   call SysSleep 1

return ulCount

