/*
Program:         CIS2IPF
Date:            22-Jul-1994
Original Author: Craig Schneiderwent
                 [CompuServe: 74631,165]
                 [Internet: 74631.165@compuserve.com]
Purpose:         To reformat Golden CommPass message files with IPF tags.  The
                 output file can be compiled into an INF file.
Syntax:          Run without any parameters and the proper syntax will be shown.
Return Codes:    0 - Normal EOJ
                 1 - Syntax error
                 2 - Can't find input file
                     Output file exists and overwrite not specified
                 3 - Input OPEN error
                     Output OPEN error
                     Output SEEK error
                 9 - Input READ error
                     Output WRITE error
                     Input CLOSE error
                     Output CLOSE error
IPFC Notes:      In order to process the output from this program, you'll need the
                 IPF Compiler (IPFC) which is part of the IBM Toolkit.  You will
                 very likely see some warning messages when you compile the IPF
                 file this program produces:

                 <TestFile.IPF:298> 306: Missing panel text in head level tag

                 This is (as near as I can figure) the result of having headings
                 which are not followed by any text to be displayed.  The INF file
                 seems to be fine and the message is just a warning, so I didn't
                 worry much about it.

On the off-chance anyone cares: this program is public domain software.  Feel free to
use it, abuse it, or post it - just don't charge money for it.  Look at the code, who
would pay for this?

Given our litigious society...

DISCLAIMER
Users of this program must accept this disclaimer of warranty:

"This program is supplied as is.  The original author disclaims all
warranties, expressed or implied, including, without limitation,
the warranties of merchantability and of fitness for any purpose.
The original author assumes no liability for damages, direct or
consequential, which may result from the use of this program."

*/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

myName = 'CIS2IPF'
version = '1.03'
destinationFile = ''
switchAt = 0
quietMode = 0
overWriteOK = 0
newMsg = 0
okayToStart = 0
count = 0
breakLvl3Occurred = 0
linesWritten = 0

/*
These literals are used to determine if the current input line indicates
a break, or heading, line.
*/
breakLvl1 = '#: 0'
breakLvl2 = '#: '
breakLvl3 = 'Sb: '
breakLvl4 = 'Fm: '
announcementFlag = 'A'

/*
The length of the break indicator literals is used repetitively in a loop.  I
hoped to improve performance by only calculating it once.
*/
lenBreakLvl1 = Length(breakLvl1)
lenBreakLvl2 = Length(breakLvl2)
lenBreakLvl3 = Length(breakLvl3)
lenBreakLvl4 = Length(breakLvl4)

prevBreakLvl2Ind = 'XjUnKx'
prevBreakLvl3Ind = 'XjUnKx'

Select
  When Words(Arg(1)) = 0 Then
    Do
      Call ShowSyntax
      Call EndThisPlease 1
    End
  When (Translate(Word(Arg(1), 1) = '/H')) |,
       (Translate(Word(Arg(1), 1) = '/?')) |,
       (Translate(Word(Arg(1), 1) = '-H')) |,
       (Translate(Word(Arg(1), 1) = 'HELP')) |,
       (Translate(Word(Arg(1), 1) = '?')) Then
    Do
      Call ShowSyntax
      Call EndThisPlease 0
    End
  When Words(Arg(1)) > 0 Then NOP
  Otherwise
    Do
      Call ShowSyntax
      Call EndThisPlease 0
    End
End

/*
Make sure the source file exists.
*/
rc = CheckForFile( Word(Arg(1), 1) )
If rc = 0 Then
  sourceFile = fullPathName
Else
  Do
    Say myName':' Word(Arg(1), 1) 'does not exist'
    Call EndThisPlease 2
  End

/*
If the destination file isn't specified, create a destination file name
from the source file.  If it is specified, make sure it doesn't already
exist or that overwrite was specified.
*/
If Words(Arg(1)) > 1 Then
  Do
    Call GetSwitches Arg(1)
    If switchAt > 2 Then
      Call CheckArgForDestination Arg(1)
    Else
      Call MakeDestinationFromSource
  End
Else
  Call MakeDestinationFromSource

If quietMode Then
  NOP
Else
  Do
    Call SysCls
    pos = SysCurPos(1,0)
    Call ShowParms
  End

/*
Make a title for the IPF file from the source file name.
*/
reversedSource = Reverse(sourceFile)
Parse Var reversedSource . '.' reversedFileTitle '\' .
fileTitle = Reverse(reversedFileTitle)
Drop reversedSource reversedFileTitle

Call LoadSpecialSymbols

Call OpenFilesAndSuch

/*
This is the main processing loop.
*/
Do While Lines(sourceFile) > 0
  Call ProcessTheSource
End

Call CloseFilesAndSuch

Exit 0

GetSwitches:

i = 0
Do Until i = Words(Arg(1))
  i = i + 1
  Select
    When Translate(Word(Arg(1), i)) = '-W' Then
      Do
        overWriteOK = 1
        If switchAt = 0 Then
          switchAt = i
        Else
          If switchAt > i Then
            switchAt = i
          Else
            NOP
      End
    When Translate(Word(Arg(1), i)) = '-Q' Then
      Do
        quietMode = 1
        If switchAt = 0 Then
          switchAt = i
        Else
          If switchAt > i Then
            switchAt = i
          Else
            NOP
      End
    Otherwise NOP
  End
End

Return

MakeDestinationFromSource:

reversedArg = Reverse(fullPathName)
Parse Var reversedArg . '.' reversedFileName
destinationFile = Reverse(reversedFileName) || '.IPF'
rc = CheckForFile( destinationFile )
If (rc = 0 & overWriteOK) | rc = 1 Then
  NOP
Else
  Do
    Say myName':' destinationFile 'exists and overwrite was not specified'
    Call EndThisPlease 2
  End

Return

CheckArgForDestination:

rc = CheckForFile( Word(Arg(1), (switchAt - 1)) )
Select
  When rc = 0 & overWriteOK Then
    destinationFile = fullPathName
  When rc = 1 Then
    destinationFile = Word(Arg(1), 2)
  Otherwise
    Do
      Say myName':' Word(Arg(1), 2) 'exists and overwrite was not specified'
      Call EndThisPlease 2
    End
End

Return

OpenFilesAndSuch:

rc = OpenFileForRead( sourceFile )
If rc = 0 Then
  NOP
Else
  Do
    Say sourceFile 'OPEN READ failed'
    Call EndThisPlease 3
  End

rc = OpenFileForWrite( destinationFile )
If rc = 0 Then
  NOP
Else
  Do
    Say sourceFile 'OPEN WRITE failed'
    Call EndThisPlease 3
  End

rc = PositionForWriteAtBeginning( destinationFile )
If rc = 0 Then
  NOP
Else
  Do
    Say sourceFile 'SEEK failed'
    Call EndThisPlease 3
  End

Call WriteFile destinationFile, ':userdoc.'
Call WriteFile destinationFile, ':title.'fileTitle
Call WriteFile destinationFile, ':docprof toc=12345.'

If quietMode Then
  NOP
Else
  Do
    Parse Value SysCurPos() With row col
    pos = SysCurPos(row, 2)
    Say 'Record Count'
  End

Return

ProcessTheSource:

Call ReadFile sourceFile
count = count + 1
If quietMode Then
  NOP
Else
  Do
    pos = SysCurPos(row, 15)
    Say count
  End

Select
  When (Length(inputLine) > lenBreakLvl1) & ,
       (Substr(inputLine, 1, lenBreakLvl1) = breakLvl1) Then
    Do
      Call BreakLevel1
    End
  When (Length(inputLine) > lenBreakLvl2) & ,
       (Substr(inputLine, 1, lenBreakLvl2) = breakLvl2) Then
    Do
      If okayToStart Then Call BreakLevel2
    End
  When (Length(inputLine) > lenBreakLvl3) & ,
       (Substr(inputLine, 1, lenBreakLvl3) = breakLvl3) Then
    Do
      If okayToStart Then Call BreakLevel3
    End
  When (Length(inputLine) > lenBreakLvl4) & ,
       (Substr(inputLine, 1, lenBreakLvl4) = breakLvl4) Then
    Do
      If okayToStart Then Call BreakLevel4
    End
  Otherwise
    Do
      Call NormalText
    End
End

Return

BreakLevel1:

Call PutELinesTagIn
newMsg = 1
okayToStart = 1
Call SubstituteSpecialSymbols inputLine

outputLine2 = ':h2. ' || modifiedString
msgHeader.0 = 5
Do k = 1 To msgHeader.0
  msgHeader.k = ''
End

Call SubstituteSpecialSymbols inputLine
msgHeader.1 = modifiedString
Call ReadFile sourceFile
Call SubstituteSpecialSymbols inputLine
msgHeader.2 = modifiedString

outputLine1 = ':h1. ' || modifiedString
Call WriteFile destinationFile, outputLine1
Call WriteFile destinationFile, outputLine2
Drop outputLine2

breakLvlCount = 2

Return

BreakLevel2:

msgHeader.0 = 5
Do k = 1 To msgHeader.0
  msgHeader.k = ''
End

newMsg = 1
Call SubstituteSpecialSymbols inputLine
msgHeader.1 = modifiedString
Parse Var inputLine . ' ' . ' ' breakLvl2Ind
If breakLvl2Ind \= prevBreakLvl2Ind Then
  Do
    Call PutELinesTagIn
    aString = Substr(inputLine, lenBreakLvl2)
    Parse Var aString . ' ' sectionHeader
    Call SubstituteSpecialSymbols sectionHeader
    breakLvlCount = breakLvlCount + 1
    If breakLvlCount > 3 Then breakLvlCount = 3
    outputLine1 = ':h' || breakLvlCount || '. ' || modifiedString
    Call WriteFile destinationFile, outputLine1
    prevBreakLvl2Ind = breakLvl2Ind
  End

Call ReadFile sourceFile
Call SubstituteSpecialSymbols inputLine
msgHeader.2 = modifiedString

Return

/*
There are a couple of different ways this break level can be
indicated.  We have to try them all.
*/
BreakLevel3:

newMsg = 1
Call SubstituteSpecialSymbols inputLine
msgHeader.3 = modifiedString
breakLvl3Ind1 = ''
breakLvl3Ind2 = ''
If Pos(announcementFlag, inputLine) > 0 Then
  breakLvl3Ind = announcementFlag
Else
  Do
    Parse Var inputLine . (breakLvl3) . '-#' breakLvl3Ind
    If breakLvl3Ind = '' Then
      Parse Var inputLine . (breakLvl3) . '-' breakLvl3Ind
    Else
      NOP
    If breakLvl3Ind = '' Then
      Parse Var inputLine . (breakLvl3) . '#' breakLvl3Ind
    Else
      NOP
    If breakLvl3Ind = '' Then
      Parse Var inputLine . (breakLvl3) breakLvl3Ind
    Else
      NOP
  End

If breakLvl3Ind \= prevBreakLvl3Ind Then
    Do
      Call PutELinesTagIn
      breakLvlCount = breakLvlCount + 1
      If breakLvlCount > 4 Then breakLvlCount = 4
      outputLine1 = ':h' || breakLvlCount || '. ' || modifiedString
      Call WriteFile destinationFile, outputLine1
      prevBreakLvl3Ind = breakLvl3Ind
    End
Else
  NOP

breakLvl3Occurred = 1

Return

BreakLevel4:

Call PutELinesTagIn
newMsg = 1
Call SubstituteSpecialSymbols inputLine
msgHeader.4 = modifiedString
breakLvlCount = breakLvlCount + 1
If breakLvlCount > 5 Then breakLvlCount = 5
outputLine1 = ':h' || breakLvlCount || '. ' || modifiedString
Call WriteFile destinationFile, outputLine1

Return

NormalText:

If newMsg & breakLvl3Occurred Then
  Do
    Call WriteFile destinationFile, ':p.'
    Call WriteFile destinationFile, ':lines.'
    linesWritten = 1
    Do i = 1 to msgHeader.0
      If msgHeader.i = '' Then
        NOP
      Else
        Call WriteFile destinationFile, msgHeader.i
    End
    newMsg = 0
    breakLvl3Occurred = 0
  End
Else
  NOP
If okayToStart Then
  Do
    Call SubstituteSpecialSymbolsInBodyText inputLine, ampersandSubscript
    inputLine = modifiedString
    Call SubstituteSpecialSymbolsInBodyText inputLine, colonSubscript
    inputLine = modifiedString
    Call SubstitutePeriodsInBodyText inputLine, periodSubscript
    Call WriteFile destinationFile, modifiedString
  End
Else
  NOP

Return

PutELinesTagIn:

If linesWritten Then
  Do
    Call WriteFile destinationFile, ':elines.'
    linesWritten = 0
  End
Else
  NOP

Return

SubstituteSpecialSymbols: Procedure Expose modifiedString specialSymbol. ipfSymbol.

/*
The logic here is ugly because both the ampersand and period are special
characters and are also used to indicate special characters.  We have to
check to make sure each is substituted properly, not replacing an existing
special character's IPF symbol.

It was rather difficult to get this to work.  Hopefully, you won't have to
modify it.
*/

modifiedString = Arg(1)

If Length(modifiedString) = 0 Then
  Return
Else
  NOP

z = specialSymbol.0
Do i = 1 To specialSymbol.0
  j = 1
  leaveMe = 0
  k = 1
  Do While ( Pos( specialSymbol.i, modifiedString, j ) > 0 ) &,
           ( Length(modifiedString) > 0 )
    j = Pos( specialSymbol.i, modifiedString, j )
    If (specialSymbol.i = specialSymbol.z) &,
       (Pos( specialSymbol.i, modifiedString, k) > 0) Then
      Do While (Pos( specialSymbol.i, modifiedString, k) > 0)
        itIsAnIPFSymbol = 0
        k = Pos( specialSymbol.i, modifiedString, k)
        Do x = 1 To ipfSymbol.0
          If Length(modifiedString) >= (k + Length(ipfSymbol.x) - 1) Then
            If Substr(modifiedString, k, Length(ipfSymbol.x)) = ipfSymbol.x Then
              Do
                itIsAnIPFSymbol = 1
                Leave x
              End
            Else
              NOP
          Else
            NOP
        End
        If itIsAnIPFSymbol Then
          Do
            k = k + Length(ipfSymbol.x) + 1
            If k >= Length(modifiedString) Then leaveMe = 1
          End
        Else
          Do
            Select
              When k = 1 Then
                Do
                  string2 = Substr(modifiedString, k + 1)
                  modifiedString = ipfSymbol.i || string2
                End
              When k = Length(modifiedString) Then
                Do
                  string1 = Substr(modifiedString, 1, k - 1)
                  modifiedString = string1 || ipfSymbol.i
                End
              Otherwise
                Do
                  string1 = Substr(modifiedString, 1, k - 1)
                  string2 = Substr(modifiedString, k + 1)
                  modifiedString = string1 || ipfSymbol.i || string2
                End
            End
            k = k + Length(ipfSymbol.i)
            If k >= Length(modifiedString) Then leaveMe = 1
          End
        j = k
      End
    Else
      Do
        Select
          When j = 1 Then
            Do
              string2 = Substr(modifiedString, j + 1)
              modifiedString = ipfSymbol.i || string2
            End
          When j = Length(modifiedString) Then
            Do
              string1 = Substr(modifiedString, 1, j - 1)
              modifiedString = string1 || ipfSymbol.i
            End
          Otherwise
            Do
              string1 = Substr(modifiedString, 1, j - 1)
              string2 = Substr(modifiedString, j + 1)
              modifiedString = string1 || ipfSymbol.i || string2
            End
        End
        j = j + Length(ipfSymbol.i)
        If j >= Length(modifiedString) Then leaveMe = 1
      End
    If leaveMe Then Leave
  End
End

Return

/*
We only need to substitute some of the special symbols into the body text.
*/
SubstituteSpecialSymbolsInBodyText: Procedure Expose modifiedString specialSymbol. ipfSymbol.

modifiedString = Arg(1)
subscript = Arg(2)

j = 1
Do While ( Pos( specialSymbol.subscript, modifiedString, j ) > 0 ) &,
         ( Length(modifiedString) > 0 )
  j = Pos( specialSymbol.subscript, modifiedString, j )
  string1 = Substr(modifiedString, 1, j - 1)
  string2 = Substr(modifiedString, j + 1)
  modifiedString = string1 || ipfSymbol.subscript || string2
  j = j + Length(ipfSymbol.subscript)
End

Return

/*
And, of course, periods aren't allowed in column one of the body text.  IPFC
thinks they're macros.  How stupid of me not to have known.
*/
SubstitutePeriodsInBodyText: Procedure Expose modifiedString specialSymbol. ipfSymbol.

modifiedString = Arg(1)
subscript = Arg(2)

If ( Pos( specialSymbol.subscript, modifiedString, 1 ) = 1 ) &,
         ( Length(modifiedString) > 1 ) Then
  Do
    modifiedString = ipfSymbol.subscript || Substr(Arg(1), 2)
  End
Else
  If Length(modifiedString) = 1 Then
  Do
    modifiedString = ipfSymbol.subscript
  End

Return

LoadSpecialSymbols:

/*
None of the following symbols are allowed in heading text.  Note that the period
is first and the ampersand is last.  This is important to the logic which replaces
these special characters.
*/

specialSymbol.0 = 123
specialSymbol.1 = '.'    /*Period              */
periodSubscript = 1      /*Not allowed in column 1 of window body text */
specialSymbol.2 = ''    /*a acute             */
specialSymbol.3 = ''    /*a circumflex        */
specialSymbol.4 = ''    /*a umlaut            */
specialSymbol.5 = ''    /*A umlaut            */
specialSymbol.6 = ''    /*a grave             */
specialSymbol.7 = ''    /*ae ligature         */
specialSymbol.8 = ''    /*AE ligature         */
specialSymbol.9 = 'A'    /*Alpha               */
specialSymbol.10 = '^'    /*and                 */
specialSymbol.11 = ''    /*angstrom            */
specialSymbol.12 = ''    /*a overcircle        */
specialSymbol.13 = ''    /*A overcircle        */
specialSymbol.14 = "'"    /*Apostrophe          */
specialSymbol.15 = ''    /*ASCII code 185      */
specialSymbol.16 = ''    /*ASCII code 186      */
specialSymbol.17 = ''    /*ASCII code 187      */
specialSymbol.18 = ''    /*ASCII code 188      */
specialSymbol.19 = ''    /*ASCII code 200      */
specialSymbol.20 = ''    /*ASCII code 201      */
specialSymbol.21 = ''    /*ASCII code 202      */
specialSymbol.22 = ''    /*ASCII code 203      */
specialSymbol.23 = ''    /*ASCII code 204      */
specialSymbol.24 = ''    /*ASCII code 205      */
specialSymbol.25 = ''    /*ASCII code 206      */
specialSymbol.26 = '*'    /*Asterisk            */
specialSymbol.27 = '@'    /*At sign             */
specialSymbol.28 = '\'    /*Back slash          */
specialSymbol.29 = ''    /*Beta                */
specialSymbol.30 = ''    /*box ascender        */
specialSymbol.31 = ''    /*box cross           */
specialSymbol.32 = ''    /*box descender       */
specialSymbol.33 = ''    /*box horizontal      */
specialSymbol.34 = ''    /*box lower-left      */
specialSymbol.35 = ''    /*box lower-right     */
specialSymbol.36 = ''    /*box right junction  */
specialSymbol.37 = ''    /*box upper-left      */
specialSymbol.38 = ''    /*box upper-right     */
specialSymbol.39 = ''    /*box vertical        */
specialSymbol.40 = ''    /*c cedilla           */
specialSymbol.41 = ''    /*C cedilla           */
specialSymbol.42 = '^'    /*Caret symbol        */
specialSymbol.43 = '"'    /*Close double quote  */
specialSymbol.44 = ''    /*Close French double */
                          /*quote               */
specialSymbol.45 = "'"    /*Close single quote  */
specialSymbol.46 = ','    /*Comma               */
specialSymbol.47 = ':'    /*Colon               */
colonSubscript = 47       /*Not allowed in window body text */
specialSymbol.48 = '-'    /*Dash                */
specialSymbol.49 = ''    /*degree              */
specialSymbol.50 = ''    /*divide              */
specialSymbol.51 = '$'    /*Dollar sign         */
specialSymbol.52 = ''    /*dot                 */
specialSymbol.53 = ''    /*Down arrow          */
specialSymbol.54 = ''    /*e acute             */
specialSymbol.55 = ''    /*E acute             */
specialSymbol.56 = ''    /*e circumflex        */
specialSymbol.57 = ''    /*e umlaut            */
specialSymbol.58 = ''    /*e grave             */
specialSymbol.59 = '-'    /*Em dash             */
specialSymbol.60 = '-'    /*En dash             */
specialSymbol.61 = '='    /*Equal sign          */
specialSymbol.62 = '!'    /*Exclamation point   */
specialSymbol.63 = ''    /*function of         */
specialSymbol.64 = '>'    /*Greater than        */
specialSymbol.65 = ''    /*House               */
specialSymbol.66 = '-'    /*Hyphen              */
specialSymbol.67 = ''    /*i acute             */
specialSymbol.68 = ''    /*i circumflex        */
specialSymbol.69 = ''    /*i umlaut            */
specialSymbol.70 = ''    /*i grave             */
specialSymbol.71 = ''    /*inverted exclamation*/
                          /*mark                */
specialSymbol.72 = ''    /*inverted question   */
                          /*mark                */
specialSymbol.73 = ''    /*Left arrow          */
specialSymbol.74 = '{'    /*Left brace          */
specialSymbol.75 = '['    /*Left bracket        */
specialSymbol.76 = '('    /*Left parenthesis    */
specialSymbol.77 = ''    /*logical not         */
specialSymbol.78 = '-'    /*M dash              */
specialSymbol.79 = '-'    /*Minus sign          */
specialSymbol.80 = ''    /*Mu                  */
specialSymbol.81 = '-'    /*N dash              */
specialSymbol.82 = ''    /*n tidle             */
specialSymbol.83 = ''    /*N tidle             */
specialSymbol.84 = ''    /*not symbol          */
specialSymbol.85 = '#'    /*Number sign         */
specialSymbol.86 = ''    /*o acute             */
specialSymbol.87 = ''    /*o circumflex        */
specialSymbol.88 = ''    /*o grave             */
specialSymbol.89 = ''    /*o umlaut            */
specialSymbol.90 = ''    /*O umlaut            */
specialSymbol.91 = ''    /*one fourth          */
specialSymbol.92 = ''    /*one half            */
specialSymbol.93 = '"'    /*Open double quote   */
specialSymbol.94 = ''    /*Open French double  */
                          /*quote               */
specialSymbol.95 = "`"    /*Open single quote   */
specialSymbol.96 = '%'    /*Percent             */
specialSymbol.97 = '+'    /*Plus sign           */
specialSymbol.98 = ''    /*plusminus           */
specialSymbol.99 = ''    /*pound sterling      */
specialSymbol.100 = '}'    /*Right brace         */
specialSymbol.101 = ']'    /*Right bracket       */
specialSymbol.102 = ')'    /*Right parenthesis   */
specialSymbol.103 = ';'    /*Semicolon           */
specialSymbol.104 = ''    /*shaded box 1/4 dots */
specialSymbol.105 = ''    /*shaded box 1/2 dots */
specialSymbol.106 = ''    /*shaded box 3/4 dots */
specialSymbol.107 = '/'    /*Slash               */
specialSymbol.108 = ''    /*solid box           */
specialSymbol.109 = ''    /*solid box bottom    */
                          /*half                */
specialSymbol.110 = '|'    /*Split vertical bar  */
                          /*(piping symbol)     */
specialSymbol.111 = ''    /*square bullet       */
specialSymbol.112 = ''    /*superscript 2       */
specialSymbol.113 = '~'    /*Tilde               */
specialSymbol.114 = ''    /*u acute             */
specialSymbol.115 = ''    /*u circumflex        */
specialSymbol.116 = ''    /*u grave             */
specialSymbol.117 = ''    /*u umlaut            */
specialSymbol.118 = ''    /*U umlaut            */
specialSymbol.119 = '_'    /*Underscore          */
specialSymbol.120 = ''    /*underscored a       */
specialSymbol.121 = ''    /*underscored o       */
specialSymbol.122 = ''    /*y umlaut            */
specialSymbol.123 = '&'    /*Ampersand           */
ampersandSubscript = 123   /*Not allowed in window body text */

/*
The '&' is last because it is also used to indicate a special symbol.  Leave
it as the last entry if more special symbols are added.
*/

ipfSymbol.0 = 123
ipfSymbol.1 = '&per.'               /*Period               .    */
ipfSymbol.2 = '&aa.'                /*a acute                  */
ipfSymbol.3 = '&ac.'                /*a circumflex             */
ipfSymbol.4 = '&ae.'                /*a umlaut                 */
ipfSymbol.5 = '&Ae.'                /*A umlaut                 */
ipfSymbol.6 = '&ag.'                /*a grave                  */
ipfSymbol.7 = '&aelig.'             /*ae ligature              */
ipfSymbol.8 = '&AElig.'             /*AE ligature              */
ipfSymbol.9 = '&Alpha.'             /*Alpha                A    */
ipfSymbol.10 = '&and.'               /*and                  ^    */
ipfSymbol.11 = '&angstrom.'          /*angstrom                 */
ipfSymbol.12 = '&ao.'                /*a overcircle             */
ipfSymbol.13 = '&Ao.'                /*A overcircle             */
ipfSymbol.14 = '&apos.'              /*Apostrophe           '    */
ipfSymbol.15 = '&bx2022.'            /*ASCII code 185           */
ipfSymbol.16 = '&bx2020.'            /*ASCII code 186           */
ipfSymbol.17 = '&bx0022.'            /*ASCII code 187           */
ipfSymbol.18 = '&bx2002.'            /*ASCII code 188           */
ipfSymbol.19 = '&bx2200.'            /*ASCII code 200           */
ipfSymbol.20 = '&bx0220.'            /*ASCII code 201           */
ipfSymbol.21 = '&bx2202.'            /*ASCII code 202           */
ipfSymbol.22 = '&bx0222.'            /*ASCII code 203           */
ipfSymbol.23 = '&bx2220.'            /*ASCII code 204           */
ipfSymbol.24 = '&bx0202.'            /*ASCII code 205           */
ipfSymbol.25 = '&bx2222.'            /*ASCII code 206           */
ipfSymbol.26 = '&asterisk.'          /*Asterisk             *    */
ipfSymbol.27 = '&atsign.'            /*At sign              @    */
ipfSymbol.28 = '&bslash.'            /*Back slash           \    */
ipfSymbol.29 = '&Beta.'              /*Beta                     */
ipfSymbol.30 = '&bxas.'              /*box ascender             */
ipfSymbol.31 = '&bxcr.'              /*box cross                */
ipfSymbol.32 = '&bxde.'              /*box descender            */
ipfSymbol.33 = '&bxh.'               /*box horizontal           */
ipfSymbol.34 = '&bxll.'              /*box lower-left           */
ipfSymbol.35 = '&bxlr.'              /*box lower-right          */
ipfSymbol.36 = '&bxri.'              /*box right junction       */
ipfSymbol.37 = '&bxul.'              /*box upper-left           */
ipfSymbol.38 = '&bxur.'              /*box upper-right          */
ipfSymbol.39 = '&bxv.'               /*box vertical             */
ipfSymbol.40 = '&cc.'                /*c cedilla                */
ipfSymbol.41 = '&Cc.'                /*C cedilla                */
ipfSymbol.42 = '&caret.'             /*Caret symbol         ^    */
ipfSymbol.43 = '&cdq.'               /*Close double quote   "    */
ipfSymbol.44 = '&cdqf.'              /*Close French double      */
                                     /*quote                     */
ipfSymbol.45 = '&csq.'               /*Close single quote   '    */
ipfSymbol.46 = '&comma.'             /*Comma                ,    */
ipfSymbol.47 = '&colon.'             /*Colon                :    */
ipfSymbol.48 = '&dash.'              /*Dash                 -    */
ipfSymbol.49 = '&degree.'            /*degree                   */
ipfSymbol.50 = '&divide.'            /*divide                   */
ipfSymbol.51 = '&dollar.'            /*Dollar sign          $    */
ipfSymbol.52 = '&dot.'               /*dot                      */
ipfSymbol.53 = '&darrow.'            /*Down arrow               */
ipfSymbol.54 = '&ea.'                /*e acute                  */
ipfSymbol.55 = '&Ea.'                /*E acute                  */
ipfSymbol.56 = '&ec.'                /*e circumflex             */
ipfSymbol.57 = '&ee.'                /*e umlaut                 */
ipfSymbol.58 = '&eg.'                /*e grave                  */
ipfSymbol.59 = '&emdash.'            /*Em dash              -    */
ipfSymbol.60 = '&endash.'            /*En dash              -    */
ipfSymbol.61 = '&eq.'                /*Equal sign           =    */
ipfSymbol.62 = '&xclm.'              /*Exclamation point    !    */
ipfSymbol.63 = '&fnof.'              /*function of              */
ipfSymbol.64 = '&gtsym.'             /*Greater than         >    */
ipfSymbol.65 = '&house.'             /*House                    */
ipfSymbol.66 = '&hyphen.'            /*Hyphen               -    */
ipfSymbol.67 = '&ia.'                /*i acute                  */
ipfSymbol.68 = '&ic.'                /*i circumflex             */
ipfSymbol.69 = '&ie.'                /*i umlaut                 */
ipfSymbol.70 = '&ig.'                /*i grave                  */
ipfSymbol.71 = '&inve.'              /*inverted exclamation     */
                                     /*mark                      */
ipfSymbol.72 = '&invq.'              /*inverted question        */
                                     /*mark                      */
ipfSymbol.73 = '&larrow.'            /*Left arrow               */
ipfSymbol.74 = '&lbrace.'            /*Left brace           {    */
ipfSymbol.75 = '&lbracket.'          /*Left bracket         [    */
ipfSymbol.76 = '&lpar.'              /*Left parenthesis     (    */
ipfSymbol.77 = '&lnot.'              /*logical not              */
ipfSymbol.78 = '&mdash.'             /*M dash               -    */
ipfSymbol.79 = '&minus.'             /*Minus sign           -    */
ipfSymbol.80 = '&mu.'                /*Mu                       */
ipfSymbol.81 = '&ndash.'             /*N dash               -    */
ipfSymbol.82 = '&nt.'                /*n tidle                  */
ipfSymbol.83 = '&Nt.'                /*N tidle                  */
ipfSymbol.84 = '&lnot.'              /*not symbol               */
ipfSymbol.85 = '&numsign.'           /*Number sign          #    */
ipfSymbol.86 = '&oa.'                /*o acute                  */
ipfSymbol.87 = '&oc.'                /*o circumflex             */
ipfSymbol.88 = '&og.'                /*o grave                  */
ipfSymbol.89 = '&oe.'                /*o umlaut                 */
ipfSymbol.90 = '&Oe.'                /*O umlaut                 */
ipfSymbol.91 = '&frac14.'            /*one fourth               */
ipfSymbol.92 = '&frac12.'            /*one half                 */
ipfSymbol.93 = '&odq.'               /*Open double quote    "    */
ipfSymbol.94 = '&odqf.'              /*Open French double       */
                                     /*quote                     */
ipfSymbol.95 = '&osq.'               /*Open single quote    `    */
ipfSymbol.96 = '&percent.'           /*Percent              %    */
ipfSymbol.97 = '&plus.'              /*Plus sign            +    */
ipfSymbol.98 = '&plusmin.'           /*plusminus                */
ipfSymbol.99 = '&Lsterling.'         /*pound sterling           */
ipfSymbol.100 = '&rbrace.'            /*Right brace          }    */
ipfSymbol.101 = '&rbracket.'          /*Right bracket        ]    */
ipfSymbol.102 = '&rpar.'              /*Right parenthesis    )    */
ipfSymbol.103 = '&semi.'              /*Semicolon            ;    */
ipfSymbol.104 = '&box14.'             /*shaded box 1/4 dots      */
ipfSymbol.105 = '&box12.'             /*shaded box 1/2 dots      */
ipfSymbol.106 = '&box34.'             /*shaded box 3/4 dots      */
ipfSymbol.107 = '&slash.'             /*Slash                /    */
ipfSymbol.108 = '&BOX.'               /*solid box                */
ipfSymbol.109 = '&BOXBOT.'            /*solid box bottom         */
                                      /*half                      */
ipfSymbol.110 = '&splitvbar.'         /*Split vertical bar   |    */
                                      /*(piping symbol)           */
ipfSymbol.111 = '&sqbul.'             /*square bullet            */
ipfSymbol.112 = '&sup2.'              /*superscript 2            */
ipfSymbol.113 = '&tilde.'             /*Tilde                ~    */
ipfSymbol.114 = '&ua.'                /*u acute                  */
ipfSymbol.115 = '&uc.'                /*u circumflex             */
ipfSymbol.116 = '&ug.'                /*u grave                  */
ipfSymbol.117 = '&ue.'                /*u umlaut                 */
ipfSymbol.118 = '&Ue.'                /*U umlaut                 */
ipfSymbol.119 = '&us.'                /*Underscore           _    */
ipfSymbol.120 = '&aus.'               /*underscored a            */
ipfSymbol.121 = '&ous.'               /*underscored o            */
ipfSymbol.122 = '&ye.'                /*y umlaut                 */
ipfSymbol.123 = '&amp.'               /*Ampersand            &    */

Return

CloseFilesAndSuch:

Call PutELinesTagIn
Call WriteFile destinationFile, ':euserdoc.'

rc = CloseFile( destinationFile )

If rc = 0 Then
  NOP
Else
  Say myName '* File close error for' destinationFile

prevRC = rc
rc = CloseFile( sourceFile )

If rc = 0 Then
  NOP
Else
  Say myName '* File close error for' sourceFile

If (rc \= 0) | (prevRC \= 0) Then
  Call EndThisPlease 9
Else
  NOP

Return

/*
Make sure the input file exists, and return its full path name
*/
CheckForFile: Procedure Expose fullPathName

fullPathName = Stream(Arg(1), 'C', 'QUERY EXISTS')
If fullPathName = '' Then
  rc = 1
Else
  rc = 0

Return rc

/*
Open the file specified in the parameter for read only.
*/
OpenFileForRead: Procedure Expose quietMode

aString = Stream(Arg(1), 'C', 'OPEN READ')

If quietMode Then
  NOP
Else
  Say ' ' Arg(1) 'OPEN READ status is' aString

If aString = 'READY:' Then
  rc = 0
Else
  rc = 1

Return rc

/*
Read the file specified in the parameter.
*/
ReadFile:

Call ON NOTREADY NAME ReadFileErr

inputLine = Linein(Arg(1))

CALL OFF NOTREADY

Return

/*
Oops, an error occurred on read.
*/
ReadFileErr:

Say myName '* File Read Error!'

Call EndThisPlease 9

Return

/*
Open the file specified in the parameter for output.
*/
OpenFileForWrite: Procedure Expose quietMode

aString = Stream(Arg(1), 'C', 'OPEN WRITE')

If quietMode Then
  NOP
Else
  Say ' ' Arg(1) 'OPEN WRITE status is' aString

If aString = 'READY:' Then
  rc = 0
Else
  rc = 1

Return rc

/*
Output a record to the file.
*/
WriteFile:

CALL ON NOTREADY NAME WriteFileErr

Call Lineout Arg(1), Arg(2)

CALL OFF NOTREADY

Return

/*
Oops, an error occurred on output.
*/
WriteFileErr:

Say myName '* File Write Error!'

Call EndThisPlease 9

Return

/*
The REXX default is to append to a file.  We don't want to do that, so
this subroutine positions the write pointer at the beginning of
the file specified in the parameter.
*/
PositionForWriteAtBeginning: Procedure Expose quietMode

aString = Stream(Arg(1), 'C', 'SEEK =1')

aString = Stream(Arg(1), 'S')

If quietMode Then
  NOP
Else
  Say ' ' Arg(1) 'SEEK status is' aString

If aString = 'READY' Then
  rc = 0
Else
  rc = 1

Return rc

/*
Close the file specified in the parameter.
*/
CloseFile: Procedure Expose quietMode

aString = Stream(Arg(1), 'C', 'CLOSE')

If quietMode Then
  NOP
Else
  Say ' ' Arg(1) 'CLOSE status is' aString

If aString = 'READY:' Then
  rc = 0
Else
  rc = 1

Return rc

ShowSyntax:

Say myName version 'Syntax:'
Say Copies(' ', Length(myName)) myName 'source-file [destination-file] [-W] [-Q]'
Say myName 'Creates an IPF file from your text file of CompuServe'
Say Copies(' ', Length(myName)) 'messages.  The default destination-file is the source-file with'
Say Copies(' ', Length(myName)) 'the extension IPF.'
Say myName 'switches: (separate them with spaces please)'
Say Copies(' ', Length(myName)) '-W   write over destination file if it exists'
Say Copies(' ', Length(myName)) '-Q   quiet mode (suppress messages)'

Return

/*
Show the parameters being used in this run.
*/
ShowParms:

Say myName version ' ' Date() Time()
Say '  Source File:      ' sourceFile
Say '  Destination File: ' destinationFile
If overWriteOK Then
  Say '  Overwrite:         Yes' 
Else
  Say '  Overwrite:         No' 

Return

/*
Just what it says...
*/
EndThisPlease:

If quietMode Then
  NOP
Else
  Say myName': return code =' Arg(1)

Exit Arg(1)
