/* REXX script to automatically call BBS, log on, download OS2NEW.ZIP, then log off. */

/* clear screen  */
CALL ZocCls

/* set variables */

user_name="XXXX XXXXXXXX"       /* your name as registered with the BBS (put in quotes) */
password="XXX##XX"              /* your password as registered with the BBS (put in quotes) */
bbs_num="#-###-###-####"        /* the BBS phone number (put in quotes) */
min_speed=#####                 /* minimum connect speed you'll accept (NO QUOTES) */
max_attempts=#                  /* maximum number of times to retry the call (NO QUOTES) */

DO call_bbs=1 TO max_attempts

  /* clear screen */
  CALL ZocCls

  /* initialize modem */
  CALL ZocSend "ATZ1^M"
  CALL ZocDelay 1

  SAY "Attempt # " call_bbs 

  SAY "Calling the OS/2 Shareware BBS to download OS2NEW.ZIP.  Dialing...." bbs_num

  CALL ZocTimeOut 60

  CALL ZocDial bbs_num "^IOS/2 Shareware"

      /* let's see what kind of response we get */
      DO result_type=1 TO 6

         /* receive next line of text */
         rc=ZocGetLine()

         /* if no answer, try again (leave loop) */
         IF rc=640 THEN 
         DO
            CALL ZocHangup
            LEAVE result_type
         END
         
         /* if BUSY was received, try again (leave loop) */
         IF ZocLastLine()="BUSY" THEN
         DO
	    CALL ZocDelay 1
	    CALL ZocMsgBox "The line is busy.  We'll try again.", 0
            LEAVE result_type
         END

         /* if NO DIAL TONE was received, end with error message */
         IF ZocLastLine()="NO DIAL TONE" THEN 
         DO
	    CALL ZocDelay 1
            CALL ZocMsgBox "Possible hardware or software trouble.  Aborting attempt.", 1
            EXIT
         END

         /* if NO CARRIER was received, end with error message */
         IF ZocLastLine()="NO CARRIER" THEN 
         DO
            CALL ZocHangup
            CALL ZocMsgBox "Possible dialing error.  Check phone number.", 1
            EXIT
         END

         /* determine the connect speed */
         DO b=9 TO 15
           IF SUBSTR(ZocLastLine(),b,1)="/" THEN
           DO 
              b=b-9
              LEAVE b
           END
         END b
         speed=SUBSTR(ZocLastLine(),9,b)
         IF speed<min_speed THEN 
         DO
            CALL ZocHangup
            ans=ZocMsgBox("Connect speed is too slow!  Do you want to try again?", 2)
            IF ans="##NO##" THEN EXIT
               ELSE LEAVE result_type
         END
         ELSE LEAVE call_bbs

      END result_type

      IF call_bbs<max_attempts THEN
      DO
	DO time_out=30 to 1 by -1
	  IF time_out>1 THEN CALL ZocNotify "Pausing " time_out " seconds."
	     ELSE CALL ZocNotify "Pausing " time_out " second."
	  Call ZocDelay 1
	END time_out
      END

END call_bbs

IF call_bbs=max_attempts+1 THEN
DO
   CALL ZocMsgBox "Can't get through now.....try again later.", 0
   CALL ZocCls
   CALL ZocSend "ATZ1^M"
   CALL ZocDelay 1
   EXIT
END

CALL ZocTimeOut 10
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait "your name:"
CALL ZocSend user_name "^M"

CALL ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait SUBSTR(user_name,LENGTH(user_name)-2,3)' [Y,n]?'
CALL ZocSend "y^M"

CALL ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait "Password:"
CALL ZocSend password "^M"

CALL ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait "o continue"
CALL ZocSend "^M"

Call ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait "e [Y,n,=]?"
CALL ZocSend "N^M"

Call ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait "Select: "
CALL ZocSend "F^M"

CALL ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait "Select: "
CALL ZocSend "D^M"

CALL ZocTimeOut 60

CALL ZocWait "load (#1):"
CALL ZocSend "OS2NEW.ZIP^M"

CALL ZocWait "load (#2):"
CALL ZocSend "/G^M"

result=ZocWaitMux("<esc> to abort:", "Disconnect [Y,n,?=help]? ", "Transfer completed.")
  SELECT
    WHEN result=0 THEN Call ZocSend "^M"
    WHEN result=1 THEN SIGNAL ALREADY_GOT_1
    WHEN result=2 THEN SIGNAL ALREADY_GOT_2
  END


ALREADY_GOT_1:
  CALL ZocSend "Y^M"
  CALL ZocDelay 1
  CALL ZocSend "N^M"
  CALL ZocDelay 1
  CALL ZocHangup
  EXIT

ALREADY_GOT_2:
  CALL ZocSend "G^M"
  CALL ZocDelay 1
  CALL ZocSend "Y^M"
  CALL ZocDelay 1
  CALL ZocSend "N^M"
  CALL ZocDelay 1
  CALL ZocHangup
  EXIT

PROBLEM:
   CALL ZocHangup
   CALL ZocMsgBox "Something went wrong", 1
   EXIT
