/* REXX script to automatically call BBS, log on, download up to TEN files, then log off. */

/* clear screen  */
CALL ZocCls

/* set variables */

user_name="XXXX XXXXXXXX"       /* your name as registered with the BBS (put in quotes) */
password="XXX##XX"              /* your password as registered with the BBS (put in quotes) */
bbs_num="#-###-###-####"        /* the BBS phone number (put in quotes) */
min_speed=#####                 /* minimum connect speed you'll accept (NO QUOTES) */
max_attempts=#                  /* maximum number of times to retry the call (NO QUOTES) */

CR=d2c(13)
qty_files=0
org_qty=0
reply=""
answer=""

CALL GET_FILE_NAMES
 
CALL FILE_NAME_CONFIRM

DO call_bbs=1 TO max_attempts

  /* clear screen */
  CALL ZocCls

  /* initialize modem */
  CALL ZocSend "ATZ1^M"
  CALL ZocDelay 1

  SAY "Attempt # " call_bbs 

  SAY "Calling the OS/2 Shareware BBS to download files.  Dialing...." bbs_num

  CALL ZocTimeOut 60

  DIAL bbs_num '^IOS/2 Shareware'

      /* let's see what kind of response we get */
      DO result_type=1 TO 6

         
         /* receive next line of text */
         rc=ZocGetLine()

         /* if no answer, try again (leave loop) */
         IF rc=640 THEN 
         DO
            CALL ZocHangup
            LEAVE result_type
         END
         
         /* if BUSY was received, try again (leave loop) */
         IF ZocLastLine()="BUSY" THEN
         DO
	    CALL ZocDelay 1
	    CALL ZocMsgBox "The line is busy.  We'll try again.", 0
            LEAVE result_type
         END

         /* if NO DIAL TONE was received, end with error message */
         IF ZocLastLine()="NO DIAL TONE" THEN 
         DO
	    CALL ZocDelay 1
            CALL ZocMsgBox "Possible hardware or software trouble.  Aborting attempt.", 1
            EXIT
         END

         /* if NO CARRIER was received, end with error message */
         IF ZocLastLine()="NO CARRIER" THEN 
         DO
            CALL ZocHangup
            CALL ZocMsgBox "Possible dialing error.  Check phone number.", 1
            EXIT
         END

         /* determine the connect speed */
         DO b=9 TO 15
           IF SUBSTR(ZocLastLine(),b,1)="/" THEN
           DO 
              b=b-9
              LEAVE b
           END
         END b
         speed=SUBSTR(ZocLastLine(),9,b)
         IF speed<min_speed THEN 
         DO
            CALL ZocHangup
            ans=ZocMsgBox("Connect speed is too slow!  Do you want to try again?", 2)
            IF ans="##NO##" THEN EXIT
               ELSE LEAVE result_type
         END
         ELSE LEAVE call_bbs

      END result_type

      IF call_bbs<max_attempts THEN
      DO
	DO time_out=30 to 1 by -1
	  IF time_out>1 THEN CALL ZocNotify "Pausing " time_out " seconds."
	     ELSE CALL ZocNotify "Pausing " time_out " second."
	  Call ZocDelay 1
	END time_out
      END

END call_bbs

IF call_bbs=max_attempts+1 THEN
DO
   CALL ZocMsgBox "Can't get through now.....try again later.", 0
   CALL ZocCls
   CALL ZocSend "ATZ1^M"
   CALL ZocDelay 1
   EXIT
END

CALL ZocTimeOut 10
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait 'your name:'
CALL ZocSend user_name '^M'

CALL ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait SUBSTR(user_name,LENGTH(user_name)-2,3)' [Y,n]?'
CALL ZocSend 'y^M'

CALL ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait 'Password:'
CALL ZocSend PASSWORD '^M'

CALL ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait 'o continue'
CALL ZocSend '^M'

CALL ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait 'e [Y,n,=]?'
CALL ZocSend 'N^M'

CALL ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait 'Select: '
CALL ZocSend 'F^M'

CALL ZocTimeOut 05
rc=ZocGetLine()
IF rc=640 THEN SIGNAL PROBLEM

CALL ZocWait 'Select: '
CALL ZocSend 'D^M'

CALL ZocTimeOut 6000

DO file_names=1 TO 100
    IF qty_files>=2 THEN
    DO  
       CALL ZocWait 'load (#1):'
       CALL ZocSend file_A '^M'
    END
    ELSE LEAVE file_names
  IF qty_files>=3 THEN
    DO  
       CALL ZocWait 'load (#2):'
       CALL ZocSend file_B '^M'
    END
    ELSE LEAVE file_names
  IF qty_files>=4 THEN
    DO  
       CALL ZocWait 'load (#3):'
       CALL ZocSend file_C '^M'
    END
    ELSE LEAVE file_names
  IF qty_files>=5 THEN
    DO  
       CALL ZocWait 'load (#4):'
       CALL ZocSend file_D '^M'
    END
    ELSE LEAVE file_names
  IF qty_files>=6 THEN
    DO  
       CALL ZocWait 'load (#5):'
       CALL ZocSend file_E '^M'
    END
    ELSE LEAVE file_names
  IF qty_files>=7 THEN
    DO  
       CALL ZocWait 'load (#6):'
       CALL ZocSend file_F '^M'
    END
    ELSE LEAVE file_names
  IF qty_files>=8 THEN
    DO  
       CALL ZocWait 'load (#7):'
       CALL ZocSend file_G '^M'
    END
    ELSE LEAVE file_names
  IF qty_files>=9 THEN
    DO  
       CALL ZocWait 'load (#8):'
       CALL ZocSend file_H '^M'
    END
    ELSE LEAVE file_names
  IF qty_files>=10 THEN
    DO  
       CALL ZocWait 'load (#9):'
       CALL ZocSend file_I '^M'
    END
    ELSE LEAVE file_names
  IF qty_files>=11 THEN
    DO  
       CALL ZocWait 'load (#10):'
       CALL ZocSend file_J '^M'
    END
    ELSE LEAVE file_names
END file_names

CALL ZocWait 'load (#'qty_files'):'
CALL ZocSend '/G^M'

CALL ZocWait '<esc> to abort:'
CALL ZocSend '^M'

EXIT


GET_FILE_NAMES:

  CALL ZocCls

  file_A=""
  file_B=""
  file_C=""
  file_D=""
  file_E=""
  file_F=""
  file_G=""
  file_H=""
  file_I=""
  file_J=""

  /* Ask user for first file name */
  answer=ZocAsk("Enter file name to download.")

  IF answer="##CANCEL##" THEN
  DO
    CALL ZocSend "ATZ1^M"
    CALL ZocNotify "Operation cancelled."
    EXIT
  END

  IF answer="" THEN
  DO
    CALL ZocSend "ATZ1^M"
    CALL ZocNotify "Operation cancelled."
    EXIT
  END

  file_A=answer
  SAY "File # 1 - "file_A

  /* ask for maximum of 9 more file names */
  DO qty_files=2 to 10

    /* Ask user for file name */
    answer=ZocAsk("Enter file name to download.")

    IF answer="" THEN LEAVE qty_files
  
    IF answer="##CANCEL##" THEN
    DO
      org_qty=qty_files
      qty_files=100
      reply=ZocMsgBox("Are you sure you want to cancel?",2)
      IF reply="##YES##" THEN
      DO
        CALL ZocCls
        CALL ZocSend "ATZ1^M"
        CALL ZocNotify "Operation cancelled."
        EXIT
      END
    END

    IF qty_files=2 THEN 
    DO 
      file_B=answer
      SAY "File # 2 - "file_B
    END
    IF qty_files=3 THEN
    DO
      file_C=answer
      SAY "File # 3 - "file_C
    END
    IF qty_files=4 THEN
    DO
      file_D=answer
      SAY "File # 4 - "file_D
    END
    IF qty_files=5 THEN
    DO
      file_E=answer
      SAY "File # 5 - "file_E
    END
    IF qty_files=6 THEN
    DO
      file_F=answer
      SAY "File # 6 - "file_F
    END
    IF qty_files=7 THEN
    DO
      file_G=answer
      SAY "File # 7 - "file_G
    END
    IF qty_files=8 THEN
    DO
      file_H=answer
      SAY "File # 8 - "file_H
    END
    IF qty_files=9 THEN
    DO
      file_I=answer
      SAY "File # 9 - "file_I
    END
    IF qty_files=10 THEN
    DO
      file_J=answer
      SAY "File # 10 - "file_J
    END

    IF qty_files=100 THEN qty_files=org_qty-1
      
  END qty_files

RETURN

FIX_FILE_NAMES:

  fix_reply=ZocAsk("Enter file NUMBER that is incorrect.")

  SELECT
    WHEN fix_reply="##CANCEL##" THEN RETURN
    WHEN fix_reply="" THEN RETURN
    WHEN fix_reply=1 THEN DO
      answer=ZocAsk("Enter file name to download.")
      IF answer="##CANCEL##" THEN RETURN
      IF answer="" THEN RETURN
      file_A=answer
      END
    WHEN fix_reply=2 THEN DO
      answer=ZocAsk("Enter file name to download.")
      IF answer="##CANCEL##" THEN RETURN
      IF answer="" THEN RETURN
      file_B=answer
      END
    WHEN fix_reply=3 THEN DO
      answer=ZocAsk("Enter file name to download.")
      IF answer="##CANCEL##" THEN RETURN
      IF answer="" THEN RETURN
      file_C=answer
      END
    WHEN fix_reply=4 THEN DO
      answer=ZocAsk("Enter file name to download.")
      IF answer="##CANCEL##" THEN RETURN
      IF answer="" THEN RETURN
      file_D=answer
      END
    WHEN fix_reply=5 THEN DO
      answer=ZocAsk("Enter file name to download.")
      IF answer="##CANCEL##" THEN RETURN
      IF answer="" THEN RETURN
      file_E=answer
      END
    WHEN fix_reply=6 THEN DO
      answer=ZocAsk("Enter file name to download.")
      IF answer="##CANCEL##" THEN RETURN
      IF answer="" THEN RETURN
      file_F=answer
      END
    WHEN fix_reply=7 THEN DO
      answer=ZocAsk("Enter file name to download.")
      IF answer="##CANCEL##" THEN RETURN
      IF answer="" THEN RETURN
      file_G=answer
      END
    WHEN fix_reply=8 THEN DO
      answer=ZocAsk("Enter file name to download.")
      IF answer="##CANCEL##" THEN RETURN
      IF answer="" THEN RETURN
      file_H=answer
      END
    WHEN fix_reply=9 THEN DO
      answer=ZocAsk("Enter file name to download.")
      IF answer="##CANCEL##" THEN RETURN
      IF answer="" THEN RETURN
      file_I=answer
      END
    WHEN fix_reply=10 THEN DO
      answer=ZocAsk("Enter file name to download.")
      IF answer="##CANCEL##" THEN RETURN
      IF answer="" THEN RETURN
      file_J=answer
      END
    OTHERWISE CALL ZocMsgBox "You made an improper entry!"||CR fix_reply " is not a correct responce."||CR "Enter the file NUMBER that is incorrect.", 1
  END /* select */

  CALL ZocCls

  SAY "File # 1 - "file_A
  IF qty_files>2 THEN SAY "File # 2 - "file_B
  IF qty_files>3 THEN SAY "File # 3 - "file_C
  IF qty_files>4 THEN SAY "File # 4 - "file_D
  IF qty_files>5 THEN SAY "File # 5 - "file_E
  IF qty_files>6 THEN SAY "File # 6 - "file_F
  IF qty_files>7 THEN SAY "File # 7 - "file_G
  IF qty_files>8 THEN SAY "File # 8 - "file_H
  IF qty_files>9 THEN SAY "File # 9 - "file_I
  IF qty_files>10 THEN SAY "File # 10 - "file_J

  CALL FILE_NAME_CONFIRM

RETURN


FILE_NAME_CONFIRM:

  ans=ZocMsgBox("Is the list of files shown correct?", 2)
  IF ans="##NO##" THEN CALL FIX_FILE_NAMES

RETURN


PROBLEM:
   CALL ZocHangup
   CALL ZocMsgBox "Something went wrong", 1
   EXIT
