//
//"This sample program is provided AS IS and may be used, executed, copied and modified without royalty payment by customer (a) for its own //instruction and study, (b) in order to develop applications designed to run with an IBM WebSphere product, either for customer's own internal use //or for redistribution by customer, as part of such an application, in customer's own products. " 
//
//Product 5630-A36,  (C) COPYRIGHT International Business Machines Corp., 2003
//All Rights Reserved * Licensed Materials - Property of IBM
//


import java.sql.*;
import java.util.*;
import java.net.*;
import java.io.*;


/**
 * @author Tom Krieger
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class Populate {
	
  private final static int MAX_FILE_SIZE = 1000000;
  private Connection con_                = null;
  //private DirTree    dirTree_            = null;
  
  public Populate() {}

  
  private static final String[] invids = { "F0001","F0002", "F0003", "F0004",
      "F0005", "F0006", "F0007", "F0008", "F0009", "F0010", "F0011", "F0012",
      "F0013", "F0014", "F0015", "F0016", "F0017", "F0018", "F0019", "F0020",
      "A0001", "A0002", "A0003", "A0004", "A0005", "A0006", "A0007", "A0008", 
      "A0009", "A0010", "A0011",
      "T0001", "T0002", "T0003", "T0004", "T0005",
      "V0001", "V0002", "V0003", "V0004", "V0005", "V0006", "V0007" };
  
  private static final String[] filenames = { "flower_african_orchid.jpg", 
      "flower_bbreath.jpg", "flower_black-eyed_susan.jpg", "flower_coleus.jpg",
      "flower_daisies.jpg", "flower_foxglove.jpg", "flower_geranium.jpg",
      "flower_goodnight_moon_iris.jpg", "flower_impatiens.jpg", "flower_lily.jpg",
      "flower_pansies.jpg", "flower_petunias.jpg", "flower_primrose.jpg",
      "flower_red_poinsettia.jpg", "flower_red_rose.jpg", "flower_sparkler_celosia.jpg",
      "flower_tulips.jpg", "flower_white_poinsettia.jpg", "flower_white_rose.jpg",
      "flower_zinnia.jpg", "accessories_bulbdigger.jpg", "accessories_birdfeeder.jpg",
      "accessories_birdhouse.jpg", "accessories_finchfood.jpg", 
      "accessories_grassrake.jpg", "accessories_leafrake.jpg", "accessories_shovel.jpg",
      "accessories_gloves.jpg", "accessories_handrake.jpg", "accessories_pot.jpg",
      "accessories_wheelbarrow.jpg", "trees_ash.jpg",
      "trees_aspen.jpg", "trees_bonsai.jpg", "trees_crab.jpg", "trees_maple.jpg",
      "veggies_cabbage.jpg", "veggies_gourds.jpg", "veggies_grapes.jpg", "veggies_onion.jpg",
      "veggies_pineapple.jpg", "veggies_strawberries.jpg", "veggies_watermelon.jpg" };
      
      public void init(String uid, String pw) throws SQLException {

     try
     {

        // Need to include db2java.zip in the classpath
        Class.forName("COM.ibm.db2.jdbc.app.DB2Driver").newInstance();
     }
     catch(Exception e)
     {
       System.out.println("JDBC  DB2 driver failed to load");
       e.printStackTrace ();
       return;
     }

	 /**
	  * Create connection to PLANTSBY database
	  */
     System.out.println("connecting to database using driver");
     //con_ = DriverManager..getConnection("jdbc:db2",uid,pw);
     try {
     con_ = DriverManager.getConnection("jdbc:db2:PLANTSBY",uid,pw);
     }
     catch (SQLException e) {
     	System.out.println("Unable to connect to database PLANTSBY: " + e.getMessage());
     }
     

     Statement stmt = con_.createStatement ();    
     
     /**
      * Create Tables
      */
     try {
     	stmt.execute("CREATE TABLE CUSTOMER (CUSTOMERID VARCHAR(250) NOT NULL,PASSWORD VARCHAR(250),FIRSTNAME VARCHAR(250),LASTNAME VARCHAR(250),ADDR1 VARCHAR(250),ADDR2 VARCHAR(250),ADDRCITY VARCHAR(250),ADDRSTATE VARCHAR(250),ADDRZIP VARCHAR(250),PHONE VARCHAR(250))");
     	stmt.executeUpdate("ALTER TABLE CUSTOMER ADD CONSTRAINT PK_CUSTOMER PRIMARY KEY (CUSTOMERID)");
     	System.out.println("CUSTOMER table created");
     }
     catch(SQLException e) {
     	System.out.println("Unable to create CUSTOMER table: " + e.getMessage());
     }
     try {
     	stmt.execute("CREATE TABLE INVENTORY (INVENTORYID VARCHAR(250) NOT NULL,NAME VARCHAR(250),HEADING VARCHAR(250),DESCRIPTION VARCHAR(250),PKGINFO VARCHAR(250),IMAGE VARCHAR(250),IMGBYTES BLOB(1000000),PRICE REAL NOT NULL,COST REAL NOT NULL,CATEGORY INTEGER NOT NULL,QUANTITY INTEGER NOT NULL,NOTES VARCHAR(250),ISPUBLIC INTEGER NOT NULL)");
     	stmt.executeUpdate("ALTER TABLE INVENTORY ADD CONSTRAINT PK_INVENTORY PRIMARY KEY (INVENTORYID)");
     	System.out.println("INVENTORY table created");
     }
     catch(SQLException e) {
     	System.out.println("Unable to create INVENTORY table: " + e.getMessage());
     }
     try {
     	stmt.execute("CREATE TABLE ORDERINFO ( orderID VARCHAR(251) NOT NULL, sellDate VARCHAR(100), customerID VARCHAR(251), billName VARCHAR(251), billAddr1 VARCHAR(251),  billAddr2 VARCHAR(120), billCity VARCHAR(120), billState VARCHAR(4), billZip VARCHAR(30), billPhone VARCHAR(100), shipName VARCHAR(251), shipAddr1 VARCHAR(251), shipAddr2 VARCHAR(120), shipCity VARCHAR(120), shipState VARCHAR(4), shipZip VARCHAR(30), shipPhone VARCHAR(100), creditCard VARCHAR(251), ccNum VARCHAR(24), ccExpireMonth VARCHAR(251), ccExpireYear VARCHAR(251), cardHolder VARCHAR(251), shippingMethod INTEGER, profit FLOAT, PRIMARY KEY (orderID))");
     	System.out.println("ORDERINFO table created");
     }
     catch(SQLException e) {
     	System.out.println("Unable to create ORDERINFO table: " + e.getMessage());
     }
     try {
     	stmt.execute("CREATE TABLE ORDERITEMS ( orderID VARCHAR(251) NOT NULL, inventoryID VARCHAR(50), name VARCHAR(251), pkginfo VARCHAR(251), price FLOAT, cost FLOAT, category INTEGER, quantity INTEGER, sellDate VARCHAR(251), indx INTEGER NOT NULL, PRIMARY KEY (orderID, indx))");
     	System.out.println("ORDERITEMS table created");
     }
     catch(SQLException e) {
     	System.out.println("Unable to create ORDERITEMS table: " + e.getMessage());
     }
     
     
     /**
      * Populate INVENTORY table with text
      */
     System.out.println("Populating INVENTORY table with text...");
     try {
     	stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0001', 'African Orchid', 'Rare Delicate Beauty', 'African orchids are some of the most endangered and rare kinds of orchids grown today. This variety is medium yellow with varigated salmon and pink insides. Height: 18 to 28 inches.', 'per plant', 'flower_african_orchid.jpg', 250.00, 145.00, 100, 0, 'NOTES and stuff', 1)");
     	stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0002', 'Baby Breath', 'Ethereal White Elegance', '(Gypsophila muralis). Small, delicate Baby Breath flowers create clouds of accents in floral arrangements or beautiful lacy designs when used alone. Can be used fresh or dried. Height: 12 to 18 inches.', '2 plants', 'flower_bbreath.jpg', 6.00, 2.00, 100, 0, 'NOTES and stuff', 1)");
     	stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0003', 'Black-eyed Susan', 'Radiant, like the Sun', '(Rudbeckia hirta). The Black-Eyed Susan was made the official Maryland flower in 1918.  Typically they grow wild -- and bloom between May and August -- but you can purchase them as a permanent addition to your own garden. Height: 2 to 3 feet.', '2 plants', 'flower_black-eyed_susan.jpg', 9.00, 2.00, 100, 0, 'NOTES and stuff', 1)");
     	stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0004', 'Coleus', 'Colorful Accent', '(Coleus blumei). An attractive foliage plant, the Coleus is especially suited for containers and underplantings. While it can tolerate the sun, the color of leaves is enhanced in partial to full shade. Height: 12 inches to 36 inches.', '4 plants', 'flower_coleus.jpg', 8.00, 3.00, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0005', 'Yellow Shasta Daisy', 'Charming Simple Beauty', '(Bellis perenis). Oversized blossoms in bright yellow with a very long bloom period. For extra decoration, cut the stems and place in food coloring and water to make vibrantly colored cut flowers. Height: 1 to 3 feet.', '2 plants', 'flower_daisies.jpg', 16.00, 2.50, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0006', 'Perennial Foxglove', 'Showy Thimble-like Blooms', '(Digitalis). Foxglove grows best in shade and works well as a tall, showy flower that lights up a dark garden area. The individual flowers are sized and shaped like thimbles. Height: 2 to 3 feet.', '3 plants', 'flower_foxglove.jpg', 12.00, 2.75, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0007', 'Geranium', 'Red and Flowery', '(Geranium sanguineum). This bright red version of the Bloody Cranesbill Geranium has small, bright green foliage that adds dimension and sets off the vibrant colored flowers. Assembled. Height: 8 inches.', 'per plant', 'flower_geranium.jpg', 8.00, 2.30, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0008', 'Goodnight Moon Iris', 'Fluorescent Bloomer', 'Iris provides lovely cut flowers which brighten rainy spring days. When the Iris has stopped blossoming, cut off dead blossoms and dead bloom stalks, but do not cut back the leaves until they begin to turn brown in the Fall.', '5 bulbs', 'flower_goodnight_moon_iris.jpg', 7.50, 3.60, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0009', 'Impatiens', 'Tangerine Dream', '(Impatiens walleriana). Vibrant tangerine-orange flowers coordinate nicely with green foliage. Impatiens is a great annual for beds, borders, containers and hanging baskets. Grow in full sun to partial shade.  Height: 15 to 20 inches.', '2 plants', 'flower_impatiens.jpg', 9.95, 1.25, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0010', 'Lily', 'Purple Summer Glory', '(Hemerocallis fulva) Magnificent flowers up to 3 inches or more across. Blooms start June through August, depending on variety, and have a subtle fragrance. Tolerates dry soil but it is wise to water deeply during periods of dry weather.', '4 bulbs', 'flower_lily.jpg', 6.50, 3.25, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0011', 'Pansy', 'Autumn Mix', '(Viola tricolor). Reminiscent of the colors of fall.  Our Pansies will bloom from fall to early winter, and again in the spring! They prefer part shade to full sun. Height 6 to 8 inches.', '1 pkt. (25 seeds)', 'flower_pansies.jpg', 2.00, 1.25, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0012', 'Petunia', 'Striped Brightness', '(Petunia x hybrida). Striking, large magenta flowers with contrasting white trumpet stripes. Excellent for borders, window boxes, planters and bouquets.  Petunias do best in full sun but will tolerate light shade. Height: 1 foot.', '1 pkt. (50 seeds)', 'flower_petunias.jpg', 3.00, 1.25, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0013', 'Primrose', 'Means: I Cannot Live Without You', '(Primula). Large, fragrant blooms in wide-eyed spring like yellow. Plants thrive despite heat and drought and require good drainage. Height: 12 inches.', '6 plants', 'flower_primrose.jpg', 10.00, 4.75, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0014', 'Red Poinsettia', 'Seasonal Beauty', '(Euphorbia pulcherrima). Lush red flowers float atop deep green leaves. They were first developed in Mexico and need warm temperatures and full sun. Height: 2 to 3 feet.', 'per plant', 'flower_red_poinsettia.jpg', 11.00, 4.50, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0015', 'Red Rose', 'Always in Bloom', '(Rosa Floribunda). Created in France (1956), this rose continually produces boldly colored, medium-sized red blooms.  Intensely fragrant. Includes thorns and songs about lost love. Height: 10 - 12 feet.', 'per vine', 'flower_red_rose.jpg', 32.00, 15.00, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0016', 'Sparkler Celosia', 'Brilliant Flames of Red Fire', '(Celosia plumosa). Excellent for cutting, these Sparkler Celosia have brilliant 6 inch plumes. They are a perfect companion for full-sun garden beds or in fresh or dried bouquets. Height: 2 to 2.5 feet.', '4 plants', 'flower_sparkler_celosia.jpg', 7.00, 3.25, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0017', 'Tulip', 'Mixed Dutch Delight', '(Tulipa). Out famous tulip bulbs are supplied by one of the finest Dutch bulb growers. Mixed colors resonate on even the cloudiest of days. These bulbs are of the highest quality and are guaranteed. Height: 10 to 12 inches.', '10 bulbs', 'flower_tulips.jpg', 17.00, 9.00, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0018', 'White Poinsettia', 'Seasonal Simplicity', '(Euphorbia pulcherrima). A rich color of deep green leaves support large bright white blossoms. Poinsettias were first developed in Mexico and need full sun. Height: 2 to 3 feet.', 'per plant', 'flower_white_poinsettia.jpg', 14.00, 5.50, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0019', 'White Rose', 'A Classic Beauty', '(Rosa Floribunda).  Classic, white buds open into double blooms of palest pink to white on this rose created in 1888 France. Thornless. Height: 4 to 5 feet.', 'per vine', 'flower_white_rose.jpg', 37.00, 17.00, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('F0020', 'Zinnia', 'You cut more, they bloom more!', '(Zinnia elegans). Zinnias add bold, vibrant color to gardens. They are heat loving and prefer full-sun. Perfect for beds and cut floral arrangements. They even attract butterflies! Height: 12 to 18 inches.', '12 plants', 'flower_zinnia.jpg', 7.95, 3.95, 100, 0, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0001', 'Bulb Digger', 'Pick The Right Tool For The Right Job', 'Simplifies digging holes for poles, posts, and many other jobs. Tempered steel even breaks through rock. Long, coated 54 inch hardwood handle.', 'Assembled', 'accessories_bulbdigger.jpg', 12.00, 5.00, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0002', 'Birdfeeder', 'Birds of a Feather Feed Together', 'Hexagon shaped bird feeder stores food upright which allows more birds to feed and gives you the best view! Natural wood base supports clear plastic lenses on all 5 sides. Ready to be hung or mounted on a pole (not included).', 'Pole not included', 'accessories_birdfeeder.jpg', 16.00, 7.00, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0003', 'Birdhouse', 'Ideal for Nesting Birds', 'Wooden birdhouse perfect for nesting birds and their companions. Made of naturally weather resistant pine with a sloped roof. Mounting hardware and instructions included. Height: 18 inches. Width: 10 inches.', 'Assembled', 'accessories_birdhouse.jpg', 12.00, 6.00, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0004', 'Finch Food', 'Attracts Fabulous Finches', 'Bird feed especially formulated for finches, as well as other small birds. No seeds are wasted; birds will like them all.', '20 lb. bag', 'accessories_finchfood.jpg', 6.50, 2.00, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0005', 'Grass Rake', 'Put the Kids to Work', 'Welded bow rake is heat treated for strength. Long, coated 54 inch hardwood handle. Use it to level and break up clumps of soil, remove debris, and spread topsoil or compost. 5 year limited warranty.', 'Assembled', 'accessories_grassrake.jpg', 6.00, 2.50, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0006', 'Leaf Rake', 'The Ultimate Backscratcher', 'Wooden polyurethene coated handle adjusts is 32 inches long. Comfortable grip. Fully heat treated head and chip resistant carbon dioxide coating make this rake last for years.', 'Assembled', 'accessories_leafrake.jpg', 10.00, 4.50, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0007', 'Shovel', 'Dig it, Man!', 'Open back tempered steel blade attached to sturdy hardwood handle with 6 inch lead.  Uses include: planting shrubs, trees, and general digging or cutting through sod or soil. Handle Length: 46 inches', 'Assembled', 'accessories_shovel.jpg', 7.00, 3.00, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0008', 'Gloves', 'If The Gloves Fit, You Must Plant It', 'One size fits all.  Each carefully sewn left glove comes with an accompanying right glove. Comes in pack of 3, with colors red, green, and blue.', '3 pairs per pack', 'accessories_gloves.jpg', 4.50, 1.00, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0009', 'Hand Rake', 'A Real Humdinger', 'Sometimes you have to work on your hands and knees. This tool is great for raking, digging, whatever. Handle is cushioned with rubber.', 'Assembled', 'accessories_handrake.jpg', 4.50, 1.50, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0010', 'Large Pot', 'Large and, well, just Large', 'Large ceramic pot perfect for bigger plants that need to be moved in during frosts. Diameter of 18 inches - holds 5 gallon plants.', 'N/A', 'accessories_pot.jpg', 10.00, 3.00, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('A0011', 'Wheelbarrow', 'Just like Grandpa used to have!', 'Shiny red wheelbarrow with epoxy coated steel bin and wooden handles. Tire is solid with thick treads that grip rough, wet surfaces. Large capacity - 3 Cu.Ft. capacity, 150 Lb. maximum load', 'Assembled', 'accessories_wheelbarrow.jpg', 29.00, 12.00, 100, 3, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('T0001', 'Ash', 'Full and Leafy like a Lollipop', 'Large, round, summer shade leads to yellow leaves that burst through dreary Fall days! Excellent for yards. Mature height: up to 20 feet.', '10 gallon seedling', 'trees_ash.jpg', 50.00, 20.00, 100, 2, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('T0002', 'Aspen', 'Tall, Slender Grace', 'White barked Aspens are particularly beautiful during white winters. Close your eyes and imagine a light breeze sailing over the trunk and the crinkling of the colliding leaves. Mature height: up to 28 feet.', '10 gallon seedling', 'trees_aspen.jpg', 53.00, 21.00, 100, 2, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('T0003', 'Bonsai', 'Tabletop Fun', 'Bonsais are great miniature replicas of your favorite yard tree. They can be indoors or out -- and their size makes them perfect for tabletop decoration.', '0.5 gallon mature tree', 'trees_bonsai.jpg', 30.00, 12.00, 100, 2, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('T0004', 'Crabapple', 'Short but beautiful', 'These trees light up Springtime with pink, fragrant flowers that change into crabapples.  Perfect for Maryland residents. Mature height: up to 20 feet.', '10 gallon seedling', 'trees_crab.jpg', 57.00, 19.00, 100, 2, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('T0005', 'Maple', 'Traditional Shade Producer', 'Famous for their syrup, you will be able to tap into your own endless supply in just a few years. Not suitable for diabetics. Mature height: up to 24 feet.', '10 gallon seedling', 'trees_maple.jpg', 45.00, 22.00, 100, 2, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('V0001', 'Cabbage', 'Crispy', 'Crispy green cabbage will poke through summer gardens about 3-4 weeks after springtime planting of seedlings. An excellent source of Vitamin A and D.', '1 pkt. (100 seeds)', 'veggies_cabbage.jpg', 2.00, .70, 100, 1, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('V0002', 'Ornamental Gourd', 'Gourd-geous!', 'OrNAMEntal gourds are a staple for Autumn flowerbeds, door decorations, floral arrangements and tabletop centerpieces. Grow your own this year to give to your neighbors and family.', '1 pkt. (100 seeds)', 'veggies_gourds.jpg', 1.50, .70, 100, 1, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('V0003', 'Grapes', 'Be Your Own Winemaker', 'Join others who are fermenting their own small, personal batches of wine! These vines were developed in France and their grapes make a fruity, medium white wine or a fruity Beaujolais when pressed with the skins.', '1 vine', 'veggies_grapes.jpg', 49.00, 20.50, 100, 1, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('V0004', 'Onion', 'Fresh and Tasty from your Garden', 'Pure white onions are sweetest when grown at home and left in the ground until picking. Tissues not included.', '4 bulbs', 'veggies_onion.jpg', 9.00, 4.75, 100, 1, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('V0005', 'Pineapple', 'Tropical Delight', 'Pineapples can be grown at home with this frost-bearing breed. Yields 4 - 5 fruits annually, more in warmer climates. Fertilize with organic compost regularly for best results. Be careful of maurading neighbors.', '8 gallon potted plant', 'veggies_pineapple.jpg', 87.00, 34.50, 100, 1, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('V0006', 'Strawberries', 'Sweet Berry Scrumptiousness', 'Our brand is known for producing plump, sweet strawberries by the mid-June bucketful. Now you can grow them easily, with relatively little care, due to our patented version. Dental floss not included.', '1 pkt. (50 seeds)', 'veggies_strawberries.jpg', 3.50, 1.50, 100, 1, 'NOTES and stuff', 1)");
		stmt.executeUpdate(" INSERT INTO INVENTORY (INVENTORYID, NAME, HEADING, DESCRIPTION, PKGINFO, IMAGE, PRICE, COST, QUANTITY, CATEGORY, NOTES, ISPUBLIC) VALUES ('V0007', 'Watermelon', 'Seedless Summer ', 'Plant our seeds indoors in late winter and transfer outside after threat of frost recedes; our seeds will produce huge, round, ripe melons by mid-June. Guaranteed not to contain active Acidophilous cultures.', '1 pkt. (100 seeds)', 'veggies_watermelon.jpg', 2.00, .50, 100, 1, 'NOTES and stuff', 1)");
     	System.out.println("INVENTORY table populated with text...");
     }
     catch (SQLException e) {
     	System.out.println("Unable to populate INVENTORY table with text data: " + e.getMessage());
     }
     
     
     
                                                   
     //stmt.executeQuery("create table FILES (name VARCHAR(255) NOT NULL, picBlob BLOB(20M) NOT NULL, PRIMARY KEY (name))");
     
  }
  
  public void run() throws SQLException, FileNotFoundException
  {

     /**
      * Add the images to the INVENTORY table
      */ 
     int i=0;
     
    try {
     	
     for (i = 0; i < invids.length; i++)
     {
        String invID = invids[i];
        String fileName = filenames[i];

        //System.out.println("<p><a href=\""+fileName+"\">"+fileName+"</a>");
        PreparedStatement stmt = con_.prepareStatement("UPDATE INVENTORY SET IMGBYTES = ? WHERE INVENTORYID = ?");
        
        //PreparedStatement stmt = con_.prepareStatement("INSERT INTO INVENTORY (INVENTORYID, picBlob) VALUES(?,?)");
        
        // create prepared statement
        System.out.println("Adding file:" + fileName + " to table INVENTORY");
        stmt.setBinaryStream(1,new FileInputStream(fileName),MAX_FILE_SIZE);
        stmt.setString(2,invID);
        stmt.executeUpdate();
        stmt.close();
     }
   }
   catch(SQLException e) {
     System.out.println("SQL Error adding image " + filenames[i] + " to table INVENTORY: " + e.getMessage());
   }
   catch(FileNotFoundException e) {
   	System.out.println("FileNotFoundException adding image " + filenames[i] + " to table INVENTORY: " + e.getMessage());
   }
    
  }
  
  public void term()
  {
     try
     {
        con_.close();
     }
     catch (Exception e)
     {
        e.printStackTrace();
     }
  }



  public static void main(String[] args) {
  	
  	if (args.length < 2) {
  		System.out.println("Incorrect number of command line arguments");
  		System.out.println("Usage: populate <db2 uid> <db2 pw>");
  		return;
  	}
  	
  	Populate populate = new Populate();
     
     try
     {
        populate.init(args[0], args[1]);
        populate.run();
        System.out.println("disconnect....closing connection");
        populate.term();
     }
    
     catch(FileNotFoundException e)
     {
        System.out.println("File not found");
     }                                       
     catch(SQLException e)
     {
        e.printStackTrace();
        System.out.println("Failed to connect to the database");
        System.out.println(e);
        System.exit(-1);
     }
     finally
     {
        populate.term();
     }






  }

  
  
  
}
  
  
  

