/*
 * include file for use with xver7nl.dll, version 7 FTN nodelist lookup
 * dynamic link library for OS/2 1.x and 2.x
 *
 * Notes:  This code uses environment variable XNODELIST to find the path
 * to the version 7 nodelist.  If not set, directory ".\\NODELIST" is
 * used.  This ain't gonna work (except for parse_address) without a
 * version 7 nodelist around.
 *
 * When doing sysop lookup, put the desired domain in the SHORTADDR
 * structure; it'll be used to determine which SYSOP.NDX file to look
 * into.  That works like this:  if the domain is "Fidonet" OR the domain
 * is blank, file SYSOP.NDX is used.  Otherwise, file domain.SDX is used.
 *
 * When doing address lookups, if domain is blank OR "Fidonet" the
 * file NODEX.NDX is used, otherwise the file domain.NDX is used.
 *
 * Variable phone in V7findnode and V7findsysop is used as a buffer into which
 * to copy the phone number of the node, if found.  These two functions are
 * provided for systems that just want to use the nodelist as a phone book
 * of sorts.  Functions V7ver7find and V7find_in_sysopndx are more what a
 * full mailer would use.
 *
 * I place no copyright upon this DLL.  It's based on code by Vince
 * Perriello which is in turn based on code by Scott Samet which is
 * in turn based on code by Phil Becker which is in turn based on work
 * done by Doug Boone which is in turn based on the Mix Database Toolchest.
 * Or something like that.  Use at your own risk.
 *
 * See additional notes at the "32-bit" declarations of the individual
 * functions below.  This DLL is 16-bit MSC 6.0a code, and going 32-bit
 * would not speed it up perceptibly, but would reduce its "portability."
 */

#pragma pack(1)

/*------------------------------------------------------------------------*/
/* Values for the `flags' field                                           */
/*------------------------------------------------------------------------*/
#define B_hub    0x0001  /* node is a net hub     0000 0000 0000 0001 */
#define B_host   0x0002  /* node is a net host    0000 0000 0000 0010 */
#define B_region 0x0004  /* node is region coord  0000 0000 0000 0100 */
#define B_zone   0x0008  /* is a zone gateway     0000 0000 0000 1000 */
#define B_CM     0x0010  /* runs continuous mail  0000 0000 0001 0000 */
#define B_res1   0x0020  /* reserved by Opus      0000 0000 0010 0000 */
#define B_res2   0x0040  /* reserved by Opus      0000 0000 0100 0000 */
#define B_res3   0x0080  /* reserved by Opus      0000 0000 1000 0000 */
#define B_res4   0x0100  /* reserved by Opus      0000 0001 0000 0000 */
#define B_res5   0x0200  /* reserved for non-Opus 0000 0010 0000 0000 */
#define B_res6   0x0400  /* reserved for non-Opus 0000 0100 0000 0000 */
#define B_res7   0x0800  /* reserved for non-Opus 0000 1000 0000 0000 */
#define B_point  0x1000  /* node is a point       0001 0000 0000 0000 */
#define B_res9   0x2000  /* reserved for non-Opus 0010 0000 0000 0000 */
#define B_resa   0x4000  /* reserved for non-Opus 0100 0000 0000 0000 */
#define B_resb   0x8000  /* reserved for non-Opus 1000 0000 0000 0000 */

/*------------------------------------------------------------------------*/
/* Values for the `modem' field                                           */
/*------------------------------------------------------------------------*/
#define M_HST      0x01    /* node uses an HST                  0000 0001 */
#define M_PEP      0x02    /* node uses a PEP modem             0000 0010 */
#define M_V42b     0x04    /* node uses a V.42b modem           0000 0100 */
#define M_V42      0x08    /* node uses a V.42 modem            0000 1000 */
#define M_H96      0x10    /* node uses a Hayes V9600           0001 0000 */
#define M_V29      0x20    /* node uses a V.29 modem            0010 0000 */
#define M_V32      0x40    /* node uses a V.32 modem            0100 0000 */
#define M_V33      0x80    /* node uses a V.33 modem            1000 0000 */

  typedef struct {
    USHORT   node;          /* node number  */
    USHORT   net;           /* net number   */
  } NODEIDX;

  /* how it really looks in the file */
  typedef struct {
    USHORT net;         /* net number */
    USHORT node;        /* node number, */
    SHORT  cost;        /* cost per minute to call */
    CHAR   name[34];    /* node name */
    CHAR   phone[40];   /* phone number */
    CHAR   city[30];    /* city and state, */
    CHAR   password[8]; /* warning, not necessarily null terminated */
    SHORT  realcost;    /* phone company's charge */
    USHORT hubnode;     /* node # of this node's hub or 0 if none */
    UCHAR  rate;        /* actual baud rate divided by 300 */
    CHAR   modem;       /* modem type code (see above) */
    USHORT flags;       /* set of flags (see above) */
    SHORT  reserved;    /* reserved */
  } REAL_NODEINFO;

  /* how the DLL presents it (C-friendly) */
  typedef struct {
    USHORT net;         /* net number */
    USHORT node;        /* node number, */
    SHORT  cost;        /* cost per minute to call */
    CHAR   name[34];    /* node name */
    CHAR   phone[40];   /* phone number */
    CHAR   city[30];    /* city and state, */
    CHAR   password[9]; /* necessarily null terminated */
    SHORT  realcost;    /* phone company's charge */
    USHORT hubnode;     /* node # of this node's hub or 0 if none */
    UCHAR  rate;        /* actual baud rate divided by 300 */
    CHAR   modem;       /* modem type code (see above) */
    USHORT flags;       /* set of flags (see above) */
    SHORT  reserved;    /* reserved */
  } NODEINFO;

  /* how addresses are represented to/from the DLL */
  typedef struct {
    USHORT zone;
    USHORT net;
    USHORT node;
    USHORT point;
    CHAR   domain[128];
  } SHORTADDR;

/* declarations for accessible functions */

#ifdef __32BIT__

/* returns non-zero on success, fills in phone */
USHORT APIENTRY16 V7findnode(SHORTADDR * _Seg16 addr,CHAR * _Seg16 phone);

/* returns non-zero on success, fills in addr, maybe phone */
USHORT APIENTRY16 V7findsysop(CHAR * _Seg16 name,SHORTADDR * _Seg16 addr,
                              CHAR * _Seg16 phone);

/* returns NULL on failure, else pointer to filled-in addr */
SHORT APIENTRY16 V7find_in_sysopndx (CHAR * _Seg16 name,
                                     SHORTADDR * _Seg16 addr);

/* returns NULL on failure, else pointer to filled-in nif */
SHORT APIENTRY16 V7ver7find (NODEINFO * _Seg16 nif,USHORT zone,
                             USHORT point,CHAR * _Seg16 domain);

/* returns non-zero on success, fills in r from address string
 * note:  it can be fooled, as it allows partial addresses (down to just
 * a node number) so that you can pre-fill the r struct with your own
 * address and override only parts from the address string.
 */
USHORT APIENTRY16 V7parse_address (CHAR * _Seg16 *address,
                                   SHORTADDR * _Seg16 r);

#else

SHORT  _export EXPENTRY V7find_in_sysopndx (CHAR *name,SHORTADDR *addr);
SHORT  _export EXPENTRY V7ver7find (NODEINFO *nif,USHORT zone,
                                        USHORT point,CHAR *domain);
USHORT _export EXPENTRY V7findnode (SHORTADDR *addr,CHAR *phone);
USHORT _export EXPENTRY V7findsysop (CHAR *name,SHORTADDR *addr,CHAR *phone);
USHORT _export EXPENTRY V7parse_address (CHAR *ad, SHORTADDR *r);

#endif

#pragma pack()

