/*
 * Basic XModem & YModem file protocols
 */

#define USE_TIME_MACROS

#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include "mailer.h"
#include "bbs.h"
#include "transfer.h"
#include "modem.h"
#include "timers.h"
#include "keys.h"
#include "xmisc.h"
#include "window.h"
#include "xbbs.h"

  extern unsigned int crctab[];
  extern HWND         xdhwnd;
  extern MDM          *modems[MAXINSTANCES];
  extern int          *_threadid;


#define GMODE  (flags & 8)
#define YMODEM (flags & 4)
#define HUMAN  (flags & 1)
#define ONEKOK (flags & 2)
#define GMODEOFF(x) (x &= (~8))


void _fastcall cancel_transfer (USHORT cp) {

  com_write(cp,"\x18\x18\x18\x18\x18\x18\x18\x18\b\b\b\b\b\b\b\b",16);
}


char * _fastcall ymodem_packet (char *filename,char *pkt,int handle) {

  /* build a ymodem block 0 */

  char    *p,*pp;
  time_t  t;

  memset(pkt,0,128);                  /* nul out block */
  p = filename;
  while((p = strchr(p,'/')) != NULL)  /* strip path */
    *p = '\\';
  p = strrchr(filename,'\\');
  if(!p) {
      p = strrchr(filename,':');
    if(!p)
      p = filename;
    else
      p++;
  }
  else
    p++;
  strcpy(pkt,p);                     /* filename first */
  p = &pkt[strlen(pkt) + 1];         /* size pos */
  pp = p;
  strcpy(p,ultoa(filelength(handle),pp,10));
  while(*p)
    p++;
  t = unixgetftime(handle);
  if(t != -1) {
    *p = ' ';
    p++;                             /* date pos */
    pp = p;
    strcpy(p,ultoa(t,pp,8));
    while(*p)
      p++;
  }
  return pkt;
}


static int _fastcall send_yblock (USHORT cp,int handle,char *filename,
                                  int ucrc) {

  /* build and send a ymodem headerblock */

  GENBLK xmblk;
  int    blksize = 128;

  xmblk.soh = SOH;
  xmblk.blk = 0;
  xmblk.blkcmp = (char)(xmblk.blk ^ 255);
  ymodem_packet(filename,xmblk.data,handle);
  if(ucrc) {                                        /* calc crc */

    register USHORT crc = 0;
    register char   *ptr = xmblk.data;
    register int    count = blksize;
    USHORT          temp;

    while(count--)
      crc = (crc << 8) ^ crctab[(crc >> 8) ^ *ptr++];
    crc = ((crc & 255) << 8) | ((crc >> 8) & 255);  /* swap byte order */
    temp = crc;
    memcpy(&xmblk.data[blksize],&temp,2);
  }
  else {                                            /* calc csum */

    register char *ptr = xmblk.data,csum = 0;
    register int  count;

    for(count = 0;count < blksize;count++)
      csum += *ptr++;
    xmblk.data[blksize] = csum;
  }

  com_write(cp,(char *)&xmblk,3 + blksize + 1 + (ucrc != 0));  /* send it */
  return 0;
}


static int _fastcall send_xblock (USHORT cp,int handle,char blknum,
                                  int ucrc,int blksize) {

  /* build and send an xmodem datablock */

  GENBLK xmblk;
  int    error;

  if(eof(handle) != 0) {
    com_putc(cp,EOT);
    if(modems[cp]->debugtrans)
      logfunc(1,cp,"Sending EOT");
    return BLKEOF;
  }

  xmblk.soh = (char)((blksize == 128) ? SOH : STX);
  xmblk.blk = blknum;
  xmblk.blkcmp = (char)(xmblk.blk ^ 255);

  error = read(handle,xmblk.data,blksize);
  if(error < 0)
    return FILEERROR;                             /* read error */
  if(error == 0) {
    com_putc(cp,EOT);
    if(modems[cp]->debugtrans)
      logfunc(1,cp,"Sending EOT");
    return BLKEOF;
  }

  if(error < blksize)
    memset(&xmblk.data[error],0x1a,blksize - error);  /* eof */
  if(ucrc) {                                      /* calc crc */

    register USHORT crc = 0;
    register char   *ptr = xmblk.data;
    register int    count = blksize;
    USHORT          temp;

    while(count--)
      crc = (crc << 8) ^ crctab[(crc >> 8) ^ *ptr++];
    crc = ((crc & 255) << 8) | ((crc >> 8) & 255);  /* swap byte order */
    temp = crc;
    memcpy(&xmblk.data[blksize],&temp,2); /* append crc */
  }
  else {                                          /* calc csum */

    register char *ptr = xmblk.data,csum = 0;
    register int  count;

    for(count = 0;count < blksize;count++)
      csum += *ptr++;
      xmblk.data[blksize] = csum;
  }

  com_write(cp,(char *)&xmblk,3 + blksize + 1 + (ucrc != 0));  /* send it */
  return ((eof(handle) == -1) ? FILEERROR : 0);
}


long _fastcall send_xfile (USHORT cp,char *filename,int flags,int *error) {

  /* send a file via XModem.  return size of file sent (0 == failure).
   * any error explained by return in *error
   * bitmapped flags:
   * 1 = user on other end, wait longer to engage
   * 2 = 1K blocks okay
   * 4 = Ymodem being used
   * 8 = Ymodem-G being used
   */

  register int  ch;
  register long blocks = 0L;
  int           handle,ucrc = 0,retries = 0,thisnak = 0,blksize,no1k = 0,
                header = 0,done = 0,waitingeofack = 0,onenak = 0;
  long          filesize,lastpos = 0L,transerrs = 0L;
  char          blocknum = 1,misc[41];
  TRANSBUF      tbuf,*dupebuf;
  char          oldpri[2];

  *error = 0;

  if(!YMODEM)
    header = 1;

  modems[cp]->checkcd = 1;
  memset(&tbuf,0,sizeof(TRANSBUF));
  DosGetPrty(2,(PUSHORT)oldpri,*_threadid); /* get old priority */

  handle = sopen(filename,O_RDONLY | O_BINARY,SH_DENYNO); /* open send file */
  if(handle == -1) {
    *error = FILEERROR;
    logfunc(0,cp,"Can't open file \"%s\"",filename);
    return 0L;
  }

  filesize = filelength(handle);    /* log start of transfer to window */
  tbuf.filename = filename;
  tbuf.err = NULL;
  tbuf.errcount = 0L;
  tbuf.filesize = filesize;
  tbuf.bytessent = 0L;
  sprintf(misc,"%cModem%s",YMODEM ? 'Y' : 'X',GMODE ? "G" : "");
  tbuf.misc = misc;
  tbuf.type = TB_NAME;
  tbuf.started = time(NULL);
  dupebuf = memdupe(&tbuf,sizeof(tbuf));
  if(dupebuf)
    if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                   MPFROMP(dupebuf)))
      free(dupebuf);

  /* log start of transfer, set send priority */

  logfunc(0,cp,"%cModem%s-sending \"%s\"",YMODEM ? 'Y' : 'X',
            GMODE ? "G" : "",filename);
  DosSetPrty(2,modems[cp]->comm[0],modems[cp]->comm[1],*_threadid);

  /* do the work */

  if(HUMAN)
    DosSleep(5000L);

  ch = peek_at_byte(cp,0L);
  if(ch == LOSTCARRIER) {
    logfunc(0,cp,"Lost carrier");
    close(handle);
    return 0L;
  }
  if(ch > 0 && ch != 'C' && ch != 'G' && ch != NAK && ch != CAN)
    purge_in(cp);

  *error = 0;
  while(!done && !*error) {
    if(onenak) {          /* are we actually sending yet? */
      if(waitingeofack) {   /* done if we get an ACK now... */
        com_putc(cp,EOT);
        if(modems[cp]->debugtrans)
          logfunc(1,cp,"Sending EOT");
      }
      else {              /* still sending the file (or ymodem header) */
        if(!no1k && ONEKOK) {   /* set appropriate block size */
          if(filesize - lastpos > 1024L)
            blksize = 1024;
          else
            blksize = 128;
        }
        else
          blksize = 128;
        if(YMODEM && !header) {  /* ymodem block 0 */
          if(modems[cp]->debugtrans)
            logfunc(1,cp,"Sending YModem header...");
          blksize = 128;
          send_yblock(cp,handle,filename,ucrc);
          if(GMODE)
            header = 1;
        }
        else {
          if(modems[cp]->debugtrans)
            logfunc(1,cp,"Sending XModem datablock #%hu (%lu) %s blksize=%d retries=%d blknaks=%d pos=%ld",
                    blocknum,blocks,(ucrc) ? "CRC" : "CSum",blksize,retries,thisnak,
                    tell(handle));
          *error = send_xblock(cp,handle,blocknum,ucrc,blksize); /* send block */
          if(*error) {
            if(*error != BLKEOF) {
              filesize = 0L;
              break;
            }
            else {
              waitingeofack = 1;
              *error = 0;
            }
          }
        }
      }
    }
    /* check ack/nak/abort/carrier detect/etc. */
ReCheck:
    ch = get_modem_byte(cp,(GMODE && header && !waitingeofack) ? 0L :
                        (5000L + (HUMAN) ? 5000L : 0L));
    if(modems[cp]->debugtrans)
      logfunc(1,cp,"Received \"%c\" (%d)",(char)ch,ch);
    /* do what's required by receiver's command */
    /* first check special cases */
    if(!blocks) {   /* check for those pesky 'different' 1-time nakkers */
      if(ch == 'C') {        /* use CRC error correction */
        ucrc = 1;
        ch = NAK;
        if(YMODEM && !header)
          GMODEOFF(flags);     /* ensure no ymodem-g for this fool */
      }
      else if(ch == 'G' && GMODE) { /* ymodem-g starting? */
        ucrc = 1;
        ch = NAK;
      }
    }
    purge_in(cp);
    switch(ch) {
      case LOSTCARRIER:   /* fatal */
        tbuf.err = "Lost carrier";
        *error = ch;
        break;

      case ACK:         /* good block, send next */
        if(onenak) {    /* really sending yet? */
FakeACK:                /* Ymodem-G interruptus */
          if(((!YMODEM) || header) && !(blocks++ % 10)) {
            tbuf.type = TB_TICK;
            tbuf.bytessent = lastpos;
            dupebuf = memdupe(&tbuf,sizeof(tbuf));
            if(dupebuf)
              if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                             MPFROMP(dupebuf)))
                free(dupebuf);
          }
          thisnak = retries = 0;
          if(!YMODEM || header)        /* ACK on Ymodem header? */
            blocknum++;             /* no, inc block count */
          lastpos = tell(handle); /* and remember last file pos */
          header = 1;
          if(waitingeofack) { /* got ACK on EOT, we can die now... */
            if(modems[cp]->debugtrans)
              logfunc(1,cp,"Received ACK to EOT");
            done = 1;
          }
          else if(eof(handle) == -1) {
              *error = FILEERROR;
              tbuf.err = "File error";
              break;
          }
        }
        break;

      case NAK:           /* bad block, send "current" again */
        onenak = 1;       /* start real sending if we weren't */
        if(HUMAN)
          tbuf.started = time(NULL);
        retries = 0;
        lseek(handle,lastpos,SEEK_SET);
        waitingeofack = 0;
        tbuf.type = TB_ERR;
        if(thisnak++ > 15) {
          tbuf.err = "Too many NAKs on one block";
          *error = TIMEOUT;
          break;
        }
        else if(transerrs++ > modems[cp]->maxtranserrs) {
          tbuf.err = "Too many errors";
          *error = TIMEOUT;
          break;
        }
        else {
          if(thisnak > 3)
            no1k = 1;
          tbuf.err = "NAK";
          tbuf.errcount = transerrs;
        }
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        if(thisnak > 5 || transerrs > modems[cp]->maxtranserrs / 10L)
          no1k = 1;
        break;

      case CAN:         /* cancel, abort, fatal */
        if(peek_at_byte(cp,1000) == CAN) {    /* two CANs? */
          tbuf.err = "Cancelled by remote";
          *error = ch;
          break;
        }
        /* else intentional fallthru */
      default:          /* anything else causes retry and eventual timeout */
        if(ch == TIMEOUT) {
          if(GMODE /* && header && blocks */ &&
             !waitingeofack)  /* Ymodem-G and not eof */
            goto FakeACK;     /* or header, so pretend */
        }
        if(retries++ > 12) {
          tbuf.err = "Too many retries";
          *error = TIMEOUT;
        }
        else {
          if(ch == TIMEOUT)
            lseek(handle,lastpos,SEEK_SET);
          else            /* if not timeout, try waiting again... */
            goto ReCheck;
        }
        break;
    }
    purge_in(cp);
  }
  close(handle);
  DosSetPrty(2,oldpri[0],oldpri[1],*_threadid); /* return priority to normal */
  tbuf.misc = NULL;
  if(*error) {    /* log error */
    tbuf.type = TB_ABORT;
    logfunc(0,cp,"%cModem%s-send of \"%s\" failed.  Error = %d (%s)",
            YMODEM ? 'Y' : 'X',GMODE ? "G" : "",filename,*error,tbuf.err);
    filesize = 0L;
    cancel_transfer(cp);
  }
  else {          /* log success */
    tbuf.type = TB_TICK;
    tbuf.bytessent = lastpos + blksize;
    dupebuf = memdupe(&tbuf,sizeof(tbuf));
    if(dupebuf)
      if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                     MPFROMP(dupebuf)))
        free(dupebuf);
    tbuf.type = TB_FIN;
  }
  dupebuf = memdupe(&tbuf,sizeof(tbuf));
  if(dupebuf)
    if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                   MPFROMP(dupebuf)))
      free(dupebuf);
  DosSleep(333L);

  purge_in(cp);
  DosSleep(100L);
  Clear_UD();
  return filesize;
}


/* Next, XModem receive */

static int _fastcall get_xblkhdr (USHORT cp,char blkexp) {

  /*
   * get an xmodem block header
   * blkexp == expected block
   */

  char blk[2];
  int  c;

  c = get_modem_block(cp,blk,2,500L);
  if(c == TIMEOUT || c == LOSTCARRIER)
    return c;
  if((blk[0] & 255) != ((blk[1] & 255) ^ 255))
    return BLKMISMATCH;
  if((char)(blk[0] & 255) == blkexp)
    return 0;
  else if((blk[0] & 255) == blkexp - 1)
    return BLKMINUS1;
  else
    return BLKFATAL;  /* can't recover from this one */
}


static int _fastcall get_yblock (USHORT cp, char *pbuf, int ucrc,
                                 int blksize,long *filesize,
                                 char *filename) {

  /* get the data portion of a ymodem header block */

  register int     c;
  register char    csum,*buf = pbuf;
  USHORT           ourcrc,hiscrc;

  c = get_modem_block(cp,buf,blksize,1000L);
  if(c == LOSTCARRIER || c == TIMEOUT) {
    purge_in(cp);
    return c;
  }

  c = blksize;
  if(ucrc) {              /* calc CRC */
    ourcrc = 0;
    while(c--)
      ourcrc = (ourcrc << 8) ^ crctab[(ourcrc >> 8) ^ *buf++];
    ourcrc = ((ourcrc & 255) << 8) | ((ourcrc >> 8) & 255);  /* swap bytes */
    c = get_modem_block(cp,(char *)&hiscrc,2,500L);
    if(c == LOSTCARRIER || c == TIMEOUT)
      return c;
  }
  else {                  /* calc checksum */
    csum = 0;
    while(c--)
      csum += *buf++;
    ourcrc = (USHORT)csum;
    c = get_modem_byte(cp,500L);
    if(c == LOSTCARRIER || c == TIMEOUT)
      return c;
  }
  if(ourcrc == hiscrc) {

//should dig filename and filesize out of file header...

    return 0;             /* good block */
  }
  return BLKCRCERR;       /* else bad block */
}


static int _fastcall get_xblock (USHORT cp, char *pbuf, int ucrc,
                                 int blksize) {

  /* get the data portion of an xmodem block */

  register int     c;
  register char    csum,*buf = pbuf;
  USHORT           ourcrc,hiscrc;

  c = get_modem_block(cp,buf,blksize,1000L);
  if(c == LOSTCARRIER || c == TIMEOUT) {
    purge_in(cp);
    return c;
  }

  c = blksize;
  if(ucrc) {              /* calc CRC */
    ourcrc = 0;
    while(c--)
      ourcrc = (ourcrc << 8) ^ crctab[(ourcrc >> 8) ^ *buf++];
    ourcrc = ((ourcrc & 255) << 8) | ((ourcrc >> 8) & 255);  /* swap bytes */
    c = get_modem_block(cp,(char *)&hiscrc,2,500L);
    if(c == LOSTCARRIER || c == TIMEOUT)
      return c;
  }
  else {                  /* calc checksum */
    csum = 0;
    while(c--)
      csum += *buf++;
    ourcrc = (USHORT)csum;
    c = get_modem_byte(cp,500L);
    if(c == LOSTCARRIER || c == TIMEOUT)
      return c;
  }
  if(ourcrc == hiscrc)
    return 0;             /* good block */
  return BLKCRCERR;       /* else bad block */
}


long _fastcall get_xfile (USHORT cp,char *filename,int flags,int *error) {

  /*
   * receive a file via xmodem(1k,ymodem).  return size of file received.
   * further explanation of error returned in *error
   * bitmapped flags:
   * 1: user online, allow greater delays
   * 2: 1k blocks allowed
   * 4: ymodem in use
   * 8: ymodem-g in use
   */

  long      filesize = 0L,transerrs = 0L,blocks = 0L;
  clock_t   t1;
  int       handle,retries = 0,thisnak = 0,ucrc = 1,c,blksize = 128,
            header = 0,waseot = 0;
  char      buf[1024],misc[41],hisfilename[133];
  TRANSBUF  tbuf,*dupebuf;
  char      oldpri[2];

  *error = 0;

  purge_in(cp);
  modems[cp]->checkcd = 1;
  memset(&tbuf,0,sizeof(TRANSBUF));
  DosGetPrty(2,(PUSHORT)oldpri,*_threadid); /* get old priority */

  if(!checkcarrier(cp)) {
    handle = sopen(filename,O_RDONLY | O_BINARY,SH_DENYNO); /* check file */
    if(handle != -1) {
      *error = FILEERROR;
      logfunc(0,cp,"File \"%s\" already exists",filename);
      DosSleep(1000L);
      cancel_transfer(cp);
      DosSleep(100L);
      purge_in(cp);
      return 0L;
    }
    close(handle);

    handle = sopen(filename,O_RDWR | O_BINARY | O_CREAT,SH_DENYWR, /* open file */
                   S_IWRITE | S_IREAD);
    if(handle == -1) {
      *error = FILEERROR;
      logfunc(0,cp,"Can't create file \"%s\"",filename);
      return 0L;
    }

    strcpy(hisfilename,filename);

    tbuf.filename = filename; /* log start of transmission to window */
    tbuf.err = NULL;
    tbuf.errcount = 0L;
    tbuf.filesize = 0L;
    tbuf.bytessent = 0L;
    sprintf(misc,"%cModem%s",YMODEM ? 'Y' : 'X',GMODE ? "G" : "");
    tbuf.misc = misc;
    tbuf.type = TB_NAME;
    tbuf.started = time(NULL);
    dupebuf = memdupe(&tbuf,sizeof(tbuf));
    if(dupebuf)
      if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                     MPFROMP(dupebuf)))
        free(dupebuf);

    /* log start of transmission, set receive priority */

    logfunc(0,cp,"%cModem%s-receiving file \"%s\"",YMODEM ? 'Y' : 'X',
            GMODE ? "G" : "",filename);
    DosSetPrty(2,modems[cp]->transfer[0],modems[cp]->transfer[1],*_threadid);

    /* do the work */

    *error = 0;
    c = 0;
    t1 = timerset(60000L);
    if(!blocks) {
      com_putc(cp,(char)((ucrc) ? (GMODE ? 'G' : 'C') : NAK));
      if(modems[cp]->debugtrans)
        logfunc(1,cp,"Polled w/ %s",(ucrc) ? (GMODE ? "G" : "C") : "NAK");
      if(HUMAN)
        tbuf.started = time(NULL);
    }
    while(!timeup(t1) && c != EOT && !*error) {
      c = get_modem_byte(cp,3000L + (((HUMAN != 0) && !blocks) * 3000L));
      if(modems[cp]->debugtrans)
        logfunc(1,cp,"Received %d",c);
      /* first check a couple of special cases... */
      if(c != EOT)
        waseot = 0;
      if(c == STX && (!ONEKOK && !YMODEM))
        c = 0;
      switch(c) {
        case EOT:
          if(!blocks) {
            *error = CAN;
            tbuf.err = "Cancelled by remote (EOT)";
          }
          else if(waseot)
            com_putc(cp,ACK);
          else {
            if(modems[cp]->debugtrans)
              logfunc(1,cp,"Checking EOT...NAKing...");
            waseot = 1;
            com_putc(cp,(char)((!blocks && ucrc) ?
                     (GMODE != 0) ? 'G' : 'C' : NAK));
          }
          break;

        case SOH:   /* start of 128 byte header */
        case STX:   /* start of 1k header? */
          if(c == SOH)
            blksize = 128;
          else
            blksize = 1024;
          t1 = timerset(10000L);
          c = get_xblkhdr(cp,(char)((YMODEM && !header) ? 0 :
                          (char)((blocks + 1L) & 255L)));

          switch(c) {         /* check return from get-a-header */
            case TIMEOUT:
              tbuf.err = "Timeout";
              *error = c;
              break;

            case LOSTCARRIER:
              tbuf.err = "Lost carrier";
              *error = c;
              break;

            case BLKMISMATCH:
              if(transerrs++ > modems[cp]->maxtranserrs || thisnak++ > 15) {
                tbuf.err = "Too many errors";
                *error = c;
              }
              else {
                com_putc(cp,(char)((!blocks && ucrc) ?
                         (GMODE != 0) ? 'G' : 'C' : NAK));
                tbuf.err = "Block mismatch";
                tbuf.errcount = transerrs;
                dupebuf = memdupe(&tbuf,sizeof(tbuf));
                if(dupebuf)
                  if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                 MPFROMP(dupebuf)))
                    free(dupebuf);
              }
              break;

            case BLKMINUS1:
              if(thisnak++ > 15 || transerrs++ > modems[cp]->maxtranserrs) {
                tbuf.err = "Too many errors";
                *error = c;
              }
              else {
                tbuf.err = "Previous block ACKed";
                tbuf.errcount = transerrs;
                dupebuf = memdupe(&tbuf,sizeof(tbuf));
                if(dupebuf)
                  if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                 MPFROMP(dupebuf)))
                    free(dupebuf);
                com_putc(cp,ACK);
              }
              break;

            case BLKFATAL:
              cancel_transfer(cp);
              tbuf.err = "Fatal wrong block";
              *error = c;
              break;

            default:          /* good block header, get data portion */
              if(!header && YMODEM)  /* get ymodem header */
                c = get_yblock(cp,buf,ucrc,blksize,&filesize,hisfilename);
              else                        /* get xmodem datablock */
                c = get_xblock(cp,buf,ucrc,blksize);
              switch(c) {
                case TIMEOUT:
                  if(transerrs++ > modems[cp]->maxtranserrs || thisnak++ > 15) {
                    tbuf.err = "Too many errors";
                    *error = c;
                  }
                  else {
                    com_putc(cp,(char)((!blocks && ucrc) ?
                             (GMODE != 0) ? 'G' : 'C' : NAK));
                    tbuf.err = "Short block";
                    tbuf.errcount = transerrs;
                    dupebuf = memdupe(&tbuf,sizeof(tbuf));
                    if(dupebuf)
                      if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                     MPFROMP(dupebuf)))
                        free(dupebuf);
                  }
                  break;

                case LOSTCARRIER:
                  tbuf.err = "Lost carrier";
                  *error = c;
                  break;

                case BLKCRCERR:
                  if(transerrs++ > modems[cp]->maxtranserrs || thisnak++ > 15) {
                    tbuf.err = "Too many errors";
                    *error = c;
                  }
                  else {
                    com_putc(cp,(char)((!blocks && ucrc) ?
                             (GMODE != 0) ? 'G' : 'C' : NAK));
                    tbuf.err = "CRC/Csum error";
                    tbuf.errcount = transerrs;
                    dupebuf = memdupe(&tbuf,sizeof(tbuf));
                    if(dupebuf)
                      if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                     MPFROMP(dupebuf)))
                        free(dupebuf);
                  }
                  break;

                default:      /* good block */
                  if(!header && YMODEM) { /* got ymodem header */
                    /* do nothing else for now... */
                    header++;
                  }
                  else {
                    if(write(handle,buf,blksize) < blksize) {
                      *error = FILEERROR;
                      tbuf.err = "Error writing to file";
                      break;
                    }
                    if(blocks++ % 10) {
                      tbuf.type = TB_TICK;
                      filesize = tell(handle);
                      tbuf.bytessent = filesize;
                      dupebuf = memdupe(&tbuf,sizeof(tbuf));
                      if(dupebuf)
                        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                       MPFROMP(dupebuf)))
                          free(dupebuf);
                    }
                  }
                  com_putc(cp,ACK);
                  thisnak = 0;
                  break;
              }
          }
          break;

        case LOSTCARRIER:
          tbuf.err = "Lost Carrier";
          *error = c;
          break;

        case CAN:
          if(peek_at_byte(cp,1000) == CAN) {
            tbuf.err = "Cancelled by remote";
            *error = c;
            break;
          }
          /* else intentional fallthru */
        default:
          purge_in(cp);
          if(retries++ > 5 && !blocks)  /* go checksum */
            ucrc = 0;
          if(retries > 12) {
            tbuf.err = "Too many retries";
            *error = TIMEOUT;
            break;
          }
          com_putc(cp,(char)((!blocks && ucrc) ?
                   (GMODE != 0) ? 'G' : 'C' : NAK));
          break;
      }
    }
    filesize = tell(handle);
    close(handle);
    DosSetPrty(2,oldpri[0],oldpri[1],*_threadid); /* restore old priority */

    tbuf.misc = NULL;
    if(*error) {  /* log error */
      tbuf.type = TB_ABORT;
      logfunc(0,cp,"%cModem%s receive of \"%s\" failed.  Error = %d (%s)",
              YMODEM ? 'Y' : 'X',GMODE ? "G" : "",filename,*error,tbuf.err);
      unlink(filename);   /* remove bad partial file */
      filesize = 0L;
      cancel_transfer(cp);
    }
    else {        /* log success */
      tbuf.type = TB_TICK;
      tbuf.bytessent = filesize;
      dupebuf = memdupe(&tbuf,sizeof(tbuf));
      if(dupebuf)
        if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                       MPFROMP(dupebuf)))
          free(dupebuf);
      tbuf.type = TB_FIN;
      logfunc(0,cp,"%cModem%s-received \"%s\"",YMODEM ? 'Y' : 'X',
              GMODE ? "G" : "",filename);
    }
    dupebuf = memdupe(&tbuf,sizeof(tbuf));
    if(dupebuf)
      if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                     MPFROMP(dupebuf)))
        free(dupebuf);
    DosSleep(250L);
  }

  DosSleep(100L);
  purge_in(cp);
  Clear_UD();
  return filesize;
}

