typedef struct BBSVARIABLE {
  char                name[26];
  int                 type;
  int                 scope;
  char                str[256];
  long                val;
  struct BBSVARIABLE *next;
} BBSVARIABLE;

typedef struct BBSFILE {
  char           *name;
  int             handle;
  struct BBSFILE *next;
} BBSFILE;

typedef struct GOSUBSTACK {
  char              *returnto;
  struct GOSUBSTACK *next;
} GOSUBSTACK;

typedef struct LOOPSTACK {
  char             *loopto;
  struct LOOPSTACK *next;
} LOOPSTACK;

typedef struct LABEL {
  char          label[26];
  char         *pos;
  struct LABEL *nextlabel;
} LABEL;

/* variable types */

#define VAR_STR         0
#define VAR_INT         1
#define VAR_STRARRAY    2
#define VAR_INTARRAY    3

/* functions */

#define FNC_ASSIGN      0   /* assign */
#define FNC_LESSTHAN    1   /* if< */
#define FNC_GRTRTHAN    2   /* if> */
#define FNC_EQUALTO     3   /* if= */
#define FNC_STARTBLK    4   /* { */
#define FNC_ENDBLK      5   /* } */
#define FNC_GOTO        6   /* goto */
#define FNC_GOSUB       7   /* gosub */
#define FNC_RETURN      8   /* return */
#define FNC_DO          9   /* do */
#define FNC_LOOP        10  /* loop */
#define FNC_RUN         11  /* run */
#define FNC_PRINT       12  /* print */
#define FNC_OPEN        13  /* open */
#define FNC_READ        14  /* read */
#define FNC_WRITE       15  /* write */
#define FNC_CLOSE       16  /* close */
#define FNC_POS         17  /* pos */
#define FNC_TELL        18  /* tell */
#define FNC_CONCAT      19  /* concat */
#define FNC_SUBSTR      20  /* substr */
#define FNC_INSTR       21  /* instr */
#define FNC_INC         22  /* inc */
#define FNC_DEC         23  /* dec */
#define FNC_INPUT       24  /* input */
#define FNC_INKEY       25  /* inkey */
#define FNC_STOP        26  /* stop */
#define FNC_SETRETURN   27  /* setreturn */
#define FNC_CLRRETURN   28  /* clrreturn */
#define FNC_EXITDO      29  /* exitdo */
#define FNC_OSCMD       30  /* oscmd */

